/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AnnotationLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;

public class GetBestElevations
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Get Best Elevations", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public double[] getBestElevations(List<LatLon> list) {
            Globe globe = this.getWwd().getModel().getGlobe();
            Sector sector = Sector.boundingSector(list);
            double[] dArray = new double[list.size()];
            double d = globe.getElevationModel().getBestResolution(sector);
            double d2 = Double.MAX_VALUE;
            while (d2 > d) {
                d2 = globe.getElevations(sector, list, d, dArray);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            return dArray;
        }

        public AppFrame() {
            super(true, true, false);
            final ScreenAnnotation screenAnnotation = new ScreenAnnotation("Shift-click to select a location", new Point(100, 50));
            AnnotationLayer annotationLayer = new AnnotationLayer();
            annotationLayer.addAnnotation((Annotation)screenAnnotation);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)annotationLayer);
            this.getWwd().getInputHandler().addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 1) == 0) {
                        return;
                    }
                    mouseEvent.consume();
                    final Position position = AppFrame.this.getWwd().getCurrentPosition();
                    if (position == null) {
                        return;
                    }
                    screenAnnotation.setText(String.format("Elevation = ", new Object[0]));
                    AppFrame.this.getWwd().redraw();
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            List<LatLon> list = Arrays.asList(position, position.add(LatLon.fromDegrees((double)1.0E-5, (double)1.0E-5)));
                            final double[] dArray = AppFrame.this.getBestElevations(list);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    screenAnnotation.setText(String.format("Elevation = %d m", (int)dArray[0]));
                                    AppFrame.this.getWwd().redraw();
                                }
                            });
                        }
                    });
                    thread.start();
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }
            });
        }
    }
}

