/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraticuleAttributesPanel
extends JPanel {
    private JPanel linePanel;
    private ColorPanel lineColorPanel;
    private JSlider lineWidthSlider;
    private JSpinner lineWidthSpinner;
    private SpinnerNumberModel lineWidthSpinnerModel;
    private JComboBox lineStyle;
    private JPanel labelPanel;
    private ColorPanel labelColorPanel;
    private JCheckBox labelEnabled;
    private JComboBox labelFontName;
    private JComboBox labelFontStyle;
    private JComboBox labelFontSize;
    private static final int MIN_LINE_WIDTH = 1;
    private static final int MAX_LINE_WIDTH = 8;
    private static final int LINE_WIDTH_SCALE = 16;
    public static final String LINE_COLOR_PROPERTY = "LineColor";
    public static final String LINE_WIDTH_PROPERTY = "LineWidth";
    public static final String LINE_STYLE_PROPERTY = "LineStyle";
    public static final String LABEL_ENABLED_PROPERTY = "LabelEnabled";
    public static final String LABEL_COLOR_PROPERTY = "LabelColor";
    public static final String LABEL_FONT_PROPERTY = "LabelFont";

    public GraticuleAttributesPanel() {
        this.makeComponents();
        this.layoutComponents();
    }

    public Color getSelectedLineColor() {
        return this.lineColorPanel.getColor();
    }

    public void setSelectedLineColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage((String)"nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.lineColorPanel.setColor(color);
    }

    public double getSelectedLineWidth() {
        return this.lineWidthSpinnerModel.getNumber().doubleValue();
    }

    public void setSelectedLineWidth(double d) {
        this.setLineWidthControls(d);
    }

    public String getSelectedLineStyle() {
        return this.lineStyle.getSelectedItem().toString();
    }

    public void setSelectedLineStyle(String string) {
        if (string == null) {
            String string2 = Logging.getMessage((String)"nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.lineStyle.setSelectedItem(string);
    }

    public boolean isLabelEnableSelected() {
        return this.labelEnabled.isSelected();
    }

    public void setLabelEnableSelected(boolean bl) {
        this.labelEnabled.setSelected(bl);
    }

    public Color getSelectedLabelColor() {
        return this.labelColorPanel.getColor();
    }

    public void setSelectedLabelColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage((String)"nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.labelColorPanel.setColor(color);
    }

    public Font getSelectedLabelFont() {
        return this.makeFontFromControls();
    }

    public void setSelectedLabelFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage((String)"nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setFontControls(font);
    }

    private void onLineColorChanged(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent != null) {
            this.firePropertyChange(LINE_COLOR_PROPERTY, null, propertyChangeEvent.getNewValue());
        }
    }

    private void onLineWidthSliderChanged(ChangeEvent changeEvent) {
        if (changeEvent != null) {
            double d = (double)this.lineWidthSlider.getValue() / 16.0;
            this.lineWidthSpinner.setValue(d);
            this.firePropertyChange(LINE_WIDTH_PROPERTY, null, (Object)d);
        }
    }

    private void onLineWidthSpinnerChanged(ChangeEvent changeEvent) {
        if (changeEvent != null) {
            double d = this.lineWidthSpinnerModel.getNumber().doubleValue();
            this.lineWidthSlider.setValue((int)(d * 16.0));
            this.firePropertyChange(LINE_WIDTH_PROPERTY, null, (Object)d);
        }
    }

    private void onLineStyleChanged(ActionEvent actionEvent) {
        if (actionEvent != null) {
            String string = this.lineStyle.getSelectedItem().toString();
            this.firePropertyChange(LINE_STYLE_PROPERTY, null, string);
        }
    }

    private void onLabelEnableChanged(ItemEvent itemEvent) {
        if (itemEvent != null) {
            this.firePropertyChange(LABEL_ENABLED_PROPERTY, null, (Object)(itemEvent.getStateChange() == 1 ? 1 : 0));
        }
    }

    private void onLabelColorChanged(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent != null) {
            this.firePropertyChange(LABEL_COLOR_PROPERTY, null, propertyChangeEvent.getNewValue());
        }
    }

    private void onLabelFontChanged(ActionEvent actionEvent) {
        if (actionEvent != null) {
            Font font = this.makeFontFromControls();
            this.firePropertyChange(LABEL_FONT_PROPERTY, null, font);
        }
    }

    private void setLineWidthControls(double d) {
        this.lineWidthSlider.setValue((int)(d * 16.0));
        this.lineWidthSpinner.setValue(d);
    }

    private Font makeFontFromControls() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.labelFontName.getSelectedItem());
        stringBuilder.append("-");
        stringBuilder.append(this.labelFontStyle.getSelectedItem());
        stringBuilder.append("-");
        stringBuilder.append(this.labelFontSize.getSelectedItem());
        return Font.decode(stringBuilder.toString());
    }

    private void setFontControls(Font font) {
        if (font == null) {
            String string = Logging.getMessage((String)"nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.labelFontName.setSelectedItem(font.getName());
        if ((font.getStyle() & 1) != 0) {
            this.labelFontStyle.setSelectedItem("Bold");
        } else if ((font.getStyle() & 2) != 0) {
            this.labelFontStyle.setSelectedItem("Italic");
        } else if ((font.getStyle() & 3) != 0) {
            this.labelFontStyle.setSelectedItem("BoldItalic");
        } else {
            this.labelFontStyle.setSelectedItem("Plain");
        }
        this.labelFontSize.setSelectedItem(String.format("%d", font.getSize()));
    }

    private void makeComponents() {
        String[] stringArray = new String[]{"LineStyleSolid", "LineStyleDashed", "LineStyleDotted"};
        this.linePanel = new JPanel();
        this.lineColorPanel = new ColorPanel();
        this.lineWidthSlider = new JSlider(16, 128);
        this.lineWidthSlider.setMajorTickSpacing(16);
        this.lineWidthSlider.setMinorTickSpacing(4);
        this.lineWidthSlider.setPaintTicks(true);
        this.lineWidthSlider.setSnapToTicks(true);
        this.lineWidthSpinnerModel = new SpinnerNumberModel(1.0, 1.0, 8.0, 0.25);
        this.lineWidthSpinner = new JSpinner(this.lineWidthSpinnerModel);
        this.lineStyle = new JComboBox<String>(stringArray);
        ListCellRenderer listCellRenderer = this.lineStyle.getRenderer();
        this.lineStyle.setRenderer(new LineStyleRenderer(listCellRenderer));
        this.lineColorPanel.addColorChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GraticuleAttributesPanel.this.onLineColorChanged(propertyChangeEvent);
            }
        });
        this.lineWidthSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GraticuleAttributesPanel.this.onLineWidthSliderChanged(changeEvent);
            }
        });
        this.lineWidthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GraticuleAttributesPanel.this.onLineWidthSpinnerChanged(changeEvent);
            }
        });
        this.lineStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraticuleAttributesPanel.this.onLineStyleChanged(actionEvent);
            }
        });
        this.labelPanel = new JPanel();
        this.labelEnabled = new JCheckBox("Show Labels");
        this.labelColorPanel = new ColorPanel();
        this.labelFontName = new JComboBox<String>(new String[]{"Arial", "SansSerif", "Serif", "Courier", "Times", "Helvetica", "Trebuchet", "Tahoma"});
        this.labelFontStyle = new JComboBox<String>(new String[]{"Plain", "Bold", "Italic", "BoldItalic"});
        this.labelFontSize = new JComboBox<String>(new String[]{"8", "10", "12", "14", "16", "18", "20", "24", "28", "34", "48", "64"});
        this.labelEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GraticuleAttributesPanel.this.onLabelEnableChanged(itemEvent);
            }
        });
        this.labelColorPanel.addColorChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GraticuleAttributesPanel.this.onLabelColorChanged(propertyChangeEvent);
            }
        });
        this.labelFontName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraticuleAttributesPanel.this.onLabelFontChanged(actionEvent);
            }
        });
        this.labelFontStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraticuleAttributesPanel.this.onLabelFontChanged(actionEvent);
            }
        });
        this.labelFontSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraticuleAttributesPanel.this.onLabelFontChanged(actionEvent);
            }
        });
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.linePanel.setLayout(new BoxLayout(this.linePanel, 3));
        this.linePanel.setBorder(new CompoundBorder(new TitledBorder("Graticule"), new EmptyBorder(10, 10, 10, 10)));
        this.lineColorPanel.setAlignmentX(0.0f);
        this.linePanel.add(this.lineColorPanel);
        this.linePanel.add(Box.createVerticalStrut(10));
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.add(this.lineWidthSlider);
        box.add(this.lineWidthSpinner);
        box.add(Box.createHorizontalGlue());
        this.linePanel.add(box);
        this.linePanel.add(Box.createVerticalStrut(10));
        this.lineStyle.setAlignmentX(0.0f);
        this.linePanel.add(this.lineStyle);
        this.linePanel.setAlignmentX(0.0f);
        this.add(this.linePanel);
        this.add(Box.createVerticalStrut(20));
        this.labelPanel.setLayout(new BoxLayout(this.labelPanel, 3));
        this.labelPanel.setBorder(new CompoundBorder(new TitledBorder("Labels"), new EmptyBorder(10, 10, 10, 10)));
        this.labelEnabled.setAlignmentX(0.0f);
        this.labelPanel.add(this.labelEnabled);
        this.labelPanel.add(Box.createVerticalStrut(10));
        this.labelColorPanel.setAlignmentX(0.0f);
        this.labelPanel.add(this.labelColorPanel);
        this.labelPanel.add(Box.createVerticalStrut(10));
        box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.add(this.labelFontName);
        box.add(this.labelFontStyle);
        box.add(this.labelFontSize);
        this.labelPanel.add(box);
        this.labelPanel.setAlignmentX(0.0f);
        this.add(this.labelPanel);
        this.add(Box.createVerticalGlue());
    }

    private static String getLineStyleLabel(String string) {
        String string2 = null;
        if ("LineStyleSolid".equals(string)) {
            string2 = "Solid";
        } else if ("LineStyleDashed".equals(string)) {
            string2 = "Dashed";
        } else if ("LineStyleDotted".equals(string)) {
            string2 = "Dotted";
        }
        return string2;
    }

    private static ImageIcon makeImageIcon(int n, int n2) {
        ImageIcon imageIcon = null;
        try {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            imageIcon = new ImageIcon(bufferedImage);
        }
        catch (Exception exception) {
            String string = "Exception while creating icon";
            Logging.logger().log(Level.SEVERE, string, exception);
        }
        return imageIcon;
    }

    private static void fillImage(Image image, Color color) {
        try {
            Graphics graphics = image.getGraphics();
            graphics.setColor(color);
            graphics.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
        }
        catch (Exception exception) {
            String string = "Exception while drawing to image";
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    private static class ColorPanel
    extends JPanel {
        private JLabel colorLabel;
        private JButton colorButton;
        private JColorChooser colorChooser;
        private JDialog colorChooserDialog;
        private JSlider opacitySlider;
        private Color lastSelectedColor = null;
        private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

        public ColorPanel() {
            this.makeComponents();
            this.layoutComponents();
        }

        public void addColorChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public void removeColorChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public void fireColorChanged() {
            this.changeSupport.firePropertyChange("color", null, this.makeColorFromControls());
        }

        public Color getColor() {
            return this.makeColorFromControls();
        }

        public void setColor(Color color) {
            if (color == null) {
                String string = Logging.getMessage((String)"nullValue.ColorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.setColorControls(color);
        }

        private Color makeColorFromControls() {
            Color color = this.colorChooser.getColor();
            int n = this.opacitySlider.getValue();
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
        }

        private void setColorControls(Color color) {
            if (color == null) {
                String string = Logging.getMessage((String)"nullValue.ColorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.colorChooser.setColor(color);
            this.opacitySlider.setValue(color.getAlpha());
            this.setColorLabel(color);
        }

        private void onColorPressed() {
            this.lastSelectedColor = this.makeColorFromControls();
            this.colorChooserDialog.setVisible(true);
        }

        private void onColorChooserOk(ActionEvent actionEvent) {
            if (actionEvent != null) {
                this.lastSelectedColor = null;
                Color color = this.makeColorFromControls();
                this.setColorLabel(color);
                if (color != null) {
                    this.fireColorChanged();
                }
            }
        }

        private void onColorChooserCancel(ActionEvent actionEvent) {
            Color color;
            if (actionEvent != null && (color = this.lastSelectedColor) != null) {
                this.setColorControls(color);
                this.fireColorChanged();
            }
        }

        private void onColorChooserChanged(ChangeEvent changeEvent) {
            if (changeEvent != null) {
                Color color = this.makeColorFromControls();
                this.setColorLabel(color);
                if (color != null) {
                    this.fireColorChanged();
                }
            }
        }

        private void onOpacityChanged(ChangeEvent changeEvent) {
            if (changeEvent != null) {
                Color color = this.makeColorFromControls();
                this.setColorLabel(color);
                if (color != null) {
                    this.fireColorChanged();
                }
            }
        }

        private void makeComponents() {
            this.colorLabel = new JLabel(GraticuleAttributesPanel.makeImageIcon(60, 16));
            this.colorButton = new JButton("Choose...");
            this.colorChooser = new JColorChooser();
            this.colorChooser.setPreviewPanel(new JPanel());
            this.opacitySlider = new JSlider(1, 255);
            this.colorChooserDialog = JColorChooser.createDialog(this, "Choose Graticule Color", true, this.colorChooser, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColorPanel.this.onColorChooserOk(actionEvent);
                }
            }, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColorPanel.this.onColorChooserCancel(actionEvent);
                }
            });
            this.colorLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ColorPanel.this.onColorPressed();
                }
            });
            this.colorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColorPanel.this.onColorPressed();
                }
            });
            this.colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ColorPanel.this.onColorChooserChanged(changeEvent);
                }
            });
            this.opacitySlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ColorPanel.this.onOpacityChanged(changeEvent);
                }
            });
        }

        private void setColorLabel(Color color) {
            ImageIcon imageIcon;
            if (color != null && this.colorLabel != null && this.colorLabel.getIcon() != null && this.colorLabel.getIcon() instanceof ImageIcon && (imageIcon = (ImageIcon)this.colorLabel.getIcon()).getImage() != null) {
                Color color2 = new Color(color.getRGB());
                GraticuleAttributesPanel.fillImage(imageIcon.getImage(), color2);
                this.colorLabel.repaint();
            }
        }

        private void layoutComponents() {
            this.setLayout(new BoxLayout(this, 3));
            Box box = Box.createHorizontalBox();
            box.setAlignmentX(0.0f);
            this.colorLabel.setBorder(new MatteBorder(1, 1, 1, 1, Color.BLACK));
            box.add(this.colorLabel);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.colorButton);
            this.add(box);
            this.add(Box.createVerticalStrut(10));
            this.opacitySlider.setAlignmentX(0.0f);
            this.add(this.opacitySlider);
        }
    }

    private static class LineStyleRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate;

        public LineStyleRenderer(ListCellRenderer listCellRenderer) {
            this.delegate = listCellRenderer;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = this.delegate.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (component != null && component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                if (object != null && object instanceof String) {
                    String string = (String)object;
                    String string2 = GraticuleAttributesPanel.getLineStyleLabel(string);
                    jLabel.setText(string2);
                }
            }
            return component;
        }
    }
}

