/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.layertree.LayerTree;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.HotSpotController;
import java.awt.Component;
import java.awt.Dimension;

public class LayerTreeUsage
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Layer Tree", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected LayerTree layerTree = new LayerTree();
        protected RenderableLayer hiddenLayer = new RenderableLayer();
        protected HotSpotController controller;

        public AppFrame() {
            super(true, false, false);
            this.hiddenLayer.addRenderable((Renderable)this.layerTree);
            this.getWwd().getModel().getLayers().add((Layer)this.hiddenLayer);
            this.hiddenLayer.setValue("gov.nasa.worldwind.avkey.Hidden", (Object)true);
            this.layerTree.getModel().refresh(this.getWwd().getModel().getLayers());
            this.controller = new HotSpotController(this.getWwd());
            Dimension dimension = new Dimension(1000, 600);
            this.setPreferredSize(dimension);
            this.pack();
            WWUtil.alignComponent(null, (Component)this, (String)"gov.nasa.worldwind.avkey.Center");
        }
    }
}

