/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;

public class LineBackground
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Line Backgrounds", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            try {
                LatLon latLon2;
                BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
                basicShapeAttributes.setOutlineMaterial(new Material(Color.BLUE));
                basicShapeAttributes.setOutlineStipplePattern((short)-21846);
                basicShapeAttributes.setOutlineStippleFactor(8);
                BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes();
                basicShapeAttributes2.setOutlineMaterial(new Material(Color.WHITE));
                basicShapeAttributes2.setOutlineOpacity(0.1);
                basicShapeAttributes2.setOutlineWidth(basicShapeAttributes.getOutlineWidth() + 2.0);
                SurfacePolyline surfacePolyline = new SurfacePolyline(new ArrayList<LatLon>(Arrays.asList(LatLon.fromDegrees((double)33.7, (double)119.6), LatLon.fromDegrees((double)33.5, (double)125.0), LatLon.fromDegrees((double)35.1, (double)129.1), LatLon.fromDegrees((double)35.8, (double)127.1))));
                surfacePolyline.setClosed(true);
                surfacePolyline.setAttributes((ShapeAttributes)basicShapeAttributes);
                SurfacePolyline surfacePolyline2 = new SurfacePolyline(surfacePolyline.getLocations());
                surfacePolyline2.setClosed(true);
                surfacePolyline2.setAttributes((ShapeAttributes)basicShapeAttributes2);
                ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
                for (LatLon latLon2 : surfacePolyline.getLocations()) {
                    arrayList.add(latLon2.add(LatLon.fromDegrees((double)2.0, (double)0.0)));
                }
                Polyline polyline = new Polyline(arrayList, 0.0);
                polyline.setFollowTerrain(true);
                polyline.setClosed(true);
                polyline.setPathType(2);
                polyline.setColor(basicShapeAttributes.getOutlineMaterial().getDiffuse());
                polyline.setLineWidth(basicShapeAttributes.getOutlineWidth());
                polyline.setStipplePattern(basicShapeAttributes.getOutlineStipplePattern());
                polyline.setStippleFactor(basicShapeAttributes.getOutlineStippleFactor());
                latLon2 = new Polyline(arrayList, 0.0);
                latLon2.setFollowTerrain(true);
                latLon2.setClosed(true);
                latLon2.setPathType(2);
                float[] fArray = basicShapeAttributes2.getOutlineMaterial().getDiffuse().getColorComponents(new float[3]);
                latLon2.setColor(new Color(fArray[0], fArray[1], fArray[2], (float)basicShapeAttributes2.getOutlineOpacity()));
                latLon2.setLineWidth(basicShapeAttributes2.getOutlineWidth());
                latLon2.setStipplePattern(basicShapeAttributes2.getOutlineStipplePattern());
                latLon2.setStippleFactor(basicShapeAttributes2.getOutlineStippleFactor());
                RenderableLayer renderableLayer = new RenderableLayer();
                renderableLayer.setName("Lines");
                renderableLayer.setPickEnabled(false);
                renderableLayer.addRenderable((Renderable)surfacePolyline2);
                renderableLayer.addRenderable((Renderable)surfacePolyline);
                renderableLayer.addRenderable((Renderable)polyline);
                renderableLayer.addRenderable((Renderable)latLon2);
                ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
                this.getLayerPanel().update(this.getWwd());
                View view = this.getWwd().getView();
                view.setEyePosition(Position.fromDegrees((double)35.3, (double)124.6, (double)1500000.0));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

