/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.layers.Earth.MGRSGraticuleLayer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.examples.GraticuleAttributesPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MGRSAttributesPanel
extends JPanel {
    private final MGRSGraticuleLayer layer;
    private JList itemList;
    private JComboBox maxResolutionComboBox;
    private JButton saveStateButton;
    private JButton loadStateButton;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private Map<String, Component> graticuleAttribPanelMap = new HashMap<String, Component>();
    private boolean ignoreLayerEvents = false;
    private boolean ignoreUIEvents = false;
    private String[] ALL_GRATICULE_TYPES = new String[]{"Graticule.UTM", "Graticule.UTM.Grid", "Graticule.100000m", "Graticule.10000m", "Graticule.1000m", "Graticule.100m", "Graticule.10m", "Graticule.1m"};
    private String[] MGRS_GRATICULE_TYPES = new String[]{"Graticule.UTM.Grid", "Graticule.100000m", "Graticule.10000m", "Graticule.1000m", "Graticule.100m", "Graticule.10m", "Graticule.1m"};

    public MGRSAttributesPanel(MGRSGraticuleLayer mGRSGraticuleLayer) {
        if (mGRSGraticuleLayer == null) {
            String string = Logging.getMessage((String)"nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.layer = mGRSGraticuleLayer;
        this.layer.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MGRSAttributesPanel.this.onLayerPropertyChanged(propertyChangeEvent);
            }
        });
        this.init();
    }

    private void init() {
        this.makeComponents();
        this.layoutComponents();
        this.updateComponents();
        String string = "Graticule.UTM.Grid";
        this.itemList.setSelectedValue(string, true);
        this.cardLayout.show(this.cardPanel, string);
    }

    public final MGRSGraticuleLayer getLayer() {
        return this.layer;
    }

    public static JDialog showDialog(Component component, String string, MGRSGraticuleLayer mGRSGraticuleLayer) {
        if (mGRSGraticuleLayer == null) {
            String string2 = Logging.getMessage((String)"nullValue.LayerIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        JDialog jDialog = component != null && component instanceof Dialog ? new JDialog((Dialog)component) : (component != null && component instanceof Frame ? new JDialog((Frame)component) : new JDialog());
        if (string != null) {
            jDialog.setTitle(string);
        }
        MGRSAttributesPanel mGRSAttributesPanel = new MGRSAttributesPanel(mGRSGraticuleLayer);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)mGRSAttributesPanel, "Center");
        jDialog.pack();
        jDialog.setVisible(true);
        return jDialog;
    }

    public String getSelectedGraticule() {
        Object e = this.itemList.getSelectedValue();
        return e != null ? e.toString() : null;
    }

    public void setSelectedGraticule(String string) {
        if (string == null) {
            String string2 = Logging.getMessage((String)"nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.itemList.setSelectedValue(string, true);
        this.cardLayout.show(this.cardPanel, string);
    }

    private void onListSelectionChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent != null) {
            Object e = this.itemList.getSelectedValue();
            this.cardLayout.show(this.cardPanel, e.toString());
        }
    }

    private void onMaxResolutionChanged(ActionEvent actionEvent) {
        if (actionEvent != null && !this.ignoreUIEvents) {
            this.updateLayer();
        }
    }

    private void onSaveStatePressed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        try {
            String string = this.layer.getRestorableState();
            MGRSAttributesPanel.saveString(string, file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onLoadStatePressed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        try {
            String string = MGRSAttributesPanel.loadString(file);
            this.layer.restoreState(string);
            this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)this.layer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onPanelStateChanged(PropertyChangeEvent propertyChangeEvent, String string) {
        if (propertyChangeEvent != null && string != null && !this.ignoreUIEvents && (propertyChangeEvent.getPropertyName().equals("LineColor") || propertyChangeEvent.getPropertyName().equals("LineWidth") || propertyChangeEvent.getPropertyName().equals("LineStyle") || propertyChangeEvent.getPropertyName().equals("LabelEnabled") || propertyChangeEvent.getPropertyName().equals("LabelColor") || propertyChangeEvent.getPropertyName().equals("LabelFont"))) {
            this.updateLayer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLayer() {
        this.ignoreLayerEvents = true;
        try {
            if (this.layer != null) {
                this.layer.setMaximumGraticuleResolution(this.maxResolutionComboBox.getSelectedItem().toString());
                for (Map.Entry<String, Component> entry : this.graticuleAttribPanelMap.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null || !(entry.getValue() instanceof GraticuleAttributesPanel)) continue;
                    this.updateLayerState((GraticuleAttributesPanel)entry.getValue(), entry.getKey());
                }
            }
        }
        finally {
            this.ignoreLayerEvents = false;
        }
    }

    private void updateLayerState(GraticuleAttributesPanel graticuleAttributesPanel, String string) {
        if (this.layer != null && graticuleAttributesPanel != null && string != null) {
            this.layer.setGraticuleLineColor(graticuleAttributesPanel.getSelectedLineColor(), string);
            this.layer.setGraticuleLineWidth(graticuleAttributesPanel.getSelectedLineWidth(), string);
            this.layer.setGraticuleLineStyle(graticuleAttributesPanel.getSelectedLineStyle(), string);
            this.layer.setDrawLabels(graticuleAttributesPanel.isLabelEnableSelected(), string);
            this.layer.setLabelColor(graticuleAttributesPanel.getSelectedLabelColor(), string);
            this.layer.setLabelFont(graticuleAttributesPanel.getSelectedLabelFont(), string);
            this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)this.layer);
        }
    }

    private void onLayerPropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent != null && !this.ignoreLayerEvents) {
            this.updateComponents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComponents() {
        this.ignoreUIEvents = true;
        try {
            if (this.layer != null) {
                this.maxResolutionComboBox.setSelectedItem(this.layer.getMaximumGraticuleResolution());
            }
            for (Map.Entry<String, Component> entry : this.graticuleAttribPanelMap.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || !(entry.getValue() instanceof GraticuleAttributesPanel)) continue;
                this.updatePanelState((GraticuleAttributesPanel)entry.getValue(), entry.getKey());
            }
        }
        finally {
            this.ignoreUIEvents = false;
        }
    }

    private void updatePanelState(GraticuleAttributesPanel graticuleAttributesPanel, String string) {
        if (this.layer != null && graticuleAttributesPanel != null && string != null) {
            graticuleAttributesPanel.setSelectedLineColor(this.layer.getGraticuleLineColor(string));
            graticuleAttributesPanel.setSelectedLineWidth(this.layer.getGraticuleLineWidth(string));
            graticuleAttributesPanel.setSelectedLineStyle(this.layer.getGraticuleLineStyle(string));
            graticuleAttributesPanel.setLabelEnableSelected(this.layer.isDrawLabels(string));
            graticuleAttributesPanel.setSelectedLabelColor(this.layer.getLabelColor(string));
            graticuleAttributesPanel.setSelectedLabelFont(this.layer.getLabelFont(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadString(File file) throws IOException {
        String string = null;
        FileReader fileReader = null;
        try {
            int n;
            fileReader = new FileReader(file);
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[2048];
            while ((n = fileReader.read(cArray, 0, cArray.length)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            string = stringBuilder.toString();
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveString(String string, File file) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            if (string != null && file != null) {
                outputStreamWriter = new FileWriter(file);
                outputStreamWriter.write(string);
            }
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void makeComponents() {
        this.itemList = new JList<String>(this.ALL_GRATICULE_TYPES);
        this.itemList.setSelectionMode(0);
        ListCellRenderer listCellRenderer = this.itemList.getCellRenderer();
        this.itemList.setCellRenderer(new GraticuleTypeListRenderer(listCellRenderer, null));
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MGRSAttributesPanel.this.onListSelectionChanged(listSelectionEvent);
            }
        });
        this.saveStateButton = new JButton("Save State");
        this.saveStateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MGRSAttributesPanel.this.onSaveStatePressed(actionEvent);
            }
        });
        this.loadStateButton = new JButton("Load State");
        this.loadStateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MGRSAttributesPanel.this.onLoadStatePressed(actionEvent);
            }
        });
        this.maxResolutionComboBox = new JComboBox<String>(this.MGRS_GRATICULE_TYPES);
        listCellRenderer = this.maxResolutionComboBox.getRenderer();
        this.maxResolutionComboBox.setRenderer(new GraticuleTypeListRenderer(listCellRenderer, null));
        this.maxResolutionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MGRSAttributesPanel.this.onMaxResolutionChanged(actionEvent);
            }
        });
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(this.cardLayout);
        for (String string : this.ALL_GRATICULE_TYPES) {
            Component component = this.makeGraticulePanel(string);
            this.graticuleAttribPanelMap.put(string, component);
        }
    }

    private Component makeGraticulePanel(final String string) {
        if (string == null) {
            String string2 = Logging.getMessage((String)"nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        GraticuleAttributesPanel graticuleAttributesPanel = new GraticuleAttributesPanel();
        graticuleAttributesPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MGRSAttributesPanel.this.onPanelStateChanged(propertyChangeEvent, string);
            }
        });
        return graticuleAttributesPanel;
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        box.setBorder(new EmptyBorder(30, 20, 20, 5));
        JScrollPane object2 = new JScrollPane(this.itemList);
        object2.setAlignmentX(0.0f);
        box.add(object2);
        box.add(Box.createVerticalStrut(20));
        JLabel jLabel = new JLabel("Maximum Resolution");
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        this.maxResolutionComboBox.setAlignmentX(0.0f);
        box.add(this.maxResolutionComboBox);
        box.add(Box.createVerticalStrut(20));
        this.saveStateButton.setAlignmentX(0.0f);
        box.add(this.saveStateButton);
        this.loadStateButton.setAlignmentX(0.0f);
        box.add(this.loadStateButton);
        box.add(Box.createVerticalGlue());
        this.add((Component)box, "West");
        this.cardPanel.setBorder(new EmptyBorder(30, 5, 20, 20));
        for (Map.Entry entry : this.graticuleAttribPanelMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.cardPanel.add((Component)entry.getValue(), entry.getKey());
        }
        this.add((Component)this.cardPanel, "Center");
    }

    private static String getGraticuleLabel(String string) {
        String string2 = null;
        if ("Graticule.UTM".equals(string)) {
            string2 = "Global UTM";
        } else if ("Graticule.UTM.Grid".equals(string)) {
            string2 = "UTM Grid";
        } else if ("Graticule.100000m".equals(string)) {
            string2 = "100km";
        } else if ("Graticule.10000m".equals(string)) {
            string2 = "10km";
        } else if ("Graticule.1000m".equals(string)) {
            string2 = "1km";
        } else if ("Graticule.100m".equals(string)) {
            string2 = "100m";
        } else if ("Graticule.10m".equals(string)) {
            string2 = "10m";
        } else if ("Graticule.1m".equals(string)) {
            string2 = "1m";
        }
        return string2;
    }

    private Icon getIcon(String string) {
        ImageIcon imageIcon = null;
        try {
            URL uRL = this.getClass().getResource(string);
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
        }
        catch (Exception exception) {
            String string2 = "Exception while loading icon";
            Logging.logger().log(Level.WARNING, string2, exception);
        }
        return imageIcon;
    }

    private static class GraticuleTypeListRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate;
        private Icon icon;

        public GraticuleTypeListRenderer(ListCellRenderer listCellRenderer, Icon icon) {
            this.delegate = listCellRenderer;
            this.icon = icon;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = this.delegate.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (component != null && component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                Font font = jLabel.getFont();
                if (font != null) {
                    jLabel.setFont(font.deriveFont(1));
                }
                if (this.icon != null) {
                    jLabel.setIcon(this.icon);
                }
                if (object != null && object instanceof String) {
                    String string = (String)object;
                    String string2 = MGRSAttributesPanel.getGraticuleLabel(string);
                    jLabel.setText(string2);
                }
            }
            return component;
        }
    }
}

