/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.ArrayList;

public class Markers
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Markers", AppFrame.class);
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private static final MarkerAttributes[] attrs;
        private Marker lastHighlit;
        private BasicMarkerAttributes lastAttrs;

        public AppFrame() {
            super(true, true, false);
            double d = 20.0;
            double d2 = 60.0;
            double d3 = 2.0;
            double d4 = -140.0;
            double d5 = -60.0;
            double d6 = 2.0;
            int n = 0;
            ArrayList<BasicMarker> arrayList = new ArrayList<BasicMarker>();
            for (double d7 = d; d7 <= d2; d7 += d3) {
                for (double d8 = d4; d8 <= d5; d8 += d6) {
                    BasicMarker basicMarker = new BasicMarker(Position.fromDegrees((double)d7, (double)d8, (double)0.0), attrs[n % attrs.length]);
                    basicMarker.setPosition(Position.fromDegrees((double)d7, (double)d8, (double)0.0));
                    basicMarker.setHeading(Angle.fromDegrees((double)(d7 * 5.0)));
                    arrayList.add(basicMarker);
                    ++n;
                }
            }
            final MarkerLayer markerLayer = new MarkerLayer();
            markerLayer.setOverrideMarkerElevation(true);
            markerLayer.setKeepSeparated(false);
            markerLayer.setElevation(1000.0);
            markerLayer.setMarkers(arrayList);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), (Layer)markerLayer);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().addSelectListener(new SelectListener(){

                public void selected(SelectEvent selectEvent) {
                    if (!(AppFrame.this.lastHighlit == null || selectEvent.getTopObject() != null && selectEvent.getTopObject().equals(AppFrame.this.lastHighlit))) {
                        AppFrame.this.lastHighlit.setAttributes((MarkerAttributes)AppFrame.this.lastAttrs);
                        AppFrame.this.lastHighlit = null;
                    }
                    if (!selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
                        return;
                    }
                    if (selectEvent.getTopObject() == null || selectEvent.getTopPickedObject().getParentLayer() == null) {
                        return;
                    }
                    if (selectEvent.getTopPickedObject().getParentLayer() != markerLayer) {
                        return;
                    }
                    if (AppFrame.this.lastHighlit == null && selectEvent.getTopObject() instanceof Marker) {
                        AppFrame.this.lastHighlit = (Marker)selectEvent.getTopObject();
                        AppFrame.this.lastAttrs = (BasicMarkerAttributes)AppFrame.this.lastHighlit.getAttributes();
                        BasicMarkerAttributes basicMarkerAttributes = new BasicMarkerAttributes(AppFrame.this.lastAttrs);
                        basicMarkerAttributes.setMaterial(Material.WHITE);
                        basicMarkerAttributes.setOpacity(1.0);
                        basicMarkerAttributes.setMarkerPixels(AppFrame.this.lastAttrs.getMarkerPixels() * 1.4);
                        basicMarkerAttributes.setMinMarkerSize(AppFrame.this.lastAttrs.getMinMarkerSize() * 1.4);
                        AppFrame.this.lastHighlit.setAttributes((MarkerAttributes)basicMarkerAttributes);
                    }
                }
            });
        }

        static {
            for (MarkerAttributes markerAttributes : attrs = new BasicMarkerAttributes[]{new BasicMarkerAttributes(Material.BLACK, "gov.nasa.worldwind.render.markers.Sphere", 1.0, 10.0, 5.0), new BasicMarkerAttributes(Material.MAGENTA, "gov.nasa.worldwind.render.markers.Cube", 1.0, 10.0, 5.0), new BasicMarkerAttributes(Material.DARK_GRAY, "gov.nasa.worldwind.render.markers.Cone", 1.0, 10.0, 5.0), new BasicMarkerAttributes(Material.LIGHT_GRAY, "gov.nasa.worldwind.render.markers.Cylinder", 1.0, 10.0, 5.0), new BasicMarkerAttributes(Material.GRAY, "gov.nasa.worldwind.render.markers.HeadingArrow", 1.0, 10.0, 5.0), new BasicMarkerAttributes(Material.WHITE, "gov.nasa.worldwind.render.markers.HeadingLine", 1.0, 10.0, 5.0), new BasicMarkerAttributes(Material.RED, "gov.nasa.worldwind.render.markers.DirectionalConeLine", 0.7), new BasicMarkerAttributes(Material.YELLOW, "gov.nasa.worldwind.render.markers.DirectionalCylinderLine", 0.9), new BasicMarkerAttributes(Material.CYAN, "gov.nasa.worldwind.render.markers.DirectionalSphereLine", 0.7), new BasicMarkerAttributes(Material.GREEN, "gov.nasa.worldwind.render.markers.DirectionalCone", 1.0), new BasicMarkerAttributes(Material.PINK, "gov.nasa.worldwind.render.markers.DirectionalSphere", 0.8), new BasicMarkerAttributes(Material.BLUE, "gov.nasa.worldwind.render.markers.DirectionalCylinder", 0.6), new BasicMarkerAttributes(Material.RED, "gov.nasa.worldwind.render.markers.DirectionalCube", 1.0)}) {
                String string = markerAttributes.getShapeType();
                if (string == "gov.nasa.worldwind.render.markers.DirectionalSphere") {
                    markerAttributes.setHeadingMaterial(Material.YELLOW);
                }
                if (string != "gov.nasa.worldwind.render.markers.DirectionalCone") continue;
                markerAttributes.setHeadingMaterial(Material.PINK);
            }
        }
    }
}

