/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.formats.gpx.GpxReader;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.tracks.TrackPointIteratorImpl;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.PowerOfTwoPaddedImage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class MarkersOrder
extends ApplicationTemplate {
    protected static final String TRACK_PATH = "gov/nasa/worldwindx/examples/data/tuolumne.gpx";
    protected static final double TRACK_LATITUDE = 37.9;
    protected static final double TRACK_LONGITUDE = -119.52;

    public static void main(String[] stringArray) {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)37.9);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)-119.52);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)40000.0);
        ApplicationTemplate.start("World Wind Markers Order", AppFrame.class);
    }

    protected static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected static final int COLOR_MODE_RAMP = 0;
        protected static final int COLOR_MODE_DOW = 1;
        protected static final int COLOR_MODE_HOURS = 2;
        protected static final int RAMP_VALUES = 32;
        protected static MarkerAttributes[] attrsRampMono;
        protected static MarkerAttributes[] attrsRampDesat;
        protected static MarkerAttributes[] attrsRampGradient;
        protected static MarkerAttributes[] attrsRampHue;
        protected static MarkerAttributes[] attrsDayOfWeek;
        protected static MarkerAttributes[] attrsHours;
        protected RenderableLayer renderableLayer;
        protected ScreenAnnotation screenAnnotation;
        protected JComboBox colorRampCombo;
        protected JSlider timeScaleSlider;
        protected Marker lastHighlit;
        protected BasicMarkerAttributes lastAttrs;
        protected final PowerOfTwoPaddedImage dayOfWeekLegend = this.createLegendForDaysOfWeek(attrsDayOfWeek);
        protected final PowerOfTwoPaddedImage hoursLegend = this.createLegendForHours(attrsHours);
        protected int colorMode = 1;
        protected MarkerAttributes[] attrs = attrsDayOfWeek;

        public static Color interpolateColor(Color color, Color color2, double d) {
            return new Color((int)((double)color.getRed() * d + (double)color2.getRed() * (1.0 - d)), (int)((double)color.getGreen() * d + (double)color2.getGreen() * (1.0 - d)), (int)((double)color.getBlue() * d + (double)color2.getBlue() * (1.0 - d)), (int)((double)color.getAlpha() * d + (double)color2.getAlpha() * (1.0 - d)));
        }

        public static Color computeColorForDayOfWeek(int n) {
            return Color.getHSBColor((float)(n - 1) / 6.5f, 1.0f, 1.0f);
        }

        public static Color computeColorForHour(int n) {
            return Color.getHSBColor((float)n / 26.0f, 1.0f, 1.0f);
        }

        public AppFrame() {
            super(true, true, false);
            final TimedMarkerLayer timedMarkerLayer = this.buildTracksLayer();
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), (Layer)timedMarkerLayer);
            this.renderableLayer = new RenderableLayer();
            this.renderableLayer.setName("Markers Legend");
            this.renderableLayer.setPickEnabled(false);
            this.updateScreenAnnotation(this.dayOfWeekLegend);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), (Layer)this.renderableLayer);
            this.getLayerPanel().update(this.getWwd());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Markers Color")));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 4, 0, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            jPanel2.add(new JLabel("Mode:"));
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton jRadioButton = new JRadioButton("Ramp");
            jRadioButton.setSelected(false);
            jRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.colorMode = 0;
                    AppFrame.this.colorRampCombo.setEnabled(true);
                    AppFrame.this.timeScaleSlider.setEnabled(true);
                    switch (AppFrame.this.colorRampCombo.getSelectedIndex()) {
                        case 0: {
                            AppFrame.this.attrs = attrsRampMono;
                            break;
                        }
                        case 1: {
                            AppFrame.this.attrs = attrsRampDesat;
                            break;
                        }
                        case 2: {
                            AppFrame.this.attrs = attrsRampGradient;
                            break;
                        }
                        case 3: {
                            AppFrame.this.attrs = attrsRampHue;
                        }
                    }
                    AppFrame.this.updateScreenAnnotation(null);
                    AppFrame.this.getWwd().redraw();
                }
            });
            buttonGroup.add(jRadioButton);
            jPanel2.add(jRadioButton);
            JRadioButton jRadioButton2 = new JRadioButton("Days");
            jRadioButton2.setSelected(true);
            jRadioButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.colorMode = 1;
                    AppFrame.this.colorRampCombo.setEnabled(false);
                    AppFrame.this.timeScaleSlider.setEnabled(false);
                    AppFrame.this.attrs = attrsDayOfWeek;
                    AppFrame.this.updateScreenAnnotation(AppFrame.this.dayOfWeekLegend);
                    AppFrame.this.getWwd().redraw();
                }
            });
            buttonGroup.add(jRadioButton2);
            jPanel2.add(jRadioButton2);
            JRadioButton jRadioButton3 = new JRadioButton("Hours");
            jRadioButton3.setSelected(false);
            jRadioButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.colorMode = 2;
                    AppFrame.this.colorRampCombo.setEnabled(false);
                    AppFrame.this.timeScaleSlider.setEnabled(false);
                    AppFrame.this.attrs = attrsHours;
                    AppFrame.this.updateScreenAnnotation(AppFrame.this.hoursLegend);
                    AppFrame.this.getWwd().redraw();
                }
            });
            buttonGroup.add(jRadioButton3);
            jPanel2.add(jRadioButton3);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.timeScaleSlider = new JSlider(0, 120, 10);
            this.timeScaleSlider.setEnabled(false);
            this.timeScaleSlider.setToolTipText("Color ramp time scale - Minutes");
            this.timeScaleSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    timedMarkerLayer.setTimeScale(AppFrame.this.timeScaleSlider.getValue() * 60 * 1000 + 100);
                    AppFrame.this.getWwd().redraw();
                }
            });
            this.timeScaleSlider.setPaintLabels(true);
            this.timeScaleSlider.setPaintTicks(true);
            this.timeScaleSlider.setMajorTickSpacing(15);
            jPanel3.add(this.timeScaleSlider);
            jPanel.add(jPanel3);
            JPanel jPanel4 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            jPanel4.add(new JLabel("Color scheme:"));
            this.colorRampCombo = new JComboBox<String>(new String[]{"Monochrome", "Desaturated", "Gradient", "Rainbow"});
            this.colorRampCombo.setEnabled(false);
            this.colorRampCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    switch (AppFrame.this.colorRampCombo.getSelectedIndex()) {
                        case 0: {
                            AppFrame.this.attrs = attrsRampMono;
                            break;
                        }
                        case 1: {
                            AppFrame.this.attrs = attrsRampDesat;
                            break;
                        }
                        case 2: {
                            AppFrame.this.attrs = attrsRampGradient;
                            break;
                        }
                        case 3: {
                            AppFrame.this.attrs = attrsRampHue;
                        }
                    }
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel4.add(this.colorRampCombo);
            jPanel.add(jPanel4);
            this.getLayerPanel().add((Component)jPanel, "South");
            this.getWwd().addSelectListener(new SelectListener(){

                public void selected(SelectEvent selectEvent) {
                    if (!(AppFrame.this.lastHighlit == null || selectEvent.getTopObject() != null && selectEvent.getTopObject().equals(AppFrame.this.lastHighlit))) {
                        AppFrame.this.lastHighlit.setAttributes((MarkerAttributes)AppFrame.this.lastAttrs);
                        AppFrame.this.lastHighlit = null;
                    }
                    if (!selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
                        return;
                    }
                    if (selectEvent.getTopObject() == null || selectEvent.getTopPickedObject().getParentLayer() == null) {
                        return;
                    }
                    if (selectEvent.getTopPickedObject().getParentLayer() != timedMarkerLayer) {
                        return;
                    }
                    if (AppFrame.this.lastHighlit == null && selectEvent.getTopObject() instanceof Marker) {
                        AppFrame.this.lastHighlit = (Marker)selectEvent.getTopObject();
                        AppFrame.this.lastAttrs = (BasicMarkerAttributes)AppFrame.this.lastHighlit.getAttributes();
                        BasicMarkerAttributes basicMarkerAttributes = new BasicMarkerAttributes(AppFrame.this.lastAttrs);
                        basicMarkerAttributes.setMaterial(Material.WHITE);
                        basicMarkerAttributes.setOpacity(1.0);
                        basicMarkerAttributes.setMarkerPixels(AppFrame.this.lastAttrs.getMarkerPixels() * 1.4);
                        basicMarkerAttributes.setMinMarkerSize(AppFrame.this.lastAttrs.getMinMarkerSize() * 1.4);
                        AppFrame.this.lastHighlit.setAttributes((MarkerAttributes)basicMarkerAttributes);
                    }
                }
            });
        }

        protected TimedMarkerLayer buildTracksLayer() {
            try {
                Object object;
                GpxReader gpxReader = new GpxReader();
                gpxReader.readStream(WWIO.openFileOrResourceStream((String)MarkersOrder.TRACK_PATH, this.getClass()));
                TrackPointIteratorImpl trackPointIteratorImpl = new TrackPointIteratorImpl((Iterable)gpxReader.getTracks());
                long l = 0L;
                ArrayList<Marker> arrayList = new ArrayList<Marker>();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                simpleDateFormat.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                while (trackPointIteratorImpl.hasNext()) {
                    object = trackPointIteratorImpl.next();
                    long l2 = 0L;
                    if (object.getTime() != null) {
                        try {
                            l2 = simpleDateFormat.parse(object.getTime().replaceAll("[TZ]", " ").trim()).getTime();
                        }
                        catch (Exception exception) {
                            l2 = 0L;
                        }
                    }
                    l = l2 > l ? l2 : l;
                    arrayList.add((Marker)new TimedMarker(object.getPosition(), this.attrs[0], l2));
                }
                object = new TimedMarkerLayer(arrayList);
                ((TimedMarkerLayer)((Object)object)).setLatestTime(l);
                object.setOverrideMarkerElevation(true);
                object.setKeepSeparated(true);
                object.setElevation(0.0);
                return object;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return null;
        }

        protected PowerOfTwoPaddedImage createLegendForHours(MarkerAttributes[] markerAttributesArray) {
            BufferedImage bufferedImage = new BufferedImage(64, 320, 6);
            Graphics graphics = bufferedImage.getGraphics();
            int n = 24;
            int n2 = 2;
            int n3 = bufferedImage.getWidth() / 2 - n2;
            int n4 = (bufferedImage.getHeight() - n2 * (n - 1)) / n;
            for (int i = 0; i < n; ++i) {
                int n5 = 0;
                int n6 = i * (bufferedImage.getHeight() / n);
                graphics.setColor(markerAttributesArray[i].getMaterial().getDiffuse());
                graphics.fillRect(n5, n6, n3, n4);
                n5 = n3 + n2 + n2;
                String string = String.format("%02d", i);
                graphics.setColor(Color.BLACK);
                graphics.drawString(string, n5 + 1, (n6 += n4) + 1);
                graphics.setColor(Color.WHITE);
                graphics.drawString(string, n5, n6);
            }
            return PowerOfTwoPaddedImage.fromBufferedImage(bufferedImage);
        }

        protected PowerOfTwoPaddedImage createLegendForDaysOfWeek(MarkerAttributes[] markerAttributesArray) {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
            String[] stringArray = dateFormatSymbols.getShortWeekdays();
            BufferedImage bufferedImage = new BufferedImage(64, 100, 6);
            Graphics graphics = bufferedImage.getGraphics();
            int n = 7;
            int n2 = 2;
            int n3 = bufferedImage.getWidth() / 2 - n2;
            int n4 = (bufferedImage.getHeight() - n2 * (n - 1)) / n;
            for (int i = 0; i < n; ++i) {
                int n5 = 0;
                int n6 = i * (bufferedImage.getHeight() / n);
                graphics.setColor(markerAttributesArray[i].getMaterial().getDiffuse());
                graphics.fillRect(n5, n6, n3, n4);
                n5 = n3 + n2 + n2;
                n6 = n6 + n4 - 1;
                String string = stringArray[i + 1].toUpperCase();
                graphics.setColor(Color.BLACK);
                graphics.drawString(string, n5 + 1, n6 + 1);
                graphics.setColor(Color.WHITE);
                graphics.drawString(string, n5, n6);
            }
            return PowerOfTwoPaddedImage.fromBufferedImage(bufferedImage);
        }

        protected void updateScreenAnnotation(PowerOfTwoPaddedImage powerOfTwoPaddedImage) {
            if (this.screenAnnotation != null) {
                this.renderableLayer.removeRenderable((Renderable)this.screenAnnotation);
            }
            if (powerOfTwoPaddedImage != null) {
                this.screenAnnotation = new ScreenAnnotation("", new Point(20, 20));
                this.screenAnnotation.getAttributes().setImageSource((Object)powerOfTwoPaddedImage.getPowerOfTwoImage());
                this.screenAnnotation.getAttributes().setSize(new Dimension(powerOfTwoPaddedImage.getOriginalWidth(), powerOfTwoPaddedImage.getOriginalHeight()));
                this.screenAnnotation.getAttributes().setDrawOffset(new Point(powerOfTwoPaddedImage.getOriginalWidth() / 2, 0));
                this.screenAnnotation.getAttributes().setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFixed");
                this.screenAnnotation.getAttributes().setBorderWidth(0.0);
                this.screenAnnotation.getAttributes().setCornerRadius(0);
                this.screenAnnotation.getAttributes().setBackgroundColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                this.renderableLayer.addRenderable((Renderable)this.screenAnnotation);
            }
        }

        static {
            float f;
            float f2;
            int n;
            attrsRampMono = new MarkerAttributes[32];
            for (n = 0; n < 32; ++n) {
                f2 = Math.max(1.0f - (float)n / 32.0f, 0.2f);
                AppFrame.attrsRampMono[n] = new BasicMarkerAttributes(new Material(Color.RED), "gov.nasa.worldwind.render.markers.Sphere", (double)f2, 10.0, 5.0);
            }
            attrsRampDesat = new MarkerAttributes[32];
            for (n = 0; n < 32; ++n) {
                f2 = 1.0f;
                f = 1.0f - (float)n / 35.2f;
                float f3 = Math.max(1.0f - (float)n / 32.0f, 0.2f);
                AppFrame.attrsRampDesat[n] = new BasicMarkerAttributes(new Material(Color.getHSBColor(f2, f, 1.0f)), "gov.nasa.worldwind.render.markers.Sphere", (double)f3, 10.0, 5.0);
            }
            attrsRampGradient = new MarkerAttributes[32];
            for (n = 0; n < 32; ++n) {
                f2 = 1.0f - (float)n / 32.0f;
                f = Math.max(1.0f - (float)n / 32.0f, 0.2f);
                AppFrame.attrsRampGradient[n] = new BasicMarkerAttributes(new Material(AppFrame.interpolateColor(Color.RED, Color.BLUE, f2)), "gov.nasa.worldwind.render.markers.Sphere", (double)f, 10.0, 5.0);
            }
            attrsRampHue = new MarkerAttributes[32];
            for (n = 0; n < 32; ++n) {
                f2 = (float)n / 35.2f;
                f = Math.max(1.0f - (float)n / 32.0f, 0.2f);
                AppFrame.attrsRampHue[n] = new BasicMarkerAttributes(new Material(Color.getHSBColor(f2, 1.0f, 1.0f)), "gov.nasa.worldwind.render.markers.Sphere", (double)f, 10.0, 5.0);
            }
            attrsDayOfWeek = new MarkerAttributes[7];
            for (n = 1; n <= 7; ++n) {
                AppFrame.attrsDayOfWeek[n - 1] = new BasicMarkerAttributes(new Material(AppFrame.computeColorForDayOfWeek(n)), "gov.nasa.worldwind.render.markers.Sphere", 1.0, 10.0, 5.0);
            }
            attrsHours = new MarkerAttributes[24];
            for (n = 0; n < 24; ++n) {
                AppFrame.attrsHours[n] = new BasicMarkerAttributes(new Material(AppFrame.computeColorForHour(n)), "gov.nasa.worldwind.render.markers.Sphere", 1.0, 10.0, 5.0);
            }
        }

        protected class TimedMarkerLayer
        extends MarkerLayer {
            protected long latestTime;
            protected long timeScale;

            public TimedMarkerLayer(Iterable<Marker> iterable) {
                super(iterable);
                this.latestTime = 0L;
                this.timeScale = 600000L;
            }

            public void draw(DrawContext drawContext, Point point) {
                if (!drawContext.isPickingMode()) {
                    Calendar calendar = Calendar.getInstance();
                    for (Marker marker : this.getMarkers()) {
                        TimedMarker timedMarker = (TimedMarker)marker;
                        int n = 0;
                        switch (AppFrame.this.colorMode) {
                            case 0: {
                                n = Math.min((int)((this.latestTime - timedMarker.time) / this.timeScale), AppFrame.this.attrs.length - 1);
                                break;
                            }
                            case 1: {
                                calendar.setTimeInMillis(timedMarker.time);
                                n = calendar.get(7) - 1;
                                break;
                            }
                            case 2: {
                                calendar.setTimeInMillis(timedMarker.time);
                                n = calendar.get(11) % 24;
                            }
                        }
                        if (timedMarker == AppFrame.this.lastHighlit) continue;
                        timedMarker.setAttributes(AppFrame.this.attrs[n]);
                    }
                }
                super.draw(drawContext, point);
            }

            public void setLatestTime(long l) {
                this.latestTime = l;
            }

            public long getLatestTime() {
                return this.latestTime;
            }

            public void setTimeScale(long l) {
                this.timeScale = l;
            }

            public long getTimeScale() {
                return this.timeScale;
            }
        }

        protected class TimedMarker
        extends BasicMarker {
            protected long time;

            public TimedMarker(Position position, MarkerAttributes markerAttributes, long l) {
                super(position, markerAttributes);
                this.time = l;
            }
        }
    }
}

