/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.MultiResolutionPath;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.ArrayList;

public class MultiResPath
extends ApplicationTemplate {
    protected static final int NUM_POSITIONS = 108000;
    protected static final double SPEED = 1.4110703485986582E-5;
    protected static final Position[] ORIGIN = new Position[]{Position.fromDegrees((double)40.2377, (double)-105.648, (double)200.0), Position.fromDegrees((double)41.2625, (double)-105.6503, (double)200.0), Position.fromDegrees((double)42.2285, (double)-105.6169, (double)200.0), Position.fromDegrees((double)43.2019, (double)-105.6467, (double)200.0), Position.fromDegrees((double)44.2414, (double)-105.6911, (double)200.0)};

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind UAVPath Test", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            this.makeMany();
        }

        protected void makeMany() {
            for (Position position : ORIGIN) {
                this.addShape(position);
            }
        }

        protected void addShape(Position position) {
            Position position2;
            int n = 2;
            LatLon latLon = new LatLon((LatLon)position);
            double d = 500.0;
            double d2 = 0.0;
            double d3 = 4.233211045795975E-5;
            ArrayList<Position> arrayList = new ArrayList<Position>(108000);
            for (int i = 0; i < 108000; ++i) {
                position2 = new Position(latLon, d);
                arrayList.add(position2);
                d += 5.0;
                latLon = LatLon.rhumbEndPosition((LatLon)latLon, (double)(d2 += 0.04908738521234052), (double)d3);
            }
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setDrawInterior(false);
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            position2 = new MultiResolutionPath(arrayList);
            position2.setShowPositions(true);
            position2.setShowPositionsThreshold(5000.0);
            position2.setViewDistanceExpiration(false);
            position2.setAltitudeMode(n);
            position2.setAttributes((ShapeAttributes)basicShapeAttributes);
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.addRenderable((Renderable)position2);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

