/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParallelPaths
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)49.05);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)-122.78);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)8000);
        ApplicationTemplate.start("World Wind Multi Path", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            List<Position> list = Arrays.asList(Position.fromDegrees((double)49.0457, (double)-122.8115, (double)100.0), Position.fromDegrees((double)49.0539, (double)-122.8091, (double)110.0), Position.fromDegrees((double)49.0621, (double)-122.7937, (double)120.0), Position.fromDegrees((double)49.0681, (double)-122.8044, (double)130.0), Position.fromDegrees((double)49.0682, (double)-122.773, (double)140.0), Position.fromDegrees((double)49.0482, (double)-122.7764, (double)150.0), Position.fromDegrees((double)49.0498, (double)-122.7466, (double)140.0), Position.fromDegrees((double)49.0389, (double)-122.7453, (double)130.0), Position.fromDegrees((double)49.0321, (double)-122.7759, (double)120.0), Position.fromDegrees((double)49.0394, (double)-122.7689, (double)110.0), Position.fromDegrees((double)49.0629, (double)-122.7666, (double)100.0));
            ArrayList<Position> arrayList = new ArrayList<Position>();
            ArrayList<Position> arrayList2 = new ArrayList<Position>();
            ArrayList<Position> arrayList3 = new ArrayList<Position>();
            ArrayList<Position> arrayList4 = new ArrayList<Position>();
            Globe globe = this.getWwd().getModel().getGlobe();
            WWMath.generateParallelLines(list, arrayList, arrayList2, (double)50.0, (Globe)globe);
            WWMath.generateParallelLines(list, arrayList3, arrayList4, (double)100.0, (Globe)globe);
            RenderableLayer renderableLayer = new RenderableLayer();
            this.addPath(renderableLayer, list, "Control Path");
            this.addPath(renderableLayer, arrayList, "Path 1");
            this.addPath(renderableLayer, arrayList2, "Path 2");
            this.addPath(renderableLayer, arrayList3, "Path 3");
            this.addPath(renderableLayer, arrayList4, "Path 4");
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), (Layer)renderableLayer);
        }

        protected void addPath(RenderableLayer renderableLayer, List<Position> list, String string) {
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineWidth(5.0);
            Path path = new Path(list);
            path.setPathType("gov.nasa.worldwind.avkey.Linear");
            path.setAltitudeMode(2);
            path.setAttributes((ShapeAttributes)basicShapeAttributes);
            path.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)string);
            renderableLayer.addRenderable((Renderable)path);
            path.setPositionColors((Path.PositionColors)new ExamplePositionColors());
        }

        public static class ExamplePositionColors
        implements Path.PositionColors {
            public Color getColor(Position position, int n) {
                double d = position.getAltitude();
                return d < 115.0 ? Color.GREEN : (d < 135.0 ? Color.BLUE : Color.RED);
            }
        }
    }
}

