/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.ToolTipController;
import java.awt.Color;
import java.util.ArrayList;

public class PathPositionColors
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)47.589);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)-122.3137);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)3000);
        ApplicationTemplate.start("World Wind Path Position Colors", AppFrame.class);
    }

    public static class ExamplePositionColors
    implements Path.PositionColors {
        protected Color[] colors;
        protected int pathLength;

        public ExamplePositionColors(Color[] colorArray, int n) {
            this.colors = colorArray;
            this.pathLength = n;
        }

        public Color getColor(Position position, int n) {
            int n2 = this.colors.length * n / this.pathLength;
            return this.colors[n2];
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.add(Position.fromDegrees((double)47.58495213398363, (double)-122.31517238581496, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.58557392961059, (double)-122.31038095541774, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.585643343225826, (double)-122.30380786403879, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.588442264013494, (double)-122.30292363044828, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.59082509462611, (double)-122.30354883680081, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.592022012752125, (double)-122.30513978083029, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.59253456911678, (double)-122.30947924950297, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.592351544411116, (double)-122.31370241373538, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.59215114879707, (double)-122.31893777293358, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.591633551472405, (double)-122.32215105706649, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.59107338189763, (double)-122.32440174494027, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.58935250213581, (double)-122.32511028595225, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.585577065954475, (double)-122.32436748847293, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.58476284067178, (double)-122.32277296412886, (double)0.0));
            arrayList.add(Position.fromDegrees((double)47.584304450759085, (double)-122.32186049274797, (double)0.0));
            Path path = new Path(arrayList);
            path.setAltitudeMode(1);
            path.setFollowTerrain(true);
            path.setShowPositions(true);
            path.setShowPositionsScale(3.0);
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineWidth(3.0);
            path.setAttributes((ShapeAttributes)basicShapeAttributes);
            Color[] colorArray = new Color[]{new Color(1.0f, 0.0f, 0.0f, 0.2f), new Color(0.0f, 1.0f, 0.0f, 0.6f), new Color(0.0f, 0.0f, 1.0f, 1.0f)};
            path.setPositionColors((Path.PositionColors)new ExamplePositionColors(colorArray, arrayList.size()));
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.addRenderable((Renderable)path);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
            this.setToolTipController(new ToolTipController(this.getWwd()){

                @Override
                public void selected(SelectEvent selectEvent) {
                    PickedObject pickedObject = selectEvent.getTopPickedObject();
                    if (pickedObject != null && pickedObject.getObject() instanceof Path) {
                        String string = pickedObject.getValue("gov.nasa.worldwind.avkey.Ordinal") != null ? "Position " + pickedObject.getValue("gov.nasa.worldwind.avkey.Ordinal") : null;
                        ((Path)pickedObject.getObject()).setValue("gov.nasa.worldwind.avkey.DisplayName", string);
                    }
                    super.selected(selectEvent);
                }
            });
        }
    }
}

