/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.DirectedPath;
import java.util.ArrayList;

public class PathsWithDirection
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)49.06);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)-122.77);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)22000);
        ApplicationTemplate.start("World Wind Paths With Direction", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setOutlineWidth(2.0);
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.add(Position.fromDegrees((double)49.01653274909177, (double)-122.7349081128505, (double)1.0));
            arrayList.add(Position.fromDegrees((double)49.01715024535254, (double)-122.7596194200486, (double)10.0));
            arrayList.add(Position.fromDegrees((double)49.02781845803761, (double)-122.7651733463364, (double)100.0));
            arrayList.add(Position.fromDegrees((double)49.05312411976134, (double)-122.7926787136435, (double)1000.0));
            arrayList.add(Position.fromDegrees((double)49.0747697644625, (double)-122.8224152286015, (double)1000.0));
            arrayList.add(Position.fromDegrees((double)49.09727187849899, (double)-122.8187118695457, (double)1000.0));
            arrayList.add(Position.fromDegrees((double)49.1002974270654, (double)-122.7348314826556, (double)100.0));
            arrayList.add(Position.fromDegrees((double)49.11190305133165, (double)-122.7345541413842, (double)100.0));
            arrayList.add(Position.fromDegrees((double)49.11101764617014, (double)-122.7455553490629, (double)10.0));
            arrayList.add(Position.fromDegrees((double)49.11509767012883, (double)-122.7459193678911, (double)10.0));
            arrayList.add(Position.fromDegrees((double)49.11467371318521, (double)-122.7563706291131, (double)10.0));
            DirectedPath directedPath = new DirectedPath(arrayList);
            directedPath.setAttributes((ShapeAttributes)basicShapeAttributes);
            directedPath.setVisible(true);
            directedPath.setAltitudeMode(2);
            directedPath.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
            renderableLayer.addRenderable((Renderable)directedPath);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

