/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.LabeledPath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.util.Arrays;
import java.util.List;

public class PathsWithLabels
extends ApplicationTemplate {
    protected static final double[] SAN_JUAN_COUNTY_1 = new double[]{-123.025486, 48.717966, -123.019699, 48.721312, -123.009787, 48.722291, -123.007511, 48.718863, -123.005086, 48.694342, -123.014449, 48.684978, -123.021215, 48.681416, -123.042337, 48.675663, -123.041645, 48.678633, -123.035672, 48.68535, -123.03636, 48.69008, -123.047058, 48.695772, -123.070427, 48.699971, -123.040179, 48.717296, -123.025486, 48.717966};
    protected static final double[] SAN_JUAN_COUNTY_2 = new double[]{-122.906298643435, 48.7142756789313, -122.894599, 48.71503, -122.883606017278, 48.7133157521183, -122.879724954535, 48.7127105384329, -122.875938, 48.71212, -122.836802504198, 48.6993713019117, -122.834290842953, 48.6985531083446, -122.833124, 48.698173, -122.831410808922, 48.6973051154063, -122.82568362967, 48.6944037865925, -122.808804479515, 48.6858529865323, -122.805788100163, 48.6843249204562, -122.802545, 48.682682, -122.800267, 48.67962, -122.761393485795, 48.6676429790988, -122.744791626046, 48.6625279071718, -122.743049, 48.661991, -122.742776245752, 48.6616237548803, -122.742082, 48.660689, -122.755031, 48.649512, -122.762709974974, 48.6457601003223, -122.774165127982, 48.6401631834124, -122.783875, 48.635419, -122.792147, 48.633502, -122.806316669653, 48.621771378491, -122.807583040252, 48.6207229903106, -122.809622, 48.619035, -122.80958330326, 48.6188448346238, -122.808864, 48.61531, -122.79901, 48.604683, -122.79877, 48.602352, -122.800217, 48.60169, -122.801521572817, 48.600075268642, -122.804869, 48.595932, -122.804736685678, 48.5955635328447, -122.802617338743, 48.5896616038081, -122.801096, 48.585425, -122.796913105296, 48.5828999845133, -122.787753320193, 48.5773706559316, -122.786586, 48.576666, -122.771206, 48.562426, -122.770349, 48.558106, -122.772384, 48.552143, -122.782618, 48.545191, -122.788503, 48.530393, -122.787596684858, 48.5246062248558, -122.787347, 48.523012, -122.777467, 48.517799, -122.779073275586, 48.5091830812273, -122.779124, 48.508911, -122.799155517055, 48.4953208059023, -122.799759583816, 48.4949109824973, -122.800414, 48.494467, -122.809344417182, 48.490749639512, -122.816332, 48.487841, -122.816392492828, 48.48768965307, -122.817912, 48.483888, -122.818113811431, 48.4811078199731, -122.818435504082, 48.4766761409594, -122.818482000648, 48.4760355983364, -122.81973, 48.458843, -122.8131, 48.452856, -122.810699656295, 48.4489394154454, -122.807708, 48.444058, -122.80671619552, 48.4419671792455, -122.802509, 48.433098, -122.803004619265, 48.4309676207466, -122.80332683408, 48.4295826064757, -122.803521, 48.428748, -122.806510124273, 48.4265382433425, -122.812173045928, 48.4223518403418, -122.812208, 48.422326, -122.825307995692, 48.4240652785748, -122.825803, 48.424131, -122.85254248494, 48.4208474850799, -122.863360429977, 48.4195190793902, -122.866475017092, 48.4191366190217, -122.866865338919, 48.419088688871, -122.867939205531, 48.4189568218194, -122.86799681456, 48.4189497476327, -122.874135, 48.418196, -122.874527604161, 48.4182203541858, -122.883759, 48.418793, -122.888474856222, 48.4206350791676, -122.893646, 48.422655, -122.889016, 48.435947, -122.903214, 48.436979, -122.913888, 48.443231, -122.917771, 48.439781, -122.927683717092, 48.4399602096806, -122.928004, 48.439966, -122.927964788402, 48.4400111660268, -122.91646, 48.453263, -122.920099, 48.458428, -122.926901, 48.460874, -122.937881, 48.456221, -122.950555015899, 48.4535630706048, -122.962009, 48.451161, -123.001288, 48.4556628590224, -123.026267878952, 48.4585258619868, -123.029013724265, 48.4588405698076, -123.033178635901, 48.4593179201736, -123.038888830654, 48.4599723790898, -123.039156, 48.460003, -123.058154, 48.471522, -123.067675, 48.479497, -123.070563309358, 48.4802266082759, -123.070833040893, 48.4802947444538, -123.076030355349, 48.481607624471, -123.099948917862, 48.4876496300162, -123.119451, 48.492576, -123.129287766067, 48.4982542349179, -123.134915117353, 48.5015026015408, -123.141478, 48.505291, -123.14482270173, 48.5083136865329, -123.148640952156, 48.5117643302889, -123.150537321568, 48.5134781244465, -123.151065, 48.513955, -123.152147442285, 48.5153416540207, -123.152738173008, 48.5160984048828, -123.163234, 48.529544, -123.164057, 48.535622, -123.161853, 48.539255, -123.161750942688, 48.5414834733667, -123.16147, 48.547618, -123.167656573858, 48.5526319405021, -123.172412, 48.556486, -123.176266, 48.562131, -123.176243708612, 48.5624730166654, -123.175852, 48.568483, -123.171958, 48.572255, -123.173061, 48.579086, -123.184941, 48.58697, -123.195467450664, 48.586350555389, -123.196697396232, 48.5862781774168, -123.197754, 48.586216, -123.198045125962, 48.586452281282, -123.20268, 48.590214, -123.203026, 48.596178, -123.195725, 48.607055, -123.179996129946, 48.6207472995959, -123.178425, 48.622115, -123.151643, 48.623686, -123.139705244805, 48.6227863453916, -123.135644582323, 48.6201710055677, -123.131377372596, 48.6205150057834, -123.107362, 48.622451, -123.10164791887, 48.6162765822218, -123.098626049648, 48.6130112657825, -123.098462, 48.612834, -123.098254, 48.610092, -123.102074, 48.604035, -123.101552, 48.59782, -123.100979011718, 48.597692305347, -123.08799197019, 48.5947980476233, -123.079379694944, 48.5928787387418, -123.079368517922, 48.5928762478604, -123.079334903513, 48.5928687566419, -123.078354245955, 48.5926502098924, -123.078029433353, 48.5925778230151, -123.077161967252, 48.5923845018144, -123.07472713592, 48.591841881744, -123.074611, 48.591816, -123.06004, 48.582105, -123.056818600556, 48.5785370170628, -123.055637295811, 48.5772286182611, -123.049834129163, 48.5708011012966, -123.048403, 48.569216, -123.037067007025, 48.5647482308128, -123.033669, 48.563409, -123.025587194622, 48.562285888132, -123.015046, 48.560821, -123.014957175286, 48.5608244377565, -123.005887152572, 48.5611754721491, -122.994982694655, 48.561597504142, -122.987296, 48.561895, -122.98611, 48.569984, -122.989649, 48.574668, -122.995026, 48.578162, -123.001291973563, 48.5798454915671, -123.003071284953, 48.5803235426935, -123.0048, 48.580788, -123.016647, 48.580244, -123.023206615953, 48.5845746092944, -123.028982347697, 48.5883877041088, -123.033093576815, 48.5911019067628, -123.034101, 48.591767, -123.024902, 48.594484, -123.023433, 48.599477, -123.041189, 48.611947, -123.046453150843, 48.6114965755598, -123.04653, 48.61149, -123.048652, 48.621002, -123.040078194353, 48.6254322142389, -123.023495, 48.634001, -123.015592, 48.642567, -123.014829, 48.647503, -123.009977399319, 48.654981685575, -123.009924, 48.655064, -123.001295006939, 48.6600601213626, -122.99988983534, 48.6608737050326, -122.988884, 48.667246, -122.984853, 48.672686, -122.970595802002, 48.6809490071059, -122.949116, 48.693398, -122.941316, 48.702904, -122.942367, 48.706723, -122.927109877131, 48.7110138483226, -122.918837934242, 48.7133402143466, -122.918252, 48.713505, -122.908658361456, 48.714123538823, -122.907454714043, 48.7142011426071, -122.906298643435, 48.7142756789313};
    protected static final double[] SAN_JUAN_COUNTY_3 = new double[]{-123.172066, 48.679866, -123.14799, 48.668001, -123.133285875321, 48.6583191438863, -123.130962, 48.656789, -123.122016049879, 48.647064627471, -123.106165, 48.633473, -123.119677246557, 48.6329724058636, -123.134956336931, 48.6372395392956, -123.170932260699, 48.6515091289271, -123.197404105632, 48.6620089945159, -123.215917, 48.669352, -123.229744313989, 48.678544158148, -123.233070031572, 48.6807550374269, -123.237148, 48.683466, -123.237135383772, 48.6835850832961, -123.236567, 48.68895, -123.213499856684, 48.6896934099409, -123.212892, 48.689713, -123.212464368268, 48.6895683569085, -123.202992056872, 48.6863644216061, -123.197953, 48.68466, -123.186997647353, 48.6848970569698, -123.186076, 48.684917, -123.184143390981, 48.6842202399606, -123.183803136584, 48.6840975686572, -123.172066, 48.679866};

    public static void main(String[] stringArray) {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)48.6);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)-122.95);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)70000);
        PathsWithLabels.start("World Wind Paths with Labels", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            this.makePaths();
        }

        protected void makePaths() {
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes.setOutlineOpacity(0.8);
            basicShapeAttributes.setOutlineWidth(3.0);
            List<Position> list = this.makePositionList(SAN_JUAN_COUNTY_1);
            SurfacePolyline surfacePolyline = new SurfacePolyline((ShapeAttributes)basicShapeAttributes, list);
            LabeledPath labeledPath = new LabeledPath(list, this.makeLabelAnnotation("Waldron Island"));
            labeledPath.setAltitudeMode(1);
            renderableLayer.addRenderable((Renderable)surfacePolyline);
            renderableLayer.addRenderable((Renderable)labeledPath);
            list = this.makePositionList(SAN_JUAN_COUNTY_2);
            surfacePolyline = new SurfacePolyline((ShapeAttributes)basicShapeAttributes, list);
            labeledPath = new LabeledPath(list, this.makeLabelAnnotation("Blakley, Center, Lopez, Orcas, Shaw & San Juan Islands"));
            labeledPath.setAltitudeMode(1);
            renderableLayer.addRenderable((Renderable)surfacePolyline);
            renderableLayer.addRenderable((Renderable)labeledPath);
            list = this.makePositionList(SAN_JUAN_COUNTY_3);
            surfacePolyline = new SurfacePolyline((ShapeAttributes)basicShapeAttributes, list);
            labeledPath = new LabeledPath(list, this.makeLabelAnnotation("Spieden & Stuart Islands"));
            labeledPath.setAltitudeMode(1);
            renderableLayer.addRenderable((Renderable)surfacePolyline);
            renderableLayer.addRenderable((Renderable)labeledPath);
            this.getWwd().getModel().getLayers().add((Layer)renderableLayer);
        }

        protected List<Position> makePositionList(double[] dArray) {
            int n = dArray.length / 2;
            Position[] positionArray = new Position[n];
            for (int i = 0; i < n; ++i) {
                double d = dArray[2 * i];
                double d2 = dArray[2 * i + 1];
                positionArray[i] = Position.fromDegrees((double)d2, (double)d, (double)0.0);
            }
            return Arrays.asList(positionArray);
        }

        protected ScreenAnnotation makeLabelAnnotation(String string) {
            ScreenAnnotation screenAnnotation = new ScreenAnnotation(string, new Point());
            screenAnnotation.setPickEnabled(false);
            AnnotationAttributes annotationAttributes = new AnnotationAttributes();
            annotationAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFitText");
            annotationAttributes.setFrameShape("gov.nasa.worldwind.avkey.ShapeRectangle");
            annotationAttributes.setDrawOffset(new Point(0, 10));
            annotationAttributes.setLeaderGapWidth(5);
            annotationAttributes.setTextColor(Color.BLACK);
            annotationAttributes.setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 0.8f));
            annotationAttributes.setCornerRadius(5);
            annotationAttributes.setBorderColor(new Color(0xABABAB));
            annotationAttributes.setFont(Font.decode("Arial-PLAIN-12"));
            annotationAttributes.setTextAlign("gov.nasa.worldwind.avkey.Center");
            annotationAttributes.setInsets(new Insets(5, 5, 5, 5));
            screenAnnotation.setAttributes(annotationAttributes);
            return screenAnnotation;
        }
    }
}

