/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Color;

public class Placemarks
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Placemarks", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            RenderableLayer renderableLayer = new RenderableLayer();
            PointPlacemark pointPlacemark = new PointPlacemark(Position.fromDegrees((double)28.0, (double)-102.0, (double)10000.0));
            pointPlacemark.setLabelText("Placemark A");
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Clamp to ground, Label, Semi-transparent, Audio icon");
            pointPlacemark.setLineEnabled(false);
            pointPlacemark.setAltitudeMode(1);
            PointPlacemarkAttributes pointPlacemarkAttributes = new PointPlacemarkAttributes();
            pointPlacemarkAttributes.setImageAddress("gov/nasa/worldwindx/examples/images/audioicon-64.png");
            pointPlacemarkAttributes.setImageColor(new Color(1.0f, 1.0f, 1.0f, 0.6f));
            pointPlacemarkAttributes.setScale(Double.valueOf(0.6));
            pointPlacemarkAttributes.setLabelOffset(new Offset(Double.valueOf(0.9), Double.valueOf(0.6), "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction"));
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            renderableLayer.addRenderable((Renderable)pointPlacemark);
            pointPlacemark = new PointPlacemark(pointPlacemark.getPosition());
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Clamp to ground, Default icon over audio icon");
            pointPlacemark.setAltitudeMode(1);
            renderableLayer.addRenderable((Renderable)pointPlacemark);
            pointPlacemark = new PointPlacemark(Position.fromDegrees((double)28.0, (double)-104.0, (double)10000.0));
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Clamp to ground, Audio icon, Heading 90, Screen relative");
            pointPlacemark.setLabelText("Placemark B");
            pointPlacemark.setLineEnabled(false);
            pointPlacemark.setAltitudeMode(1);
            pointPlacemarkAttributes = new PointPlacemarkAttributes(pointPlacemarkAttributes);
            pointPlacemarkAttributes.setHeading(Double.valueOf(90.0));
            pointPlacemarkAttributes.setHeadingReference("gov.nasa.worldwind.avkey.RelativeToScreen");
            pointPlacemarkAttributes.setScale(Double.valueOf(0.6));
            pointPlacemarkAttributes.setImageOffset(new Offset(Double.valueOf(19.0), Double.valueOf(8.0), "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.Pixels"));
            pointPlacemarkAttributes.setLabelOffset(new Offset(Double.valueOf(0.9), Double.valueOf(0.6), "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction"));
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            renderableLayer.addRenderable((Renderable)pointPlacemark);
            pointPlacemark = new PointPlacemark(pointPlacemark.getPosition());
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Clamp to ground, Default icon over rotated audio icon");
            pointPlacemark.setAltitudeMode(1);
            renderableLayer.addRenderable((Renderable)pointPlacemark);
            pointPlacemark = new PointPlacemark(Position.fromDegrees((double)29.0, (double)-104.0, (double)20000.0));
            pointPlacemark.setLabelText("Placemark C");
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Absolute, Label, Red pin icon, Line in random color and 2 wide");
            pointPlacemark.setLineEnabled(true);
            pointPlacemark.setAltitudeMode(0);
            pointPlacemarkAttributes = new PointPlacemarkAttributes();
            pointPlacemarkAttributes.setScale(Double.valueOf(0.6));
            pointPlacemarkAttributes.setImageOffset(new Offset(Double.valueOf(19.0), Double.valueOf(8.0), "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.Pixels"));
            pointPlacemarkAttributes.setLabelOffset(new Offset(Double.valueOf(0.9), Double.valueOf(0.6), "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction"));
            pointPlacemarkAttributes.setLineMaterial(new Material(WWUtil.makeRandomColor(null)));
            pointPlacemarkAttributes.setLineWidth(Double.valueOf(2.0));
            pointPlacemarkAttributes.setImageAddress("images/pushpins/plain-red.png");
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            renderableLayer.addRenderable((Renderable)pointPlacemark);
            pointPlacemark = new PointPlacemark(Position.fromDegrees((double)30.0, (double)-104.5, (double)20000.0));
            pointPlacemark.setLabelText("Placemark D");
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Relative to ground, Label, Teal pin icon, No line");
            pointPlacemark.setAltitudeMode(2);
            pointPlacemarkAttributes = new PointPlacemarkAttributes(pointPlacemarkAttributes);
            pointPlacemarkAttributes.setImageAddress("images/pushpins/plain-teal.png");
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            renderableLayer.addRenderable((Renderable)pointPlacemark);
            pointPlacemark = new PointPlacemark(Position.fromDegrees((double)28.0, (double)-104.5, (double)20000.0));
            pointPlacemark.setLabelText("Placemark E");
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Clamp to ground, Blue label, White pin icon");
            pointPlacemark.setAltitudeMode(1);
            pointPlacemarkAttributes = new PointPlacemarkAttributes(pointPlacemarkAttributes);
            pointPlacemarkAttributes.setLabelColor("ffff0000");
            pointPlacemarkAttributes.setImageAddress("images/pushpins/plain-white.png");
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            renderableLayer.addRenderable((Renderable)pointPlacemark);
            pointPlacemark = new PointPlacemark(Position.fromDegrees((double)30.0, (double)-103.5, (double)2000.0));
            pointPlacemark.setLabelText("Placemark F");
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"All defaults");
            renderableLayer.addRenderable((Renderable)pointPlacemark);
            pointPlacemark = new PointPlacemark(Position.fromDegrees((double)29.0, (double)-104.5, (double)20000.0));
            pointPlacemark.setLabelText("Placemark G");
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Clamp to ground, White label, Red point, Scale 5");
            pointPlacemark.setAltitudeMode(1);
            pointPlacemarkAttributes = new PointPlacemarkAttributes();
            pointPlacemarkAttributes.setLabelColor("ffffffff");
            pointPlacemarkAttributes.setLineColor("ff0000ff");
            pointPlacemarkAttributes.setUsePointAsDefaultImage(true);
            pointPlacemarkAttributes.setScale(Double.valueOf(5.0));
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            renderableLayer.addRenderable((Renderable)pointPlacemark);
            pointPlacemark = new PointPlacemark(Position.fromDegrees((double)30.0, (double)-104.0, (double)20000.0));
            pointPlacemark.setLabelText("Placemark H");
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Relative to ground, Blue label, Magenta point and line, Scale 10");
            pointPlacemark.setAltitudeMode(2);
            pointPlacemark.setLineEnabled(true);
            pointPlacemarkAttributes = new PointPlacemarkAttributes();
            pointPlacemarkAttributes.setLabelColor("ffff0000");
            pointPlacemarkAttributes.setLineMaterial(Material.MAGENTA);
            pointPlacemarkAttributes.setLineWidth(Double.valueOf(2.0));
            pointPlacemarkAttributes.setUsePointAsDefaultImage(true);
            pointPlacemarkAttributes.setScale(Double.valueOf(10.0));
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            renderableLayer.addRenderable((Renderable)pointPlacemark);
            pointPlacemark = new PointPlacemark(Position.fromDegrees((double)28.0, (double)-103.0, (double)10000.0));
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Clamp to ground, Audio icon, Heading -45, Globe relative");
            pointPlacemark.setLabelText("Placemark I");
            pointPlacemark.setLineEnabled(false);
            pointPlacemark.setAltitudeMode(1);
            pointPlacemarkAttributes = new PointPlacemarkAttributes(pointPlacemarkAttributes);
            pointPlacemarkAttributes.setImageAddress("gov/nasa/worldwindx/examples/images/audioicon-64.png");
            pointPlacemarkAttributes.setHeading(Double.valueOf(-45.0));
            pointPlacemarkAttributes.setHeadingReference("gov.nasa.worldwind.avkey.RelativeToGlobe");
            pointPlacemarkAttributes.setScale(Double.valueOf(0.6));
            pointPlacemarkAttributes.setImageOffset(new Offset(Double.valueOf(19.0), Double.valueOf(8.0), "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.Pixels"));
            pointPlacemarkAttributes.setLabelColor("ffffffff");
            pointPlacemarkAttributes.setLabelOffset(new Offset(Double.valueOf(0.9), Double.valueOf(0.6), "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction"));
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            renderableLayer.addRenderable((Renderable)pointPlacemark);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

