/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.ArrayList;

public class Polygons
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Extruded Polygons", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            this.getWwd().addSelectListener((SelectListener)new BasicDragger(this.getWwd()));
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes.setOutlineOpacity(0.5);
            basicShapeAttributes.setInteriorOpacity(0.8);
            basicShapeAttributes.setOutlineMaterial(Material.GREEN);
            basicShapeAttributes.setOutlineWidth(2.0);
            basicShapeAttributes.setDrawOutline(true);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setEnableLighting(true);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes((ShapeAttributes)basicShapeAttributes);
            basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes2.setOutlineOpacity(1.0);
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.add(Position.fromDegrees((double)28.0, (double)-106.0, (double)30000.0));
            arrayList.add(Position.fromDegrees((double)35.0, (double)-104.0, (double)30000.0));
            arrayList.add(Position.fromDegrees((double)35.0, (double)-107.0, (double)90000.0));
            arrayList.add(Position.fromDegrees((double)28.0, (double)-107.0, (double)90000.0));
            arrayList.add(Position.fromDegrees((double)28.0, (double)-106.0, (double)30000.0));
            Polygon polygon = new Polygon(arrayList);
            polygon.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Has a hole\nRotated -170\u00b0");
            arrayList.clear();
            arrayList.add(Position.fromDegrees((double)29.0, (double)-106.4, (double)40000.0));
            arrayList.add(Position.fromDegrees((double)30.0, (double)-106.4, (double)40000.0));
            arrayList.add(Position.fromDegrees((double)29.0, (double)-106.8, (double)70000.0));
            arrayList.add(Position.fromDegrees((double)29.0, (double)-106.4, (double)40000.0));
            polygon.addInnerBoundary(arrayList);
            polygon.setAltitudeMode(2);
            polygon.setAttributes((ShapeAttributes)basicShapeAttributes);
            polygon.setHighlightAttributes((ShapeAttributes)basicShapeAttributes2);
            polygon.setRotation(Double.valueOf(-170.0));
            renderableLayer.addRenderable((Renderable)polygon);
            ArrayList<Position> arrayList2 = new ArrayList<Position>();
            arrayList2.add(Position.fromDegrees((double)28.0, (double)-110.0, (double)50000.0));
            arrayList2.add(Position.fromDegrees((double)35.0, (double)-108.0, (double)50000.0));
            arrayList2.add(Position.fromDegrees((double)35.0, (double)-111.0, (double)50000.0));
            arrayList2.add(Position.fromDegrees((double)28.0, (double)-111.0, (double)50000.0));
            arrayList2.add(Position.fromDegrees((double)28.0, (double)-110.0, (double)50000.0));
            polygon = new Polygon(arrayList2);
            polygon.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Has an image");
            basicShapeAttributes = new BasicShapeAttributes((ShapeAttributes)basicShapeAttributes);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setInteriorMaterial(Material.WHITE);
            basicShapeAttributes.setInteriorOpacity(1.0);
            polygon.setAttributes((ShapeAttributes)basicShapeAttributes);
            polygon.setHighlightAttributes((ShapeAttributes)basicShapeAttributes2);
            float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f};
            polygon.setTextureImageSource((Object)"images/32x32-icon-nasa.png", fArray, 5);
            renderableLayer.addRenderable((Renderable)polygon);
            arrayList2.clear();
            arrayList2.add(Position.fromDegrees((double)28.0, (double)-170.0, (double)290000.0));
            arrayList2.add(Position.fromDegrees((double)35.0, (double)-174.0, (double)290000.0));
            arrayList2.add(Position.fromDegrees((double)35.0, (double)174.0, (double)290000.0));
            arrayList2.add(Position.fromDegrees((double)28.0, (double)170.0, (double)290000.0));
            arrayList2.add(Position.fromDegrees((double)28.0, (double)-170.0, (double)290000.0));
            polygon = new Polygon(arrayList2);
            polygon.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Spans dateline\nRotated -45\u00b0");
            basicShapeAttributes = new BasicShapeAttributes((ShapeAttributes)basicShapeAttributes);
            basicShapeAttributes.setDrawInterior(true);
            polygon.setAttributes((ShapeAttributes)basicShapeAttributes);
            polygon.setHighlightAttributes((ShapeAttributes)basicShapeAttributes2);
            polygon.setAltitudeMode(2);
            polygon.setRotation(Double.valueOf(-45.0));
            renderableLayer.addRenderable((Renderable)polygon);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

