/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Box;
import gov.nasa.worldwind.render.Cone;
import gov.nasa.worldwind.render.Cylinder;
import gov.nasa.worldwind.render.Ellipsoid;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Pyramid;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.Wedge;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.ArrayList;

public class RigidShapes
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Rigid Shapes", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            this.makeShapes();
        }

        protected void makeShapes() {
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Rigid Shapes");
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes.setInteriorOpacity(0.7);
            basicShapeAttributes.setEnableLighting(true);
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setOutlineWidth(2.0);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setDrawOutline(false);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes();
            basicShapeAttributes2.setInteriorMaterial(Material.PINK);
            basicShapeAttributes2.setInteriorOpacity(1.0);
            basicShapeAttributes2.setEnableLighting(true);
            basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes2.setOutlineWidth(2.0);
            basicShapeAttributes2.setDrawOutline(false);
            Pyramid pyramid = new Pyramid(Position.fromDegrees((double)40.0, (double)-120.0, (double)220000.0), 200000.0, 200000.0, 200000.0);
            pyramid.setAltitudeMode(0);
            pyramid.setAttributes((ShapeAttributes)basicShapeAttributes);
            pyramid.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Pyramid with equal axes, ABSOLUTE altitude mode");
            renderableLayer.addRenderable((Renderable)pyramid);
            Cone cone = new Cone(Position.fromDegrees((double)37.5, (double)-115.0, (double)200000.0), 200000.0, 200000.0, 200000.0);
            cone.setAltitudeMode(2);
            cone.setAttributes((ShapeAttributes)basicShapeAttributes);
            cone.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Cone with equal axes, RELATIVE_TO_GROUND altitude mode");
            renderableLayer.addRenderable((Renderable)cone);
            Wedge wedge = new Wedge(Position.fromDegrees((double)35.0, (double)-110.0, (double)200000.0), Angle.fromDegrees((double)225.0), 200000.0, 200000.0, 200000.0);
            wedge.setAltitudeMode(1);
            wedge.setAttributes((ShapeAttributes)basicShapeAttributes);
            wedge.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Wedge with equal axes, CLAMP_TO_GROUND altitude mode");
            renderableLayer.addRenderable((Renderable)wedge);
            Box box = new Box(Position.fromDegrees((double)0.0, (double)-90.0, (double)600000.0), 600000.0, 600000.0, 600000.0);
            box.setAltitudeMode(2);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("images/32x32-icon-nasa.png");
            arrayList.add(null);
            arrayList.add("gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            arrayList.add(null);
            arrayList.add("images/64x64-crosshair.png");
            arrayList.add(null);
            box.setImageSources(arrayList);
            box.setAttributes((ShapeAttributes)basicShapeAttributes);
            box.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Box with a texture");
            renderableLayer.addRenderable((Renderable)box);
            Ellipsoid ellipsoid = new Ellipsoid(Position.fromDegrees((double)0.0, (double)-110.0, (double)600000.0), 600000.0, 600000.0, 600000.0);
            ellipsoid.setAltitudeMode(2);
            ellipsoid.setImageSources((Object)"gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            ellipsoid.setAttributes((ShapeAttributes)basicShapeAttributes);
            ellipsoid.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Sphere with a texture");
            renderableLayer.addRenderable((Renderable)ellipsoid);
            Cylinder cylinder = new Cylinder(Position.fromDegrees((double)0.0, (double)-130.0, (double)600000.0), 600000.0, 600000.0, 600000.0);
            cylinder.setAltitudeMode(2);
            cylinder.setImageSources((Object)"gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            cylinder.setAttributes((ShapeAttributes)basicShapeAttributes);
            cylinder.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Cylinder with a texture");
            renderableLayer.addRenderable((Renderable)cylinder);
            cylinder = new Cylinder(Position.ZERO, 600000.0, 500000.0, 300000.0);
            cylinder.setAltitudeMode(0);
            cylinder.setAttributes((ShapeAttributes)basicShapeAttributes);
            cylinder.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Cylinder with default orientation");
            renderableLayer.addRenderable((Renderable)cylinder);
            Ellipsoid ellipsoid2 = new Ellipsoid(Position.fromDegrees((double)0.0, (double)30.0, (double)750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            ellipsoid2.setAltitudeMode(2);
            ellipsoid2.setAttributes((ShapeAttributes)basicShapeAttributes2);
            ellipsoid2.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Ellipsoid with a pre-set orientation");
            renderableLayer.addRenderable((Renderable)ellipsoid2);
            ellipsoid2 = new Ellipsoid(Position.fromDegrees((double)30.0, (double)30.0, (double)750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            ellipsoid2.setAltitudeMode(2);
            ellipsoid2.setImageSources((Object)"gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            ellipsoid2.setAttributes((ShapeAttributes)basicShapeAttributes2);
            ellipsoid2.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Ellipsoid with a pre-set orientation");
            renderableLayer.addRenderable((Renderable)ellipsoid2);
            ellipsoid2 = new Ellipsoid(Position.fromDegrees((double)60.0, (double)30.0, (double)750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            ellipsoid2.setAltitudeMode(2);
            ellipsoid2.setAttributes((ShapeAttributes)basicShapeAttributes2);
            ellipsoid2.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Ellipsoid with a pre-set orientation");
            renderableLayer.addRenderable((Renderable)ellipsoid2);
            ellipsoid2 = new Ellipsoid(Position.fromDegrees((double)-45.0, (double)-180.0, (double)750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            ellipsoid2.setAltitudeMode(2);
            ellipsoid2.setAttributes((ShapeAttributes)basicShapeAttributes2);
            ellipsoid2.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Ellipsoid oriented in 3rd \"quadrant\" (-X, -Y, -Z)");
            renderableLayer.addRenderable((Renderable)ellipsoid2);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

