/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.layers.BasicLayerFactory;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.terrain.BasicElevationModelFactory;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwindx.examples.ApplicationTemplate;

public class ScankortDenmark {
    public static void setupConfiguration() {
        Sector sector = ScankortDenmark.getDenmarkSector();
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)ScankortDenmark.computeZoomForExtent(sector));
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)sector.getCentroid().getLatitude().degrees);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)sector.getCentroid().getLongitude().degrees);
    }

    public static Sector getDenmarkSector() {
        return new Sector(Angle.fromDMS((String)"54\u00b0 33\u2019 35\u201d"), Angle.fromDMS((String)"57\u00b0 45\u2019 7\u201d"), Angle.fromDMS((String)"8\u00b0 4\u2019 22\u201d"), Angle.fromDMS((String)"15\u00b0 11\u2019 55\u201d"));
    }

    public static double computeZoomForExtent(Sector sector) {
        Angle angle = sector.getDeltaLat();
        if (sector.getDeltaLon().compareTo(angle) > 0) {
            angle = sector.getDeltaLon();
        }
        double d = angle.radians * 6378137.0;
        double d2 = Configuration.getDoubleValue((String)"gov.nasa.worldwind.avkey.FieldOfView", (Double)45.0);
        return d / (2.0 * Math.tan(d2 / 2.0));
    }

    public static void main(String[] stringArray) {
        ScankortDenmark.setupConfiguration();
        ApplicationTemplate.start("Scankort Denmark Data", MyAppFrame.class);
    }

    private static class MyAppFrame
    extends ApplicationTemplate.AppFrame {
        public MyAppFrame() {
            BasicLayerFactory basicLayerFactory = new BasicLayerFactory();
            Layer layer = (Layer)basicLayerFactory.createFromConfigSource((Object)"config/Earth/ScankortDenmarkImageLayer.xml", null);
            layer.setEnabled(true);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), layer);
            this.getLayerPanel().update(this.getWwd());
            BasicElevationModelFactory basicElevationModelFactory = new BasicElevationModelFactory();
            ElevationModel elevationModel = (ElevationModel)basicElevationModelFactory.createFromConfigSource((Object)"config/Earth/ScankortDenmarkDSMElevationModel.xml", null);
            if (this.getWwd().getModel().getGlobe().getElevationModel() instanceof CompoundElevationModel) {
                ((CompoundElevationModel)this.getWwd().getModel().getGlobe().getElevationModel()).addElevationModel(elevationModel);
            } else {
                this.getWwd().getModel().getGlobe().setElevationModel(elevationModel);
            }
        }
    }
}

