/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.event.MessageListener;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Highlightable;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.HighlightController;
import gov.nasa.worldwindx.examples.util.ScreenSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ScreenSelection
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ScreenSelection.start("World Wind Screen Selection", AppFrame.class);
    }

    protected static class SelectionHighlightController
    extends HighlightController
    implements MessageListener {
        protected ScreenSelector screenSelector;
        protected List<Highlightable> lastBoxHighlightObjects = new ArrayList<Highlightable>();

        public SelectionHighlightController(WorldWindow worldWindow, ScreenSelector screenSelector) {
            super(worldWindow, "gov.nasa.worldwind.SelectEvent.Rollover");
            this.screenSelector = screenSelector;
            this.screenSelector.addMessageListener(this);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.screenSelector.removeMessageListener(this);
        }

        public void onMessage(Message message) {
            try {
                if (message.getName().equals("ScreenSelector.SelectionStarted") || message.getName().equals("ScreenSelector.SelectionChanged")) {
                    this.highlightSelectedObjects(this.screenSelector.getSelectedObjects());
                }
            }
            catch (Exception exception) {
                Util.getLogger().warning(exception.getMessage() != null ? exception.getMessage() : exception.toString());
            }
        }

        @Override
        protected void highlight(Object object) {
            if (this.lastHighlightObject != object && this.lastBoxHighlightObjects.contains(this.lastHighlightObject)) {
                this.lastHighlightObject = null;
                return;
            }
            super.highlight(object);
        }

        protected void highlightSelectedObjects(List<?> list) {
            if (this.lastBoxHighlightObjects.equals(list)) {
                return;
            }
            for (Object object : this.lastBoxHighlightObjects) {
                if (object == this.lastHighlightObject) continue;
                object.setHighlighted(false);
            }
            this.lastBoxHighlightObjects.clear();
            if (list != null) {
                for (Object object : list) {
                    if (!(object instanceof Highlightable)) continue;
                    object.setHighlighted(true);
                    this.lastBoxHighlightObjects.add((Highlightable)object);
                }
            }
            this.wwd.redraw();
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected ScreenSelector screenSelector = new ScreenSelector(this.getWwd());
        protected SelectionHighlightController selectionHighlightController = new SelectionHighlightController(this.getWwd(), this.screenSelector);

        public AppFrame() {
            this.getWwjPanel().highlightController.dispose();
            JButton jButton = new JButton(new EnableSelectorAction());
            JPanel jPanel = new JPanel(new BorderLayout(5, 5));
            jPanel.add((Component)jButton, "Center");
            this.getLayerPanel().add((Component)jPanel, "South");
            this.addShapes();
        }

        protected void addShapes() {
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.RED);
            basicShapeAttributes.setOutlineMaterial(Material.WHITE);
            for (int i = -180; i < 180; i += 10) {
                for (int j = -90; j < 90; j += 10) {
                    ExtrudedPolygon extrudedPolygon = new ExtrudedPolygon(Arrays.asList(LatLon.fromDegrees((double)(j - 1), (double)(i - 1)), LatLon.fromDegrees((double)(j - 1), (double)(i + 1)), LatLon.fromDegrees((double)(j + 1), (double)(i + 1)), LatLon.fromDegrees((double)(j + 1), (double)(i - 1))), Double.valueOf(100000.0));
                    extrudedPolygon.setHighlightAttributes((ShapeAttributes)basicShapeAttributes);
                    extrudedPolygon.setSideHighlightAttributes((ShapeAttributes)basicShapeAttributes);
                    renderableLayer.addRenderable((Renderable)extrudedPolygon);
                }
            }
            this.getWwd().getModel().getLayers().add((Layer)renderableLayer);
        }

        protected class DisableSelectorAction
        extends AbstractAction {
            public DisableSelectorAction() {
                super("Stop");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JButton)actionEvent.getSource()).setAction(new EnableSelectorAction());
                AppFrame.this.screenSelector.disable();
            }
        }

        protected class EnableSelectorAction
        extends AbstractAction {
            public EnableSelectorAction() {
                super("Start");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JButton)actionEvent.getSource()).setAction(new DisableSelectorAction());
                AppFrame.this.screenSelector.enable();
            }
        }
    }
}

