/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.OpenStreetMapShapefileLoader;
import gov.nasa.worldwindx.examples.util.ShapefileLoader;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Shapefiles
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Shapefiles.start("World Wind Shapefiles", AppFrame.class);
    }

    public static class WorkerThread
    extends Thread {
        protected Object source;
        protected AppFrame appFrame;

        public WorkerThread(Object object, AppFrame appFrame) {
            this.source = object;
            this.appFrame = appFrame;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                final List<Layer> list = this.makeShapefileLayers();
                for (int i = 0; i < list.size(); ++i) {
                    String string = this.makeDisplayName(this.source);
                    list.get(i).setName(i == 0 ? string : string + "-" + Integer.toString(i));
                    list.get(i).setPickEnabled(this.appFrame.pickCheck.isSelected());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (Layer layer : list) {
                            ApplicationTemplate.insertBeforePlacenames(WorkerThread.this.appFrame.getWwd(), layer);
                            WorkerThread.this.appFrame.layers.add(layer);
                        }
                        WorkerThread.this.appFrame.layerPanel.update(WorkerThread.this.appFrame.getWwd());
                    }
                });
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((Component)WorkerThread.this.appFrame.getWwd()).setCursor(Cursor.getDefaultCursor());
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        protected List<Layer> makeShapefileLayers() {
            if (OpenStreetMapShapefileLoader.isOSMPlacesSource(this.source)) {
                Layer layer = OpenStreetMapShapefileLoader.makeLayerFromOSMPlacesSource(this.source);
                ArrayList<Layer> arrayList = new ArrayList<Layer>();
                arrayList.add(layer);
                return arrayList;
            }
            ShapefileLoader shapefileLoader = new ShapefileLoader();
            return shapefileLoader.createLayersFromSource(this.source);
        }

        protected String makeDisplayName(Object object) {
            String string = WWIO.getSourcePath((Object)object);
            if (string != null) {
                string = WWIO.getFilename((String)string);
            }
            if (string == null) {
                string = "Shapefile";
            }
            return string;
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected List<Layer> layers = new ArrayList<Layer>();
        protected BasicDragger dragger;
        protected JFileChooser fc = new JFileChooser(Configuration.getUserHomeDirectory());
        protected JCheckBox pickCheck;
        protected JCheckBox dragCheck;

        public AppFrame() {
            this.makeControlPanel();
            this.dragger = new BasicDragger(this.getWwd());
            this.fc = new JFileChooser();
            this.fc.addChoosableFileFilter(new FileNameExtensionFilter("ESRI Shapefile", "shp"));
        }

        protected void makeControlPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(0, 9, 9, 9), new TitledBorder("Shapefiles")));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 5));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel.add(jPanel2);
            JButton jButton = new JButton("Open File...");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.showOpenFileDialog();
                }
            });
            jPanel2.add(jButton);
            JButton jButton2 = new JButton("Open URL...");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.showOpenURLDialog();
                }
            });
            jPanel2.add(jButton2);
            JPanel jPanel3 = new JPanel(new GridLayout(1, 1, 10, 10));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.pickCheck = new JCheckBox("Allow picking");
            this.pickCheck.setSelected(true);
            this.pickCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.enablePicking(((JCheckBox)actionEvent.getSource()).isSelected());
                }
            });
            jPanel3.add(this.pickCheck);
            this.dragCheck = new JCheckBox("Allow dragging");
            this.dragCheck.setSelected(false);
            this.dragCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.enableDragging(((JCheckBox)actionEvent.getSource()).isSelected());
                }
            });
            jPanel3.add(this.dragCheck);
            jPanel.add(jPanel3);
            this.getLayerPanel().add((Component)jPanel, "South");
        }

        protected void enablePicking(boolean bl) {
            for (Layer layer : this.layers) {
                layer.setPickEnabled(bl);
            }
            this.dragCheck.setEnabled(bl);
        }

        protected void enableDragging(boolean bl) {
            if (bl) {
                this.getWwd().addSelectListener((SelectListener)this.dragger);
            } else {
                this.getWwd().removeSelectListener((SelectListener)this.dragger);
            }
        }

        public void showOpenFileDialog() {
            int n = this.fc.showOpenDialog(this);
            if (n != 0) {
                return;
            }
            WorkerThread workerThread = new WorkerThread(this.fc.getSelectedFile(), this);
            workerThread.start();
            ((Component)this.getWwd()).setCursor(new Cursor(3));
        }

        public void showOpenURLDialog() {
            String string = JOptionPane.showInputDialog(this, "Enter Shapefile URL", "Open", 1);
            if (WWUtil.isEmpty((Object)string)) {
                return;
            }
            URL uRL = WWIO.makeURL((String)string);
            if (uRL == null) {
                JOptionPane.showMessageDialog(this, string + " is not a valid URL.", "Open", 0);
                return;
            }
            WorkerThread workerThread = new WorkerThread(uRL, this);
            workerThread.start();
            ((Component)this.getWwd()).setCursor(new Cursor(3));
        }
    }
}

