/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.util.BasicDragger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import javax.swing.JFrame;

public class SimpleShapeDragging
extends JFrame {
    public SimpleShapeDragging() {
        final WorldWindowGLCanvas worldWindowGLCanvas = new WorldWindowGLCanvas();
        worldWindowGLCanvas.setPreferredSize(new Dimension(1000, 800));
        this.getContentPane().add((Component)worldWindowGLCanvas, "Center");
        worldWindowGLCanvas.setModel((Model)new BasicModel());
        SurfaceImage surfaceImage = new SurfaceImage((Object)"images/400x230-splash-nww.png", Sector.fromDegrees((double)35.0, (double)45.0, (double)-115.0, (double)-95.0));
        RenderableLayer renderableLayer = new RenderableLayer();
        renderableLayer.addRenderable((Renderable)surfaceImage);
        SimpleShapeDragging.insertBeforePlacenames((WorldWindow)worldWindowGLCanvas, (Layer)renderableLayer);
        worldWindowGLCanvas.addSelectListener(new SelectListener(){
            private BasicDragger dragger;
            {
                this.dragger = new BasicDragger((WorldWindow)worldWindowGLCanvas);
            }

            public void selected(SelectEvent selectEvent) {
                this.dragger.selected(selectEvent);
            }
        });
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleShapeDragging simpleShapeDragging = new SimpleShapeDragging();
                simpleShapeDragging.setDefaultCloseOperation(3);
                simpleShapeDragging.pack();
                simpleShapeDragging.setVisible(true);
            }
        });
    }

    public static void insertBeforePlacenames(WorldWindow worldWindow, Layer layer) {
        int n = 0;
        LayerList layerList = worldWindow.getModel().getLayers();
        for (Layer layer2 : layerList) {
            if (!(layer2 instanceof PlaceNameLayer)) continue;
            n = layerList.indexOf((Object)layer2);
        }
        layerList.add(n, layer);
    }
}

