/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.terrain.HighResolutionTerrain;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class TerrainIntersections
extends ApplicationTemplate {
    protected static final Angle GRID_RADIUS = Angle.fromDegrees((double)0.05);
    protected static final int GRID_DIMENSION = 10;
    protected static final Double TARGET_RESOLUTION = 10.0;
    protected static final int NUM_THREADS = 4;

    public static void main(String[] stringArray) {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)34000.0);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)37.9521);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)-119.7761);
        ApplicationTemplate.start("World Wind Terrain Intersections", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private static final Cursor WaitCursor = new Cursor(3);
        protected HighResolutionTerrain terrain;
        protected RenderableLayer gridLayer;
        protected RenderableLayer intersectionsLayer;
        protected RenderableLayer sightLinesLayer;
        protected RenderableLayer tilesLayer;
        protected Thread calculationDispatchThread;
        protected JProgressBar progressBar;
        protected ThreadPoolExecutor threadPool;
        protected List<Position> grid;
        protected int numGridPoints;
        protected long startTime;
        protected long endTime;
        protected Position previousCurrentPosition;
        protected List<Position> firstIntersectionPositions = new ArrayList<Position>();
        protected List<Position[]> sightLines = new ArrayList<Position[]>(100);
        protected Position referencePosition;
        protected Vec4 referencePoint;
        private long lastTime = System.currentTimeMillis();

        public AppFrame() {
            super(true, true, false);
            this.threadPool = new ThreadPoolExecutor(4, 4, 200L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setBorder(new EmptyBorder(0, 10, 0, 10));
            this.progressBar.setBorderPainted(false);
            this.progressBar.setStringPainted(true);
            this.layerPanel.add((Component)this.progressBar, "South");
            this.terrain = new HighResolutionTerrain(this.getWwd().getModel().getGlobe(), TARGET_RESOLUTION);
            this.terrain.setCacheCapacity(200000000L);
            this.gridLayer = new RenderableLayer();
            this.gridLayer.setName("Grid");
            this.getWwd().getModel().getLayers().add((Layer)this.gridLayer);
            this.intersectionsLayer = new RenderableLayer();
            this.intersectionsLayer.setName("Intersections");
            this.getWwd().getModel().getLayers().add((Layer)this.intersectionsLayer);
            this.sightLinesLayer = new RenderableLayer();
            this.sightLinesLayer.setName("Sight Lines");
            this.getWwd().getModel().getLayers().add((Layer)this.sightLinesLayer);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().getInputHandler().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 2) != 0) {
                        if (AppFrame.this.calculationDispatchThread != null && AppFrame.this.calculationDispatchThread.isAlive()) {
                            AppFrame.this.calculationDispatchThread.interrupt();
                        }
                        return;
                    }
                    if ((mouseEvent.getModifiers() & 8) != 0) {
                        if (AppFrame.this.previousCurrentPosition == null) {
                            return;
                        }
                        mouseEvent.consume();
                        AppFrame.this.computeAndShowIntersections(AppFrame.this.previousCurrentPosition);
                        return;
                    }
                    if ((mouseEvent.getModifiers() & 1) == 0) {
                        return;
                    }
                    mouseEvent.consume();
                    Position position = AppFrame.this.getWwd().getCurrentPosition();
                    if (position == null) {
                        return;
                    }
                    AppFrame.this.computeAndShowIntersections(position);
                }
            });
        }

        protected void computeAndShowIntersections(final Position position) {
            this.previousCurrentPosition = position;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AppFrame.this.setCursor(WaitCursor);
                }
            });
            this.calculationDispatchThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AppFrame.this.performIntersectionTests(position);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("Operation was interrupted");
                    }
                }
            });
            this.calculationDispatchThread.start();
        }

        protected synchronized void addIntersectionPosition(Position position) {
            this.firstIntersectionPositions.add(position);
        }

        protected synchronized void addSightLine(Position position, Position position2) {
            this.sightLines.add(new Position[]{position, position2});
        }

        protected synchronized int getSightlinesSize() {
            return this.sightLines.size();
        }

        protected synchronized void updateProgress() {
            if (this.sightLines.size() >= this.numGridPoints) {
                this.endTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() < this.lastTime + 250L) {
                return;
            }
            this.lastTime = System.currentTimeMillis();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = (int)(100.0 * (double)AppFrame.this.getSightlinesSize() / (double)AppFrame.this.numGridPoints);
                    AppFrame.this.progressBar.setValue(n);
                    if (n >= 100) {
                        AppFrame.this.setCursor(Cursor.getDefaultCursor());
                        AppFrame.this.progressBar.setString(AppFrame.this.endTime - AppFrame.this.startTime + " ms");
                        AppFrame.this.showResults();
                        System.out.printf("Calculation time %d milliseconds\n", AppFrame.this.endTime - AppFrame.this.startTime);
                    }
                }
            });
        }

        protected void showResults() {
            this.showIntersections(this.firstIntersectionPositions);
            this.showSightLines(this.sightLines);
            this.getWwd().redraw();
        }

        protected void performIntersectionTests(Position position) throws InterruptedException {
            this.firstIntersectionPositions.clear();
            this.sightLines.clear();
            double d = TerrainIntersections.GRID_RADIUS.degrees;
            Sector sector = Sector.fromDegrees((double)(position.getLatitude().degrees - d), (double)(position.getLatitude().degrees + d), (double)(position.getLongitude().degrees - d), (double)(position.getLongitude().degrees + d));
            this.grid = this.buildGrid(sector, 5.0, 10, 10);
            this.numGridPoints = this.grid.size();
            this.referencePosition = new Position(position.getLatitude(), position.getLongitude(), 5.0);
            this.referencePoint = this.terrain.getSurfacePoint(position.getLatitude(), position.getLongitude(), 5.0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AppFrame.this.progressBar.setValue(0);
                    AppFrame.this.progressBar.setString(null);
                    AppFrame.this.clearLayers();
                    AppFrame.this.showGrid(AppFrame.this.grid, AppFrame.this.referencePosition);
                    AppFrame.this.getWwd().redraw();
                }
            });
            this.startTime = System.currentTimeMillis();
            for (Position position2 : this.grid) {
                this.threadPool.execute(new Intersector(position2));
            }
        }

        protected void performIntersection(Position position) throws InterruptedException {
            Intersection[] intersectionArray = this.terrain.intersect(this.referencePosition, position);
            if (intersectionArray == null || intersectionArray.length == 0) {
                this.sightLines.add(new Position[]{this.referencePosition, position});
                return;
            }
            Vec4 vec4 = intersectionArray[0].getIntersectionPoint();
            Vec4 vec42 = this.terrain.getSurfacePoint(position.getLatitude(), position.getLongitude(), position.getAltitude());
            if (vec4.distanceTo3(this.referencePoint) >= vec42.distanceTo3(this.referencePoint)) {
                this.addSightLine(this.referencePosition, position);
                return;
            }
            Position position2 = this.terrain.getGlobe().computePositionFromPoint(vec4);
            this.addSightLine(this.referencePosition, new Position((LatLon)position2, 0.0));
            this.addIntersectionPosition(position2);
            this.updateProgress();
        }

        protected List<Position> buildGrid(Sector sector, double d, int n, int n2) {
            ArrayList<Position> arrayList = new ArrayList<Position>((n + 1) * (n2 + 1));
            double d2 = sector.getDeltaLatDegrees() / (double)n;
            double d3 = sector.getDeltaLonDegrees() / (double)n2;
            for (int i = 0; i <= n; ++i) {
                double d4 = i == n ? sector.getMaxLatitude().degrees : sector.getMinLatitude().degrees + (double)i * d2;
                for (int j = 0; j <= n2; ++j) {
                    double d5 = j == n2 ? sector.getMaxLongitude().degrees : sector.getMinLongitude().degrees + (double)j * d3;
                    arrayList.add(Position.fromDegrees((double)d4, (double)d5, (double)d));
                }
            }
            return arrayList;
        }

        protected void preCache(List<Position> list, Position position) throws InterruptedException {
            double d = 0.0;
            long l = System.currentTimeMillis();
            for (Position position2 : list) {
                double d2 = d;
                d = d2 + 1.0;
                final double d3 = 100.0 * (d2 / (double)list.size());
                this.terrain.cacheIntersectingTiles(position, position2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AppFrame.this.progressBar.setValue((int)d3);
                        AppFrame.this.progressBar.setString(null);
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AppFrame.this.progressBar.setValue(100);
                }
            });
            long l2 = System.currentTimeMillis();
            System.out.printf("Pre-caching time %d milliseconds, cache usage %f, tiles %d\n", l2 - l, this.terrain.getCacheUsage(), this.terrain.getNumCacheEntries());
        }

        protected void clearLayers() {
            this.intersectionsLayer.removeAllRenderables();
            this.sightLinesLayer.removeAllRenderables();
            this.gridLayer.removeAllRenderables();
        }

        protected void showIntersections(List<Position> list) {
            this.intersectionsLayer.removeAllRenderables();
            PointPlacemarkAttributes pointPlacemarkAttributes = new PointPlacemarkAttributes();
            pointPlacemarkAttributes.setLineMaterial(Material.CYAN);
            pointPlacemarkAttributes.setScale(Double.valueOf(6.0));
            pointPlacemarkAttributes.setUsePointAsDefaultImage(true);
            for (Position position : list) {
                PointPlacemark pointPlacemark = new PointPlacemark(position);
                pointPlacemark.setAltitudeMode(1);
                pointPlacemark.setAttributes(pointPlacemarkAttributes);
                pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)position.toString());
                this.intersectionsLayer.addRenderable((Renderable)pointPlacemark);
            }
        }

        protected void showSightLines(List<Position[]> list) {
            this.sightLinesLayer.removeAllRenderables();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setDrawOutline(true);
            basicShapeAttributes.setDrawInterior(false);
            basicShapeAttributes.setOutlineMaterial(Material.GREEN);
            basicShapeAttributes.setOutlineOpacity(0.6);
            for (Position[] positionArray : list) {
                ArrayList<Position> arrayList = new ArrayList<Position>();
                arrayList.add(positionArray[0]);
                arrayList.add(positionArray[1]);
                Path path = new Path(arrayList);
                path.setAltitudeMode(2);
                path.setAttributes((ShapeAttributes)basicShapeAttributes);
                this.sightLinesLayer.addRenderable((Renderable)path);
            }
        }

        protected void showGridSightLines(List<Position> list, Position position) {
            this.sightLinesLayer.removeAllRenderables();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setDrawOutline(true);
            basicShapeAttributes.setDrawInterior(false);
            basicShapeAttributes.setOutlineMaterial(Material.GREEN);
            basicShapeAttributes.setOutlineOpacity(0.6);
            for (Position position2 : list) {
                ArrayList<Position> arrayList = new ArrayList<Position>();
                arrayList.add(position);
                arrayList.add(new Position(position2.getLatitude(), position2.getLongitude(), 0.0));
                Path path = new Path(arrayList);
                path.setAltitudeMode(2);
                path.setAttributes((ShapeAttributes)basicShapeAttributes);
                this.sightLinesLayer.addRenderable((Renderable)path);
            }
        }

        protected void showGrid(List<Position> list, Position position) {
            this.gridLayer.removeAllRenderables();
            PointPlacemarkAttributes pointPlacemarkAttributes = new PointPlacemarkAttributes();
            pointPlacemarkAttributes.setLineMaterial(Material.YELLOW);
            pointPlacemarkAttributes.setScale(Double.valueOf(6.0));
            pointPlacemarkAttributes.setUsePointAsDefaultImage(true);
            for (Position position2 : list) {
                PointPlacemark pointPlacemark = new PointPlacemark(position2);
                pointPlacemark.setAltitudeMode(2);
                pointPlacemark.setAttributes(pointPlacemarkAttributes);
                pointPlacemark.setLineEnabled(true);
                pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)position2.toString());
                this.gridLayer.addRenderable((Renderable)pointPlacemark);
            }
            this.showCenterPoint(position);
        }

        protected void showCenterPoint(Position position) {
            PointPlacemarkAttributes pointPlacemarkAttributes = new PointPlacemarkAttributes();
            pointPlacemarkAttributes.setLineMaterial(Material.RED);
            pointPlacemarkAttributes.setScale(Double.valueOf(8.0));
            pointPlacemarkAttributes.setUsePointAsDefaultImage(true);
            PointPlacemark pointPlacemark = new PointPlacemark(position);
            pointPlacemark.setAltitudeMode(2);
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)position.toString());
            pointPlacemark.setLineEnabled(true);
            this.gridLayer.addRenderable((Renderable)pointPlacemark);
        }

        protected class Intersector
        implements Runnable {
            protected final Position gridPosition;

            public Intersector(Position position) {
                this.gridPosition = position;
            }

            @Override
            public void run() {
                try {
                    AppFrame.this.performIntersection(this.gridPosition);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }
}

