/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ViewIteration
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        try {
            AppFrame appFrame = new AppFrame();
            appFrame.setTitle("World Wind View Paths");
            appFrame.setDefaultCloseOperation(3);
            appFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class AppFrame
    extends JFrame {
        static ArrayList<Position> path = new ArrayList();
        protected int pathPosition = 0;
        protected PathAction[] pathActions = new PathAction[]{new GoToLatLonFromCurrent("Zero", LatLon.ZERO), new FollowPath("Follow"), new Heading("Heading"), new Forward("Forward"), new Backwards("Backwards")};
        protected Dimension canvasSize = new Dimension(800, 600);
        protected ApplicationTemplate.AppPanel wwjPanel = new ApplicationTemplate.AppPanel(this.canvasSize, true);

        public AppFrame() {
            this.wwjPanel.setPreferredSize(this.canvasSize);
            JPanel jPanel = this.makeControlPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)this.wwjPanel, "Center");
            this.getContentPane().add((Component)jPanel, "West");
            this.pack();
            Dimension dimension = this.getPreferredSize();
            Point point = new Point(0, 0);
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = point.x + (dimension2.width - dimension.width) / 2;
            int n2 = point.y + (dimension2.height - dimension.height) / 2;
            this.setLocation(n, n2);
            this.setResizable(true);
        }

        protected JPanel makeControlPanel() {
            JPanel jPanel = new JPanel(new GridLayout(8, 1));
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Go To"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            for (PathAction pathAction : this.pathActions) {
                JButton jButton = new JButton(pathAction);
                jPanel.add(jButton);
            }
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "Center");
            return jPanel2;
        }

        protected Angle computeHeading(Position position, Position position2) {
            return LatLon.greatCircleAzimuth((LatLon)position, (LatLon)position2);
        }

        static {
            path.add(Position.fromDegrees((double)0.0, (double)0.0, (double)100000.0));
            path.add(Position.fromDegrees((double)0.0, (double)10.0, (double)100000.0));
            path.add(Position.fromDegrees((double)0.0, (double)20.0, (double)100000.0));
            path.add(Position.fromDegrees((double)0.0, (double)30.0, (double)100000.0));
            path.add(Position.fromDegrees((double)0.0, (double)40.0, (double)100000.0));
            path.add(Position.fromDegrees((double)0.0, (double)50.0, (double)100000.0));
            path.add(Position.fromDegrees((double)0.0, (double)60.0, (double)100000.0));
            path.add(Position.fromDegrees((double)0.0, (double)70.0, (double)100000.0));
        }

        protected class FollowPath
        extends PathAction {
            ArrayList<Position> path;

            FollowPath(String string) {
                super(string);
                this.path = new ArrayList();
                this.path.add(Position.fromDegrees((double)0.0, (double)0.0, (double)100000.0));
                this.path.add(Position.fromDegrees((double)1.0, (double)3.0, (double)100000.0));
                this.path.add(Position.fromDegrees((double)2.0, (double)4.0, (double)100000.0));
                this.path.add(Position.fromDegrees((double)3.0, (double)5.0, (double)100000.0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (Position position : this.path) {
                    BasicOrbitView basicOrbitView = (BasicOrbitView)AppFrame.this.wwjPanel.getWwd().getView();
                    basicOrbitView.addEyePositionAnimator(4000L, basicOrbitView.getEyePosition(), new Position((LatLon)position, basicOrbitView.getEyePosition().getElevation()));
                }
            }
        }

        protected class GoToLatLonFromCurrent
        extends PathAction {
            protected final LatLon latlon;

            GoToLatLonFromCurrent(String string, LatLon latLon) {
                super(string);
                this.latlon = latLon;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicOrbitView basicOrbitView = (BasicOrbitView)AppFrame.this.wwjPanel.getWwd().getView();
                basicOrbitView.addEyePositionAnimator(4000L, basicOrbitView.getEyePosition(), new Position(this.latlon, basicOrbitView.getEyePosition().getElevation()));
            }
        }

        protected class Heading
        extends PathAction {
            public Heading(String string) {
                super(string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Angle angle = AppFrame.this.pathPosition == 0 ? AppFrame.this.computeHeading(path.get(0), path.get(1)) : AppFrame.this.computeHeading(path.get(AppFrame.this.pathPosition - 1), path.get(AppFrame.this.pathPosition));
                BasicOrbitView basicOrbitView = (BasicOrbitView)AppFrame.this.wwjPanel.getWwd().getView();
                basicOrbitView.addHeadingAnimator(basicOrbitView.getHeading(), angle);
            }
        }

        protected class Backwards
        extends PathAction {
            public Backwards(String string) {
                super(string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AppFrame.this.pathPosition > 0) {
                    BasicOrbitView basicOrbitView = (BasicOrbitView)AppFrame.this.wwjPanel.getWwd().getView();
                    basicOrbitView.addEyePositionAnimator(4000L, basicOrbitView.getEyePosition(), path.get(--AppFrame.this.pathPosition));
                }
            }
        }

        protected class Forward
        extends PathAction {
            public Forward(String string) {
                super(string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AppFrame.this.pathPosition < path.size() - 1) {
                    BasicOrbitView basicOrbitView = (BasicOrbitView)AppFrame.this.wwjPanel.getWwd().getView();
                    basicOrbitView.setHeading(Angle.fromDegrees((double)90.0));
                    basicOrbitView.addEyePositionAnimator(4000L, basicOrbitView.getEyePosition(), path.get(++AppFrame.this.pathPosition));
                }
            }
        }

        protected abstract class PathAction
        extends AbstractAction {
            PathAction(String string) {
                super(string);
            }
        }
    }
}

