/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BalloonAttributes;
import gov.nasa.worldwind.render.BasicBalloonAttributes;
import gov.nasa.worldwind.render.GlobeBrowserBalloon;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.BalloonController;
import gov.nasa.worldwindx.examples.util.HotSpotController;
import java.awt.Component;
import java.awt.Dimension;
import java.io.InputStream;

public class WebBrowserBalloons
extends ApplicationTemplate {
    protected static final String BROWSER_BALLOON_CONTENT_PATH = "gov/nasa/worldwindx/examples/data/BrowserBalloonExample.html";

    public static void main(String[] stringArray) {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)62);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)-77);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)9500000);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialPitch", (Object)45);
        WebBrowserBalloons.start("World Wind Web Browser Balloons", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected HotSpotController hotSpotController;
        protected BalloonController balloonController;

        public AppFrame() {
            this.makeBrowserBalloon();
            this.hotSpotController = new HotSpotController(this.getWwd());
            this.balloonController = new BalloonController(this.getWwd());
            Dimension dimension = new Dimension(1200, 800);
            this.setPreferredSize(dimension);
            this.pack();
            WWUtil.alignComponent(null, (Component)this, (String)"gov.nasa.worldwind.avkey.Center");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void makeBrowserBalloon() {
            String string = null;
            InputStream inputStream = null;
            try {
                inputStream = WWIO.openFileOrResourceStream((String)WebBrowserBalloons.BROWSER_BALLOON_CONTENT_PATH, this.getClass());
                string = WWIO.readStreamToString((InputStream)inputStream, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                WWIO.closeStream((Object)inputStream, (String)WebBrowserBalloons.BROWSER_BALLOON_CONTENT_PATH);
            }
            if (string == null) {
                string = Logging.getMessage((String)"generic.ExceptionAttemptingToReadFile", (String)WebBrowserBalloons.BROWSER_BALLOON_CONTENT_PATH);
            }
            Position position = Position.fromDegrees((double)38.883056, (double)-77.016389);
            GlobeBrowserBalloon globeBrowserBalloon = new GlobeBrowserBalloon(string, position);
            BasicBalloonAttributes basicBalloonAttributes = new BasicBalloonAttributes();
            basicBalloonAttributes.setSize(new Size("gov.nasa.worldwind.render.Size.NativeDimension", 0.0, null, "gov.nasa.worldwind.render.Size.NativeDimension", 0.0, null));
            globeBrowserBalloon.setAttributes((BalloonAttributes)basicBalloonAttributes);
            PointPlacemark pointPlacemark = new PointPlacemark(position);
            pointPlacemark.setLabelText("Click to open balloon");
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.Balloon", (Object)globeBrowserBalloon);
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Web Browser Balloons");
            renderableLayer.addRenderable((Renderable)globeBrowserBalloon);
            renderableLayer.addRenderable((Renderable)pointPlacemark);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

