/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.Wedge;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Wedges
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Wedges", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            this.getLayerPanel().add((Component)this.makeDetailHintControlPanel(), "South");
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes.setInteriorOpacity(0.7);
            basicShapeAttributes.setEnableLighting(true);
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setOutlineWidth(2.0);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setDrawOutline(false);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes();
            basicShapeAttributes2.setInteriorMaterial(Material.PINK);
            basicShapeAttributes2.setInteriorOpacity(1.0);
            basicShapeAttributes2.setEnableLighting(true);
            basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes2.setOutlineWidth(2.0);
            basicShapeAttributes2.setDrawOutline(false);
            Wedge wedge = new Wedge(Position.fromDegrees((double)40.0, (double)-120.0, (double)80000.0), Angle.POS90, 50000.0, 50000.0, 50000.0);
            wedge.setAltitudeMode(0);
            wedge.setAttributes((ShapeAttributes)basicShapeAttributes);
            wedge.setVisible(true);
            wedge.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Wedge with equal axes, ABSOLUTE altitude mode");
            renderableLayer.addRenderable((Renderable)wedge);
            Wedge wedge2 = new Wedge(Position.fromDegrees((double)37.5, (double)-115.0, (double)50000.0), Angle.POS90, 50000.0, 50000.0, 50000.0);
            wedge2.setAltitudeMode(2);
            wedge2.setAttributes((ShapeAttributes)basicShapeAttributes);
            wedge2.setVisible(true);
            wedge2.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Wedge with equal axes, RELATIVE_TO_GROUND altitude mode");
            renderableLayer.addRenderable((Renderable)wedge2);
            Wedge wedge3 = new Wedge(Position.fromDegrees((double)35.0, (double)-110.0, (double)50000.0), Angle.POS90, 50000.0, 50000.0, 50000.0);
            wedge3.setAltitudeMode(1);
            wedge3.setAttributes((ShapeAttributes)basicShapeAttributes);
            wedge3.setVisible(true);
            wedge3.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Wedge with equal axes, CLAMP_TO_GROUND altitude mode");
            renderableLayer.addRenderable((Renderable)wedge3);
            Wedge wedge4 = new Wedge(Position.fromDegrees((double)0.0, (double)-90.0, (double)600000.0), Angle.fromDegrees((double)225.0), 1200000.0, 600000.0);
            wedge4.setAltitudeMode(2);
            wedge4.setImageSources((Object)"gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            wedge4.setAttributes((ShapeAttributes)basicShapeAttributes);
            wedge4.setVisible(true);
            wedge4.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Wedge with a texture");
            renderableLayer.addRenderable((Renderable)wedge4);
            Wedge wedge5 = new Wedge(Position.ZERO, Angle.fromDegrees((double)125.0), 500000.0, 500000.0, 500000.0);
            wedge5.setAltitudeMode(0);
            wedge5.setAttributes((ShapeAttributes)basicShapeAttributes);
            wedge5.setVisible(true);
            wedge5.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled Wedge with default orientation");
            renderableLayer.addRenderable((Renderable)wedge5);
            Wedge wedge6 = new Wedge(Position.fromDegrees((double)0.0, (double)30.0, (double)750000.0), Angle.POS90, 500000.0, 500000.0, 500000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            wedge6.setAltitudeMode(2);
            wedge6.setAttributes((ShapeAttributes)basicShapeAttributes2);
            wedge6.setVisible(true);
            wedge6.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled Wedge with a pre-set orientation");
            renderableLayer.addRenderable((Renderable)wedge6);
            Wedge wedge7 = new Wedge(Position.fromDegrees((double)30.0, (double)30.0, (double)750000.0), Angle.POS90, 500000.0, 500000.0, 500000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            wedge7.setAltitudeMode(2);
            wedge7.setImageSources((Object)"gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            wedge7.setAttributes((ShapeAttributes)basicShapeAttributes2);
            wedge7.setVisible(true);
            wedge7.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled Wedge with a pre-set orientation");
            renderableLayer.addRenderable((Renderable)wedge7);
            Wedge wedge8 = new Wedge(Position.fromDegrees((double)60.0, (double)30.0, (double)750000.0), Angle.POS90, 500000.0, 500000.0, 500000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            wedge8.setAltitudeMode(2);
            wedge8.setAttributes((ShapeAttributes)basicShapeAttributes2);
            wedge8.setVisible(true);
            wedge8.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled Wedge with a pre-set orientation");
            renderableLayer.addRenderable((Renderable)wedge8);
            Wedge wedge9 = new Wedge(Position.fromDegrees((double)-45.0, (double)-180.0, (double)750000.0), Angle.POS90, 500000.0, 1000000.0, 500000.0, Angle.fromDegrees((double)90.0), Angle.fromDegrees((double)45.0), Angle.fromDegrees((double)30.0));
            wedge9.setAltitudeMode(2);
            wedge9.setAttributes((ShapeAttributes)basicShapeAttributes2);
            wedge9.setVisible(true);
            wedge9.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Scaled, oriented Wedge with in the 3rd 'quadrant' (-X, -Y, -Z)");
            renderableLayer.addRenderable((Renderable)wedge9);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }

        protected JPanel makeDetailHintControlPanel() {
            JPanel jPanel = new JPanel(new BorderLayout(0, 10));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Detail Hint")));
            JPanel jPanel2 = new JPanel(new BorderLayout(0, 5));
            int n = -10;
            int n2 = 10;
            int n3 = 0;
            JSlider jSlider = new JSlider(n, n2, n3);
            jSlider.setMajorTickSpacing(10);
            jSlider.setMinorTickSpacing(1);
            jSlider.setPaintTicks(true);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(-10, new JLabel("-1.0"));
            hashtable.put(0, new JLabel("0.0"));
            hashtable.put(10, new JLabel("1.0"));
            jSlider.setLabelTable(hashtable);
            jSlider.setPaintLabels(true);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    double d = (double)((JSlider)changeEvent.getSource()).getValue() / 10.0;
                    AppFrame.this.setWedgeDetailHint(d);
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel2.add((Component)jSlider, "South");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 0));
            jPanel3.add(jPanel2);
            jPanel.add((Component)jPanel3, "South");
            return jPanel;
        }

        protected RenderableLayer getLayer() {
            for (Layer layer : this.getWwd().getModel().getLayers()) {
                if (!layer.getName().contains("Renderable")) continue;
                return (RenderableLayer)layer;
            }
            return null;
        }

        protected void setWedgeDetailHint(double d) {
            for (Renderable renderable : this.getLayer().getRenderables()) {
                Wedge wedge = (Wedge)renderable;
                wedge.setDetailHint(d);
            }
            System.out.println("wedge detail hint set to " + d);
        }
    }
}

