/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.analytics;

import com.jogamp.common.nio.Buffers;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.AbstractSurfaceObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurfaceAttributes;
import java.awt.Color;
import java.awt.Point;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.media.opengl.GL2;

public class AnalyticSurface
implements Renderable,
PreRenderable {
    protected static final double DEFAULT_ALTITUDE = 0.0;
    protected static final int DEFAULT_ALTITUDE_MODE = 0;
    protected static final int DEFAULT_DIMENSION = 10;
    protected static final double DEFAULT_VALUE = 0.0;
    protected static final Color DEFAULT_COLOR = Color.BLACK;
    protected static final GridPointAttributes DEFAULT_GRID_POINT_ATTRIBUTES = AnalyticSurface.createGridPointAttributes(0.0, DEFAULT_COLOR);
    protected static final long RELATIVE_TO_GROUND_REGEN_PERIOD = 2000L;
    protected boolean visible = true;
    protected Sector sector;
    protected double altitude;
    protected int altitudeMode = 0;
    protected int width;
    protected int height;
    protected Iterable<? extends GridPointAttributes> values;
    protected double verticalScale = 1.0;
    protected AnalyticSurfaceAttributes surfaceAttributes = new AnalyticSurfaceAttributes();
    protected Object pickObject;
    protected Layer clientLayer;
    protected double[] extremeValues;
    protected boolean expired = true;
    protected boolean updateFailed;
    protected Object globeStateKey;
    protected long regenTime;
    protected Position referencePos;
    protected Vec4 referencePoint;
    protected RenderInfo surfaceRenderInfo;
    protected AnalyticSurfaceObject clampToGroundSurface;
    protected AnalyticSurfaceObject shadowSurface;
    protected final PickSupport pickSupport = new PickSupport();

    public AnalyticSurface(Sector sector, double d, int n, int n2, Iterable<? extends GridPointAttributes> iterable) {
        if (sector == null) {
            String string = Logging.getMessage((String)"nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n <= 0) {
            String string = Logging.getMessage((String)"Geom.WidthInvalid", (Object[])new Object[]{n});
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 <= 0) {
            String string = Logging.getMessage((String)"Geom.HeightInvalid", (Object[])new Object[]{n});
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage((String)"nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
        this.altitude = d;
        this.width = n;
        this.height = n2;
        this.values = iterable;
        this.setExpired(true);
    }

    public AnalyticSurface(Sector sector, double d, int n, int n2) {
        this(sector, d, n, n2, AnalyticSurface.createDefaultValues(n * n2));
    }

    public AnalyticSurface(Sector sector, double d) {
        this(sector, d, 10, 10);
    }

    public AnalyticSurface(int n, int n2) {
        this(Sector.EMPTY_SECTOR, 0.0, n, n2);
    }

    public AnalyticSurface() {
        this(10, 10);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public Sector getSector() {
        return this.sector;
    }

    public void setSector(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage((String)"nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
        this.setExpired(true);
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double d) {
        this.altitude = d;
        this.setExpired(true);
    }

    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(int n) {
        this.altitudeMode = n;
        this.setExpired(true);
    }

    public int[] getDimensions() {
        return new int[]{this.width, this.height};
    }

    public void setDimensions(int n, int n2) {
        if (n <= 0) {
            String string = Logging.getMessage((String)"Geom.WidthInvalid", (Object[])new Object[]{n});
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 <= 0) {
            String string = Logging.getMessage((String)"Geom.HeightInvalid", (Object[])new Object[]{n2});
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.width = n;
        this.height = n2;
        this.setExpired(true);
    }

    public Iterable<? extends GridPointAttributes> getValues() {
        return this.values;
    }

    public void setValues(Iterable<? extends GridPointAttributes> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage((String)"nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.values = iterable;
        this.extremeValues = AnalyticSurface.computeExtremeValues(iterable);
        this.setExpired(true);
    }

    public double getVerticalScale() {
        return this.verticalScale;
    }

    public void setVerticalScale(double d) {
        this.verticalScale = d;
        this.setExpired(true);
    }

    public AnalyticSurfaceAttributes getSurfaceAttributes() {
        return this.surfaceAttributes.copy();
    }

    public void setSurfaceAttributes(AnalyticSurfaceAttributes analyticSurfaceAttributes) {
        if (analyticSurfaceAttributes == null) {
            String string = Logging.getMessage((String)"nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.surfaceAttributes = analyticSurfaceAttributes.copy();
        this.setExpired(true);
    }

    public Object getPickObject() {
        return this.pickObject;
    }

    public void setPickObject(Object object) {
        this.pickObject = object;
    }

    public Layer getClientLayer() {
        return this.clientLayer;
    }

    public void setClientLayer(Layer layer) {
        this.clientLayer = layer;
    }

    public void preRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage((String)"nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        if (!this.intersectsFrustum(drawContext)) {
            return;
        }
        if (this.isExpired(drawContext)) {
            this.update(drawContext);
        }
        if (this.isExpired(drawContext)) {
            return;
        }
        this.preRenderSurfaceObjects(drawContext);
    }

    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage((String)"nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        if (!this.intersectsFrustum(drawContext)) {
            return;
        }
        if (this.isExpired(drawContext)) {
            this.update(drawContext);
        }
        if (this.isExpired(drawContext)) {
            return;
        }
        this.makeOrderedRenderable(drawContext);
        this.drawSurfaceObjects(drawContext);
    }

    public Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage((String)"nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.getAltitudeMode() == 1) {
            return Sector.computeBoundingBox((Globe)drawContext.getGlobe(), (double)drawContext.getVerticalExaggeration(), (Sector)this.getSector());
        }
        double d = this.getAltitude();
        double d2 = this.getAltitude();
        double[] dArray = drawContext.getGlobe().getMinAndMaxElevations(this.getSector());
        if (this.extremeValues != null) {
            d = this.getAltitude() + this.getVerticalScale() * this.extremeValues[0];
            d2 = this.getAltitude() + this.getVerticalScale() * this.extremeValues[1];
        }
        if (dArray != null) {
            if (this.getAltitudeMode() == 2) {
                d -= dArray[0];
                d2 += dArray[1];
            }
            if (d > dArray[0]) {
                d = dArray[0];
            }
            if (d2 < dArray[1]) {
                d2 = dArray[1];
            }
        }
        return Sector.computeBoundingBox((Globe)drawContext.getGlobe(), (double)drawContext.getVerticalExaggeration(), (Sector)this.getSector(), (double)d, (double)d2);
    }

    protected boolean intersectsFrustum(DrawContext drawContext) {
        Extent extent = this.getExtent(drawContext);
        if (extent == null) {
            return false;
        }
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(extent);
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersects(extent);
    }

    public static double[] computeExtremeValues(Iterable<? extends GridPointAttributes> iterable, double d) {
        if (iterable == null) {
            String string = Logging.getMessage((String)"nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        for (GridPointAttributes gridPointAttributes : iterable) {
            double d4 = gridPointAttributes.getValue();
            if (Double.compare(d4, d) == 0) continue;
            if (d2 > d4) {
                d2 = d4;
            }
            if (!(d3 < d4)) continue;
            d3 = d4;
        }
        if (d2 == Double.MAX_VALUE || d2 == -4.9E-324) {
            return null;
        }
        return new double[]{d2, d3};
    }

    public static double[] computeExtremeValues(Iterable<? extends GridPointAttributes> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage((String)"nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return AnalyticSurface.computeExtremeValues(iterable, Double.NaN);
    }

    public static GridPointAttributes createGridPointAttributes(final double d, final Color color) {
        return new GridPointAttributes(){

            @Override
            public double getValue() {
                return d;
            }

            @Override
            public Color getColor() {
                return color;
            }
        };
    }

    public static GridPointAttributes createColorGradientAttributes(double d, double d2, double d3, double d4, double d5) {
        double d6 = WWMath.computeInterpolationFactor((double)d, (double)d2, (double)d3);
        Color color = Color.getHSBColor((float)WWMath.mixSmooth((double)d6, (double)d4, (double)d5), 1.0f, 1.0f);
        double d7 = WWMath.computeInterpolationFactor((double)d, (double)d2, (double)(d2 + (d3 - d2) * 0.1));
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * d7));
        return AnalyticSurface.createGridPointAttributes(d, color2);
    }

    public static Iterable<? extends GridPointAttributes> createDefaultValues(int n) {
        ArrayList arrayList = new ArrayList(n);
        Collections.fill(arrayList, DEFAULT_GRID_POINT_ATTRIBUTES);
        return arrayList;
    }

    public static Iterable<? extends GridPointAttributes> createColorGradientValues(BufferWrapper bufferWrapper, double d, double d2, double d3, double d4, double d5) {
        if (bufferWrapper == null) {
            String string = Logging.getMessage((String)"nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<GridPointAttributes> arrayList = new ArrayList<GridPointAttributes>();
        for (int i = 0; i < bufferWrapper.length(); ++i) {
            double d6 = bufferWrapper.getDouble(i);
            if (Double.compare(d6, d) == 0) {
                d6 = d2;
            }
            arrayList.add(AnalyticSurface.createColorGradientAttributes(d6, d2, d3, d4, d5));
        }
        return arrayList;
    }

    protected void makeOrderedRenderable(DrawContext drawContext) {
        if (this.getAltitudeMode() == 1) {
            return;
        }
        Extent extent = this.getExtent(drawContext);
        double d = drawContext.getView().getEyePoint().distanceTo3(extent.getCenter()) - extent.getRadius();
        if (d < 1.0) {
            d = 1.0;
        }
        drawContext.addOrderedRenderable((OrderedRenderable)new OrderedSurface(this, d));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawOrderedRenderable(DrawContext drawContext) {
        this.beginDrawing(drawContext);
        try {
            this.doDrawOrderedRenderable(drawContext);
        }
        finally {
            this.endDrawing(drawContext);
        }
    }

    protected void doDrawOrderedRenderable(DrawContext drawContext) {
        this.bind(drawContext);
        if (this.surfaceAttributes.isDrawOutline() && this.surfaceAttributes.isDrawInterior()) {
            drawContext.getGL().glDepthMask(false);
            this.drawOutline(drawContext);
            drawContext.getGL().glDepthMask(true);
        }
        if (this.surfaceAttributes.isDrawInterior()) {
            this.drawInterior(drawContext);
        }
        if (this.surfaceAttributes.isDrawOutline()) {
            this.drawOutline(drawContext);
        }
    }

    protected void bind(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glEnableClientState(32884);
        gL2.glVertexPointer(3, 5126, 0, (Buffer)this.surfaceRenderInfo.cartesianVertexBuffer);
        if (!drawContext.isPickingMode()) {
            gL2.glEnableClientState(32885);
            gL2.glNormalPointer(5126, 0, (Buffer)this.surfaceRenderInfo.cartesianNormalBuffer);
            gL2.glEnableClientState(32886);
            gL2.glColorPointer(4, 5121, 0, (Buffer)this.surfaceRenderInfo.colorBuffer);
        }
    }

    protected void drawInterior(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!drawContext.isPickingMode()) {
            gL2.glEnable(2903);
            gL2.glColorMaterial(1032, 4609);
            this.surfaceAttributes.getInteriorMaterial().apply(gL2, 1032, (float)this.surfaceAttributes.getInteriorOpacity());
        }
        gL2.glCullFace(1028);
        this.surfaceRenderInfo.drawInterior(drawContext);
        gL2.glCullFace(1029);
        this.surfaceRenderInfo.drawInterior(drawContext);
    }

    protected void drawOutline(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!drawContext.isPickingMode()) {
            gL2.glEnable(2848);
            gL2.glDisable(2896);
            gL2.glDisable(2903);
            Color color = this.surfaceAttributes.getOutlineMaterial().getDiffuse();
            int n = (int)(255.0 * this.surfaceAttributes.getOutlineOpacity() + 0.5);
            gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)n);
            gL2.glDisableClientState(32886);
        }
        gL2.glLineWidth((float)this.surfaceAttributes.getOutlineWidth());
        this.surfaceRenderInfo.drawOutline(drawContext);
        if (!drawContext.isPickingMode()) {
            gL2.glEnable(2896);
            gL2.glDisable(2848);
            gL2.glDisable(2852);
            gL2.glEnableClientState(32886);
        }
    }

    protected void beginDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glPushAttrib(0x410D | (!drawContext.isPickingMode() ? 64 : 0) | (!drawContext.isPickingMode() ? 4096 : 0));
        gL2.glEnable(3008);
        gL2.glAlphaFunc(516, 0.0f);
        gL2.glEnable(2884);
        if (drawContext.isPickingMode()) {
            Color color = drawContext.getUniquePickColor();
            this.pickSupport.addPickableObject(color.getRGB(), this.getPickObject() != null ? this.getPickObject() : this, new Position(this.sector.getCentroid(), this.altitude), false);
            gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        } else {
            gL2.glEnable(3042);
            OGLUtil.applyBlending((GL2)gL2, (boolean)false);
            gL2.glDisable(2903);
            gL2.glDisable(16384);
            gL2.glEnable(2896);
            gL2.glEnable(16385);
            gL2.glEnable(2977);
            gL2.glLightModeli(2897, 1);
            gL2.glLightModeli(2898, 1);
            gL2.glShadeModel(7425);
            OGLUtil.applyLightingDirectionalFromViewer((GL2)gL2, (int)16385, (Vec4)new Vec4(1.0, 0.5, 1.0).normalize3());
        }
        drawContext.getView().pushReferenceCenter(drawContext, this.referencePoint);
    }

    protected void endDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        drawContext.getView().popReferenceCenter(drawContext);
        gL2.glPopAttrib();
        gL2.glDisableClientState(32884);
        gL2.glDisableClientState(32886);
        gL2.glDisableClientState(32885);
    }

    protected boolean isExpired(DrawContext drawContext) {
        if (this.expired) {
            return true;
        }
        if (this.getAltitudeMode() == 2 && drawContext.getFrameTimeStamp() - this.regenTime > 2000L) {
            return true;
        }
        if (this.getAltitudeMode() == 2 || this.getAltitudeMode() == 0) {
            Object object = drawContext.getGlobe().getStateKey(drawContext);
            if (this.globeStateKey != null ? !this.globeStateKey.equals(object) : object != null) {
                return true;
            }
        }
        return false;
    }

    protected void setExpired(boolean bl) {
        this.expired = bl;
        if (this.expired) {
            if (this.clampToGroundSurface != null) {
                this.clampToGroundSurface.markAsModified();
            }
            if (this.shadowSurface != null) {
                this.shadowSurface.markAsModified();
            }
        }
    }

    protected void update(DrawContext drawContext) {
        if (this.updateFailed) {
            return;
        }
        try {
            this.doUpdate(drawContext);
            this.setExpired(false);
            this.globeStateKey = drawContext.getGlobe().getStateKey(drawContext);
            this.regenTime = drawContext.getFrameTimeStamp();
        }
        catch (Exception exception) {
            String string = Logging.getMessage((String)"generic.ExceptionWhileUpdating", (Object[])new Object[]{this});
            Logging.logger().log(Level.SEVERE, string, exception);
            this.updateFailed = true;
        }
    }

    protected void doUpdate(DrawContext drawContext) {
        this.referencePos = new Position(this.sector.getCentroid(), this.altitude);
        this.referencePoint = drawContext.getGlobe().computePointFromPosition(this.referencePos);
        if (this.surfaceRenderInfo == null || this.surfaceRenderInfo.getGridWidth() != this.width || this.surfaceRenderInfo.getGridHeight() != this.height) {
            this.surfaceRenderInfo = new RenderInfo(this.width, this.height);
        }
        this.updateSurfacePoints(drawContext, this.surfaceRenderInfo);
        this.updateSurfaceNormals(this.surfaceRenderInfo);
    }

    protected void updateSurfacePoints(DrawContext drawContext, RenderInfo renderInfo) {
        Iterator<? extends GridPointAttributes> iterator = this.values.iterator();
        double d = -this.sector.getDeltaLatDegrees() / (double)(this.height - 1);
        double d2 = this.sector.getDeltaLonDegrees() / (double)(this.width - 1);
        double d3 = this.sector.getMaxLatitude().degrees;
        for (int i = 0; i < this.height; ++i) {
            double d4 = this.sector.getMinLongitude().degrees;
            for (int j = 0; j < this.width; ++j) {
                GridPointAttributes gridPointAttributes = iterator.hasNext() ? iterator.next() : null;
                this.updateNextSurfacePoint(drawContext, Angle.fromDegrees((double)d3), Angle.fromDegrees((double)d4), gridPointAttributes, renderInfo);
                d4 += d2;
            }
            d3 += d;
        }
        renderInfo.cartesianVertexBuffer.rewind();
        renderInfo.geographicVertexBuffer.rewind();
        renderInfo.colorBuffer.rewind();
        renderInfo.shadowColorBuffer.rewind();
    }

    protected void updateNextSurfacePoint(DrawContext drawContext, Angle angle, Angle angle2, GridPointAttributes gridPointAttributes, RenderInfo renderInfo) {
        Color color = gridPointAttributes != null ? gridPointAttributes.getColor() : DEFAULT_COLOR;
        int n = (int)((double)color.getAlpha() * this.surfaceAttributes.getInteriorOpacity() + 0.5);
        renderInfo.colorBuffer.put((byte)color.getRed());
        renderInfo.colorBuffer.put((byte)color.getGreen());
        renderInfo.colorBuffer.put((byte)color.getBlue());
        renderInfo.colorBuffer.put((byte)n);
        if (this.getAltitudeMode() == 1 || this.surfaceAttributes.isDrawShadow()) {
            renderInfo.geographicVertexBuffer.put((float)(angle2.degrees - this.referencePos.getLongitude().degrees));
            renderInfo.geographicVertexBuffer.put((float)(angle.degrees - this.referencePos.getLatitude().degrees));
            renderInfo.geographicVertexBuffer.put(1.0f);
        }
        if (this.getAltitudeMode() != 1) {
            Vec4 vec4 = this.computeSurfacePoint(drawContext, angle, angle2, gridPointAttributes != null ? gridPointAttributes.getValue() : 0.0);
            renderInfo.cartesianVertexBuffer.put((float)(vec4.x - this.referencePoint.x));
            renderInfo.cartesianVertexBuffer.put((float)(vec4.y - this.referencePoint.y));
            renderInfo.cartesianVertexBuffer.put((float)(vec4.z - this.referencePoint.z));
        }
        if (this.surfaceAttributes.isDrawShadow()) {
            int n2 = (int)((double)n * this.surfaceAttributes.getShadowOpacity() + 0.5);
            renderInfo.shadowColorBuffer.put((byte)0);
            renderInfo.shadowColorBuffer.put((byte)0);
            renderInfo.shadowColorBuffer.put((byte)0);
            renderInfo.shadowColorBuffer.put((byte)n2);
        }
    }

    protected Vec4 computeSurfacePoint(DrawContext drawContext, Angle angle, Angle angle2, double d) {
        double d2 = this.altitude + this.verticalScale * d;
        if (this.getAltitudeMode() == 2) {
            return drawContext.computeTerrainPoint(angle, angle2, drawContext.getVerticalExaggeration() * d2);
        }
        return drawContext.getGlobe().computePointFromPosition(angle, angle2, d2);
    }

    protected void updateSurfaceNormals(RenderInfo renderInfo) {
        WWMath.computeNormalsForIndexedTriangleStrip((IntBuffer)renderInfo.interiorIndexBuffer, (FloatBuffer)renderInfo.cartesianVertexBuffer, (FloatBuffer)renderInfo.cartesianNormalBuffer);
    }

    protected void preRenderSurfaceObjects(DrawContext drawContext) {
        if (this.surfaceAttributes.isDrawShadow()) {
            if (this.shadowSurface == null) {
                this.shadowSurface = this.createShadowSurface();
            }
            this.shadowSurface.preRender(drawContext);
        }
        if (this.getAltitudeMode() == 1) {
            if (this.clampToGroundSurface == null) {
                this.clampToGroundSurface = this.createClampToGroundSurface();
            }
            this.clampToGroundSurface.preRender(drawContext);
        }
    }

    protected void drawSurfaceObjects(DrawContext drawContext) {
        if (this.surfaceAttributes.isDrawShadow() && !drawContext.isPickingMode()) {
            this.shadowSurface.render(drawContext);
        }
        if (this.getAltitudeMode() == 1) {
            this.clampToGroundSurface.render(drawContext);
        }
    }

    protected AnalyticSurfaceObject createClampToGroundSurface() {
        return new ClampToGroundSurface(this);
    }

    protected AnalyticSurfaceObject createShadowSurface() {
        return new ShadowSurface(this);
    }

    protected static class ShadowSurface
    extends AnalyticSurfaceObject {
        public ShadowSurface(AnalyticSurface analyticSurface) {
            super(analyticSurface);
        }

        protected void buildPickRepresentation(DrawContext drawContext) {
        }

        @Override
        protected void bind(DrawContext drawContext) {
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glEnableClientState(32884);
            gL2.glVertexPointer(3, 5126, 0, (Buffer)this.analyticSurface.surfaceRenderInfo.geographicVertexBuffer);
            if (!drawContext.isPickingMode()) {
                gL2.glEnableClientState(32886);
                gL2.glColorPointer(4, 5121, 0, (Buffer)this.analyticSurface.surfaceRenderInfo.shadowColorBuffer);
            }
        }

        @Override
        protected void drawOutline(DrawContext drawContext) {
            GL2 gL2 = drawContext.getGL().getGL2();
            if (!drawContext.isPickingMode()) {
                int n = (int)(255.0 * this.analyticSurface.surfaceAttributes.getOutlineOpacity() * this.analyticSurface.surfaceAttributes.getShadowOpacity() + 0.5);
                gL2.glColor4ub((byte)0, (byte)0, (byte)0, (byte)n);
                gL2.glDisableClientState(32886);
            }
            super.drawOutline(drawContext);
            if (!drawContext.isPickingMode()) {
                gL2.glEnableClientState(32886);
            }
        }
    }

    protected static class ClampToGroundSurface
    extends AnalyticSurfaceObject {
        public ClampToGroundSurface(AnalyticSurface analyticSurface) {
            super(analyticSurface);
        }

        @Override
        protected void bind(DrawContext drawContext) {
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glEnableClientState(32884);
            gL2.glVertexPointer(3, 5126, 0, (Buffer)this.analyticSurface.surfaceRenderInfo.geographicVertexBuffer);
            if (!drawContext.isPickingMode()) {
                gL2.glEnableClientState(32886);
                gL2.glColorPointer(4, 5121, 0, (Buffer)this.analyticSurface.surfaceRenderInfo.colorBuffer);
            }
        }

        @Override
        protected void drawOutline(DrawContext drawContext) {
            GL2 gL2 = drawContext.getGL().getGL2();
            if (!drawContext.isPickingMode()) {
                Color color = this.analyticSurface.surfaceAttributes.getOutlineMaterial().getDiffuse();
                int n = (int)(255.0 * this.analyticSurface.surfaceAttributes.getOutlineOpacity() + 0.5);
                gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)n);
                gL2.glDisableClientState(32886);
            }
            super.drawOutline(drawContext);
            if (!drawContext.isPickingMode()) {
                gL2.glEnableClientState(32886);
            }
        }
    }

    protected static class AnalyticSurfaceObject
    extends AbstractSurfaceObject {
        protected AnalyticSurface analyticSurface;

        public AnalyticSurfaceObject(AnalyticSurface analyticSurface) {
            this.analyticSurface = analyticSurface;
        }

        public void markAsModified() {
            super.updateModifiedTime();
            super.clearCaches();
        }

        public List<Sector> getSectors(DrawContext drawContext) {
            if (drawContext == null) {
                String string = Logging.getMessage((String)"nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return Arrays.asList(this.analyticSurface.sector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void drawGeographic(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
            this.beginDrawing(drawContext);
            try {
                this.doDrawGeographic(drawContext, surfaceTileDrawContext);
            }
            finally {
                this.endDrawing(drawContext);
            }
        }

        protected void beginDrawing(DrawContext drawContext) {
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glPushAttrib(16645);
            gL2.glMatrixMode(5888);
            gL2.glPushMatrix();
            gL2.glEnable(3042);
            OGLUtil.applyBlending((GL2)gL2, (boolean)false);
            gL2.glDisable(2929);
            if (!drawContext.isPickingMode()) {
                gL2.glEnable(2848);
            }
        }

        protected void endDrawing(DrawContext drawContext) {
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glPopMatrix();
            gL2.glPopAttrib();
            gL2.glDisableClientState(32884);
            gL2.glDisableClientState(32886);
        }

        protected void doDrawGeographic(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
            GL2 gL2 = drawContext.getGL().getGL2();
            Matrix matrix = surfaceTileDrawContext.getModelviewMatrix((LatLon)this.analyticSurface.referencePos);
            gL2.glMultMatrixd(matrix.toArray(new double[16], 0, false), 0);
            this.bind(drawContext);
            if (this.analyticSurface.surfaceAttributes.isDrawInterior()) {
                this.drawInterior(drawContext);
            }
            if (this.analyticSurface.surfaceAttributes.isDrawOutline()) {
                this.drawOutline(drawContext);
            }
        }

        protected void bind(DrawContext drawContext) {
        }

        protected void drawInterior(DrawContext drawContext) {
            this.analyticSurface.surfaceRenderInfo.drawInterior(drawContext);
        }

        protected void drawOutline(DrawContext drawContext) {
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glLineWidth((float)this.analyticSurface.surfaceAttributes.getOutlineWidth());
            this.analyticSurface.surfaceRenderInfo.drawOutline(drawContext);
        }
    }

    protected static class RenderInfo {
        protected final int gridWidth;
        protected final int gridHeight;
        protected final IntBuffer interiorIndexBuffer;
        protected final IntBuffer outlineIndexBuffer;
        protected final FloatBuffer cartesianVertexBuffer;
        protected final FloatBuffer cartesianNormalBuffer;
        protected final FloatBuffer geographicVertexBuffer;
        protected final ByteBuffer colorBuffer;
        protected final ByteBuffer shadowColorBuffer;

        public RenderInfo(int n, int n2) {
            int n3 = n * n2;
            this.gridWidth = n;
            this.gridHeight = n2;
            this.interiorIndexBuffer = WWMath.computeIndicesForGridInterior((int)n, (int)n2);
            this.outlineIndexBuffer = WWMath.computeIndicesForGridOutline((int)n, (int)n2);
            this.cartesianVertexBuffer = Buffers.newDirectFloatBuffer((int)(3 * n3));
            this.cartesianNormalBuffer = Buffers.newDirectFloatBuffer((int)(3 * n3));
            this.geographicVertexBuffer = Buffers.newDirectFloatBuffer((int)(3 * n3));
            this.colorBuffer = Buffers.newDirectByteBuffer((int)(4 * n3));
            this.shadowColorBuffer = Buffers.newDirectByteBuffer((int)(4 * n3));
        }

        public int getGridWidth() {
            return this.gridWidth;
        }

        public int getGridHeight() {
            return this.gridHeight;
        }

        public int getNumVertices() {
            return this.gridWidth * this.gridHeight;
        }

        public void drawInterior(DrawContext drawContext) {
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glDrawElements(5, this.interiorIndexBuffer.remaining(), 5125, (Buffer)this.interiorIndexBuffer);
        }

        public void drawOutline(DrawContext drawContext) {
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glDrawElements(2, this.outlineIndexBuffer.remaining(), 5125, (Buffer)this.outlineIndexBuffer);
        }
    }

    protected static class OrderedSurface
    implements OrderedRenderable {
        protected final AnalyticSurface surface;
        protected final double eyeDistance;

        public OrderedSurface(AnalyticSurface analyticSurface, double d) {
            this.surface = analyticSurface;
            this.eyeDistance = d;
        }

        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pick(DrawContext drawContext, Point point) {
            this.surface.pickSupport.beginPicking(drawContext);
            try {
                this.render(drawContext);
            }
            finally {
                this.surface.pickSupport.endPicking(drawContext);
                this.surface.pickSupport.resolvePick(drawContext, drawContext.getPickPoint(), this.surface.getClientLayer());
            }
        }

        public void render(DrawContext drawContext) {
            this.surface.drawOrderedRenderable(drawContext);
        }
    }

    public static interface GridPointAttributes {
        public double getValue();

        public Color getColor();
    }
}

