/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.analytics;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.BufferWrapperRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterReaderFactory;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWBufferUtil;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurface;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurfaceAttributes;
import gov.nasa.worldwindx.examples.analytics.ExportableAnalyticSurface;
import gov.nasa.worldwindx.examples.kml.KMLDocumentBuilder;
import gov.nasa.worldwindx.examples.util.ExampleUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public class ExportAsKMLGroundOverlay {
    protected static final String DATA_PATH = "gov/nasa/worldwindx/examples/data/wa-precip-24hmam-5km.tif";
    protected static final double HUE_BLUE = 0.6666666666666666;
    protected static final double HUE_RED = 0.0;

    protected static ExportableAnalyticSurface createPrecipitationSurface() {
        BufferWrapperRaster bufferWrapperRaster = ExportAsKMLGroundOverlay.loadRasterElevations(DATA_PATH);
        if (bufferWrapperRaster == null) {
            return null;
        }
        double[] dArray = WWBufferUtil.computeExtremeValues((BufferWrapper)bufferWrapperRaster.getBuffer(), (double)bufferWrapperRaster.getTransparentValue());
        if (dArray == null) {
            return null;
        }
        ExportableAnalyticSurface exportableAnalyticSurface = new ExportableAnalyticSurface();
        exportableAnalyticSurface.setSector(bufferWrapperRaster.getSector());
        exportableAnalyticSurface.setDimensions(bufferWrapperRaster.getWidth(), bufferWrapperRaster.getHeight());
        exportableAnalyticSurface.setValues(AnalyticSurface.createColorGradientValues(bufferWrapperRaster.getBuffer(), bufferWrapperRaster.getTransparentValue(), dArray[0], dArray[1], 0.6666666666666666, 0.0));
        exportableAnalyticSurface.setVerticalScale(5000.0);
        AnalyticSurfaceAttributes analyticSurfaceAttributes = new AnalyticSurfaceAttributes();
        analyticSurfaceAttributes.setDrawOutline(false);
        exportableAnalyticSurface.setSurfaceAttributes(analyticSurfaceAttributes);
        return exportableAnalyticSurface;
    }

    protected static BufferWrapperRaster loadRasterElevations(String string) {
        File file = ExampleUtil.saveResourceToTempFile(string, "." + WWIO.getSuffix((String)string));
        DataRasterReaderFactory dataRasterReaderFactory = (DataRasterReaderFactory)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.DataRasterReaderFactoryClassName");
        DataRasterReader dataRasterReader = dataRasterReaderFactory.findReaderFor((Object)file, null);
        try {
            int n;
            AVList aVList = dataRasterReader.readMetadata((Object)file, null);
            if (aVList == null || !"gov.nasa.worldwind.avkey.Elevation".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
                String string2 = Logging.getMessage((String)"ElevationModel.SourceNotElevations", (String)file.getAbsolutePath());
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            DataRaster[] dataRasterArray = dataRasterReader.read((Object)file, null);
            if (dataRasterArray == null || dataRasterArray.length == 0) {
                String string3 = Logging.getMessage((String)"ElevationModel.CannotReadElevations", (String)file.getAbsolutePath());
                Logging.logger().severe(string3);
                throw new WWRuntimeException(string3);
            }
            Sector sector = (Sector)dataRasterArray[0].getValue("gov.nasa.worldwind.avKey.Sector");
            if (sector == null) {
                String string4 = Logging.getMessage((String)"DataRaster.MissingMetadata", (String)"gov.nasa.worldwind.avKey.Sector");
                Logging.logger().severe(string4);
                throw new IllegalArgumentException(string4);
            }
            int n2 = dataRasterArray[0].getWidth();
            DataRaster dataRaster = dataRasterArray[0].getSubRaster(n2, n = dataRasterArray[0].getHeight(), sector, (AVList)dataRasterArray[0]);
            if (!(dataRaster instanceof BufferWrapperRaster)) {
                String string5 = Logging.getMessage((String)"ElevationModel.CannotCreateElevationBuffer", (String)string);
                Logging.logger().severe(string5);
                throw new WWRuntimeException(string5);
            }
            return (BufferWrapperRaster)dataRaster;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        try {
            ExportableAnalyticSurface exportableAnalyticSurface = ExportAsKMLGroundOverlay.createPrecipitationSurface();
            if (exportableAnalyticSurface != null) {
                exportableAnalyticSurface.setExportImagePath(Configuration.getUserHomeDirectory());
                exportableAnalyticSurface.setExportImageName("GroundOverlayImage.png");
                exportableAnalyticSurface.setExportImageWidth(1024);
                exportableAnalyticSurface.setExportImageHeight(1024);
                FileOutputStream fileOutputStream = new FileOutputStream(Configuration.getUserHomeDirectory() + "/GroundOverlay.kml");
                KMLDocumentBuilder kMLDocumentBuilder = new KMLDocumentBuilder(fileOutputStream);
                kMLDocumentBuilder.writeObject(exportableAnalyticSurface);
                kMLDocumentBuilder.close();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

