/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.analytics;

import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ExportableAnalyticSurface
extends AnalyticSurface
implements Exportable {
    protected String exportImagePath;
    protected String exportImageName;
    protected int exportImageWidth = 1024;
    protected int exportImageHeight = 1024;

    public void setExportImagePath(String string) {
        this.exportImagePath = string;
    }

    public String getExportImagePath() {
        return this.exportImagePath;
    }

    public String getExportImageName() {
        return this.exportImageName;
    }

    public void setExportImageName(String string) {
        this.exportImageName = string;
    }

    public int getExportImageWidth() {
        return this.exportImageWidth;
    }

    public void setExportImageWidth(int n) {
        this.exportImageWidth = n;
    }

    public int getExportImageHeight() {
        return this.exportImageHeight;
    }

    public void setExportImageHeight(int n) {
        this.exportImageHeight = n;
    }

    public void export(String string, Object object) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage((String)"nullValue.Format");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage((String)"nullValue.OutputBufferIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            try {
                this.exportAsKML(object);
            }
            catch (XMLStreamException xMLStreamException) {
                Logging.logger().throwing(this.getClass().getName(), "export", xMLStreamException);
                throw new IOException(xMLStreamException);
            }
        } else {
            String string4 = Logging.getMessage((String)"Export.UnsupportedFormat", (String)string);
            Logging.logger().warning(string4);
            throw new UnsupportedOperationException(string4);
        }
    }

    public String isExportFormatSupported(String string) {
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            return "Export.FormatSupported";
        }
        return "Export.FormatNotSupported";
    }

    protected void exportAsKML(Object object) throws IOException, XMLStreamException {
        XMLStreamWriter xMLStreamWriter = null;
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        boolean bl = true;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
            bl = false;
        } else if (object instanceof Writer) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((Writer)object);
        } else if (object instanceof OutputStream) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }
        if (xMLStreamWriter == null) {
            String string = Logging.getMessage((String)"Export.UnsupportedOutputObject");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        if (this.exportImagePath == null || this.exportImageName == null) {
            String string = Logging.getMessage((String)"Export.UnableToExportImageSource", (String)"Image path or name unspecified");
            Logging.logger().severe(string);
        } else {
            File file = new File(this.exportImagePath + "/" + this.exportImageName);
            BufferedImage bufferedImage = this.createImage(this.exportImageWidth, this.exportImageHeight);
            try {
                String string = WWIO.getSuffix((String)this.exportImageName);
                ImageIO.write((RenderedImage)bufferedImage, string, file);
            }
            catch (IOException iOException) {
                String string = Logging.getMessage((String)"Export.UnableToExportImageSource", (Object[])new Object[]{file.getAbsolutePath(), iOException});
                Logging.logger().severe(string);
            }
        }
        xMLStreamWriter.writeStartElement("GroundOverlay");
        xMLStreamWriter.writeStartElement("Icon");
        xMLStreamWriter.writeStartElement("href");
        if (this.exportImageName != null) {
            xMLStreamWriter.writeCharacters(this.exportImageName);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("altitudeMode");
        xMLStreamWriter.writeCharacters("clampToGround");
        xMLStreamWriter.writeEndElement();
        this.exportKMLLatLonBox(xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }

    protected void exportKMLLatLonBox(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("LatLonBox");
        xMLStreamWriter.writeStartElement("north");
        xMLStreamWriter.writeCharacters(Double.toString(this.sector.getMaxLatitude().getDegrees()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("south");
        xMLStreamWriter.writeCharacters(Double.toString(this.sector.getMinLatitude().getDegrees()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("east");
        xMLStreamWriter.writeCharacters(Double.toString(this.sector.getMinLongitude().getDegrees()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("west");
        xMLStreamWriter.writeCharacters(Double.toString(this.sector.getMaxLongitude().getDegrees()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    public BufferedImage createImage(int n, int n2) {
        Object object;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        if (this.surfaceAttributes.drawInterior && this.values != null) {
            object = new ArrayList(this.width * this.height);
            for (AnalyticSurface.GridPointAttributes gridPointAttributes : this.values) {
                ((ArrayList)object).add(gridPointAttributes.getColor());
            }
            double d = this.sector.getDeltaLat().radians;
            double d2 = this.sector.getDeltaLon().radians;
            double d3 = d / (double)n2;
            double d4 = d2 / (double)n;
            double d5 = d2 / (double)(this.width - 1);
            double d6 = d / (double)(this.height - 1);
            for (int i = 0; i < n2; ++i) {
                double d7 = ((double)i + 0.5) * d3;
                int n3 = (int)(d7 / d6);
                for (int j = 0; j < n; ++j) {
                    double d8 = ((double)j + 0.5) * d4;
                    int n4 = (int)(d8 / d5);
                    Color color = (Color)((ArrayList)object).get((n3 + 1) * this.width + n4);
                    Color color2 = (Color)((ArrayList)object).get((n3 + 1) * this.width + n4 + 1);
                    Color color3 = (Color)((ArrayList)object).get(n3 * this.width + n4 + 1);
                    Color color4 = (Color)((ArrayList)object).get(n3 * this.width + n4);
                    double d9 = (d8 - (double)n4 * d5) / d5;
                    double d10 = (d7 - (double)n3 * d6) / d6;
                    int n5 = ImageUtil.interpolateColor((double)d9, (double)(1.0 - d10), (int)color.getRGB(), (int)color2.getRGB(), (int)color4.getRGB(), (int)color3.getRGB());
                    bufferedImage.setRGB(j, i, n5);
                }
            }
        }
        if (this.surfaceAttributes.drawOutline) {
            object = bufferedImage.createGraphics();
            ((Graphics2D)object).setPaint(this.surfaceAttributes.outlineMaterial.getDiffuse());
            ((Graphics2D)object).setStroke(new BasicStroke((float)this.surfaceAttributes.outlineWidth));
            ((Graphics)object).drawRect(0, 0, n - 1, n2 - 1);
        }
        return bufferedImage;
    }
}

