/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.dataimport;

import gov.nasa.worldwind.BasicFactory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.data.TiledElevationProducer;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.dataimport.DataInstallUtil;
import gov.nasa.worldwindx.examples.util.ExampleUtil;
import java.awt.Cursor;
import java.io.File;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;

public class InstallElevations
extends ApplicationTemplate {
    protected static final String BASE_CACHE_PATH = "Examples/";
    protected static final String ELEVATIONS_PATH = "gov/nasa/worldwindx/examples/data/craterlake-elev-16bit-30m.tif";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Elevation Installation", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            this.setCursor(new Cursor(3));
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    AppFrame.this.installElevations();
                    AppFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            });
            thread.start();
        }

        protected void installElevations() {
            FileStore fileStore;
            File file = ExampleUtil.saveResourceToTempFile(InstallElevations.ELEVATIONS_PATH, ".tif");
            final ElevationModel elevationModel = this.installElevations("Crater Lake Elevations 16bit 30m", file, fileStore = WorldWind.getDataFileStore());
            if (elevationModel == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CompoundElevationModel compoundElevationModel = (CompoundElevationModel)AppFrame.this.getWwd().getModel().getGlobe().getElevationModel();
                    compoundElevationModel.addElevationModel(elevationModel);
                    AVList aVList = (AVList)elevationModel.getValue("gov.nasa.worldwind.avkey.ConstructionParameters");
                    Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
                    ExampleUtil.goTo(AppFrame.this.getWwd(), sector);
                }
            });
        }

        protected ElevationModel installElevations(String string, Object object, FileStore fileStore) {
            File file = DataInstallUtil.getDefaultInstallLocation(fileStore);
            String string2 = InstallElevations.BASE_CACHE_PATH + WWIO.replaceIllegalFileNameCharacters((String)string);
            AVListImpl aVListImpl = new AVListImpl();
            aVListImpl.setValue("gov.nasa.worldwind.avkey.FileStoreLocation", (Object)file.getAbsolutePath());
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", (Object)string2);
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", (Object)string);
            TiledElevationProducer tiledElevationProducer = new TiledElevationProducer();
            try {
                tiledElevationProducer.setStoreParameters((AVList)aVListImpl);
                tiledElevationProducer.offerDataSource(object, null);
                tiledElevationProducer.startProduction();
            }
            catch (Exception exception) {
                tiledElevationProducer.removeProductionState();
                exception.printStackTrace();
                return null;
            }
            Iterable iterable = tiledElevationProducer.getProductionResults();
            if (iterable == null || iterable.iterator() == null || !iterable.iterator().hasNext()) {
                return null;
            }
            Object t = iterable.iterator().next();
            if (t == null || !(t instanceof Document)) {
                return null;
            }
            return (ElevationModel)BasicFactory.create((String)"gov.nasa.worldwind.avkey.ElevationModelFactory", (Object)((Document)t).getDocumentElement());
        }
    }
}

