/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.dataimport;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.data.CachedDataRaster;
import gov.nasa.worldwind.data.DataStoreProducer;
import gov.nasa.worldwind.data.TiledElevationProducer;
import gov.nasa.worldwind.data.TiledImageProducer;
import gov.nasa.worldwind.data.TiledRasterProducer;
import gov.nasa.worldwind.data.WWDotNetLayerSetConverter;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.DataConfigurationFilter;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.dataimport.DataInstallUtil;
import gov.nasa.worldwindx.examples.dataimport.InstalledDataPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.xml.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InstallImageryAndElevationsDemo
extends ApplicationTemplate {
    protected static void addInstalledData(final Document document, final AVList aVList, final InstalledDataPanel installedDataPanel) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InstallImageryAndElevationsDemo.addInstalledData(document, aVList, installedDataPanel);
                }
            });
        } else {
            installedDataPanel.addInstalledData(document.getDocumentElement(), aVList);
        }
    }

    protected static void loadInstalledDataFromDirectory(File file, InstalledDataPanel installedDataPanel) {
        String[] stringArray = WWIO.listDescendantFilenames((File)file, (FileFilter)new DataConfigurationFilter(), (boolean)false);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (String string : stringArray) {
            File file2;
            Document document = null;
            try {
                file2 = new File(file, string);
                document = WWXML.openDocument((Object)file2);
                document = DataConfigurationUtils.convertToStandardDataConfigDocument((Document)document);
            }
            catch (WWRuntimeException wWRuntimeException) {
                wWRuntimeException.printStackTrace();
            }
            if (document == null) continue;
            file2 = new AVListImpl();
            InstallImageryAndElevationsDemo.setFallbackParams(document, string, (AVList)file2);
            InstallImageryAndElevationsDemo.addInstalledData(document, (AVList)file2, installedDataPanel);
        }
    }

    protected static void loadInstalledDataFromFileStore(FileStore fileStore, InstalledDataPanel installedDataPanel) {
        for (File file : fileStore.getLocations()) {
            if (!file.exists() || !fileStore.isInstallLocation(file.getPath())) continue;
            InstallImageryAndElevationsDemo.loadInstalledDataFromDirectory(file, installedDataPanel);
        }
    }

    protected static void setFallbackParams(Document document, String string, AVList aVList) {
        String string2;
        XPath xPath = WWXML.makeXPath();
        Element element = document.getDocumentElement();
        String string3 = WWXML.getText((Element)element, (String)"DataCacheName", (XPath)xPath);
        if (string3 == null || string3.length() == 0) {
            DataConfigurationUtils.getDataConfigCacheName((String)string, (AVList)aVList);
        }
        if ((string2 = DataConfigurationUtils.getDataConfigType((Element)element)).equalsIgnoreCase("ElevationModel")) {
            if (WWXML.getDouble((Element)element, (String)"ExtremeElevations/@min", (XPath)xPath) == null) {
                aVList.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", (Object)-11000.0);
            }
            if (WWXML.getDouble((Element)element, (String)"ExtremeElevations/@max", (XPath)xPath) == null) {
                aVList.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", (Object)8500.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Document installDataFromFiles(Component component, File[] fileArray, FileStore fileStore) throws Exception {
        final DataStoreProducer dataStoreProducer = InstallImageryAndElevationsDemo.createDataStoreProducerFromFiles(fileArray);
        final ProgressMonitor progressMonitor = new ProgressMonitor(component, "Importing ....", null, 0, 100);
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (progressMonitor.isCanceled()) {
                    return;
                }
                if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwind.avkey.Progress")) {
                    atomicInteger.set((int)(100.0 * (Double)propertyChangeEvent.getNewValue()));
                }
            }
        };
        dataStoreProducer.addPropertyChangeListener(propertyChangeListener);
        progressMonitor.setProgress(0);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                progressMonitor.setProgress(atomicInteger.get());
                if (progressMonitor.isCanceled()) {
                    dataStoreProducer.stopProduction();
                    this.cancel();
                }
            }
        }, progressMonitor.getMillisToDecideToPopup(), 100L);
        Document document = null;
        try {
            document = InstallImageryAndElevationsDemo.createDataStore(fileArray, fileStore, dataStoreProducer);
            if (document != null && !(dataStoreProducer instanceof WWDotNetLayerSetConverter)) {
                InstallImageryAndElevationsDemo.createRasterServerConfigDoc(fileStore, dataStoreProducer);
            }
            if (progressMonitor.isCanceled()) {
                document = null;
                dataStoreProducer.removeProductionState();
            }
        }
        finally {
            dataStoreProducer.removePropertyChangeListener(propertyChangeListener);
            dataStoreProducer.removeAllDataSources();
            progressMonitor.close();
            timer.cancel();
        }
        return document;
    }

    protected static Document createDataStore(File[] fileArray, FileStore fileStore, DataStoreProducer dataStoreProducer) throws Exception {
        Object t;
        Object object;
        File file = DataInstallUtil.getDefaultInstallLocation(fileStore);
        if (file == null) {
            String string = Logging.getMessage((String)"generic.NoDefaultImportLocation");
            Logging.logger().severe(string);
            return null;
        }
        AVListImpl aVListImpl = new AVListImpl();
        String string = InstallImageryAndElevationsDemo.askForDatasetName(InstallImageryAndElevationsDemo.suggestDatasetName(fileArray));
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", (Object)string);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", (Object)string);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FileStoreLocation", (Object)file.getAbsolutePath());
        boolean bl = Configuration.getBooleanValue((String)"gov.nasa.worldwind.avkey.Producer.EnableFullPyramid", (Boolean)false);
        if (!bl) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceName", (Object)"LocalRasterServer");
            object = Configuration.getStringValue((String)"gov.nasa.worldwind.avkey.TiledRasterProducer.LimitMaxLevel", (String)"Auto");
            aVListImpl.setValue("gov.nasa.worldwind.avkey.TiledRasterProducer.LimitMaxLevel", object);
        } else {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Producer.EnableFullPyramid", (Object)true);
        }
        dataStoreProducer.setStoreParameters((AVList)aVListImpl);
        try {
            for (File file2 : fileArray) {
                dataStoreProducer.offerDataSource((Object)file2, null);
                Thread.yield();
            }
            dataStoreProducer.startProduction();
        }
        catch (InterruptedException interruptedException) {
            dataStoreProducer.removeProductionState();
            Thread.interrupted();
            throw interruptedException;
        }
        catch (Exception exception) {
            dataStoreProducer.removeProductionState();
            throw exception;
        }
        object = dataStoreProducer.getProductionResults();
        if (object != null && object.iterator() != null && object.iterator().hasNext() && (t = object.iterator().next()) != null && t instanceof Document) {
            return (Document)t;
        }
        return null;
    }

    protected static String askForDatasetName(String string) {
        int n;
        String string2 = string;
        do {
            String string3;
            Object object;
            if (!((object = JOptionPane.showInputDialog(null, "Name:", "Enter dataset name", 3, null, null, string2)) instanceof String)) {
                Thread.interrupted();
                string3 = Logging.getMessage((String)"generic.OperationCancelled", (String)"Import");
                Logging.logger().info(string3);
                throw new WWRuntimeException(string3);
            }
            string2 = WWIO.replaceIllegalFileNameCharacters((String)((String)object));
            string3 = "Import as `" + string2 + "` ?";
            n = JOptionPane.showOptionDialog(null, string3, null, 1, 3, null, new Object[]{"Yes", "Edit name", "Cancel import"}, "Yes");
            if (n != 0) continue;
            return string2;
        } while (n == 1 || n != 2);
        Thread.interrupted();
        String string4 = Logging.getMessage((String)"generic.OperationCancelled", (String)"Import");
        Logging.logger().info(string4);
        throw new WWRuntimeException(string4);
    }

    /*
     * WARNING - void declaration
     */
    protected static String suggestDatasetName(File[] fileArray) {
        Object object;
        if (null == fileArray || fileArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        block0: for (File object22 : fileArray) {
            object = object22.getAbsolutePath();
            if (WWUtil.isEmpty((Object)object)) continue;
            object = WWIO.replaceIllegalFileNameCharacters((String)WWIO.replaceSuffix((String)object, (String)""));
            if (stringBuilder.length() == 0) {
                stringBuilder.append((String)object);
                continue;
            }
            int n = Math.min(((String)object).length(), stringBuilder.length());
            for (int i = 0; i < n; ++i) {
                if (((String)object).charAt(i) == stringBuilder.charAt(i)) continue;
                stringBuilder.setLength(i);
                continue block0;
            }
        }
        String string = stringBuilder.toString();
        stringBuilder.setLength(0);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " _:/\\-=!@#$%^&()[]{}|\".,<>;`+");
        Object var5_8 = null;
        while (stringTokenizer.hasMoreTokens()) {
            void var5_9;
            object = stringTokenizer.nextToken();
            if (WWUtil.isEmpty((Object)object) || ((String)object).length() < 2 || ((String)object).equalsIgnoreCase((String)var5_9)) continue;
            Object object2 = object;
            arrayList.add(object);
            if (arrayList.size() <= 4) continue;
            arrayList.remove(0);
        }
        if (arrayList.size() > 0) {
            stringBuilder.setLength(0);
            for (String string2 : arrayList) {
                stringBuilder.append(string2).append(' ');
            }
            return stringBuilder.toString().trim();
        }
        return WWUtil.isEmpty((Object)string) ? "change me" : string;
    }

    protected static void createRasterServerConfigDoc(FileStore fileStore, DataStoreProducer dataStoreProducer) {
        String[] stringArray2;
        AVList aVList = null != dataStoreProducer ? dataStoreProducer.getProductionParameters() : new AVListImpl();
        Object object = aVList = null == aVList ? new AVListImpl() : aVList;
        if (!"LocalRasterServer".equals(aVList.getValue("gov.nasa.worldwind.avkey.ServiceName"))) {
            return;
        }
        File file = DataInstallUtil.getDefaultInstallLocation(fileStore);
        if (file == null) {
            String string = Logging.getMessage((String)"generic.NoDefaultImportLocation");
            Logging.logger().severe(string);
            return;
        }
        Document document = WWXML.createDocumentBuilder((boolean)true).newDocument();
        Element element = WWXML.setDocumentElement((Document)document, (String)"RasterServer");
        WWXML.setTextAttribute((Element)element, (String)"version", (String)"1.0");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(file.getAbsolutePath()).append(File.separator);
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.DataCacheNameKey")) {
            String string = Logging.getMessage((String)"generic.MissingRequiredParameter", (String)"gov.nasa.worldwind.avkey.DataCacheNameKey");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        stringBuilder.append(aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey")).append(File.separator);
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.DatasetNameKey")) {
            String string = Logging.getMessage((String)"generic.MissingRequiredParameter", (String)"gov.nasa.worldwind.avkey.DatasetNameKey");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        stringBuilder.append(aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey")).append(".RasterServer.xml");
        Object object2 = aVList.getValue("gov.nasa.worldwind.avkey.DisplayName");
        if (WWUtil.isEmpty((Object)object2)) {
            aVList.setValue("gov.nasa.worldwind.avkey.DisplayName", aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey"));
        }
        String string = stringBuilder.toString();
        Sector sector = null;
        if (aVList.hasKey("gov.nasa.worldwind.avKey.Sector") && null != (object2 = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) && object2 instanceof Sector) {
            sector = (Sector)object2;
        }
        if (null == sector) {
            String string2 = Logging.getMessage((String)"generic.MissingRequiredParameter", (String)"gov.nasa.worldwind.avKey.Sector");
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        WWXML.appendSector((Element)element, (String)"Sector", sector);
        Element element2 = document.createElementNS(null, "Sources");
        if (dataStoreProducer instanceof TiledRasterProducer) {
            for (String[] stringArray2 : ((TiledRasterProducer)dataStoreProducer).getDataRasters()) {
                if (stringArray2 instanceof CachedDataRaster) {
                    try {
                        InstallImageryAndElevationsDemo.appendSource(element2, (CachedDataRaster)stringArray2);
                    }
                    catch (Throwable throwable) {
                        String string3 = WWUtil.extractExceptionReason((Throwable)throwable);
                        Logging.logger().warning(string3);
                    }
                    continue;
                }
                String string4 = Logging.getMessage((String)"TiledRasterProducer.UnrecognizedRasterType", (Object[])new Object[]{stringArray2.getClass().getName(), stringArray2.getStringValue("gov.nasa.worldwind.avkey.DatasetNameKey")});
                Logging.logger().severe(string4);
                throw new WWRuntimeException(string4);
            }
        }
        AVListImpl aVListImpl = new AVListImpl();
        stringArray2 = new String[]{"gov.nasa.worldwind.avkey.DataCacheNameKey", "gov.nasa.worldwind.avkey.DatasetNameKey", "gov.nasa.worldwind.avkey.DisplayName"};
        WWUtil.copyValues((AVList)aVList, (AVList)aVListImpl, (String[])stringArray2, (boolean)false);
        InstallImageryAndElevationsDemo.appendProperties(element, (AVList)aVListImpl);
        element.appendChild(element2);
        WWXML.saveDocumentToFile((Document)document, (String)string);
    }

    protected static void appendProperties(Element element, AVList aVList) {
        if (null == element || aVList == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : aVList.getEntries()) {
            stringBuilder.setLength(0);
            String string = (String)entry.getKey();
            stringBuilder.append(aVList.getValue(string));
            String string2 = stringBuilder.toString();
            if (WWUtil.isEmpty((Object)string) || WWUtil.isEmpty((Object)string2)) continue;
            Element element2 = WWXML.appendElement((Element)element, (String)"Property");
            WWXML.setTextAttribute((Element)element2, (String)"name", (String)string);
            WWXML.setTextAttribute((Element)element2, (String)"value", (String)string2);
        }
    }

    protected static void appendSource(Element element, CachedDataRaster cachedDataRaster) throws WWRuntimeException {
        Object object = cachedDataRaster.getDataSource();
        if (WWUtil.isEmpty((Object)object)) {
            String string = Logging.getMessage((String)"nullValue.DataSourceIsNull");
            Logging.logger().fine(string);
            throw new WWRuntimeException(string);
        }
        File file = WWIO.getFileForLocalAddress((Object)object);
        if (WWUtil.isEmpty((Object)file)) {
            String string = Logging.getMessage((String)"TiledRasterProducer.UnrecognizedDataSource", (Object[])new Object[]{object});
            Logging.logger().fine(string);
            throw new WWRuntimeException(string);
        }
        Element element2 = WWXML.appendElement((Element)element, (String)"Source");
        WWXML.setTextAttribute((Element)element2, (String)"type", (String)"file");
        WWXML.setTextAttribute((Element)element2, (String)"path", (String)file.getAbsolutePath());
        AVList aVList = cachedDataRaster.getParams();
        if (null == aVList) {
            String string = Logging.getMessage((String)"nullValue.ParamsIsNull");
            Logging.logger().fine(string);
            throw new WWRuntimeException(string);
        }
        Sector sector = cachedDataRaster.getSector();
        if (null == sector && aVList.hasKey("gov.nasa.worldwind.avKey.Sector") && (object = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) instanceof Sector) {
            sector = (Sector)object;
        }
        if (null != sector) {
            WWXML.appendSector((Element)element2, (String)"Sector", (Sector)sector);
        }
    }

    protected static DataStoreProducer createDataStoreProducerFromFiles(File[] fileArray) throws IllegalArgumentException {
        if (fileArray == null || fileArray.length == 0) {
            String string = Logging.getMessage((String)"nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = null;
        for (File file : fileArray) {
            AVListImpl aVListImpl = new AVListImpl();
            if (DataInstallUtil.isDataRaster(file, (AVList)aVListImpl)) {
                String string2 = aVListImpl.getStringValue("gov.nasa.worldwind.avkey.PixelFormat");
                if (WWUtil.isEmpty(string)) {
                    if (WWUtil.isEmpty((Object)string2)) {
                        String string4 = Logging.getMessage((String)"generic.UnrecognizedSourceType", (String)file.getAbsolutePath());
                        Logging.logger().severe(string4);
                        throw new IllegalArgumentException(string4);
                    }
                    string = string2;
                    continue;
                }
                if (string == null || string.equals(string2)) continue;
                if (WWUtil.isEmpty((Object)string2)) {
                    String string5 = Logging.getMessage((String)"generic.UnrecognizedSourceType", (String)file.getAbsolutePath());
                    Logging.logger().severe(string5);
                    throw new IllegalArgumentException(string5);
                }
                String string3 = Logging.getMessage((String)"generic.UnexpectedRasterType", (String)string2);
                String string4 = file.getAbsolutePath() + ": " + string3;
                String string5 = Logging.getMessage((String)"DataRaster.IncompatibleRaster", (String)string4);
                Logging.logger().severe(string5);
                throw new IllegalArgumentException(string5);
            }
            if (!DataInstallUtil.isWWDotNetLayerSet(file)) continue;
            return new WWDotNetLayerSetConverter();
        }
        if ("gov.nasa.worldwind.avkey.Image".equals(string)) {
            return new TiledImageProducer();
        }
        if ("gov.nasa.worldwind.avkey.Elevation".equals(string)) {
            return new TiledElevationProducer();
        }
        String string6 = Logging.getMessage((String)"generic.UnexpectedRasterType", string);
        Logging.logger().severe(string6);
        throw new IllegalArgumentException(string6);
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Imagery and Elevation Installation", AppFrame.class);
    }

    protected static class InstallableDataFilter
    extends javax.swing.filechooser.FileFilter {
        @Override
        public boolean accept(File file) {
            if (file == null || file.isDirectory()) {
                return true;
            }
            if (DataInstallUtil.isDataRaster(file, null)) {
                return true;
            }
            return DataInstallUtil.isWWDotNetLayerSet(file);
        }

        @Override
        public String getDescription() {
            return "Supported Images/Elevations";
        }
    }

    public static class InstalledDataFrame
    extends JFrame {
        public static final String TOOLTIP_FULL_PYRAMID = "Installing a full pyramid takes longer and consumes more space on the user's hard drive, but has the best runtime performance, which is important for World Wind Server";
        public static final String TOOLTIP_PARTIAL_PYRAMID = "Installing a partial pyramid takes less time and consumes less space on the user's hard drivebut requires that the original data not be moved or deleted";
        protected FileStore fileStore;
        protected InstalledDataPanel dataConfigPanel;
        protected JFileChooser fileChooser;
        protected File lastUsedFolder = null;

        public InstalledDataFrame(FileStore fileStore, WorldWindow worldWindow) throws HeadlessException {
            if (fileStore == null) {
                String string = Logging.getMessage((String)"nullValue.FileStoreIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.fileStore = fileStore;
            this.dataConfigPanel = new InstalledDataPanel("Installed Surface Data", worldWindow);
            this.fileChooser = new JFileChooser(this.getLastUsedFolder());
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            this.fileChooser.addChoosableFileFilter(new InstallableDataFilter());
            this.fileChooser.setMultiSelectionEnabled(true);
            this.fileChooser.setFileSelectionMode(0);
            this.layoutComponents();
            this.loadPreviouslyInstalledData();
        }

        protected File getLastUsedFolder() {
            if (WWUtil.isEmpty((Object)this.lastUsedFolder)) {
                this.setLastUsedFolder(new File(Configuration.getUserHomeDirectory()));
            }
            return this.lastUsedFolder;
        }

        protected void setLastUsedFolder(File file) {
            if (null != file && file.isDirectory()) {
                this.lastUsedFolder = file;
            }
        }

        protected void loadPreviouslyInstalledData() {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    InstallImageryAndElevationsDemo.loadInstalledDataFromFileStore(InstalledDataFrame.this.fileStore, InstalledDataFrame.this.dataConfigPanel);
                }
            });
            thread.start();
        }

        protected void installFromFiles() {
            int n = this.fileChooser.showDialog(this, "Install");
            if (n != 0) {
                return;
            }
            this.setLastUsedFolder(this.fileChooser.getCurrentDirectory());
            final File[] fileArray = this.fileChooser.getSelectedFiles();
            if (fileArray == null || fileArray.length == 0) {
                return;
            }
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Document document = null;
                    try {
                        document = InstallImageryAndElevationsDemo.installDataFromFiles(InstalledDataFrame.this, fileArray, InstalledDataFrame.this.fileStore);
                    }
                    catch (Exception exception) {
                        final String string = exception.getMessage();
                        Logging.logger().log(Level.FINEST, string, exception);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(InstalledDataFrame.this, string, "Installation Error", 0);
                            }
                        });
                    }
                    if (document != null) {
                        AVListImpl aVListImpl = new AVListImpl();
                        InstallImageryAndElevationsDemo.addInstalledData(document, (AVList)aVListImpl, InstalledDataFrame.this.dataConfigPanel);
                    }
                }
            });
            thread.start();
        }

        protected void layoutComponents() {
            this.setTitle("Installed Data");
            this.getContentPane().setLayout(new BorderLayout(0, 0));
            this.getContentPane().add((Component)this.dataConfigPanel, "Center");
            JButton jButton = new JButton("Install...");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    InstalledDataFrame.this.installFromFiles();
                }
            });
            JCheckBox jCheckBox = new JCheckBox("Create a full pyramid", true);
            Configuration.setValue((String)"gov.nasa.worldwind.avkey.Producer.EnableFullPyramid", (Object)true);
            Configuration.removeKey((String)"gov.nasa.worldwind.avkey.TiledRasterProducer.LimitMaxLevel");
            jCheckBox.setToolTipText(TOOLTIP_FULL_PYRAMID);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = actionEvent.getSource();
                    if (object instanceof JCheckBox) {
                        String string;
                        JCheckBox jCheckBox = (JCheckBox)object;
                        if (jCheckBox.isSelected()) {
                            Configuration.setValue((String)"gov.nasa.worldwind.avkey.Producer.EnableFullPyramid", (Object)true);
                            Configuration.removeKey((String)"gov.nasa.worldwind.avkey.TiledRasterProducer.LimitMaxLevel");
                            string = InstalledDataFrame.TOOLTIP_FULL_PYRAMID;
                        } else {
                            Configuration.removeKey((String)"gov.nasa.worldwind.avkey.Producer.EnableFullPyramid");
                            Configuration.setValue((String)"gov.nasa.worldwind.avkey.TiledRasterProducer.LimitMaxLevel", (Object)"50%");
                            string = InstalledDataFrame.TOOLTIP_PARTIAL_PYRAMID;
                        }
                        jCheckBox.setToolTipText(string);
                    }
                }
            });
            Box box = Box.createHorizontalBox();
            box.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            box.add(jButton);
            box.add(jCheckBox);
            this.getContentPane().add((Component)box, "South");
            this.setPreferredSize(new Dimension(400, 500));
            this.validate();
            this.pack();
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected InstalledDataFrame installedDataFrame = new InstalledDataFrame(WorldWind.getDataFileStore(), this.getWwd());

        public AppFrame() {
            WWUtil.alignComponent((Component)this, (Component)this.installedDataFrame, (String)"gov.nasa.worldwind.avkey.Right");
            this.installedDataFrame.setVisible(true);
            this.getWwd().getModel().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwind.avkey.LayersObject")) {
                        AppFrame.this.getLayerPanel().update(AppFrame.this.getWwd());
                    }
                }
            });
            this.layoutComponents();
        }

        public InstalledDataFrame getInstalledDataFrame() {
            return this.installedDataFrame;
        }

        protected void layoutComponents() {
            JButton jButton = new JButton("Show Installed Data...");
            jButton.setAlignmentX(0.0f);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.getInstalledDataFrame().setVisible(true);
                }
            });
            Box box = Box.createVerticalBox();
            box.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            box.add(jButton);
            this.getLayerPanel().add((Component)box, "South");
            this.validate();
            this.pack();
        }
    }
}

