/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.dataimport;

import gov.nasa.worldwind.Factory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.ExampleUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.w3c.dom.Element;

public class InstalledDataPanel
extends JPanel {
    protected WorldWindow worldWindow;
    protected JPanel dataConfigPanel;

    public InstalledDataPanel(String string, WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string2 = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.worldWindow = worldWindow;
        this.dataConfigPanel = new JPanel(new GridLayout(0, 1, 0, 4));
        this.layoutComponents(string);
    }

    public void addInstalledData(Element element, AVList aVList) {
        if (element == null) {
            String string = Logging.getMessage((String)"nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.addToWorldWindow(element, aVList);
        String string = this.getDescription(element);
        Sector sector = this.getSector(element);
        Box box = Box.createHorizontalBox();
        box.add(new JButton(new GoToSectorAction(sector)));
        box.add(Box.createHorizontalStrut(10));
        box.add(new JLabel(string));
        this.dataConfigPanel.add(box);
        this.revalidate();
    }

    protected void layoutComponents(String string) {
        this.dataConfigPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.dataConfigPanel, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 10));
        jPanel2.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder(string)));
        jPanel2.add(jScrollPane);
        this.setLayout(new GridLayout(0, 1, 0, 0));
        this.add(jPanel2);
    }

    protected String getDescription(Element element) {
        String string = DataConfigurationUtils.getDataConfigDisplayName((Element)element);
        String string2 = DataConfigurationUtils.getDataConfigType((Element)element);
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string2.equalsIgnoreCase("Layer")) {
            stringBuilder.append(" (Layer)");
        } else if (string2.equalsIgnoreCase("ElevationModel")) {
            stringBuilder.append(" (Elevations)");
        }
        return stringBuilder.toString();
    }

    protected Sector getSector(Element element) {
        return WWXML.getSector((Element)element, (String)"Sector", null);
    }

    protected void addToWorldWindow(Element element, AVList aVList) {
        String string = DataConfigurationUtils.getDataConfigType((Element)element);
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("Layer")) {
            this.addLayerToWorldWindow(element, aVList);
        } else if (string.equalsIgnoreCase("ElevationModel")) {
            this.addElevationModelToWorldWindow(element, aVList);
        }
    }

    protected void addLayerToWorldWindow(Element element, AVList aVList) {
        Layer layer = null;
        try {
            Factory factory = (Factory)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.LayerFactory");
            layer = (Layer)factory.createFromConfigSource((Object)element, aVList);
        }
        catch (Exception exception) {
            String string = Logging.getMessage((String)"generic.CreationFromConfigurationFailed", (String)DataConfigurationUtils.getDataConfigDisplayName((Element)element));
            Logging.logger().log(Level.SEVERE, string, exception);
        }
        if (layer == null) {
            return;
        }
        layer.setEnabled(true);
        if (!this.worldWindow.getModel().getLayers().contains((Object)layer)) {
            ApplicationTemplate.insertBeforePlacenames(this.worldWindow, layer);
        }
    }

    protected void addElevationModelToWorldWindow(Element element, AVList aVList) {
        String string;
        Factory factory;
        ElevationModel elevationModel = null;
        try {
            factory = (Factory)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ElevationModelFactory");
            elevationModel = (ElevationModel)factory.createFromConfigSource((Object)element, aVList);
        }
        catch (Exception exception) {
            string = Logging.getMessage((String)"generic.CreationFromConfigurationFailed", (String)DataConfigurationUtils.getDataConfigDisplayName((Element)element));
            Logging.logger().log(Level.SEVERE, string, exception);
        }
        if (elevationModel == null) {
            return;
        }
        factory = this.worldWindow.getModel().getGlobe().getElevationModel();
        if (factory instanceof CompoundElevationModel) {
            if (!((CompoundElevationModel)factory).containsElevationModel(elevationModel)) {
                ((CompoundElevationModel)factory).addElevationModel(elevationModel);
            }
        } else {
            string = new CompoundElevationModel();
            string.addElevationModel((ElevationModel)factory);
            string.addElevationModel(elevationModel);
            this.worldWindow.getModel().getGlobe().setElevationModel((ElevationModel)string);
        }
    }

    protected class GoToSectorAction
    extends AbstractAction {
        protected Sector sector;

        public GoToSectorAction(Sector sector) {
            super("Go To");
            this.sector = sector;
            this.setEnabled(this.sector != null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExampleUtil.goTo(InstalledDataPanel.this.worldWindow, this.sector);
        }
    }
}

