/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.elevations;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.terrain.WMSBasicElevationModel;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.examples.elevations.GetElevationsPostProcessor;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class ElevationsRetriever {
    private Retriever retriever = null;
    private GetElevationsPostProcessor callBack = null;

    public ElevationsRetriever(WMSBasicElevationModel wMSBasicElevationModel, ArrayList<LatLon> arrayList, int n, int n2, GetElevationsPostProcessor getElevationsPostProcessor) {
        if (null == wMSBasicElevationModel) {
            String string = Logging.getMessage((String)"nullValue.ElevationModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (null == arrayList || 0 == arrayList.size()) {
            String string = Logging.getMessage((String)"nullValue.LatLonListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (null == getElevationsPostProcessor) {
            String string = Logging.getMessage((String)"nullValue.PostProcessorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Level level = wMSBasicElevationModel.getLevels().getLastLevel();
        String string = level.getService();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.endsWith("?")) {
            stringBuffer.append("?");
        }
        stringBuffer.append("REQUEST=GetElevations");
        stringBuffer.append("&WW_MAX_THREADS=2");
        stringBuffer.append("&LAYERS=").append(level.getDataset());
        stringBuffer.append("&LOCATIONS=");
        for (LatLon latLon : arrayList) {
            stringBuffer.append(latLon.getLongitude().degrees).append(",").append(latLon.getLatitude().degrees).append(";");
        }
        stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(";"));
        this.callBack = getElevationsPostProcessor;
        try {
            URL uRL = new URL(stringBuffer.toString());
            this.retriever = new HTTPRetriever(uRL, (RetrievalPostProcessor)new ElevationsRetrieverPostProcessor(getElevationsPostProcessor));
            this.retriever.setConnectTimeout(n);
            this.retriever.setReadTimeout(n2);
        }
        catch (Exception exception) {
            Logging.logger().severe(exception.getMessage());
            getElevationsPostProcessor.onError(exception.getMessage());
        }
    }

    public void start() {
        try {
            this.retriever.call();
        }
        catch (Exception exception) {
            Logging.logger().severe(exception.getMessage());
            this.callBack.onError(exception.getMessage());
        }
    }

    protected static class ElevationsRetrieverPostProcessor
    implements RetrievalPostProcessor {
        private GetElevationsPostProcessor callBack = null;

        public ElevationsRetrieverPostProcessor(GetElevationsPostProcessor getElevationsPostProcessor) {
            this.callBack = getElevationsPostProcessor;
        }

        public ByteBuffer run(Retriever retriever) {
            HTTPRetriever hTTPRetriever;
            if (retriever == null) {
                String string = Logging.getMessage((String)"nullValue.RetrieverIsNull");
                Logging.logger().severe(string);
                this.callBack.onError(string);
                return null;
            }
            if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                this.callBack.onError(retriever.getState());
                return null;
            }
            if (retriever instanceof HTTPRetriever && (hTTPRetriever = (HTTPRetriever)retriever).getResponseCode() != 200) {
                this.callBack.onError("" + hTTPRetriever.getResponseCode());
                return null;
            }
            hTTPRetriever = (URLRetriever)retriever;
            ByteBuffer byteBuffer = hTTPRetriever.getBuffer();
            if (byteBuffer != null) {
                byteBuffer.rewind();
                FloatBuffer floatBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
                floatBuffer.rewind();
                int n = floatBuffer.capacity() / 3;
                Position[] positionArray = new Position[n];
                for (int i = 0; i < n; ++i) {
                    double d = floatBuffer.get();
                    double d2 = floatBuffer.get();
                    double d3 = floatBuffer.get();
                    positionArray[i] = Position.fromDegrees((double)d, (double)d2, (double)d3);
                }
                this.callBack.onSuccess(positionArray);
                return byteBuffer;
            }
            this.callBack.onError("Unknown error");
            return null;
        }
    }
}

