/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.elevations;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.terrain.WMSBasicElevationModel;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.LayerPanel;
import gov.nasa.worldwindx.examples.elevations.ElevationsRetriever;
import gov.nasa.worldwindx.examples.elevations.GetElevationsPostProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RetrieveElevations
extends ApplicationTemplate {
    public static final String ACTION_COMMAND_BUTTON1 = "ActionCommand_Button1";
    public static final String ACTION_COMMAND_BUTTON2 = "ActionCommand_Button2";
    public static final String ACTION_COMMAND_BUTTON3 = "ActionCommand_Button3";
    public static final String ACTION_COMMAND_BUTTON4 = "ActionCommand_Button4";
    public static final String ACTION_COMMAND_VERTICAL_EXAGGERATION = "ActionCommandVerticalExaggeration";

    public static void main(String[] stringArray) {
        RetrieveElevations.start("World Wind Elevations Demo", AppFrame.class);
    }

    public static class ElevationsDemoController
    implements ActionListener {
        protected AppFrame frame;
        protected WorldWindow wwd;

        public ElevationsDemoController(WorldWindow worldWindow) {
            this.wwd = worldWindow;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RetrieveElevations.ACTION_COMMAND_BUTTON1.equalsIgnoreCase(actionEvent.getActionCommand())) {
                this.doActionOnButton1();
            } else if (RetrieveElevations.ACTION_COMMAND_BUTTON2.equalsIgnoreCase(actionEvent.getActionCommand())) {
                this.doActionOnButton2();
            } else if (RetrieveElevations.ACTION_COMMAND_BUTTON3.equalsIgnoreCase(actionEvent.getActionCommand())) {
                this.doActionOnButton3();
            } else if (RetrieveElevations.ACTION_COMMAND_BUTTON4.equalsIgnoreCase(actionEvent.getActionCommand())) {
                this.doActionOnButton4();
            } else if (RetrieveElevations.ACTION_COMMAND_VERTICAL_EXAGGERATION.equalsIgnoreCase(actionEvent.getActionCommand())) {
                Double d = (Double)actionEvent.getSource();
                this.doSetVerticalExaggeration(d);
                this.wwd.redraw();
            }
        }

        public void doActionOnButton1() {
            Logging.logger().info("Zooming to Matterhorn");
            View view = this.wwd.getView();
            Position position = new Position(LatLon.fromDegrees((double)45.9763888888889, (double)7.65833333333333), 0.0);
            view.goTo(position, 5000.0);
        }

        public void doActionOnButton2() {
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            arrayList.add(LatLon.fromDegrees((double)45.5, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.52, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.54, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.56, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.58, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.6, (double)-123.3));
            Sector sector = Sector.fromDegrees((double)44.0, (double)46.0, (double)-123.0, (double)-121.0);
            double[] dArray = new double[arrayList.size()];
            double d = Angle.fromDegrees((double)1.0).radians / 3600.0;
            double d2 = this.wwd.getModel().getGlobe().getElevationModel().getElevations(sector, arrayList, d, dArray);
            StringBuffer stringBuffer = new StringBuffer();
            for (double d3 : dArray) {
                stringBuffer.append("\n").append(d3);
            }
            stringBuffer.append("\nresolutionAchieved = ").append(d2);
            stringBuffer.append(", requested resolution = ").append(d);
            Logging.logger().info(stringBuffer.toString());
        }

        public void doActionOnButton3() {
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            arrayList.add(LatLon.fromDegrees((double)45.5, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.52, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.54, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.56, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.58, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.6, (double)-123.3));
            ElevationModel elevationModel = this.wwd.getModel().getGlobe().getElevationModel();
            StringBuffer stringBuffer = new StringBuffer();
            for (LatLon latLon : arrayList) {
                double d = elevationModel.getElevation(latLon.getLatitude(), latLon.getLongitude());
                stringBuffer.append("\n").append(d);
            }
            Logging.logger().info(stringBuffer.toString());
        }

        public void doActionOnButton4() {
            Object object;
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            arrayList.add(LatLon.fromDegrees((double)45.5, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.52, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.54, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.56, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.58, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)45.6, (double)-123.3));
            arrayList.add(LatLon.fromDegrees((double)40.5, (double)-120.1));
            arrayList.add(LatLon.fromDegrees((double)40.52, (double)-120.2));
            arrayList.add(LatLon.fromDegrees((double)40.54, (double)-120.3));
            arrayList.add(LatLon.fromDegrees((double)40.56, (double)-120.4));
            arrayList.add(LatLon.fromDegrees((double)40.58, (double)-120.5));
            arrayList.add(LatLon.fromDegrees((double)40.6, (double)-120.6));
            WMSBasicElevationModel wMSBasicElevationModel = null;
            ElevationModel elevationModel = this.wwd.getModel().getGlobe().getElevationModel();
            if (elevationModel instanceof CompoundElevationModel) {
                object = (CompoundElevationModel)elevationModel;
                for (ElevationModel elevationModel2 : object.getElevationModels()) {
                    if (!(elevationModel2 instanceof WMSBasicElevationModel)) continue;
                    wMSBasicElevationModel = (WMSBasicElevationModel)elevationModel2;
                    break;
                }
            } else if (elevationModel instanceof WMSBasicElevationModel) {
                wMSBasicElevationModel = (WMSBasicElevationModel)elevationModel;
            }
            if (null != wMSBasicElevationModel) {
                object = new ElevationsRetriever(wMSBasicElevationModel, arrayList, 10000, 30000, new NotifyWhenReady());
                ((ElevationsRetriever)object).start();
            } else {
                object = Logging.getMessage((String)"ElevationModel.ExceptionRequestingElevations", (String)"No instance of WMSBasicElevationModel was found");
                Logging.logger().severe((String)object);
            }
        }

        public void doSetVerticalExaggeration(double d) {
            this.wwd.getSceneController().setVerticalExaggeration(d);
        }

        protected class NotifyWhenReady
        implements GetElevationsPostProcessor {
            protected NotifyWhenReady() {
            }

            @Override
            public void onSuccess(Position[] positionArray) {
                for (Position position : positionArray) {
                    Logging.logger().info(position.getLatitude().degrees + "," + position.getLongitude().degrees + " --> " + position.getElevation());
                }
            }

            @Override
            public void onError(String string) {
                String string2 = Logging.getMessage((String)"ElevationModel.ExceptionRequestingElevations", (String)string);
                Logging.logger().severe(string2);
            }
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected ElevationsDemoController controller = new ElevationsDemoController(this.getWwd());
        protected LayerPanel layerPanel;

        public AppFrame() {
            super(true, false, false);
            this.controller.frame = this;
            this.makeComponents();
            this.getLayerPanel().update(this.getWwd());
            this.pack();
        }

        @Override
        public LayerPanel getLayerPanel() {
            return this.layerPanel;
        }

        protected void makeComponents() {
            ((Component)this.getWwd()).setPreferredSize(new Dimension(1024, 768));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(10, 0, 10, 0));
            JPanel jPanel2 = new JPanel(new BorderLayout(0, 10));
            jPanel2.setBorder(new EmptyBorder(20, 10, 20, 10));
            JPanel jPanel3 = new JPanel(new GridLayout(5, 1, 0, 5));
            JComponent jComponent = new JButton("Zoom to Matterhorn");
            ((AbstractButton)jComponent).setActionCommand(RetrieveElevations.ACTION_COMMAND_BUTTON1);
            ((AbstractButton)jComponent).addActionListener(this.controller);
            jPanel3.add(jComponent);
            jComponent = new JButton("DEMO getElevations()");
            ((AbstractButton)jComponent).setActionCommand(RetrieveElevations.ACTION_COMMAND_BUTTON2);
            ((AbstractButton)jComponent).addActionListener(this.controller);
            jPanel3.add(jComponent);
            jComponent = new JButton("DEMO getElevation()");
            ((AbstractButton)jComponent).setActionCommand(RetrieveElevations.ACTION_COMMAND_BUTTON3);
            ((AbstractButton)jComponent).addActionListener(this.controller);
            jPanel3.add(jComponent);
            jComponent = new JButton("DEMO new getElevations");
            ((AbstractButton)jComponent).setActionCommand(RetrieveElevations.ACTION_COMMAND_BUTTON4);
            ((AbstractButton)jComponent).addActionListener(this.controller);
            jPanel3.add(jComponent);
            jPanel2.add((Component)jPanel3, "North");
            jComponent = new JPanel(new BorderLayout(0, 5));
            JLabel jLabel = new JLabel("Vertical Exaggeration");
            jComponent.add((Component)jLabel, "North");
            int n = 1;
            int n2 = 8;
            int n3 = (int)this.getWwd().getSceneController().getVerticalExaggeration();
            n3 = n3 < n ? n : (n3 > n2 ? n2 : n3);
            JSlider jSlider = new JSlider(n, n2, n3);
            jSlider.setMajorTickSpacing(1);
            jSlider.setPaintTicks(true);
            jSlider.setSnapToTicks(true);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(1, new JLabel("1x"));
            hashtable.put(2, new JLabel("2x"));
            hashtable.put(4, new JLabel("4x"));
            hashtable.put(8, new JLabel("8x"));
            jSlider.setLabelTable(hashtable);
            jSlider.setPaintLabels(true);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    double d = ((JSlider)changeEvent.getSource()).getValue();
                    ActionEvent actionEvent = new ActionEvent(d, 0, RetrieveElevations.ACTION_COMMAND_VERTICAL_EXAGGERATION);
                    AppFrame.this.controller.actionPerformed(actionEvent);
                }
            });
            jComponent.add((Component)jSlider, "South");
            jPanel2.add((Component)jComponent, "South");
            jPanel.add((Component)jPanel2, "South");
            this.layerPanel = new LayerPanel(this.getWwd(), null);
            jPanel.add((Component)this.layerPanel, "Center");
            this.getContentPane().add((Component)jPanel, "West");
        }
    }
}

