/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.kml;

import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.examples.kml.KMLDocumentBuilder;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ExportKML {
    protected static ShapeAttributes normalShapeAttributes;
    protected static ShapeAttributes highlightShapeAttributes;

    protected static PointPlacemark makePointPlacemark() {
        PointPlacemark pointPlacemark = new PointPlacemark(Position.fromDegrees((double)37.824713, (double)-122.370028, (double)0.0));
        pointPlacemark.setLabelText("Treasure Island");
        pointPlacemark.setValue("gov.nasa.worldwind.avkey.Server.ShortDescription", (Object)"Sample placemark");
        pointPlacemark.setValue("gov.nasa.worldwind.avkey.BalloonText", (Object)"This is a <b>Point Placemark</b>");
        pointPlacemark.setLineEnabled(false);
        pointPlacemark.setAltitudeMode(1);
        return pointPlacemark;
    }

    protected static Path makePath() {
        Path path = new Path();
        List<Position> list = Arrays.asList(Position.fromDegrees((double)37.8304, (double)-122.372, (double)0.0), Position.fromDegrees((double)37.8293, (double)-122.3679, (double)50.0), Position.fromDegrees((double)37.8282, (double)-122.371, (double)100.0));
        path.setPositions(list);
        path.setExtrude(true);
        path.setAttributes(normalShapeAttributes);
        path.setHighlightAttributes(highlightShapeAttributes);
        path.setValue("gov.nasa.worldwind.avkey.Server.ShortDescription", (Object)"Short description of Path");
        path.setValue("gov.nasa.worldwind.avkey.BalloonText", (Object)"This is a Path.");
        return path;
    }

    protected static Polygon makePolygon() {
        Polygon polygon = new Polygon();
        List<Position> list = Arrays.asList(Position.fromDegrees((double)37.8224479345424, (double)-122.3739784354151, (double)50.0), Position.fromDegrees((double)37.82239261906633, (double)-122.3740285701554, (double)50.0), Position.fromDegrees((double)37.82240608112512, (double)-122.3744696934806, (double)50.0), Position.fromDegrees((double)37.82228167878964, (double)-122.3744693163394, (double)50.0), Position.fromDegrees((double)37.82226619249474, (double)-122.3739902862858, (double)50.0), Position.fromDegrees((double)37.82219810227204, (double)-122.3739510452131, (double)50.0), Position.fromDegrees((double)37.82191990027978, (double)-122.3742004406226, (double)50.0), Position.fromDegrees((double)37.82186185177756, (double)-122.3740740264531, (double)50.0), Position.fromDegrees((double)37.82213350487949, (double)-122.3738377669854, (double)50.0), Position.fromDegrees((double)37.82213842777661, (double)-122.3737599855226, (double)50.0), Position.fromDegrees((double)37.82184815805735, (double)-122.3735538230499, (double)50.0), Position.fromDegrees((double)37.82188747252212, (double)-122.3734202823307, (double)50.0), Position.fromDegrees((double)37.82220302338508, (double)-122.37362176179, (double)50.0), Position.fromDegrees((double)37.8222686063349, (double)-122.3735762207482, (double)50.0), Position.fromDegrees((double)37.82224254303025, (double)-122.3731468984375, (double)50.0), Position.fromDegrees((double)37.82237319467147, (double)-122.3731303943743, (double)50.0), Position.fromDegrees((double)37.82238194814573, (double)-122.3735637823936, (double)50.0), Position.fromDegrees((double)37.82244505243797, (double)-122.3736008458059, (double)50.0), Position.fromDegrees((double)37.82274355652806, (double)-122.3734009024945, (double)50.0), Position.fromDegrees((double)37.82280084508153, (double)-122.3735091430554, (double)50.0), Position.fromDegrees((double)37.82251198652374, (double)-122.3737489159765, (double)50.0), Position.fromDegrees((double)37.82251207172572, (double)-122.3738269699774, (double)50.0), Position.fromDegrees((double)37.82280161524027, (double)-122.3740332968739, (double)50.0), Position.fromDegrees((double)37.82275318071796, (double)-122.3741825267907, (double)50.0), Position.fromDegrees((double)37.8224479345424, (double)-122.3739784354151, (double)50.0));
        List<Position> list2 = Arrays.asList(Position.fromDegrees((double)37.82237624346899, (double)-122.3739179072036, (double)50.0), Position.fromDegrees((double)37.82226147323489, (double)-122.3739053159649, (double)50.0), Position.fromDegrees((double)37.82221834573171, (double)-122.3737889140025, (double)50.0), Position.fromDegrees((double)37.82226275093125, (double)-122.3736772434448, (double)50.0), Position.fromDegrees((double)37.82237889526623, (double)-122.3736727730745, (double)50.0), Position.fromDegrees((double)37.82243486851886, (double)-122.3737811526564, (double)50.0), Position.fromDegrees((double)37.82237624346899, (double)-122.3739179072036, (double)50.0));
        polygon.setOuterBoundary(list);
        polygon.addInnerBoundary(list2);
        polygon.setAltitudeMode(2);
        polygon.setAttributes(normalShapeAttributes);
        polygon.setHighlightAttributes(highlightShapeAttributes);
        polygon.setValue("gov.nasa.worldwind.avkey.Server.ShortDescription", (Object)"Short description of Polygon");
        polygon.setValue("gov.nasa.worldwind.avkey.BalloonText", (Object)"This is a Polygon.");
        return polygon;
    }

    protected static SurfaceQuad makeSurfaceQuad() {
        return new SurfaceQuad(LatLon.fromDegrees((double)45.0, (double)100.0), 10000.0, 20000.0, Angle.ZERO);
    }

    public static void main(String[] stringArray) {
        try {
            normalShapeAttributes = new BasicShapeAttributes();
            normalShapeAttributes.setInteriorMaterial(Material.BLUE);
            normalShapeAttributes.setOutlineMaterial(Material.BLACK);
            highlightShapeAttributes = new BasicShapeAttributes();
            highlightShapeAttributes.setInteriorMaterial(Material.RED);
            highlightShapeAttributes.setOutlineMaterial(Material.BLACK);
            StringWriter stringWriter = new StringWriter();
            KMLDocumentBuilder kMLDocumentBuilder = new KMLDocumentBuilder(stringWriter);
            kMLDocumentBuilder.writeObjects(new Exportable[]{ExportKML.makeSurfaceQuad(), ExportKML.makePointPlacemark(), ExportKML.makePath(), ExportKML.makePolygon()});
            kMLDocumentBuilder.close();
            String string = ((Object)stringWriter).toString();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new StreamSource(new StringReader(string)), new StreamResult(System.out));
        }
        catch (Exception exception) {
            String string = Logging.getMessage((String)"generic.ExceptionAttemptingToWriteXml", (String)exception.toString());
            Logging.logger().severe(string);
            exception.printStackTrace();
        }
    }
}

