/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.kml;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.animation.AngleAnimator;
import gov.nasa.worldwind.animation.AnimationSupport;
import gov.nasa.worldwind.animation.Animator;
import gov.nasa.worldwind.animation.DoubleAnimator;
import gov.nasa.worldwind.animation.Interpolator;
import gov.nasa.worldwind.animation.PositionAnimator;
import gov.nasa.worldwind.animation.ScheduledInterpolator;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.ogc.kml.KMLCamera;
import gov.nasa.worldwind.ogc.kml.KMLLookAt;
import gov.nasa.worldwind.ogc.kml.impl.KMLUtil;
import gov.nasa.worldwind.view.ViewPropertyAccessor;
import gov.nasa.worldwind.view.firstperson.BasicFlyView;
import gov.nasa.worldwind.view.firstperson.FlyToFlyViewAnimator;
import gov.nasa.worldwind.view.firstperson.FlyViewInputHandler;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwindx.examples.kml.KMLViewController;

public class KMLFlyViewController
extends KMLViewController {
    protected final long MIN_LENGTH_MILLIS = 4000L;
    protected final long MAX_LENGTH_MILLIS = 16000L;
    protected BasicFlyView flyView;

    protected KMLFlyViewController(WorldWindow worldWindow) {
        super(worldWindow);
        this.flyView = (BasicFlyView)worldWindow.getView();
    }

    @Override
    protected void goTo(KMLLookAt kMLLookAt) {
        double d = kMLLookAt.getLatitude() != null ? kMLLookAt.getLatitude() : 0.0;
        double d2 = kMLLookAt.getLongitude() != null ? kMLLookAt.getLongitude() : 0.0;
        double d3 = kMLLookAt.getAltitude() != null ? kMLLookAt.getAltitude() : 0.0;
        double d4 = kMLLookAt.getHeading() != null ? kMLLookAt.getHeading() : 0.0;
        double d5 = kMLLookAt.getTilt() != null ? kMLLookAt.getTilt() : 0.0;
        double d6 = kMLLookAt.getRange();
        String string = kMLLookAt.getAltitudeMode();
        Position position = Position.fromDegrees((double)d, (double)d2, (double)d3);
        Vec4 vec4 = this.flyView.getCenterPoint();
        Position position2 = vec4 != null ? this.flyView.getGlobe().computePositionFromPoint(vec4) : this.flyView.getCurrentEyePosition();
        long l = AnimationSupport.getScaledTimeMillisecs((LatLon)position2, (LatLon)position, (long)4000L, (long)16000L);
        FlyToFlyViewAnimator flyToFlyViewAnimator = this.createFlyToLookAtAnimator(this.flyView, position, Angle.fromDegrees((double)d4), Angle.fromDegrees((double)d5), d6, l, KMLUtil.convertAltitudeMode((String)string, (int)1));
        FlyViewInputHandler flyViewInputHandler = (FlyViewInputHandler)this.flyView.getViewInputHandler();
        flyViewInputHandler.stopAnimators();
        flyViewInputHandler.addAnimator((Animator)flyToFlyViewAnimator);
    }

    @Override
    protected void goTo(KMLCamera kMLCamera) {
        double d = kMLCamera.getLatitude() != null ? kMLCamera.getLatitude() : 0.0;
        double d2 = kMLCamera.getLongitude() != null ? kMLCamera.getLongitude() : 0.0;
        double d3 = kMLCamera.getAltitude() != null ? kMLCamera.getAltitude() : 0.0;
        double d4 = kMLCamera.getHeading() != null ? kMLCamera.getHeading() : 0.0;
        double d5 = kMLCamera.getTilt() != null ? kMLCamera.getTilt() : 0.0;
        double d6 = kMLCamera.getRoll() != null ? kMLCamera.getRoll() : 0.0;
        d6 = -d6;
        String string = kMLCamera.getAltitudeMode();
        Position position = Position.fromDegrees((double)d, (double)d2, (double)d3);
        long l = AnimationSupport.getScaledTimeMillisecs((LatLon)this.flyView.getEyePosition(), (LatLon)position, (long)4000L, (long)16000L);
        FlyToFlyViewAnimator flyToFlyViewAnimator = FlyToFlyViewAnimator.createFlyToFlyViewAnimator((BasicFlyView)this.flyView, (Position)this.flyView.getEyePosition(), (Position)position, (Angle)this.flyView.getHeading(), (Angle)Angle.fromDegrees((double)d4), (Angle)this.flyView.getPitch(), (Angle)Angle.fromDegrees((double)d5), (Angle)this.flyView.getRoll(), (Angle)Angle.fromDegrees((double)d6), (double)this.flyView.getEyePosition().getElevation(), (double)position.getElevation(), (long)l, (int)KMLUtil.convertAltitudeMode((String)string, (int)2));
        FlyViewInputHandler flyViewInputHandler = (FlyViewInputHandler)this.flyView.getViewInputHandler();
        flyViewInputHandler.stopAnimators();
        flyViewInputHandler.addAnimator((Animator)flyToFlyViewAnimator);
    }

    protected FlyToFlyViewAnimator createFlyToLookAtAnimator(BasicFlyView basicFlyView, Position position, Angle angle, Angle angle2, double d, long l, int n) {
        BasicOrbitView basicOrbitView = new BasicOrbitView();
        basicOrbitView.setGlobe(basicFlyView.getGlobe());
        basicOrbitView.setCenterPosition(position);
        basicOrbitView.setHeading(angle);
        basicOrbitView.setPitch(angle2);
        basicOrbitView.setZoom(d);
        Position position2 = basicFlyView.getCurrentEyePosition();
        Position position3 = basicOrbitView.getCurrentEyePosition();
        FlyToFlyViewAnimator.OnSurfacePositionAnimator onSurfacePositionAnimator = new FlyToFlyViewAnimator.OnSurfacePositionAnimator(basicFlyView.getGlobe(), (Interpolator)new ScheduledInterpolator(l), position2, position3, ViewPropertyAccessor.createEyePositionAccessor((View)basicFlyView), n);
        FlyToFlyViewAnimator.FlyToElevationAnimator flyToElevationAnimator = new FlyToFlyViewAnimator.FlyToElevationAnimator(basicFlyView, basicFlyView.getGlobe(), position2.getElevation(), position3.getElevation(), (LatLon)position2, (LatLon)position3, 0, ViewPropertyAccessor.createElevationAccessor((View)basicFlyView));
        AngleAnimator angleAnimator = new AngleAnimator((Interpolator)new ScheduledInterpolator(l), basicFlyView.getHeading(), angle, ViewPropertyAccessor.createHeadingAccessor((View)basicFlyView));
        AngleAnimator angleAnimator2 = new AngleAnimator((Interpolator)new ScheduledInterpolator(l), basicFlyView.getPitch(), angle2, ViewPropertyAccessor.createPitchAccessor((View)basicFlyView));
        return new FlyToLookAtAnimator((Interpolator)new ScheduledInterpolator(l), (OrbitView)basicOrbitView, position, n, (PositionAnimator)onSurfacePositionAnimator, (DoubleAnimator)flyToElevationAnimator, angleAnimator, angleAnimator2, null);
    }

    protected class FlyToLookAtAnimator
    extends FlyToFlyViewAnimator {
        protected int altitudeMode;
        protected OrbitView targetView;
        protected Position lookAtPosition;
        protected PositionAnimator eyePositionAnimator;
        protected DoubleAnimator elevationAnimator;

        public FlyToLookAtAnimator(Interpolator interpolator, OrbitView orbitView, Position position, int n, PositionAnimator positionAnimator, DoubleAnimator doubleAnimator, AngleAnimator angleAnimator, AngleAnimator angleAnimator2, AngleAnimator angleAnimator3) {
            super(interpolator, n, positionAnimator, doubleAnimator, angleAnimator, angleAnimator2, angleAnimator3);
            this.targetView = orbitView;
            this.altitudeMode = n;
            this.lookAtPosition = position;
            this.eyePositionAnimator = positionAnimator;
            this.elevationAnimator = doubleAnimator;
        }

        protected void setImpl(double d) {
            double d2 = 0.0;
            boolean bl = false;
            if (this.altitudeMode == 1) {
                bl = true;
                d2 = this.targetView.getGlobe().getElevation(this.lookAtPosition.getLatitude(), this.lookAtPosition.getLongitude());
            } else if (this.altitudeMode == 2) {
                bl = true;
                d2 = this.targetView.getGlobe().getElevation(this.lookAtPosition.getLatitude(), this.lookAtPosition.getLongitude()) + this.lookAtPosition.getAltitude();
            }
            if (bl) {
                Position position = new Position((LatLon)this.lookAtPosition, d2);
                this.targetView.setCenterPosition(position);
                Position position2 = this.targetView.getCurrentEyePosition();
                this.eyePositionAnimator.setEnd(position2);
                this.elevationAnimator.setEnd(Double.valueOf(position2.getElevation()));
            }
            super.setImpl(d);
        }
    }
}

