/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.kml;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLAbstractGeometry;
import gov.nasa.worldwind.ogc.kml.KMLAbstractView;
import gov.nasa.worldwind.ogc.kml.KMLCamera;
import gov.nasa.worldwind.ogc.kml.KMLGroundOverlay;
import gov.nasa.worldwind.ogc.kml.KMLLookAt;
import gov.nasa.worldwind.ogc.kml.KMLPlacemark;
import gov.nasa.worldwind.ogc.kml.impl.KMLUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.firstperson.BasicFlyView;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwindx.examples.kml.KMLFlyViewController;
import gov.nasa.worldwindx.examples.kml.KMLOrbitViewController;
import java.util.ArrayList;
import java.util.List;

public abstract class KMLViewController {
    public static final double DEFAULT_VIEW_ALTITUDE = 10000.0;
    protected double viewAltitude = 10000.0;
    protected WorldWindow wwd;

    public static KMLViewController create(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        View view = worldWindow.getView();
        if (view instanceof OrbitView) {
            return new KMLOrbitViewController(worldWindow);
        }
        if (view instanceof BasicFlyView) {
            return new KMLFlyViewController(worldWindow);
        }
        Logging.logger().warning(Logging.getMessage((String)"generic.UnrecognizedView", (Object[])new Object[]{view}));
        return null;
    }

    protected KMLViewController(WorldWindow worldWindow) {
        this.wwd = worldWindow;
    }

    public void goTo(KMLAbstractFeature kMLAbstractFeature) {
        if (kMLAbstractFeature == null) {
            String string = Logging.getMessage((String)"nullValue.FeatureIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        KMLAbstractView kMLAbstractView = kMLAbstractFeature.getView();
        if (kMLAbstractView instanceof KMLLookAt) {
            this.goTo((KMLLookAt)kMLAbstractView);
        } else if (kMLAbstractView instanceof KMLCamera) {
            this.goTo((KMLCamera)kMLAbstractView);
        } else {
            this.goToDefaultView(kMLAbstractFeature);
        }
    }

    public void goTo(KMLAbstractView kMLAbstractView) {
        if (kMLAbstractView == null) {
            String string = Logging.getMessage((String)"nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (kMLAbstractView instanceof KMLLookAt) {
            this.goTo((KMLLookAt)kMLAbstractView);
        } else if (kMLAbstractView instanceof KMLCamera) {
            this.goTo((KMLCamera)kMLAbstractView);
        } else {
            Logging.logger().warning(Logging.getMessage((String)"generic.UnrecognizedView", (Object[])new Object[]{kMLAbstractView}));
        }
    }

    protected abstract void goTo(KMLLookAt var1);

    protected abstract void goTo(KMLCamera var1);

    public void goToDefaultView(KMLAbstractFeature kMLAbstractFeature) {
        if (kMLAbstractFeature instanceof KMLPlacemark) {
            this.goToDefaultPlacemarkView((KMLPlacemark)kMLAbstractFeature);
        } else if (kMLAbstractFeature instanceof KMLGroundOverlay) {
            this.goToDefaultGroundOverlayView((KMLGroundOverlay)kMLAbstractFeature);
        }
    }

    protected void goToDefaultPlacemarkView(KMLPlacemark kMLPlacemark) {
        View view = this.wwd.getView();
        ArrayList arrayList = new ArrayList();
        KMLAbstractGeometry kMLAbstractGeometry = kMLPlacemark.getGeometry();
        KMLUtil.getPositions((Globe)view.getGlobe(), (KMLAbstractGeometry)kMLAbstractGeometry, arrayList);
        this.goToDefaultView(arrayList);
    }

    protected void goToDefaultGroundOverlayView(KMLGroundOverlay kMLGroundOverlay) {
        List list = kMLGroundOverlay.getPositions().list;
        String string = kMLGroundOverlay.getAltitudeMode() != null ? kMLGroundOverlay.getAltitudeMode() : "clampToGround";
        list = KMLUtil.computeAltitude((Globe)this.wwd.getModel().getGlobe(), (List)list, (String)string);
        this.goToDefaultView(list);
    }

    protected void goToDefaultView(List<? extends Position> list) {
        View view = this.wwd.getView();
        if (list.size() == 1) {
            Position position = list.get(0);
            view.goTo(position, position.getAltitude() + this.getViewAltitude());
        } else if (list.size() > 1) {
            double d;
            Sector sector = Sector.boundingSector(list);
            Globe globe = view.getGlobe();
            double d2 = this.wwd.getSceneController().getVerticalExaggeration();
            double d3 = this.findMaxAltitude(list);
            double[] dArray = globe.getMinAndMaxElevations(sector);
            double d4 = dArray[0];
            Cylinder cylinder = Sector.computeBoundingCylinder((Globe)globe, (double)d2, (Sector)sector, (double)d4, (double)(d = Math.max(dArray[1], d3)));
            if (cylinder == null) {
                String string = Logging.getMessage((String)"nullValue.SectorIsNull");
                Logging.logger().warning(string);
                return;
            }
            Angle angle = view.getFieldOfView();
            Position position = new Position(sector.getCentroid(), d3);
            double d5 = cylinder.getRadius() / (angle.tanHalfAngle() * angle.cosHalfAngle()) + this.getViewAltitude();
            view.goTo(position, d5);
        }
    }

    protected double findMaxAltitude(List<? extends Position> list) {
        double d = -1.7976931348623157E308;
        for (Position position : list) {
            double d2 = position.getAltitude();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double getViewAltitude() {
        return this.viewAltitude;
    }

    public void setViewAltitude(double d) {
        this.viewAltitude = d;
    }
}

