/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.kml;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLRoot;
import gov.nasa.worldwind.ogc.kml.impl.KMLController;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.retrieve.RetrievalService;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.layertree.KMLLayerTreeNode;
import gov.nasa.worldwind.util.layertree.KMLNetworkLinkTreeNode;
import gov.nasa.worldwind.util.layertree.LayerTree;
import gov.nasa.worldwind.util.layertree.LayerTreeNode;
import gov.nasa.worldwind.util.tree.Tree;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.kml.KMLApplicationController;
import gov.nasa.worldwindx.examples.util.BalloonController;
import gov.nasa.worldwindx.examples.util.HotSpotController;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.stream.XMLStreamException;

public class KMLViewer
extends ApplicationTemplate {
    protected static String formName(Object object, KMLRoot kMLRoot) {
        KMLAbstractFeature kMLAbstractFeature = kMLRoot.getFeature();
        if (kMLAbstractFeature != null && !WWUtil.isEmpty((Object)kMLAbstractFeature.getName())) {
            return kMLAbstractFeature.getName();
        }
        if (object instanceof File) {
            return ((File)object).getName();
        }
        if (object instanceof URL) {
            return ((URL)object).getPath();
        }
        if (object instanceof String && WWIO.makeURL((String)((String)object)) != null) {
            return WWIO.makeURL((String)((String)object)).getPath();
        }
        return "KML Layer";
    }

    protected static void makeMenu(final AppFrame appFrame) {
        final JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("KML/KMZ File", "kml", "kmz"));
        JMenuBar jMenuBar = new JMenuBar();
        appFrame.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Open File..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = jFileChooser.showOpenDialog(appFrame);
                    if (n == 0) {
                        for (File file : jFileChooser.getSelectedFiles()) {
                            new WorkerThread(file, appFrame).start();
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(new AbstractAction("Open URL..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = JOptionPane.showInputDialog(appFrame, (Object)"URL");
                    if (!WWUtil.isEmpty((Object)string)) {
                        new WorkerThread(string.trim(), appFrame).start();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jMenu.add(jMenuItem2);
    }

    public static void main(String[] stringArray) {
        AppFrame appFrame = (AppFrame)KMLViewer.start("World Wind KML Viewer", AppFrame.class);
    }

    public static class WorkerThread
    extends Thread {
        protected Object kmlSource;
        protected AppFrame appFrame;

        public WorkerThread(Object object, AppFrame appFrame) {
            this.kmlSource = object;
            this.appFrame = appFrame;
        }

        @Override
        public void run() {
            try {
                KMLRoot kMLRoot = this.parse();
                kMLRoot.setField("gov.nasa.worldwind.avkey.DisplayName", (Object)KMLViewer.formName(this.kmlSource, kMLRoot));
                final KMLRoot kMLRoot2 = kMLRoot;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WorkerThread.this.appFrame.addKMLLayer(kMLRoot2);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        protected KMLRoot parse() throws IOException, XMLStreamException {
            return KMLRoot.createAndParse((Object)this.kmlSource);
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected LayerTree layerTree = new LayerTree(new Offset(Double.valueOf(20.0), Double.valueOf(160.0), "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.InsetPixels"));
        protected RenderableLayer hiddenLayer;
        protected HotSpotController hotSpotController;
        protected KMLApplicationController kmlAppController;
        protected BalloonController balloonController;

        public AppFrame() {
            super(true, false, false);
            this.layerTree.getModel().refresh(this.getWwd().getModel().getLayers());
            this.hiddenLayer = new RenderableLayer();
            this.hiddenLayer.addRenderable((Renderable)this.layerTree);
            this.getWwd().getModel().getLayers().add((Layer)this.hiddenLayer);
            this.hotSpotController = new HotSpotController(this.getWwd());
            this.kmlAppController = new KMLApplicationController(this.getWwd());
            this.balloonController = new BalloonController(this.getWwd()){

                @Override
                protected void addDocumentLayer(KMLRoot kMLRoot) {
                    AppFrame.this.addKMLLayer(kMLRoot);
                }
            };
            this.kmlAppController.setBalloonController(this.balloonController);
            Dimension dimension = new Dimension(1400, 800);
            this.setPreferredSize(dimension);
            this.pack();
            WWUtil.alignComponent(null, (Component)this, (String)"gov.nasa.worldwind.avkey.Center");
            KMLViewer.makeMenu(this);
            WorldWind.getRetrievalService().setSSLExceptionListener(new RetrievalService.SSLExceptionListener(){

                public void onException(Throwable throwable, String string) {
                    System.out.println(string);
                    System.out.println(throwable);
                }
            });
        }

        protected void addKMLLayer(KMLRoot kMLRoot) {
            KMLController kMLController = new KMLController(kMLRoot);
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName((String)kMLRoot.getField("gov.nasa.worldwind.avkey.DisplayName"));
            renderableLayer.addRenderable((Renderable)kMLController);
            this.getWwd().getModel().getLayers().add((Layer)renderableLayer);
            KMLLayerTreeNode kMLLayerTreeNode = new KMLLayerTreeNode((Layer)renderableLayer, kMLRoot);
            this.layerTree.getModel().addLayer((LayerTreeNode)kMLLayerTreeNode);
            this.layerTree.makeVisible(kMLLayerTreeNode.getPath());
            kMLLayerTreeNode.expandOpenContainers((Tree)this.layerTree);
            kMLLayerTreeNode.addPropertyChangeListener("gov.nasa.worldwind.avkey.RetrievalStateSuccessful", new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getSource() instanceof KMLNetworkLinkTreeNode) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((KMLNetworkLinkTreeNode)propertyChangeEvent.getSource()).expandOpenContainers((Tree)AppFrame.this.layerTree);
                                AppFrame.this.getWwd().redraw();
                            }
                        });
                    }
                }
            });
        }
    }
}

