/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.kml;

import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.util.Logging;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class KMZDocumentBuilder {
    protected ZipOutputStream zipStream;
    protected XMLStreamWriter writer;

    public KMZDocumentBuilder(OutputStream outputStream) throws XMLStreamException, IOException {
        if (outputStream == null) {
            String string = Logging.getMessage((String)"nullValue.OutputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.zipStream = new ZipOutputStream(outputStream);
        this.startDocument();
    }

    protected String getMainFileName() {
        return "doc.kml";
    }

    protected void startDocument() throws XMLStreamException, IOException {
        this.zipStream.putNextEntry(new ZipEntry(this.getMainFileName()));
        this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(this.zipStream);
        this.writer.writeStartDocument();
        this.writer.writeStartElement("kml");
        this.writer.writeDefaultNamespace("http://www.opengis.net/kml/2.2");
        this.writer.setPrefix("gx", "http://www.google.com/kml/ext/2.2");
        this.writer.writeNamespace("gx", "http://www.google.com/kml/ext/2.2");
        this.writer.writeStartElement("Document");
    }

    protected void endDocument() throws XMLStreamException, IOException {
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.close();
        this.zipStream.closeEntry();
        this.zipStream.finish();
    }

    public void close() throws XMLStreamException, IOException {
        this.endDocument();
    }

    public void writeObject(Exportable exportable) throws IOException {
        String string = exportable.isExportFormatSupported("application/vnd.google-earth.kml+xml");
        if ("Export.FormatSupported".equals(string) || "Export.FormatPartiallySupported".equals(string)) {
            exportable.export("application/vnd.google-earth.kml+xml", (Object)this.writer);
        }
    }

    public void writeObjects(Exportable ... exportableArray) throws IOException {
        for (Exportable exportable : exportableArray) {
            exportable.export("application/vnd.google-earth.kml+xml", (Object)this.writer);
        }
    }
}

