/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.layermanager;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.layermanager.LayerAndElevationManagerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class LayerManagerApp {
    public static AppFrame start(String string, Class clazz) {
        if (Configuration.isMacOS() && string != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string);
        }
        try {
            final AppFrame appFrame = (AppFrame)clazz.newInstance();
            appFrame.setTitle(string);
            appFrame.setDefaultCloseOperation(3);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    appFrame.setVisible(true);
                }
            });
            return appFrame;
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "Exception at application start", exception);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        LayerManagerApp.start("Layer Manager", AppFrame.class);
    }

    static {
        System.setProperty("java.net.useSystemProxies", "true");
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Application");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        } else if (Configuration.isWindowsOS()) {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
    }

    public static class AppFrame
    extends JFrame {
        protected AppPanel wwjPanel;

        public AppFrame() {
            this.initialize();
            WWUtil.alignComponent(null, (Component)this, (String)"gov.nasa.worldwind.avkey.Center");
        }

        protected void initialize() {
            this.wwjPanel = new AppPanel();
            this.getContentPane().add((Component)this.wwjPanel, "Center");
            LayerAndElevationManagerPanel layerAndElevationManagerPanel = new LayerAndElevationManagerPanel(this.getWwd());
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            jPanel.add((Component)layerAndElevationManagerPanel, "Center");
            this.getContentPane().add((Component)jPanel, "West");
            this.pack();
            WWUtil.alignComponent(null, (Component)this, (String)"gov.nasa.worldwind.avkey.Center");
            this.setResizable(true);
        }

        public WorldWindow getWwd() {
            return this.wwjPanel.wwd;
        }
    }

    public static class AppPanel
    extends JPanel {
        protected WorldWindow wwd = new WorldWindowGLCanvas();
        protected StatusBar statusBar;

        public AppPanel() {
            super(new BorderLayout());
            ((Component)this.wwd).setPreferredSize(new Dimension(1000, 600));
            Model model = (Model)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ModelClassName");
            this.wwd.setModel(model);
            this.add((Component)this.wwd, "Center");
            this.statusBar = new StatusBar();
            this.add((Component)this.statusBar, "Last");
            this.statusBar.setEventSource(this.wwd);
        }
    }
}

