/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.lineofsight;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.terrain.HighResolutionTerrain;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.VecBuffer;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.LayerPanel;
import gov.nasa.worldwindx.examples.lineofsight.ShapeLineIntersector;
import gov.nasa.worldwindx.examples.lineofsight.TerrainLineIntersector;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

public class LinesOfSight
extends ApplicationTemplate {
    protected static final Angle GRID_RADIUS = Angle.fromDegrees((double)0.005);
    protected static final int GRID_DIMENSION = 10;
    protected static final int REFERENCE_POSITION_HEIGHT = 5;
    protected static final int GRID_POSITION_HEIGHT = 1;
    protected static final Double TARGET_RESOLUTION = 20.0;
    protected static final int NUM_TERRAIN_THREADS = 1;
    protected static final int NUM_SHAPE_THREADS = 1;
    protected static final long CACHE_SIZE = 150000000L;
    protected static final boolean SHOW_ONLY_FIRST_INTERSECTIONS = true;

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Terrain Intersections", AppFrame.class);
    }

    public static class ShapeLoaderThread
    extends Thread {
        protected File file;
        protected WorldWindow wwd;
        protected LayerPanel layerPanel;
        protected RenderableLayer layer;
        protected ShapeAttributes buildingAttributes;

        public ShapeLoaderThread(File file, WorldWindow worldWindow, RenderableLayer renderableLayer, LayerPanel layerPanel) {
            this.file = file;
            this.wwd = worldWindow;
            this.layer = renderableLayer;
            this.layerPanel = layerPanel;
            this.buildingAttributes = new BasicShapeAttributes();
            this.buildingAttributes.setDrawOutline(true);
            this.buildingAttributes.setDrawInterior(true);
            this.buildingAttributes.setInteriorMaterial(Material.LIGHT_GRAY);
            this.buildingAttributes.setInteriorOpacity(0.4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Shapefile shapefile = new Shapefile((Object)this.file);
            try {
                while (shapefile.hasNext()) {
                    ShapefileRecord shapefileRecord = shapefile.nextRecord();
                    if (shapefileRecord == null || shapefileRecord.getNumberOfPoints() < 4) continue;
                    this.layer.addRenderable((Renderable)this.makeShape(shapefileRecord));
                }
            }
            finally {
                shapefile.close();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationTemplate.insertBeforePlacenames(ShapeLoaderThread.this.wwd, (Layer)ShapeLoaderThread.this.layer);
                    ShapeLoaderThread.this.layerPanel.update(ShapeLoaderThread.this.wwd);
                }
            });
        }

        protected ExtrudedPolygon makeShape(ShapefileRecord shapefileRecord) {
            Double d = null;
            Object object = shapefileRecord.getAttributes().getValue("Height");
            if (object != null) {
                d = Double.parseDouble(object.toString());
            }
            ExtrudedPolygon extrudedPolygon = new ExtrudedPolygon();
            extrudedPolygon.setSideAttributes(this.buildingAttributes);
            extrudedPolygon.setCapAttributes(this.buildingAttributes);
            VecBuffer vecBuffer = shapefileRecord.getPointBuffer(0);
            extrudedPolygon.setOuterBoundary(vecBuffer.getLocations(), d);
            return extrudedPolygon;
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private static final Cursor WaitCursor = new Cursor(3);
        protected HighResolutionTerrain terrain;
        protected TerrainLineIntersector terrainIntersector;
        protected ShapeLineIntersector shapeIntersector;
        protected RenderableLayer gridLayer;
        protected RenderableLayer intersectionsLayer;
        protected RenderableLayer sightLinesLayer;
        protected RenderableLayer tilesLayer;
        protected Thread calculationDispatchThread;
        protected JProgressBar progressBar;
        protected List<Position> grid;
        protected Position referencePosition;
        protected Vec4 referencePoint;
        protected long startTime;
        protected long endTime;
        protected Position previousCurrentPosition;
        protected Timer updateProgressTimer;
        protected AtomicInteger numPositionsProcessed = new AtomicInteger();
        protected RenderableLayer renderableLayer = new RenderableLayer();
        protected ShapeAttributes sightLineAttributes;
        protected PointPlacemarkAttributes intersectionPointAttributes;
        protected PointPlacemarkAttributes gridPointAttributes;
        protected PointPlacemarkAttributes selectedLocationAttributes;

        public AppFrame() {
            super(true, true, false);
            this.makeMenu();
            this.updateProgressTimer = new Timer();
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setBorder(new EmptyBorder(0, 10, 0, 10));
            this.progressBar.setBorderPainted(false);
            this.progressBar.setStringPainted(true);
            this.layerPanel.add((Component)this.progressBar, "South");
            this.gridLayer = new RenderableLayer();
            this.gridLayer.setName("Grid");
            this.getWwd().getModel().getLayers().add((Layer)this.gridLayer);
            this.intersectionsLayer = new RenderableLayer();
            this.intersectionsLayer.setName("Intersections");
            this.getWwd().getModel().getLayers().add((Layer)this.intersectionsLayer);
            this.sightLinesLayer = new RenderableLayer();
            this.sightLinesLayer.setName("Sight Lines");
            this.getWwd().getModel().getLayers().add((Layer)this.sightLinesLayer);
            this.getLayerPanel().update(this.getWwd());
            this.terrain = new HighResolutionTerrain(this.getWwd().getModel().getGlobe(), TARGET_RESOLUTION);
            this.terrain.setCacheCapacity(150000000L);
            this.terrainIntersector = new TerrainLineIntersector((Terrain)this.terrain, 1);
            this.shapeIntersector = new ShapeLineIntersector((Terrain)this.terrain, 1);
            this.getWwd().getInputHandler().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 2) != 0) {
                        if (AppFrame.this.calculationDispatchThread != null && AppFrame.this.calculationDispatchThread.isAlive()) {
                            AppFrame.this.calculationDispatchThread.interrupt();
                        }
                        return;
                    }
                    if ((mouseEvent.getModifiers() & 8) != 0) {
                        if (AppFrame.this.previousCurrentPosition == null) {
                            return;
                        }
                        mouseEvent.consume();
                        AppFrame.this.computeAndShow(AppFrame.this.previousCurrentPosition);
                        return;
                    }
                    if ((mouseEvent.getModifiers() & 1) == 0) {
                        return;
                    }
                    mouseEvent.consume();
                    Position position = AppFrame.this.getWwd().getCurrentPosition();
                    if (position == null) {
                        return;
                    }
                    AppFrame.this.computeAndShow(position);
                }
            });
            this.gridPointAttributes = new PointPlacemarkAttributes();
            this.gridPointAttributes.setLineMaterial(Material.YELLOW);
            this.gridPointAttributes.setScale(Double.valueOf(6.0));
            this.gridPointAttributes.setUsePointAsDefaultImage(true);
            this.selectedLocationAttributes = new PointPlacemarkAttributes();
            this.selectedLocationAttributes.setLineMaterial(Material.RED);
            this.selectedLocationAttributes.setScale(Double.valueOf(8.0));
            this.selectedLocationAttributes.setUsePointAsDefaultImage(true);
            this.sightLineAttributes = new BasicShapeAttributes();
            this.sightLineAttributes.setDrawOutline(true);
            this.sightLineAttributes.setDrawInterior(false);
            this.sightLineAttributes.setOutlineMaterial(Material.GREEN);
            this.sightLineAttributes.setOutlineOpacity(0.6);
            this.intersectionPointAttributes = new PointPlacemarkAttributes();
            this.intersectionPointAttributes.setLineMaterial(Material.CYAN);
            this.intersectionPointAttributes.setScale(Double.valueOf(10.0));
            this.intersectionPointAttributes.setUsePointAsDefaultImage(true);
        }

        protected void computeAndShow(final Position position) {
            this.previousCurrentPosition = position;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AppFrame.this.setCursor(WaitCursor);
                }
            });
            this.calculationDispatchThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AppFrame.this.performIntersectionTests(position);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("Operation was interrupted");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            this.calculationDispatchThread.start();
        }

        protected void performIntersectionTests(Position position) throws InterruptedException {
            this.referencePosition = new Position(position.getLatitude(), position.getLongitude(), 5.0);
            this.referencePoint = this.terrain.getSurfacePoint(this.referencePosition);
            Sector sector = this.computeGridSector(position, LinesOfSight.GRID_RADIUS.degrees);
            this.grid = this.buildGrid(sector, 1.0, 10, 10);
            this.terrainIntersector.setReferencePosition(this.referencePosition);
            this.terrainIntersector.setPositions(this.grid);
            if (this.renderableLayer.getNumRenderables() > 0) {
                this.shapeIntersector.setReferencePosition(this.referencePosition);
                this.shapeIntersector.setPositions(this.grid);
                this.shapeIntersector.setRenderables(this.renderableLayer.getRenderables());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AppFrame.this.progressBar.setValue(0);
                    AppFrame.this.progressBar.setString(null);
                    AppFrame.this.clearLayers();
                    AppFrame.this.showGrid(AppFrame.this.grid, AppFrame.this.referencePosition);
                    AppFrame.this.getWwd().redraw();
                }
            });
            if (this.updateProgressTimer != null) {
                this.updateProgressTimer.cancel();
            }
            this.updateProgressTimer = new Timer();
            this.updateProgressTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    AppFrame.this.updateProgress();
                }
            }, 500L, 250L);
            this.startTime = System.currentTimeMillis();
            this.computeIntersections();
        }

        protected void clearLayers() {
            this.intersectionsLayer.removeAllRenderables();
            this.sightLinesLayer.removeAllRenderables();
            this.gridLayer.removeAllRenderables();
        }

        protected void computeIntersections() {
            Thread thread = new Thread(this.terrainIntersector);
            thread.start();
            if (this.shapeIntersector.hasRenderables()) {
                Thread thread2 = new Thread(this.shapeIntersector);
                thread2.start();
            }
        }

        protected Sector computeGridSector(Position position, double d) {
            return Sector.fromDegrees((double)(position.getLatitude().degrees - d), (double)(position.getLatitude().degrees + d), (double)(position.getLongitude().degrees - d), (double)(position.getLongitude().degrees + d));
        }

        protected List<Position> buildGrid(Sector sector, double d, int n, int n2) {
            ArrayList<Position> arrayList = new ArrayList<Position>(n * n2);
            double d2 = sector.getDeltaLatDegrees() / (double)(n2 - 1);
            double d3 = sector.getDeltaLonDegrees() / (double)(n - 1);
            for (int i = 0; i < n; ++i) {
                double d4 = i == n - 1 ? sector.getMaxLatitude().degrees : sector.getMinLatitude().degrees + (double)i * d2;
                for (int j = 0; j < n2; ++j) {
                    double d5 = j == n2 - 1 ? sector.getMaxLongitude().degrees : sector.getMinLongitude().degrees + (double)j * d3;
                    arrayList.add(Position.fromDegrees((double)d4, (double)d5, (double)d));
                }
            }
            return arrayList;
        }

        protected synchronized void updateProgress() {
            int n = this.grid.size();
            int n2 = this.terrainIntersector.getNumProcessedPositions();
            if (this.renderableLayer.getNumRenderables() > 0) {
                n += this.grid.size();
                n2 += this.shapeIntersector.getNumProcessedPositions();
            }
            final int n3 = (int)(100.0 * (double)n2 / (double)n);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AppFrame.this.progressBar.setValue(n3);
                    if (n3 >= 100) {
                        AppFrame.this.endTime = System.currentTimeMillis();
                        AppFrame.this.updateProgressTimer.cancel();
                        AppFrame.this.updateProgressTimer = null;
                        AppFrame.this.setCursor(Cursor.getDefaultCursor());
                        AppFrame.this.progressBar.setString(AppFrame.this.endTime - AppFrame.this.startTime + " ms");
                        AppFrame.this.showResults();
                        System.out.printf("Calculation time %d milliseconds\n", AppFrame.this.endTime - AppFrame.this.startTime);
                    }
                }
            });
        }

        protected void showResults() {
            this.intersectionsLayer.removeAllRenderables();
            this.sightLinesLayer.removeAllRenderables();
            for (Position position : this.grid) {
                this.showIntersectionsForPosition(position);
            }
            this.getWwd().redraw();
        }

        protected void showIntersectionsForPosition(Position position) {
            List<Intersection> list = this.terrainIntersector.getIntersections(position);
            List<Intersection> list2 = this.shapeIntersector.getIntersections(position);
            if (list == null && list2 == null) {
                this.showNonIntersection(position);
                return;
            }
            Queue queue = Intersection.sort((Vec4)this.referencePoint, list, list2);
            if (queue.size() == 0) {
                this.showSightLine(position);
            } else {
                this.showSightLine(((Intersection)queue.peek()).getIntersectionPosition());
                this.showIntersection((Intersection)queue.peek());
            }
        }

        protected void showSightLine(Position position) {
            Position position2 = this.referencePosition;
            Path path = new Path(position2, position);
            path.setAltitudeMode(2);
            path.setAttributes(this.sightLineAttributes);
            this.sightLinesLayer.addRenderable((Renderable)path);
        }

        protected void showIntersection(Intersection intersection) {
            PointPlacemark pointPlacemark = new PointPlacemark(intersection.getIntersectionPosition());
            pointPlacemark.setAltitudeMode(2);
            pointPlacemark.setAttributes(this.intersectionPointAttributes);
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)intersection.getIntersectionPosition().toString());
            this.intersectionsLayer.addRenderable((Renderable)pointPlacemark);
        }

        protected void showIntersections(Queue<Intersection> queue) {
            for (Intersection intersection : queue) {
                PointPlacemark pointPlacemark = new PointPlacemark(intersection.getIntersectionPosition());
                pointPlacemark.setAltitudeMode(2);
                pointPlacemark.setAttributes(this.intersectionPointAttributes);
                pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)intersection.getIntersectionPosition().toString());
                this.intersectionsLayer.addRenderable((Renderable)pointPlacemark);
            }
        }

        protected void showNonIntersection(Position position) {
            Path path = new Path(this.referencePosition, position);
            path.setAltitudeMode(2);
            path.setAttributes(this.sightLineAttributes);
            this.sightLinesLayer.addRenderable((Renderable)path);
        }

        protected void showNonIntersections(Collection<Position> collection) {
            for (Position position : collection) {
                Path path = new Path(this.referencePosition, position);
                path.setAltitudeMode(2);
                path.setAttributes(this.sightLineAttributes);
                this.sightLinesLayer.addRenderable((Renderable)path);
            }
        }

        protected void showGrid(List<Position> list, Position position) {
            this.gridLayer.removeAllRenderables();
            PointPlacemarkAttributes pointPlacemarkAttributes = new PointPlacemarkAttributes();
            pointPlacemarkAttributes.setLineMaterial(Material.YELLOW);
            pointPlacemarkAttributes.setScale(Double.valueOf(6.0));
            pointPlacemarkAttributes.setUsePointAsDefaultImage(true);
            for (Position position2 : list) {
                PointPlacemark pointPlacemark = new PointPlacemark(position2);
                pointPlacemark.setAltitudeMode(2);
                pointPlacemark.setAttributes(this.gridPointAttributes);
                pointPlacemark.setLineEnabled(true);
                pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)position2.toString());
                this.gridLayer.addRenderable((Renderable)pointPlacemark);
            }
            this.showCenterPoint(position);
        }

        protected void showCenterPoint(Position position) {
            PointPlacemarkAttributes pointPlacemarkAttributes = new PointPlacemarkAttributes();
            pointPlacemarkAttributes.setLineMaterial(Material.RED);
            pointPlacemarkAttributes.setScale(Double.valueOf(8.0));
            pointPlacemarkAttributes.setUsePointAsDefaultImage(true);
            PointPlacemark pointPlacemark = new PointPlacemark(position);
            pointPlacemark.setAltitudeMode(2);
            pointPlacemark.setAttributes(this.selectedLocationAttributes);
            pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)position.toString());
            pointPlacemark.setLineEnabled(true);
            this.gridLayer.addRenderable((Renderable)pointPlacemark);
        }

        protected void makeMenu() {
            final JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("ESRI Shapefiles", "shp"));
            JMenuBar jMenuBar = new JMenuBar();
            this.setJMenuBar(jMenuBar);
            JMenu jMenu = new JMenu("File");
            jMenuBar.add(jMenu);
            JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Open File..."){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        int n = jFileChooser.showOpenDialog(AppFrame.this);
                        if (n == 0) {
                            ShapeLoaderThread shapeLoaderThread = new ShapeLoaderThread(jFileChooser.getSelectedFile(), AppFrame.this.getWwd(), AppFrame.this.renderableLayer, AppFrame.this.layerPanel);
                            shapeLoaderThread.start();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            jMenu.add(jMenuItem);
        }
    }
}

