/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.lineofsight;

import com.jogamp.common.nio.Buffers;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Highlightable;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.awt.Point;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.GL2;

public class PointGrid
extends WWObjectImpl
implements OrderedRenderable,
Highlightable {
    protected static final Double DEFAULT_HIGHLIGHT_SCALE = 1.3;
    protected static final Double DEFAULT_POINT_SIZE = 10.0;
    protected static final Color DEFAULT_POINT_COLOR = Color.YELLOW;
    protected static final Color DEFAULT_HIGHLIGHT_POINT_COLOR = Color.WHITE;
    protected static final long DEFAULT_GEOMETRY_GENERATION_INTERVAL = 5000L;
    protected static final Attributes defaultAttributes = new Attributes(DEFAULT_POINT_SIZE, DEFAULT_POINT_COLOR);
    protected List<Position> corners;
    protected Iterable<? extends Position> positions;
    protected int numPositions;
    protected boolean highlighted;
    protected boolean highlightOnePosition = true;
    protected boolean visible = true;
    protected int altitudeMode = 1;
    protected boolean applyVerticalExaggeration = true;
    protected long geometryRegenerationInterval = 5000L;
    protected Attributes normalAttrs;
    protected Attributes highlightAttrs;
    protected Attributes activeAttributes = new Attributes();
    protected Extent extent;
    protected double eyeDistance;
    protected FloatBuffer currentPoints;
    protected PickSupport pickSupport = new PickSupport();
    protected Layer pickLayer;
    protected long frameID;
    protected double previousExaggeration = -1.0;
    protected long visGeomRegenFrame = -1L;

    public PointGrid() {
    }

    public PointGrid(List<Position> list, Iterable<? extends Position> iterable, Integer n) {
        this.corners = list;
        this.setPositions(iterable, n);
    }

    public List<Position> getCorners() {
        return this.corners;
    }

    public void setCorners(List<Position> list) {
        this.corners = list;
    }

    public int getNumPositions() {
        return this.numPositions;
    }

    public Iterable<? extends Position> getPositions() {
        return this.positions;
    }

    public void setPositions(Iterable<? extends Position> iterable, Integer n) {
        if (n == null) {
            this.numPositions = 0;
            Iterator<? extends Position> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                ++this.numPositions;
            }
        } else {
            this.numPositions = n;
        }
        this.positions = iterable;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public boolean isHighlightOnePosition() {
        return this.highlightOnePosition;
    }

    public void setHighlightOnePosition(boolean bl) {
        this.highlightOnePosition = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(int n) {
        this.altitudeMode = n;
    }

    public boolean isApplyVerticalExaggeration() {
        return this.applyVerticalExaggeration;
    }

    public void setApplyVerticalExaggeration(boolean bl) {
        this.applyVerticalExaggeration = bl;
    }

    public long getGeometryRegenerationInterval() {
        return this.geometryRegenerationInterval;
    }

    public Attributes getAttributes() {
        return this.normalAttrs;
    }

    public void setAttributes(Attributes attributes) {
        this.normalAttrs = attributes;
    }

    public Attributes getHighlightAttributes() {
        return this.highlightAttrs;
    }

    public void setHighlightAttributes(Attributes attributes) {
        this.highlightAttrs = attributes;
    }

    public Attributes getActiveAttributes() {
        return this.activeAttributes;
    }

    protected boolean mustRegenerateGeometry(DrawContext drawContext) {
        if (this.currentPoints == null || drawContext.getVerticalExaggeration() != this.previousExaggeration) {
            return true;
        }
        return this.getAltitudeMode() != 0 && this.frameID - this.visGeomRegenFrame > this.getGeometryRegenerationInterval();
    }

    protected void determineActiveAttributes() {
        Attributes attributes = this.getActiveAttributes();
        if (this.isHighlighted() && !this.isHighlightOnePosition()) {
            if (this.getHighlightAttributes() != null) {
                attributes.copy(this.getHighlightAttributes());
            } else if (this.getAttributes() != null) {
                attributes.copy(this.getAttributes());
                if (this.getAttributes().getPointSize() != null) {
                    attributes.setPointSize(DEFAULT_HIGHLIGHT_SCALE * this.getAttributes().getPointSize());
                }
            } else {
                attributes.copy(defaultAttributes);
                if (defaultAttributes.getPointSize() != null) {
                    attributes.setPointSize(DEFAULT_HIGHLIGHT_SCALE * defaultAttributes.getPointSize());
                }
            }
            if (attributes.getPointSize() == null) {
                attributes.setPointSize(defaultAttributes.getPointSize() * DEFAULT_HIGHLIGHT_SCALE);
            }
            if (attributes.getPointColor() == null) {
                attributes.setPointColor(DEFAULT_HIGHLIGHT_POINT_COLOR);
            }
        } else if (this.getAttributes() != null) {
            attributes.copy(this.getAttributes());
        } else {
            attributes.copy(defaultAttributes);
        }
    }

    protected Color determineHighlightColor() {
        Color color = null;
        if (this.getHighlightAttributes() != null) {
            color = this.getHighlightAttributes().getPointColor();
        } else if (this.getAttributes() != null) {
            color = this.getAttributes().getPointColor();
        }
        return color != null ? color : DEFAULT_HIGHLIGHT_POINT_COLOR;
    }

    protected Double determineHighlightPointSize() {
        Double d = null;
        if (this.getHighlightAttributes() != null) {
            d = this.getHighlightAttributes().getPointSize();
        } else if (this.getAttributes() != null && (d = this.getAttributes().getPointSize()) != null) {
            d = d * DEFAULT_HIGHLIGHT_SCALE;
        }
        return d != null ? d : DEFAULT_HIGHLIGHT_SCALE * DEFAULT_POINT_SIZE;
    }

    public double getDistanceFromEye() {
        return this.eyeDistance;
    }

    public Extent getExtent() {
        return this.extent;
    }

    protected void setExtent(Extent extent) {
        this.extent = extent;
    }

    protected Extent computeExtentAndEyeDistance(DrawContext drawContext) {
        if (WWUtil.isEmpty(this.corners)) {
            return null;
        }
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>(this.getCorners().size());
        this.eyeDistance = Double.MAX_VALUE;
        for (Position position : this.corners) {
            Vec4 vec4;
            if (position == null || (vec4 = this.computePoint(drawContext, position)) == null) continue;
            arrayList.add(vec4);
            double d = vec4.distanceTo3(drawContext.getView().getEyePoint());
            if (!(d < this.eyeDistance)) continue;
            this.eyeDistance = d;
        }
        return Box.computeBoundingBox(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pick(DrawContext drawContext, Point point) {
        this.pickSupport.clearPickList();
        try {
            this.pickSupport.beginPicking(drawContext);
            this.render(drawContext);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, point, this.pickLayer);
        }
    }

    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage((String)"nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getSurfaceGeometry() == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (drawContext.isOrderedRenderingMode()) {
            this.drawOrderedRenderable(drawContext);
        } else {
            this.makeOrderedRenderable(drawContext);
        }
        this.frameID = drawContext.getFrameTimeStamp();
    }

    protected void makeOrderedRenderable(DrawContext drawContext) {
        if (this.mustRegenerateGeometry(drawContext)) {
            this.extent = this.computeExtentAndEyeDistance(drawContext);
            if (!this.intersectsFrustum(drawContext)) {
                return;
            }
            this.currentPoints = this.computeGridPoints(drawContext, this.currentPoints);
            if (this.currentPoints == null || this.currentPoints.limit() == 0) {
                return;
            }
            this.determineActiveAttributes();
            this.visGeomRegenFrame = drawContext.getFrameTimeStamp();
            this.previousExaggeration = drawContext.getVerticalExaggeration();
        }
        if (this.intersectsFrustum(drawContext)) {
            if (drawContext.isPickingMode()) {
                this.pickLayer = drawContext.getCurrentLayer();
            }
            drawContext.addOrderedRenderable((OrderedRenderable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawOrderedRenderable(DrawContext drawContext) {
        if (this.currentPoints == null) {
            return;
        }
        this.beginDrawing(drawContext);
        try {
            this.doDrawOrderedRenderable(drawContext);
        }
        finally {
            this.endDrawing(drawContext);
        }
    }

    protected void beginDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        int n = 24579;
        if (drawContext.isPickingMode()) {
            n |= 0x1900;
        }
        gL2.glPushAttrib(n);
        if (!drawContext.isPickingMode()) {
            gL2.glEnable(3042);
            OGLUtil.applyBlending((GL2)gL2, (boolean)false);
        }
    }

    protected void endDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glPopAttrib();
    }

    protected void doDrawOrderedRenderable(DrawContext drawContext) {
        if (drawContext.isPickingMode()) {
            this.pickPoints(drawContext);
        } else {
            this.drawPoints(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pickPoints(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            this.setPointSize(drawContext, null);
            oGLStackHandler.pushProjectionIdentity(gL2);
            gL2.glOrtho(0.0, (double)drawContext.getView().getViewport().width, 0.0, (double)drawContext.getView().getViewport().height, -1.0, 1.0);
            oGLStackHandler.pushModelviewIdentity(gL2);
            if (!drawContext.isDeepPickingEnabled()) {
                gL2.glEnable(2929);
            }
            gL2.glDepthMask(false);
            gL2.glDepthFunc(513);
            Iterator<? extends Position> iterator = this.positions.iterator();
            FloatBuffer floatBuffer = this.currentPoints;
            floatBuffer.rewind();
            gL2.glBegin(0);
            try {
                while (floatBuffer.hasRemaining()) {
                    Position position = iterator.next();
                    Vec4 vec4 = new Vec4((double)floatBuffer.get(), (double)floatBuffer.get(), (double)floatBuffer.get());
                    if (!drawContext.getView().getFrustumInModelCoordinates().contains(vec4)) continue;
                    Vec4 vec42 = drawContext.getView().project(vec4);
                    if (!drawContext.getPickFrustums().containsInAny(vec42.x, vec42.y)) continue;
                    double d = vec42.z - 0.00391006472;
                    d = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
                    gL2.glDepthRange(d, d);
                    Color color = drawContext.getUniquePickColor();
                    this.pickSupport.addPickableObject(color.getRGB(), (Object)this, position);
                    gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                    gL2.glVertex3d(vec42.x, vec42.y, 0.0);
                }
            }
            finally {
                gL2.glEnd();
            }
            gL2.glDepthRange(0.0, 1.0);
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    protected void drawPoints(DrawContext drawContext) {
        Vec4 vec4;
        Position position;
        GL2 gL2 = drawContext.getGL().getGL2();
        this.setPointColor(drawContext, null);
        this.setPointSize(drawContext, null);
        gL2.glPushClientAttrib(2);
        gL2.glEnableClientState(32884);
        drawContext.pushProjectionOffest(Double.valueOf(0.99));
        gL2.glVertexPointer(3, 5126, 0, this.currentPoints.rewind());
        gL2.glDrawArrays(0, 0, this.currentPoints.limit() / 3);
        drawContext.popProjectionOffest();
        gL2.glPopClientAttrib();
        if (drawContext.getPickedObjects().getTopObject() == this && (position = drawContext.getPickedObjects().getTopPickedObject().getPosition()) != null && (vec4 = this.computePoint(drawContext, position)) != null) {
            this.setPointColor(drawContext, this.determineHighlightColor());
            this.setPointSize(drawContext, this.determineHighlightPointSize());
            drawContext.pushProjectionOffest(Double.valueOf(0.98));
            gL2.glBegin(0);
            gL2.glVertex3d(vec4.x, vec4.y, vec4.z);
            gL2.glEnd();
            drawContext.popProjectionOffest();
        }
    }

    protected void setPointColor(DrawContext drawContext, Color color) {
        if (color == null) {
            color = this.getActiveAttributes().getPointColor();
        }
        if (color == null) {
            color = DEFAULT_POINT_COLOR;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)color.getAlpha());
    }

    protected void setPointSize(DrawContext drawContext, Double d) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (d == null) {
            d = this.getActiveAttributes().getPointSize();
        }
        if (d == null) {
            d = DEFAULT_POINT_SIZE;
        }
        double d2 = drawContext.getView().getEyePosition().getAltitude();
        if (drawContext.isPickingMode()) {
            d = d * 2.0;
        } else if (d2 > 100000.0) {
            d = d2 < 200000.0 ? Double.valueOf(Math.max(0.8 * d, 1.0)) : (d2 < 400000.0 ? Double.valueOf(Math.max(0.6 * d, 1.0)) : (d2 < 700000.0 ? Double.valueOf(Math.max(0.4 * d, 1.0)) : (d2 < 1000000.0 ? Double.valueOf(Math.max(0.2 * d, 1.0)) : Double.valueOf(Math.max(0.1 * d, 1.0)))));
        }
        gL2.glPointSize(d.floatValue());
        if (!drawContext.isPickingMode() && this.getActiveAttributes().isEnablePointSmoothing()) {
            gL2.glEnable(2832);
            gL2.glHint(3153, 4354);
        }
    }

    protected boolean intersectsFrustum(DrawContext drawContext) {
        if (this.getExtent() == null) {
            this.setExtent(this.computeExtentAndEyeDistance(drawContext));
            if (this.getExtent() == null) {
                return false;
            }
        }
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(this.getExtent());
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersects(this.getExtent());
    }

    protected FloatBuffer computeGridPoints(DrawContext drawContext, FloatBuffer floatBuffer) {
        int n = 3 * this.numPositions;
        if (floatBuffer == null || floatBuffer.capacity() < n || (double)floatBuffer.capacity() > 1.5 * (double)n) {
            floatBuffer = Buffers.newDirectFloatBuffer((int)n);
        }
        floatBuffer.rewind();
        Iterator<? extends Position> iterator = this.positions.iterator();
        while (iterator.hasNext()) {
            Vec4 vec4 = this.computePoint(drawContext, iterator.next());
            if (vec4 == null) continue;
            floatBuffer.put((float)vec4.x).put((float)vec4.y).put((float)vec4.z);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    protected Vec4 computePoint(DrawContext drawContext, Position position) {
        if (this.getAltitudeMode() == 1) {
            return drawContext.getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude(), 0.0);
        }
        if (this.getAltitudeMode() == 2) {
            return drawContext.getTerrain().getSurfacePoint(position);
        }
        if (this.applyVerticalExaggeration) {
            position = new Position((LatLon)position, drawContext.getVerticalExaggeration() * position.getAltitude());
        }
        return drawContext.getGlobe().computePointFromPosition(position);
    }

    protected static class Attributes {
        protected Double pointSize;
        protected Color pointColor;
        protected boolean enablePointSmoothing = true;

        public Attributes() {
        }

        public Attributes(Double d, Color color) {
            this.pointSize = d;
            this.pointColor = color;
        }

        public void copy(Attributes attributes) {
            if (attributes != null) {
                this.setPointSize(attributes.getPointSize());
                this.setPointColor(attributes.getPointColor());
            }
        }

        public Double getPointSize() {
            return this.pointSize;
        }

        public void setPointSize(Double d) {
            this.pointSize = d;
        }

        public Color getPointColor() {
            return this.pointColor;
        }

        public void setPointColor(Color color) {
            this.pointColor = color;
        }

        public boolean isEnablePointSmoothing() {
            return this.enablePointSmoothing;
        }

        public void setEnablePointSmoothing(Boolean bl) {
            this.enablePointSmoothing = bl;
        }
    }
}

