/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.lineofsight;

import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwindx.examples.lineofsight.LineIntersector;
import java.util.ArrayList;
import java.util.List;

public class ShapeLineIntersector
extends LineIntersector {
    protected Iterable<Renderable> renderables;

    public ShapeLineIntersector(Terrain terrain, int n) {
        super(terrain, n);
    }

    public Iterable<Renderable> getRenderables() {
        return this.renderables;
    }

    public void setRenderables(Iterable<Renderable> iterable) {
        this.renderables = iterable;
    }

    public boolean hasRenderables() {
        return this.renderables != null && this.renderables.iterator().hasNext();
    }

    @Override
    protected void doPerformIntersection(Position position) throws InterruptedException {
        if (this.renderables == null) {
            return;
        }
        Vec4 vec4 = this.terrain.getSurfacePoint(position);
        Line line = new Line(this.referencePoint, vec4.subtract3(this.referencePoint));
        double d = vec4.distanceTo3(this.referencePoint);
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        for (Renderable renderable : this.renderables) {
            try {
                List<Intersection> list = this.performRenderableIntersection(line, renderable);
                if (list == null) continue;
                for (Intersection intersection : list) {
                    if (!(intersection.getIntersectionPoint().distanceTo3(this.referencePoint) <= d)) continue;
                    arrayList.add(intersection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!arrayList.isEmpty()) {
            this.allIntersections.put(position, arrayList);
        }
    }

    protected List<Intersection> performRenderableIntersection(Line line, Renderable renderable) throws InterruptedException {
        List list = null;
        if (renderable instanceof ExtrudedPolygon) {
            list = ((ExtrudedPolygon)renderable).intersect(line, this.terrain);
        }
        return list;
    }
}

