/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.lineofsight;

import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwindx.examples.lineofsight.LineIntersector;
import java.util.ArrayList;

public class TerrainLineIntersector
extends LineIntersector {
    public TerrainLineIntersector(Terrain terrain, int n) {
        super(terrain, n);
    }

    @Override
    protected void doPerformIntersection(Position position) throws InterruptedException {
        Intersection[] intersectionArray = this.terrain.intersect(this.referencePosition, position);
        if (intersectionArray == null || intersectionArray.length == 0) {
            return;
        }
        Vec4 vec4 = intersectionArray[0].getIntersectionPoint();
        Vec4 vec42 = this.terrain.getSurfacePoint(position.getLatitude(), position.getLongitude(), position.getAltitude());
        if (vec4.distanceTo3(this.referencePoint) >= vec42.distanceTo3(this.referencePoint)) {
            return;
        }
        Position position2 = this.terrain.getGlobe().computePositionFromPoint(vec4);
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        arrayList.add(new Intersection(vec4, new Position((LatLon)position2, 0.0), false, null));
        for (int i = 1; i < intersectionArray.length; ++i) {
            vec4 = intersectionArray[i].getIntersectionPoint();
            position2 = this.terrain.getGlobe().computePositionFromPoint(vec4);
            arrayList.add(new Intersection(vec4, new Position((LatLon)position2, 0.0), false, null));
        }
        this.allIntersections.put(position, arrayList);
    }
}

