/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.multiwindow;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.BMNGWMSLayer;
import gov.nasa.worldwind.layers.Earth.LandsatI3WMSLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.StarsLayer;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.layers.ViewControlsSelectListener;
import gov.nasa.worldwind.util.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MultiFrame {
    public static void main(String[] stringArray) {
        try {
            Earth earth = new Earth();
            Layer[] layerArray = new Layer[]{new StarsLayer(), new CompassLayer(), new BMNGWMSLayer(), new LandsatI3WMSLayer()};
            BasicModel basicModel = new BasicModel();
            basicModel.setGlobe((Globe)earth);
            basicModel.setLayers(new LayerList(layerArray));
            BasicModel basicModel2 = new BasicModel();
            basicModel2.setGlobe((Globe)earth);
            basicModel2.setLayers(new LayerList(layerArray));
            CanvasFrame canvasFrame = new CanvasFrame(null, (Model)basicModel, "left");
            canvasFrame.setDefaultCloseOperation(3);
            canvasFrame.setTitle("Frame A");
            canvasFrame.wwp.wwd.setModel((Model)basicModel);
            canvasFrame.setVisible(true);
            CanvasFrame canvasFrame2 = new CanvasFrame((WorldWindow)canvasFrame.wwp.wwd, (Model)basicModel2, "right");
            canvasFrame2.setDefaultCloseOperation(3);
            canvasFrame2.setTitle("Frame B");
            canvasFrame2.wwp.wwd.setModel((Model)basicModel2);
            canvasFrame2.setVisible(true);
            ViewControlsLayer viewControlsLayer = new ViewControlsLayer();
            canvasFrame.wwp.wwd.getModel().getLayers().add((Layer)viewControlsLayer);
            canvasFrame.wwp.wwd.addSelectListener((SelectListener)new ViewControlsSelectListener((WorldWindow)canvasFrame.wwp.wwd, viewControlsLayer));
            ViewControlsLayer viewControlsLayer2 = new ViewControlsLayer();
            canvasFrame2.wwp.wwd.getModel().getLayers().add((Layer)viewControlsLayer2);
            canvasFrame2.wwp.wwd.addSelectListener((SelectListener)new ViewControlsSelectListener((WorldWindow)canvasFrame2.wwp.wwd, viewControlsLayer2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class CanvasFrame
    extends JFrame {
        private WWPanel wwp;

        public CanvasFrame(WorldWindow worldWindow, Model model, String string) {
            this.getContentPane().setLayout(new BorderLayout(5, 5));
            this.wwp = new WWPanel((WorldWindowGLCanvas)worldWindow, 500, 500, model);
            this.getContentPane().add((Component)this.wwp, "Center");
            this.pack();
            Dimension dimension = this.getPreferredSize();
            dimension.setSize(dimension.getWidth(), 1.1 * dimension.getHeight());
            this.setSize(dimension);
            Point point = new Point(0, 0);
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = point.x + (dimension2.width / 2 + (string.equals("left") ? -dimension.width : 20));
            int n2 = point.y + (dimension2.height - dimension.height) / 2;
            this.setLocation(n, n2);
            this.setResizable(true);
        }
    }

    private static class WWPanel
    extends JPanel {
        private WorldWindowGLCanvas wwd;

        public WWPanel(WorldWindowGLCanvas worldWindowGLCanvas, int n, int n2, Model model) {
            this.wwd = worldWindowGLCanvas != null ? new WorldWindowGLCanvas((WorldWindow)worldWindowGLCanvas) : new WorldWindowGLCanvas();
            this.wwd.setSize(new Dimension(n, n2));
            this.wwd.setModel(model);
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.wwd, "Center");
            StatusBar statusBar = new StatusBar();
            statusBar.setEventSource((WorldWindow)this.wwd);
            this.add((Component)statusBar, "South");
        }
    }
}

