/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.multiwindow;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AirspaceLayer;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.BMNGOneImage;
import gov.nasa.worldwind.layers.Earth.BMNGWMSLayer;
import gov.nasa.worldwind.layers.Earth.LandsatI3WMSLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.StarsLayer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.BasicAirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.Box;
import gov.nasa.worldwind.render.airspaces.Cake;
import gov.nasa.worldwind.render.airspaces.CappedCylinder;
import gov.nasa.worldwind.render.airspaces.Curtain;
import gov.nasa.worldwind.render.airspaces.Orbit;
import gov.nasa.worldwind.render.airspaces.PartialCappedCylinder;
import gov.nasa.worldwind.render.airspaces.PolyArc;
import gov.nasa.worldwind.render.airspaces.Polygon;
import gov.nasa.worldwind.render.airspaces.Route;
import gov.nasa.worldwind.render.airspaces.SphereAirspace;
import gov.nasa.worldwind.render.airspaces.TrackAirspace;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.view.orbit.FlatOrbitView;
import gov.nasa.worldwindx.examples.util.HighlightController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SharedShapes {
    protected static Layer makeAirspaceLayer() {
        AirspaceLayer airspaceLayer = new AirspaceLayer();
        airspaceLayer.setName("Airspaces");
        BasicAirspaceAttributes basicAirspaceAttributes = new BasicAirspaceAttributes();
        basicAirspaceAttributes.setMaterial(Material.RED);
        Orbit orbit = new Orbit(LatLon.fromDegrees((double)37.5, (double)-120.0), LatLon.fromDegrees((double)42.5, (double)-120.0), "Center", 100000.0);
        orbit.setAltitudes(10000.0, 20000.0);
        orbit.setTerrainConforming(true);
        orbit.setAttributes((AirspaceAttributes)basicAirspaceAttributes);
        airspaceLayer.addAirspace((Airspace)orbit);
        orbit = new Curtain(Arrays.asList(LatLon.fromDegrees((double)37.5, (double)-112.5), LatLon.fromDegrees((double)42.5, (double)-112.5), LatLon.fromDegrees((double)37.5, (double)-107.5)));
        orbit.setAltitudes(10000.0, 20000.0);
        orbit.setTerrainConforming(true);
        orbit.setAttributes((AirspaceAttributes)basicAirspaceAttributes);
        airspaceLayer.addAirspace((Airspace)orbit);
        orbit = new Polygon(Arrays.asList(LatLon.fromDegrees((double)37.5, (double)-102.5), LatLon.fromDegrees((double)42.5, (double)-102.5), LatLon.fromDegrees((double)37.5, (double)-97.5)));
        orbit.setAltitudes(10000.0, 20000.0);
        orbit.setTerrainConforming(true);
        orbit.setAttributes((AirspaceAttributes)basicAirspaceAttributes);
        airspaceLayer.addAirspace((Airspace)orbit);
        orbit = new PolyArc(Arrays.asList(LatLon.fromDegrees((double)37.5, (double)-92.5), LatLon.fromDegrees((double)42.5, (double)-92.5), LatLon.fromDegrees((double)37.5, (double)-87.5)), 200000.0, Angle.fromDegrees((double)0.0), Angle.fromDegrees((double)90.0));
        orbit.setAltitudes(10000.0, 20000.0);
        orbit.setTerrainConforming(true);
        orbit.setAttributes((AirspaceAttributes)basicAirspaceAttributes);
        airspaceLayer.addAirspace((Airspace)orbit);
        orbit = new Cake(Arrays.asList(new Cake.Layer(LatLon.fromDegrees((double)40.0, (double)-80.0), 100000.0, Angle.ZERO, Angle.ZERO, 10000.0, 20000.0), new Cake.Layer(LatLon.fromDegrees((double)40.0, (double)-80.0), 50000.0, Angle.ZERO, Angle.ZERO, 20000.0, 30000.0), new Cake.Layer(LatLon.fromDegrees((double)40.0, (double)-80.0), 25000.0, Angle.ZERO, Angle.ZERO, 30000.0, 40000.0)));
        orbit.setTerrainConforming(true);
        orbit.setAttributes((AirspaceAttributes)basicAirspaceAttributes);
        airspaceLayer.addAirspace((Airspace)orbit);
        orbit = new CappedCylinder(LatLon.fromDegrees((double)30.0, (double)-120.0), 100000.0);
        orbit.setAltitudes(10000.0, 20000.0);
        orbit.setTerrainConforming(true);
        orbit.setAttributes((AirspaceAttributes)basicAirspaceAttributes);
        airspaceLayer.addAirspace((Airspace)orbit);
        orbit = new PartialCappedCylinder(LatLon.fromDegrees((double)30.0, (double)-110.0), 100000.0, Angle.fromDegrees((double)30.0), Angle.fromDegrees((double)330.0));
        orbit.setAltitudes(10000.0, 20000.0);
        orbit.setTerrainConforming(true);
        orbit.setAttributes((AirspaceAttributes)basicAirspaceAttributes);
        airspaceLayer.addAirspace((Airspace)orbit);
        orbit = new SphereAirspace(LatLon.fromDegrees((double)30.0, (double)-100.0), 100000.0);
        orbit.setAltitudes(10000.0, 20000.0);
        orbit.setTerrainConforming(true);
        orbit.setAttributes((AirspaceAttributes)basicAirspaceAttributes);
        airspaceLayer.addAirspace((Airspace)orbit);
        orbit = new TrackAirspace(Arrays.asList(new Box(LatLon.fromDegrees((double)27.5, (double)-92.5), LatLon.fromDegrees((double)32.5, (double)-92.5), 100000.0, 100000.0), new Box(LatLon.fromDegrees((double)32.5, (double)-92.5), LatLon.fromDegrees((double)27.5, (double)-87.5), 100000.0, 100000.0)));
        ((Box)((TrackAirspace)orbit).getLegs().get(0)).setAltitudes(10000.0, 20000.0);
        ((Box)((TrackAirspace)orbit).getLegs().get(1)).setAltitudes(20000.0, 30000.0);
        orbit.setTerrainConforming(true);
        orbit.setAttributes((AirspaceAttributes)basicAirspaceAttributes);
        airspaceLayer.addAirspace((Airspace)orbit);
        orbit = new Route(Arrays.asList(LatLon.fromDegrees((double)27.5, (double)-82.5), LatLon.fromDegrees((double)32.5, (double)-82.5), LatLon.fromDegrees((double)27.5, (double)-77.5)), 200000.0);
        orbit.setAltitudes(10000.0, 20000.0);
        orbit.setTerrainConforming(true);
        orbit.setAttributes((AirspaceAttributes)basicAirspaceAttributes);
        airspaceLayer.addAirspace((Airspace)orbit);
        return airspaceLayer;
    }

    public static void main(String[] stringArray) {
        Layer[] layerArray = new Layer[]{new StarsLayer(), new CompassLayer(), new BMNGOneImage(), new BMNGWMSLayer(), new LandsatI3WMSLayer()};
        Layer[] layerArray2 = new Layer[]{SharedShapes.makeAirspaceLayer()};
        Layer[] layerArray3 = new Layer[layerArray.length + layerArray2.length];
        System.arraycopy(layerArray, 0, layerArray3, 0, layerArray.length);
        System.arraycopy(layerArray2, 0, layerArray3, layerArray.length, layerArray2.length);
        BasicModel basicModel = new BasicModel((Globe)new Earth(), new LayerList(layerArray3));
        BasicModel basicModel2 = new BasicModel((Globe)new EarthFlat(), new LayerList(layerArray3));
        WWPanel wWPanel = new WWPanel(null, (Model)basicModel, new Dimension(900, 900));
        SharedLayerPanel sharedLayerPanel = new SharedLayerPanel("Shared Shapes", new Dimension(200, 0), Arrays.asList(layerArray2));
        javax.swing.Box box = javax.swing.Box.createHorizontalBox();
        box.add(sharedLayerPanel);
        box.add(javax.swing.Box.createHorizontalStrut(5));
        box.add(wWPanel);
        JFrame jFrame = new JFrame("World Wind Shared Shapes");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add((Component)box, "Center");
        jFrame.setVisible(true);
        WWPanel wWPanel2 = new WWPanel(wWPanel.getWwd(), (Model)basicModel2, new Dimension(900, 900));
        wWPanel2.getWwd().setView((View)new FlatOrbitView());
        box.add(javax.swing.Box.createHorizontalStrut(5));
        box.add(wWPanel2);
        jFrame.pack();
        WWUtil.alignComponent(null, (Component)jFrame, (String)"gov.nasa.worldwind.avkey.Center");
    }

    protected static class SharedLayerPanel
    extends JPanel {
        protected JComponent layersComponent;

        public SharedLayerPanel(String string, Dimension dimension, Iterable<? extends Layer> iterable) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder(string)));
            this.layersComponent = javax.swing.Box.createVerticalBox();
            this.layersComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.update(iterable);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.layersComponent, "North");
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            if (dimension != null) {
                jScrollPane.setPreferredSize(dimension);
            }
            this.add((Component)jScrollPane, "Center");
        }

        public void update(Iterable<? extends Layer> iterable) {
            this.layersComponent.removeAll();
            if (iterable != null) {
                for (Layer layer : iterable) {
                    this.addLayer(layer);
                }
            }
            this.revalidate();
        }

        protected void addLayer(final Layer layer) {
            final JCheckBox jCheckBox = new JCheckBox(layer.getName(), layer.isEnabled());
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    layer.setEnabled(jCheckBox.isSelected());
                    layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)layer);
                }
            });
            this.layersComponent.add(jCheckBox);
            this.layersComponent.add(javax.swing.Box.createVerticalStrut(5));
        }
    }

    protected static class WWPanel
    extends JPanel {
        protected WorldWindowGLCanvas wwd;
        protected HighlightController highlightController;

        public WWPanel(WorldWindow worldWindow, Model model, Dimension dimension) {
            super(new BorderLayout(5, 5));
            WorldWindowGLCanvas worldWindowGLCanvas = this.wwd = worldWindow != null ? new WorldWindowGLCanvas(worldWindow) : new WorldWindowGLCanvas();
            if (dimension != null) {
                this.wwd.setPreferredSize(dimension);
            }
            this.wwd.setModel(model);
            this.add((Component)this.wwd, "Center");
            StatusBar statusBar = new StatusBar();
            statusBar.setEventSource((WorldWindow)this.wwd);
            this.add((Component)statusBar, "South");
            this.highlightController = new HighlightController((WorldWindow)this.wwd, "gov.nasa.worldwind.SelectEvent.Rollover");
        }

        public WorldWindow getWwd() {
            return this.wwd;
        }
    }
}

