/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.shapebuilder;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.UnitsFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class AbstractShapeEditor
extends AbstractLayer
implements MouseListener,
MouseMotionListener {
    public static final String ANGLE_LABEL = "MeasureTool.AngleLabel";
    public static final String AREA_LABEL = "MeasureTool.AreaLabel";
    public static final String LENGTH_LABEL = "MeasureTool.LengthLabel";
    public static final String PERIMETER_LABEL = "MeasureTool.PerimeterLabel";
    public static final String RADIUS_LABEL = "MeasureTool.RadiusLabel";
    public static final String HEIGHT_LABEL = "MeasureTool.HeightLabel";
    public static final String WIDTH_LABEL = "MeasureTool.WidthLabel";
    public static final String HEADING_LABEL = "MeasureTool.HeadingLabel";
    public static final String TILT_LABEL = "MeasureTool.TiltLabel";
    public static final String ROLL_LABEL = "MeasureTool.RollLabel";
    public static final String EAST_SKEW_LABEL = "MeasureTool.EastSkewLabel";
    public static final String NORTH_SKEW_LABEL = "MeasureTool.NorthSkewLabel";
    public static final String CENTER_LATITUDE_LABEL = "MeasureTool.CenterLatitudeLabel";
    public static final String CENTER_LONGITUDE_LABEL = "MeasureTool.CenterLongitudeLabel";
    public static final String CENTER_ALTITUDE_LABEL = "MeasureTool.CenterAltitudeLabel";
    public static final String LATITUDE_LABEL = "MeasureTool.LatitudeLabel";
    public static final String LONGITUDE_LABEL = "MeasureTool.LongitudeLabel";
    public static final String ALTITUDE_LABEL = "MeasureTool.AltitudeLabel";
    public static final String ACCUMULATED_LABEL = "MeasureTool.AccumulatedLabel";
    public static final String MAJOR_AXIS_LABEL = "MeasureTool.MajorAxisLabel";
    public static final String MINOR_AXIS_LABEL = "MeasureTool.MinorAxisLabel";
    protected WorldWindow wwd;
    protected Point mousePoint;
    protected ScreenAnnotation annotation;
    protected AnnotationAttributes annotationAttributes;
    protected UnitsFormat unitsFormat;
    protected boolean armed;
    protected boolean showAnnotation = true;
    protected boolean aboveGround = false;
    protected long frameTimestamp = -1L;
    protected String activeAction;
    protected String editMode;
    protected int altitudeMode = 0;

    public WorldWindow getWorldWindow() {
        return this.wwd;
    }

    public void setWorldWindow(WorldWindow worldWindow) {
        if (this.wwd == worldWindow) {
            return;
        }
        if (this.wwd != null) {
            this.wwd.getInputHandler().removeMouseListener((MouseListener)this);
            this.wwd.getInputHandler().removeMouseMotionListener((MouseMotionListener)this);
        }
        this.wwd = worldWindow;
        if (this.wwd != null) {
            this.wwd.getInputHandler().addMouseListener((MouseListener)this);
            this.wwd.getInputHandler().addMouseMotionListener((MouseMotionListener)this);
        }
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean bl) {
        this.armed = bl;
    }

    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(int n) {
        this.altitudeMode = n;
    }

    public boolean isShowAnnotation() {
        return this.showAnnotation;
    }

    public void setShowAnnotation(boolean bl) {
        this.showAnnotation = bl;
    }

    public boolean isAboveGround() {
        return this.aboveGround;
    }

    public void setAboveGround(boolean bl) {
        this.aboveGround = bl;
    }

    public String getLabel(String string) {
        if (string == null) {
            String string2 = Logging.getMessage((String)"nullValue.LabelName");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = this.getStringValue(string);
        if (string3 != null) {
            return string3;
        }
        if (this.unitsFormat == null) {
            this.unitsFormat = new UnitsFormat();
        }
        return this.unitsFormat.getStringValue(string);
    }

    public void setLabel(String string, String string2) {
        if (string != null && string.length() > 0) {
            this.setValue(string, string2);
        }
    }

    protected void setAnnotationAttributes(AnnotationAttributes annotationAttributes) {
        this.annotationAttributes = annotationAttributes;
    }

    protected AnnotationAttributes getAnnotationAttributes() {
        return this.annotationAttributes;
    }

    public abstract void setShape(AbstractShape var1);

    public abstract String getEditMode();

    public abstract void setEditMode(String var1);

    public abstract void updateAnnotation(Position var1);

    protected void initializeAnnotation() {
        this.setInitialLabels();
        this.annotationAttributes = new AnnotationAttributes();
        this.annotationAttributes.setFrameShape("gov.nasa.worldwind.avkey.ShapeNone");
        this.annotationAttributes.setInsets(new Insets(0, 0, 0, 0));
        this.annotationAttributes.setDrawOffset(new Point(0, 10));
        this.annotationAttributes.setTextAlign("gov.nasa.worldwind.avkey.Center");
        this.annotationAttributes.setEffect("gov.nasa.worldwind.avkey.TextEffectOutline");
        this.annotationAttributes.setFont(Font.decode("Arial-Bold-14"));
        this.annotationAttributes.setTextColor(Color.WHITE);
        this.annotationAttributes.setBackgroundColor(Color.BLACK);
        this.annotationAttributes.setSize(new Dimension(220, 0));
        this.annotation = new ScreenAnnotation("", new Point(0, 0), this.annotationAttributes);
        this.annotation.getAttributes().setVisible(false);
        this.annotation.getAttributes().setDrawOffset(null);
    }

    protected void setInitialLabels() {
        this.setLabel(ACCUMULATED_LABEL, Logging.getMessage((String)ACCUMULATED_LABEL));
        this.setLabel(ANGLE_LABEL, Logging.getMessage((String)ANGLE_LABEL));
        this.setLabel(AREA_LABEL, Logging.getMessage((String)AREA_LABEL));
        this.setLabel(CENTER_LATITUDE_LABEL, Logging.getMessage((String)CENTER_LATITUDE_LABEL));
        this.setLabel(CENTER_LONGITUDE_LABEL, Logging.getMessage((String)CENTER_LONGITUDE_LABEL));
        this.setLabel(CENTER_ALTITUDE_LABEL, Logging.getMessage((String)CENTER_ALTITUDE_LABEL));
        this.setLabel(HEADING_LABEL, Logging.getMessage((String)HEADING_LABEL));
        this.setLabel(TILT_LABEL, Logging.getMessage((String)TILT_LABEL));
        this.setLabel(ROLL_LABEL, Logging.getMessage((String)ROLL_LABEL));
        this.setLabel(EAST_SKEW_LABEL, Logging.getMessage((String)EAST_SKEW_LABEL));
        this.setLabel(NORTH_SKEW_LABEL, Logging.getMessage((String)NORTH_SKEW_LABEL));
        this.setLabel(HEIGHT_LABEL, Logging.getMessage((String)HEIGHT_LABEL));
        this.setLabel(LATITUDE_LABEL, Logging.getMessage((String)LATITUDE_LABEL));
        this.setLabel(LONGITUDE_LABEL, Logging.getMessage((String)LONGITUDE_LABEL));
        this.setLabel(ALTITUDE_LABEL, Logging.getMessage((String)ALTITUDE_LABEL));
        this.setLabel(LENGTH_LABEL, Logging.getMessage((String)LENGTH_LABEL));
        this.setLabel(MAJOR_AXIS_LABEL, Logging.getMessage((String)MAJOR_AXIS_LABEL));
        this.setLabel(MINOR_AXIS_LABEL, Logging.getMessage((String)MINOR_AXIS_LABEL));
        this.setLabel(PERIMETER_LABEL, Logging.getMessage((String)PERIMETER_LABEL));
        this.setLabel(RADIUS_LABEL, Logging.getMessage((String)RADIUS_LABEL));
        this.setLabel(WIDTH_LABEL, Logging.getMessage((String)WIDTH_LABEL));
    }

    protected boolean arePositionsRedundant(Position position, Position position2) {
        String string;
        String string2;
        if (position == null || position2 == null) {
            return false;
        }
        String string3 = this.unitsFormat.angleNL("", position.getLatitude());
        if (!string3.equals(string2 = this.unitsFormat.angleNL("", position2.getLatitude()))) {
            return false;
        }
        String string4 = this.unitsFormat.angleNL("", position.getLongitude());
        if (!string4.equals(string = this.unitsFormat.angleNL("", position2.getLongitude()))) {
            return false;
        }
        String string5 = this.unitsFormat.lengthNL("", position.getAltitude());
        String string6 = this.unitsFormat.lengthNL("", position2.getAltitude());
        return string5.equals(string6);
    }
}

