/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.shapebuilder;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Ellipsoid;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.RigidShape;
import gov.nasa.worldwindx.examples.shapebuilder.RigidShapeEditor;
import gov.nasa.worldwindx.examples.util.ShapeUtils;
import java.awt.Point;

public class CylinderEditor
extends RigidShapeEditor {
    @Override
    protected void assembleScaleControlPoints(DrawContext drawContext) {
        RigidShape rigidShape = this.getShape();
        Matrix matrix = rigidShape.computeRenderMatrix(drawContext);
        Vec4 vec4 = rigidShape.computeReferencePoint(drawContext);
        Position position = rigidShape.getReferencePosition();
        double d = ShapeUtils.getViewportScaleFactor(this.wwd) / 12.0;
        if (this.controlPoints.size() > 0) {
            for (RigidShape rigidShape2 : this.controlPoints) {
                rigidShape2.setEastWestRadius(d);
                rigidShape2.setNorthSouthRadius(d);
                rigidShape2.setVerticalRadius(d);
            }
        } else {
            Vec4 vec42 = matrix.transformBy3(matrix, 1.0, 0.0, 0.0).add3(vec4);
            Position position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            Ellipsoid ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.scaleControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.ScaleEastAction");
            this.controlPoints.add(ellipsoid);
            Path path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.scaleRodAttributes);
            this.controlPointRods.add(path);
            vec42 = matrix.transformBy3(matrix, 0.0, 1.0, 0.0).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.scaleControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.ScaleNorthAction");
            this.controlPoints.add(ellipsoid);
            path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.scaleRodAttributes);
            this.controlPointRods.add(path);
            vec42 = matrix.transformBy3(matrix, 0.0, 0.0, 1.0).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.scaleControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.ScaleUpAction");
            this.controlPoints.add(ellipsoid);
            path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.scaleRodAttributes);
            this.controlPointRods.add(path);
            vec42 = matrix.transformBy3(matrix, -1.0, 0.0, 0.0).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.scaleControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.ScaleWestAction");
            this.controlPoints.add(ellipsoid);
            path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.scaleRodAttributes);
            this.controlPointRods.add(path);
            vec42 = matrix.transformBy3(matrix, 0.0, -1.0, 0.0).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.scaleControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.ScaleSouthAction");
            this.controlPoints.add(ellipsoid);
            path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.scaleRodAttributes);
            this.controlPointRods.add(path);
            vec42 = matrix.transformBy3(matrix, 0.0, 0.0, -1.0).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.scaleControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.ScaleDownAction");
            this.controlPoints.add(ellipsoid);
            path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.scaleRodAttributes);
            this.controlPointRods.add(path);
            vec42 = matrix.transformBy3(matrix, 1.0, 1.0, -1.0).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.radiusControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.ScaleRadiusAction");
            this.controlPoints.add(ellipsoid);
            path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.radiusRodAttributes);
            this.controlPointRods.add(path);
        }
    }

    @Override
    protected void assembleTextureControlPoints(DrawContext drawContext) {
        RigidShape rigidShape = this.getShape();
        Matrix matrix = rigidShape.computeRenderMatrix(drawContext);
        Vec4 vec4 = rigidShape.computeReferencePoint(drawContext);
        double d = ShapeUtils.getViewportScaleFactor(this.wwd) / 12.0;
        Vec4 vec42 = new Vec4(0.0, 0.0, 0.0);
        Vec4 vec43 = new Vec4(0.0, 0.0, 0.0);
        Vec4 vec44 = new Vec4(0.0, 0.0, 0.0);
        Vec4 vec45 = new Vec4(0.0, 0.0, 0.0);
        if (this.selectedFace == 0) {
            vec42 = new Vec4((double)(-1.0f + rigidShape.getOffsets(0, 0)[0]), (double)(1.0f + rigidShape.getOffsets(0, 0)[1]), 1.0);
            vec43 = new Vec4((double)(1.0f + rigidShape.getOffsets(0, 1)[0]), (double)(1.0f + rigidShape.getOffsets(0, 1)[1]), 1.0);
            vec44 = new Vec4((double)(-1.0f + rigidShape.getOffsets(0, 2)[0]), (double)(-1.0f + rigidShape.getOffsets(0, 2)[1]), 1.0);
            vec45 = new Vec4((double)(1.0f + rigidShape.getOffsets(0, 3)[0]), (double)(-1.0f + rigidShape.getOffsets(0, 3)[1]), 1.0);
        } else if (this.selectedFace == 1) {
            vec42 = new Vec4((double)(1.0f - rigidShape.getOffsets(1, 0)[0]), (double)(1.0f + rigidShape.getOffsets(1, 0)[1]), -1.0);
            vec43 = new Vec4((double)(-1.0f - rigidShape.getOffsets(1, 1)[0]), (double)(1.0f + rigidShape.getOffsets(1, 1)[1]), -1.0);
            vec44 = new Vec4((double)(1.0f - rigidShape.getOffsets(1, 2)[0]), (double)(-1.0f + rigidShape.getOffsets(1, 2)[1]), -1.0);
            vec45 = new Vec4((double)(-1.0f - rigidShape.getOffsets(1, 3)[0]), (double)(-1.0f + rigidShape.getOffsets(1, 3)[1]), -1.0);
        } else if (this.selectedFace == 2) {
            vec42 = new Vec4((double)(-1.0f + rigidShape.getOffsets(2, 0)[0]), -1.0, (double)(1.0f + rigidShape.getOffsets(2, 0)[1]));
            vec43 = new Vec4((double)(1.0f + rigidShape.getOffsets(2, 1)[0]), -1.0, (double)(1.0f + rigidShape.getOffsets(2, 1)[1]));
            vec44 = new Vec4((double)(-1.0f + rigidShape.getOffsets(2, 2)[0]), -1.0, (double)(-1.0f + rigidShape.getOffsets(2, 2)[1]));
            vec45 = new Vec4((double)(1.0f + rigidShape.getOffsets(2, 3)[0]), -1.0, (double)(-1.0f + rigidShape.getOffsets(2, 3)[1]));
        }
        Vec4 vec46 = vec42.add3(vec43).divide3(2.0);
        Vec4 vec47 = vec44.add3(vec45).divide3(2.0);
        Vec4 vec48 = vec42.add3(vec44).divide3(2.0);
        Vec4 vec49 = vec43.add3(vec45).divide3(2.0);
        Vec4 vec410 = vec48.add3(vec49).divide3(2.0);
        if (this.controlPoints.size() > 0) {
            for (RigidShape rigidShape2 : this.controlPoints) {
                rigidShape2.setEastWestRadius(d);
                rigidShape2.setNorthSouthRadius(d);
                rigidShape2.setVerticalRadius(d);
            }
        } else {
            Vec4 vec411 = matrix.transformBy3(matrix, vec42.getX(), vec42.getY(), vec42.getZ()).add3(vec4);
            Position position = this.wwd.getModel().getGlobe().computePositionFromPoint(vec411);
            Ellipsoid ellipsoid = new Ellipsoid(position, d, d, d);
            ellipsoid.setAttributes(this.textureControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.textureUpperLeftAction");
            this.controlPoints.add(ellipsoid);
            vec411 = matrix.transformBy3(matrix, vec43.getX(), vec43.getY(), vec43.getZ()).add3(vec4);
            Position position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec411);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.textureControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.textureUpperRightAction");
            this.controlPoints.add(ellipsoid);
            vec411 = matrix.transformBy3(matrix, vec44.getX(), vec44.getY(), vec44.getZ()).add3(vec4);
            Position position3 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec411);
            ellipsoid = new Ellipsoid(position3, d, d, d);
            ellipsoid.setAttributes(this.textureControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.textureLowerLeftAction");
            this.controlPoints.add(ellipsoid);
            vec411 = matrix.transformBy3(matrix, vec45.getX(), vec45.getY(), vec45.getZ()).add3(vec4);
            Position position4 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec411);
            ellipsoid = new Ellipsoid(position4, d, d, d);
            ellipsoid.setAttributes(this.textureControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.textureLowerRightAction");
            this.controlPoints.add(ellipsoid);
            vec411 = matrix.transformBy3(matrix, vec49.getX(), vec49.getY(), vec49.getZ()).add3(vec4);
            Position position5 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec411);
            ellipsoid = new Ellipsoid(position5, d, d, d);
            ellipsoid.setAttributes(this.radiusControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.textureScaleRightAction");
            this.controlPoints.add(ellipsoid);
            vec411 = matrix.transformBy3(matrix, vec48.getX(), vec48.getY(), vec48.getZ()).add3(vec4);
            position5 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec411);
            ellipsoid = new Ellipsoid(position5, d, d, d);
            ellipsoid.setAttributes(this.radiusControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.textureScaleLeftAction");
            this.controlPoints.add(ellipsoid);
            vec411 = matrix.transformBy3(matrix, vec46.getX(), vec46.getY(), vec46.getZ()).add3(vec4);
            position5 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec411);
            ellipsoid = new Ellipsoid(position5, d, d, d);
            ellipsoid.setAttributes(this.radiusControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.textureScaleUpAction");
            this.controlPoints.add(ellipsoid);
            vec411 = matrix.transformBy3(matrix, vec47.getX(), vec47.getY(), vec47.getZ()).add3(vec4);
            position5 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec411);
            ellipsoid = new Ellipsoid(position5, d, d, d);
            ellipsoid.setAttributes(this.radiusControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.textureScaleDownAction");
            this.controlPoints.add(ellipsoid);
            vec411 = matrix.transformBy3(matrix, vec410.getX(), vec410.getY(), vec410.getZ()).add3(vec4);
            position5 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec411);
            ellipsoid = new Ellipsoid(position5, d, d, d);
            ellipsoid.setAttributes(this.radiusControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)"gov.nasa.worldwind.RigidShapeEditor.TextureMoveAction");
            Path path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.translationRodAttributes);
            path.setVisible(true);
            this.controlPointRods.add(path);
            path = new Path(position2, position4);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.translationRodAttributes);
            path.setVisible(true);
            this.controlPointRods.add(path);
            path = new Path(position4, position3);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.translationRodAttributes);
            path.setVisible(true);
            this.controlPointRods.add(path);
            path = new Path(position3, position);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.translationRodAttributes);
            path.setVisible(true);
            this.controlPointRods.add(path);
        }
    }

    @Override
    protected void scaleShapeNorth(Point point, Point point2) {
        this.scaleShapeNorthSouth(point, point2, "gov.nasa.worldwind.RigidShapeEditor.ScaleNorthAction");
    }

    @Override
    protected void scaleShapeSouth(Point point, Point point2) {
        this.scaleShapeNorthSouth(point, point2, "gov.nasa.worldwind.RigidShapeEditor.ScaleSouthAction");
    }

    protected void scaleShapeNorthSouth(Point point, Point point2, String string) {
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec42 = line.nearestPointTo(vec4);
        Vec4 vec43 = line2.nearestPointTo(vec4);
        Position position2 = ((RigidShape)this.controlPoints.get(1)).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Vec4 vec45 = vec44.subtract3(vec4).normalize3();
        if (string.equals("gov.nasa.worldwind.RigidShapeEditor.ScaleSouthAction")) {
            vec45 = vec45.getNegative3();
        }
        double d = vec42.distanceTo3(vec4);
        double d2 = vec43.distanceTo3(vec4);
        double d3 = d - d2;
        RigidShape rigidShape = this.getShape();
        double d4 = rigidShape.getNorthSouthRadius();
        if (d4 + d3 > 0.0) {
            this.shape.setNorthSouthRadius(d4 + d3 / 2.0);
            Vec4 vec46 = vec4.add3(vec45.multiply3(d3 / 2.0));
            Position position3 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec46);
            this.shape.setCenterPosition(position3);
        }
    }

    @Override
    protected void scaleShapeEast(Point point, Point point2) {
        this.scaleShapeEastWest(point, point2, "gov.nasa.worldwind.RigidShapeEditor.ScaleEastAction");
    }

    @Override
    protected void scaleShapeWest(Point point, Point point2) {
        this.scaleShapeEastWest(point, point2, "gov.nasa.worldwind.RigidShapeEditor.ScaleWestAction");
    }

    protected void scaleShapeEastWest(Point point, Point point2, String string) {
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec42 = line.nearestPointTo(vec4);
        Vec4 vec43 = line2.nearestPointTo(vec4);
        Position position2 = ((RigidShape)this.controlPoints.get(0)).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Vec4 vec45 = vec44.subtract3(vec4).normalize3();
        if (string.equals("gov.nasa.worldwind.RigidShapeEditor.ScaleWestAction")) {
            vec45 = vec45.getNegative3();
        }
        double d = vec42.distanceTo3(vec4);
        double d2 = vec43.distanceTo3(vec4);
        double d3 = d - d2;
        RigidShape rigidShape = this.getShape();
        double d4 = rigidShape.getEastWestRadius();
        if (d4 + d3 > 0.0) {
            this.shape.setEastWestRadius(d4 + d3 / 2.0);
            Vec4 vec46 = vec4.add3(vec45.multiply3(d3 / 2.0));
            Position position3 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec46);
            this.shape.setCenterPosition(position3);
        }
    }

    @Override
    protected void scaleShapeUp(Point point, Point point2) {
        this.scaleShapeVertical(point, point2, "gov.nasa.worldwind.RigidShapeEditor.ScaleUpAction");
    }

    @Override
    protected void scaleShapeDown(Point point, Point point2) {
        this.scaleShapeVertical(point, point2, "gov.nasa.worldwind.RigidShapeEditor.ScaleDownAction");
    }

    protected void scaleShapeVertical(Point point, Point point2, String string) {
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec42 = line.nearestPointTo(vec4);
        Vec4 vec43 = line2.nearestPointTo(vec4);
        Position position2 = ((RigidShape)this.controlPoints.get(2)).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Vec4 vec45 = vec44.subtract3(vec4).normalize3();
        if (string.equals("gov.nasa.worldwind.RigidShapeEditor.ScaleDownAction")) {
            vec45 = vec45.getNegative3();
        }
        double d = vec42.distanceTo3(vec4);
        double d2 = vec43.distanceTo3(vec4);
        double d3 = d - d2;
        RigidShape rigidShape = this.getShape();
        double d4 = rigidShape.getVerticalRadius();
        if (d4 + d3 > 0.0) {
            this.shape.setVerticalRadius(d4 + d3 / 2.0);
            Vec4 vec46 = vec4.add3(vec45.multiply3(d3 / 2.0));
            Position position3 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec46);
            this.shape.setCenterPosition(position3);
        }
    }

    @Override
    protected void scaleShapeRadius(Point point, Point point2) {
        double d;
        RigidShape rigidShape;
        double d2;
        double d3;
        double d4;
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec42 = line.nearestPointTo(vec4);
        Vec4 vec43 = line2.nearestPointTo(vec4);
        double d5 = vec42.distanceTo3(vec4);
        double d6 = d5 - (d4 = vec43.distanceTo3(vec4));
        double d7 = (d6 + (d3 = ((d2 = (rigidShape = this.getShape()).getEastWestRadius()) + (d = rigidShape.getNorthSouthRadius())) / 2.0)) / d3;
        if (d7 > 0.0) {
            this.shape.setEastWestRadius(d2 * d7);
            this.shape.setNorthSouthRadius(d * d7);
        }
    }

    @Override
    protected void scaleShape(Point point, Point point2) {
        double d;
        double d2;
        RigidShape rigidShape;
        double d3;
        double d4;
        double d5;
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec42 = line.nearestPointTo(vec4);
        Vec4 vec43 = line2.nearestPointTo(vec4);
        Position position2 = ((RigidShape)this.controlPoints.get(2)).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Vec4 vec45 = vec44.subtract3(vec4).normalize3();
        double d6 = vec42.distanceTo3(vec4);
        double d7 = d6 - (d5 = vec43.distanceTo3(vec4));
        double d8 = (d7 + (d4 = ((d3 = (rigidShape = this.getShape()).getEastWestRadius()) + (d2 = rigidShape.getNorthSouthRadius()) + (d = rigidShape.getVerticalRadius())) / 3.0)) / d4;
        if (d8 > 0.0) {
            this.shape.setEastWestRadius(d3 * d8);
            this.shape.setNorthSouthRadius(d2 * d8);
            this.shape.setVerticalRadius(d * d8);
            vec45 = vec45.multiply3(this.shape.getVerticalRadius() - d);
            Vec4 vec46 = vec4.add3(vec45);
            Position position3 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec46);
            this.shape.setCenterPosition(position3);
        }
    }

    @Override
    protected void skewShapeEastWest(Point point, Point point2) {
        RigidShape rigidShape = this.getShape();
        double d = rigidShape.getSkewEastWest().getDegrees();
        double d2 = ShapeUtils.getViewportScaleFactor(this.wwd);
        Matrix matrix = this.shape.computeRenderMatrix(this.wwd.getModel().getGlobe(), this.wwd.getSceneController().getVerticalExaggeration());
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Position position2 = ((RigidShape)this.controlPoints.get(2)).getCenterPosition();
        Vec4 vec42 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Vec4 vec43 = vec42.subtract3(vec4).normalize3();
        Position position3 = ((RigidShape)this.controlPoints.get(3)).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position3);
        Vec4 vec45 = vec44.subtract3(vec4).normalize3();
        Position position4 = ((RigidShape)this.controlPoints.get(4)).getCenterPosition();
        Vec4 vec46 = this.wwd.getModel().getGlobe().computePointFromPosition(position4);
        Vec4 vec47 = vec46.subtract3(vec4).normalize3();
        Vec4 vec48 = vec4.add3(vec43.multiply3(this.shape.getEastWestRadius()));
        Vec4 vec49 = vec48.add3(vec45);
        Vec4 vec410 = vec48.add3(vec47);
        Plane plane = Plane.fromPoints((Vec4)vec48, (Vec4)vec49, (Vec4)vec410);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec411 = line.nearestPointTo(vec48);
        Vec4 vec412 = line2.nearestPointTo(vec48);
        double d3 = vec411.distanceTo3(vec48);
        double d4 = vec412.distanceTo3(vec48);
        double d5 = (d3 - d4) / d2;
        d5 *= 1.0 - Math.abs(d - 90.0) / 90.0;
        d5 *= 50.0;
        int n = plane.onSameSide(vec4, vec411);
        if (n != 0) {
            d5 *= -1.0;
        }
        if (d + d5 >= 0.0 && d + d5 < 180.0) {
            this.shape.setSkewEastWest(Angle.fromDegrees((double)(d + d5)));
        }
        Vec4 vec413 = matrix.transformBy3(matrix, 0.0, 0.0, -1.0);
        Matrix matrix2 = this.shape.computeRenderMatrix(this.wwd.getModel().getGlobe(), this.wwd.getSceneController().getVerticalExaggeration());
        Vec4 vec414 = matrix2.transformBy3(matrix2, 0.0, 0.0, -1.0);
        Vec4 vec415 = vec414.subtract3(vec413);
        vec4 = vec4.subtract3(vec415);
        Position position5 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec4);
        this.shape.setCenterPosition(position5);
    }

    @Override
    protected void skewShapeNorthSouth(Point point, Point point2) {
        RigidShape rigidShape = this.getShape();
        double d = rigidShape.getSkewNorthSouth().getDegrees();
        double d2 = ShapeUtils.getViewportScaleFactor(this.wwd);
        Matrix matrix = this.shape.computeRenderMatrix(this.wwd.getModel().getGlobe(), this.wwd.getSceneController().getVerticalExaggeration());
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Position position2 = ((RigidShape)this.controlPoints.get(3)).getCenterPosition();
        Vec4 vec42 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Vec4 vec43 = vec42.subtract3(vec4).normalize3();
        Position position3 = ((RigidShape)this.controlPoints.get(2)).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position3);
        Vec4 vec45 = vec44.subtract3(vec4).normalize3();
        Position position4 = ((RigidShape)this.controlPoints.get(4)).getCenterPosition();
        Vec4 vec46 = this.wwd.getModel().getGlobe().computePointFromPosition(position4);
        Vec4 vec47 = vec46.subtract3(vec4).normalize3();
        Vec4 vec48 = vec4.add3(vec43.multiply3(this.shape.getNorthSouthRadius()));
        Vec4 vec49 = vec48.add3(vec45);
        Vec4 vec410 = vec48.add3(vec47);
        Plane plane = Plane.fromPoints((Vec4)vec48, (Vec4)vec49, (Vec4)vec410);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec411 = line.nearestPointTo(vec48);
        Vec4 vec412 = line2.nearestPointTo(vec48);
        double d3 = vec411.distanceTo3(vec48);
        double d4 = vec412.distanceTo3(vec48);
        double d5 = (d3 - d4) / d2;
        d5 *= 1.0 - Math.abs(d - 90.0) / 90.0;
        d5 *= 50.0;
        int n = plane.onSameSide(vec4, vec411);
        if (n != 0) {
            d5 *= -1.0;
        }
        if (d + d5 >= 0.0 && d + d5 < 180.0) {
            this.shape.setSkewNorthSouth(Angle.fromDegrees((double)(d + d5)));
        }
        Vec4 vec413 = matrix.transformBy3(matrix, 0.0, 0.0, -1.0);
        Matrix matrix2 = this.shape.computeRenderMatrix(this.wwd.getModel().getGlobe(), this.wwd.getSceneController().getVerticalExaggeration());
        Vec4 vec414 = matrix2.transformBy3(matrix2, 0.0, 0.0, -1.0);
        Vec4 vec415 = vec414.subtract3(vec413);
        vec4 = vec4.subtract3(vec415);
        Position position5 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec4);
        this.shape.setCenterPosition(position5);
    }

    @Override
    protected void moveTextureCorner(Point point, Point point2, Integer n) {
        Vec4 vec4 = new Vec4(0.0, 0.0, 0.0);
        Vec4 vec42 = new Vec4(0.0, 0.0, 0.0);
        if (this.selectedFace == 0) {
            vec4 = new Vec4(1.0, 0.0, 0.0);
            vec42 = new Vec4(0.0, 1.0, 0.0);
        } else if (this.selectedFace == 1) {
            vec4 = new Vec4(-1.0, 0.0, 0.0);
            vec42 = new Vec4(0.0, 1.0, 0.0);
        } else if (this.selectedFace == 2) {
            vec4 = new Vec4(1.0, 0.0, 0.0);
            vec42 = new Vec4(0.0, 0.0, 1.0);
        }
        Matrix matrix = this.shape.computeRenderMatrixInverse(this.wwd.getModel().getGlobe(), this.wwd.getSceneController().getVerticalExaggeration());
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Position position = ((RigidShape)this.controlPoints.get(0)).getCenterPosition();
        Vec4 vec43 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Position position2 = ((RigidShape)this.controlPoints.get(1)).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Position position3 = ((RigidShape)this.controlPoints.get(2)).getCenterPosition();
        Vec4 vec45 = this.wwd.getModel().getGlobe().computePointFromPosition(position3);
        Plane plane = Plane.fromPoints((Vec4)vec43, (Vec4)vec44, (Vec4)vec45);
        Vec4 vec46 = plane.intersect(line);
        Vec4 vec47 = plane.intersect(line2);
        Vec4 vec48 = vec46.subtract3(vec47);
        Vec4 vec49 = matrix.transformBy3(matrix, vec48.getX(), vec48.getY(), vec48.getZ());
        float[] fArray = new float[]{0.0f, 0.0f};
        float[] fArray2 = this.shape.getOffsets(this.selectedFace, n.intValue());
        fArray[0] = (float)((double)fArray2[0] + vec4.dot3(vec49));
        fArray[1] = (float)((double)fArray2[1] + vec42.dot3(vec49));
        this.shape.setOffset(this.selectedFace, n.intValue(), fArray[0], fArray[1]);
        switch (n) {
            case 0: {
                n = 3;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 0;
            }
        }
        fArray2 = this.shape.getOffsets(this.selectedFace, n.intValue());
        fArray[0] = (float)((double)fArray2[0] - vec4.dot3(vec49));
        fArray[1] = (float)((double)fArray2[1] - vec42.dot3(vec49));
        this.shape.setOffset(this.selectedFace, n.intValue(), fArray[0], fArray[1]);
    }

    @Override
    protected void scaleTexture(Point point, Point point2, RigidShapeEditor.Direction direction) {
        Vec4 vec4 = new Vec4(0.0, 0.0, 0.0);
        Vec4 vec42 = new Vec4(0.0, 0.0, 0.0);
        int n = 0;
        int n2 = 0;
        if (this.selectedFace == 0) {
            vec4 = new Vec4(1.0, 0.0, 0.0);
            vec42 = new Vec4(0.0, 1.0, 0.0);
        } else if (this.selectedFace == 1) {
            vec4 = new Vec4(-1.0, 0.0, 0.0);
            vec42 = new Vec4(0.0, 1.0, 0.0);
        } else if (this.selectedFace == 2) {
            vec4 = new Vec4(1.0, 0.0, 0.0);
            vec42 = new Vec4(0.0, 0.0, 1.0);
        }
        switch (direction) {
            case RIGHT: {
                n = 1;
                n2 = 3;
                break;
            }
            case LEFT: {
                n = 2;
                n2 = 0;
                break;
            }
            case UP: {
                n = 0;
                n2 = 1;
                break;
            }
            case DOWN: {
                n = 3;
                n2 = 2;
            }
        }
        Matrix matrix = this.shape.computeRenderMatrixInverse(this.wwd.getModel().getGlobe(), this.wwd.getSceneController().getVerticalExaggeration());
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Position position = ((RigidShape)this.controlPoints.get(0)).getCenterPosition();
        Vec4 vec43 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Position position2 = ((RigidShape)this.controlPoints.get(1)).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Position position3 = ((RigidShape)this.controlPoints.get(2)).getCenterPosition();
        Vec4 vec45 = this.wwd.getModel().getGlobe().computePointFromPosition(position3);
        Plane plane = Plane.fromPoints((Vec4)vec43, (Vec4)vec44, (Vec4)vec45);
        Vec4 vec46 = plane.intersect(line);
        Vec4 vec47 = plane.intersect(line2);
        Vec4 vec48 = vec46.subtract3(vec47);
        Vec4 vec49 = matrix.transformBy3(matrix, vec48.getX(), vec48.getY(), vec48.getZ());
        float[] fArray = new float[]{0.0f, 0.0f};
        double d = vec4.dot3(vec49);
        double d2 = vec42.dot3(vec49);
        float[] fArray2 = this.shape.getOffsets(this.selectedFace, n);
        if (direction == RigidShapeEditor.Direction.RIGHT || direction == RigidShapeEditor.Direction.LEFT) {
            fArray[0] = (float)((double)fArray2[0] + d);
            this.shape.setOffset(this.selectedFace, n, fArray[0], fArray2[1]);
        } else {
            fArray[1] = (float)((double)fArray2[1] + d2);
            this.shape.setOffset(this.selectedFace, n, fArray2[0], fArray[1]);
        }
        fArray2 = this.shape.getOffsets(this.selectedFace, n2);
        if (direction == RigidShapeEditor.Direction.RIGHT || direction == RigidShapeEditor.Direction.LEFT) {
            fArray[0] = (float)((double)fArray2[0] + d);
            this.shape.setOffset(this.selectedFace, n2, fArray[0], fArray2[1]);
        } else {
            fArray[1] = (float)((double)fArray2[1] + d2);
            this.shape.setOffset(this.selectedFace, n2, fArray2[0], fArray[1]);
        }
    }
}

