/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.shapebuilder;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Ellipsoid;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Pyramid;
import gov.nasa.worldwind.render.RigidShape;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditorUtil;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.UnitsFormat;
import gov.nasa.worldwindx.examples.shapebuilder.AbstractShapeEditor;
import gov.nasa.worldwindx.examples.util.ShapeUtils;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class RigidShapeEditor
extends AbstractShapeEditor {
    public static final String MOVE_VERTEX_ACTION = "gov.nasa.worldwind.RigidShapeEditor.MoveVertexAction";
    public static final String CHANGE_HEIGHT_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ChangeHeightAction";
    public static final String CHANGE_LATITUDE_ACTION = "gov.nasa.worldwind.RigidShapeEditor.MoveShapeLatitudeAction";
    public static final String CHANGE_LONGITUDE_ACTION = "gov.nasa.worldwind.RigidShapeEditor.MoveShapeLongitudeAction";
    public static final String MOVE_SHAPE_ACTION = "gov.nasa.worldwind.RigidShapeEditor.MoveShapeAction";
    public static final String SCALE_SHAPE_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleShapeAction";
    public static final String SCALE_NORTH_SOUTH_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleNorthSouthAction";
    public static final String SCALE_EAST_WEST_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleEastWestAction";
    public static final String SCALE_VERTICAL_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleVerticalAction";
    public static final String SCALE_NORTH_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleNorthAction";
    public static final String SCALE_SOUTH_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleSouthAction";
    public static final String SCALE_EAST_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleEastAction";
    public static final String SCALE_WEST_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleWestAction";
    public static final String SCALE_UP_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleUpAction";
    public static final String SCALE_DOWN_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleDownAction";
    public static final String SCALE_RADIUS_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleRadiusAction";
    public static final String SCALE_ANGLE_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleAngleAction";
    public static final String SCALE_NORTHEAST_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleNortheastAction";
    public static final String SCALE_SOUTHWEST_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleSouthwestAction";
    public static final String SCALE_NORTHWEST_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleNorthwestAction";
    public static final String SCALE_SOUTHEAST_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ScaleSoutheastAction";
    public static final String CHANGE_HEADING_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ChangeHeadingAction";
    public static final String CHANGE_TILT_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ChangeTiltAction";
    public static final String CHANGE_ROLL_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ChangeRollAction";
    public static final String SKEW_NORTH_SOUTH_ACTION = "gov.nasa.worldwind.RigidShapeEditor.SkewNorthSouthAction";
    public static final String SKEW_EAST_WEST_ACTION = "gov.nasa.worldwind.RigidShapeEditor.SkewEastWestAction";
    public static final String CHANGE_SKEW_ACTION = "gov.nasa.worldwind.RigidShapeEditor.ChangeSkewAction";
    public static final String SET_TEXTURE_ACTION = "gov.nasa.worldwind.RigidShapeEditor.SetTextureAction";
    public static final String TEXTURE_MOVE_ACTION = "gov.nasa.worldwind.RigidShapeEditor.TextureMoveAction";
    public static final String TEXTURE_UPPER_LEFT_ACTION = "gov.nasa.worldwind.RigidShapeEditor.textureUpperLeftAction";
    public static final String TEXTURE_UPPER_RIGHT_ACTION = "gov.nasa.worldwind.RigidShapeEditor.textureUpperRightAction";
    public static final String TEXTURE_LOWER_LEFT_ACTION = "gov.nasa.worldwind.RigidShapeEditor.textureLowerLeftAction";
    public static final String TEXTURE_LOWER_RIGHT_ACTION = "gov.nasa.worldwind.RigidShapeEditor.textureLowerRightAction";
    public static final String TEXTURE_SCALE_RIGHT_ACTION = "gov.nasa.worldwind.RigidShapeEditor.textureScaleRightAction";
    public static final String TEXTURE_SCALE_LEFT_ACTION = "gov.nasa.worldwind.RigidShapeEditor.textureScaleLeftAction";
    public static final String TEXTURE_SCALE_UP_ACTION = "gov.nasa.worldwind.RigidShapeEditor.textureScaleUpAction";
    public static final String TEXTURE_SCALE_DOWN_ACTION = "gov.nasa.worldwind.RigidShapeEditor.textureScaleDownAction";
    public static final String TRANSLATION_MODE = "gov.nasa.worldwind.RigidShapeEditor.TranslationMode";
    public static final String SCALE_MODE = "gov.nasa.worldwind.RigidShapeEditor.ScaleMode";
    public static final String ROTATION_MODE = "gov.nasa.worldwind.RigidShapeEditor.RotationMode";
    public static final String SKEW_MODE = "gov.nasa.worldwind.RigidShapeEditor.SkewMode";
    public static final String TEXTURE_MODE = "gov.nasa.worldwind.RigidShapeEditor.TextureMode";
    public static final Integer UPPER_LEFT_UV = 0;
    public static final Integer UPPER_RIGHT_UV = 1;
    public static final Integer LOWER_LEFT_UV = 2;
    public static final Integer LOWER_RIGHT_UV = 3;
    protected RigidShape shape;
    protected RigidShape activeControlPoint;
    protected int activeControlPointIndex;
    protected List<RigidShape> controlPoints;
    protected int selectedFace = -1;
    protected BasicMarkerAttributes vertexControlAttributes;
    protected ShapeAttributes translationControlAttributes;
    protected ShapeAttributes scaleControlAttributes;
    protected ShapeAttributes rotationControlAttributes;
    protected ShapeAttributes textureControlAttributes;
    protected ShapeAttributes heightControlAttributes;
    protected ShapeAttributes radiusControlAttributes;
    protected ShapeAttributes rollGuideAttributes;
    protected ShapeAttributes headingGuideAttributes;
    protected ShapeAttributes tiltGuideAttributes;
    protected ShapeAttributes translationRodAttributes;
    protected ShapeAttributes scaleRodAttributes;
    protected ShapeAttributes rotationRodAttributes;
    protected ShapeAttributes radiusRodAttributes;
    List<Path> controlPointRods;
    protected Thread intersectionsDispatchThread;
    protected Path tempPath;
    protected Path tempPath2;
    protected Path tempPath3;
    protected boolean firstPass = true;

    public RigidShapeEditor() {
        this.assembleControlPointAttributes();
        this.initializeAnnotation();
        this.unitsFormat = new UnitsFormat();
    }

    public RigidShape getShape() {
        return this.shape;
    }

    @Override
    public void setShape(AbstractShape abstractShape) {
        if (abstractShape == null) {
            String string = "nullValue.Shape";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.shape = (RigidShape)abstractShape;
    }

    @Override
    public String getEditMode() {
        return this.editMode;
    }

    @Override
    public void setEditMode(String string) {
        if (string.equalsIgnoreCase("move")) {
            this.editMode = TRANSLATION_MODE;
        } else if (string.equalsIgnoreCase("scale")) {
            this.editMode = SCALE_MODE;
        } else if (string.equalsIgnoreCase("rotate")) {
            this.editMode = ROTATION_MODE;
        } else if (string.equalsIgnoreCase("skew")) {
            this.editMode = SKEW_MODE;
        } else if (string.equalsIgnoreCase("texture")) {
            this.editMode = TEXTURE_MODE;
        }
    }

    public int getSelectedFace() {
        return this.selectedFace;
    }

    public void setSelectedFace(int n) {
        this.selectedFace = n >= this.shape.getFaceCount() || n < 0 ? 0 : n;
    }

    protected void assembleControlPoints(DrawContext drawContext) {
        this.controlPoints = new ArrayList<RigidShape>();
        this.controlPointRods = new ArrayList<Path>();
        if (this.editMode.equalsIgnoreCase(TRANSLATION_MODE)) {
            this.assembleTranslationControlPoints(drawContext);
        } else if (this.editMode.equalsIgnoreCase(SCALE_MODE)) {
            this.assembleScaleControlPoints(drawContext);
        } else if (this.editMode.equalsIgnoreCase(ROTATION_MODE)) {
            this.assembleRotationControlPoints(drawContext);
        } else if (this.editMode.equalsIgnoreCase(SKEW_MODE)) {
            this.assembleSkewControlPoints(drawContext);
        } else if (this.editMode.equalsIgnoreCase(TEXTURE_MODE)) {
            this.assembleTextureControlPoints(drawContext);
        }
    }

    protected void assembleTranslationControlPoints(DrawContext drawContext) {
        RigidShape rigidShape = this.getShape();
        Vec4 vec4 = rigidShape.computeReferencePoint(drawContext);
        Position position = rigidShape.getReferencePosition();
        double d = ShapeUtils.getViewportScaleFactor(this.wwd) / 12.0;
        if (this.controlPoints.size() > 0) {
            for (RigidShape rigidShape2 : this.controlPoints) {
                rigidShape2.setEastWestRadius(d);
                rigidShape2.setNorthSouthRadius(d);
                rigidShape2.setVerticalRadius(d);
            }
        } else {
            double d2;
            Vec4 vec42 = this.wwd.getModel().getGlobe().computeSurfaceNormalAtLocation(position.getLatitude(), position.getLongitude()).normalize3();
            Vec4 vec43 = this.wwd.getModel().getGlobe().computeNorthPointingTangentAtLocation(position.getLatitude(), position.getLongitude()).normalize3();
            Vec4 vec44 = vec43.cross3(vec42).normalize3();
            double d3 = Math.abs(Math.sin(this.shape.getHeading().getRadians()) * this.shape.getNorthSouthRadius());
            double d4 = d3 > (d2 = Math.abs(Math.cos(this.shape.getHeading().getRadians()) * this.shape.getEastWestRadius())) ? d3 : d2;
            Vec4 vec45 = vec4.add3(vec44.multiply3(d4 + 2.0 * d));
            Position position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec45);
            Pyramid pyramid = new Pyramid(position2, d, d, d);
            pyramid.setRoll(Angle.NEG90);
            pyramid.setAttributes(this.translationControlAttributes);
            pyramid.setAltitudeMode(this.getAltitudeMode());
            pyramid.setValue("gov.nasa.worldwind.avkey.Action", (Object)CHANGE_LONGITUDE_ACTION);
            this.controlPoints.add((RigidShape)pyramid);
            Path path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.translationRodAttributes);
            this.controlPointRods.add(path);
            double d5 = Math.abs(Math.cos(this.shape.getHeading().getRadians()) * this.shape.getNorthSouthRadius());
            double d6 = Math.abs(Math.sin(this.shape.getHeading().getRadians()) * this.shape.getEastWestRadius());
            d4 = d5 > d6 ? d5 : d6;
            vec45 = vec4.add3(vec43.multiply3(d4 + 2.0 * d));
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec45);
            pyramid = new Pyramid(position2, d, d, d);
            pyramid.setTilt(Angle.POS90);
            pyramid.setAttributes(this.translationControlAttributes);
            pyramid.setAltitudeMode(this.getAltitudeMode());
            pyramid.setValue("gov.nasa.worldwind.avkey.Action", (Object)CHANGE_LATITUDE_ACTION);
            this.controlPoints.add((RigidShape)pyramid);
            path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.translationRodAttributes);
            this.controlPointRods.add(path);
            vec45 = vec4.add3(vec42.multiply3(this.shape.getVerticalRadius() + 2.0 * d));
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec45);
            pyramid = new Pyramid(position2, d, d, d);
            pyramid.setAttributes(this.translationControlAttributes);
            pyramid.setAltitudeMode(this.getAltitudeMode());
            pyramid.setValue("gov.nasa.worldwind.avkey.Action", (Object)CHANGE_HEIGHT_ACTION);
            this.controlPoints.add((RigidShape)pyramid);
            path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.translationRodAttributes);
            this.controlPointRods.add(path);
        }
    }

    protected void assembleScaleControlPoints(DrawContext drawContext) {
        RigidShape rigidShape = this.getShape();
        Matrix matrix = rigidShape.computeRenderMatrix(drawContext);
        Vec4 vec4 = rigidShape.computeReferencePoint(drawContext);
        Position position = rigidShape.getReferencePosition();
        double d = ShapeUtils.getViewportScaleFactor(this.wwd) / 12.0;
        if (this.controlPoints.size() > 0) {
            for (RigidShape rigidShape2 : this.controlPoints) {
                rigidShape2.setEastWestRadius(d);
                rigidShape2.setNorthSouthRadius(d);
                rigidShape2.setVerticalRadius(d);
            }
        } else {
            Vec4 vec42 = matrix.transformBy3(matrix, 1.0, 0.0, 0.0).add3(vec4);
            Position position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            Ellipsoid ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.scaleControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)SCALE_EAST_WEST_ACTION);
            this.controlPoints.add((RigidShape)ellipsoid);
            Path path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.scaleRodAttributes);
            this.controlPointRods.add(path);
            vec42 = matrix.transformBy3(matrix, 0.0, 1.0, 0.0).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.scaleControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)SCALE_NORTH_SOUTH_ACTION);
            this.controlPoints.add((RigidShape)ellipsoid);
            path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.scaleRodAttributes);
            this.controlPointRods.add(path);
            vec42 = matrix.transformBy3(matrix, 0.0, 0.0, 1.0).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.scaleControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)SCALE_VERTICAL_ACTION);
            this.controlPoints.add((RigidShape)ellipsoid);
            path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.scaleRodAttributes);
            this.controlPointRods.add(path);
        }
    }

    protected void assembleRotationControlPoints(DrawContext drawContext) {
        RigidShape rigidShape = this.getShape();
        Matrix matrix = rigidShape.computeRenderMatrix(drawContext);
        Vec4 vec4 = rigidShape.computeReferencePoint(drawContext);
        Position position = rigidShape.getReferencePosition();
        double d = ShapeUtils.getViewportScaleFactor(this.wwd) / 12.0;
        if (this.controlPoints.size() > 0) {
            for (RigidShape rigidShape2 : this.controlPoints) {
                rigidShape2.setEastWestRadius(d);
                rigidShape2.setNorthSouthRadius(d);
                rigidShape2.setVerticalRadius(d);
            }
        } else {
            Vec4 vec42 = matrix.transformBy3(matrix, 1.5, 0.0, 0.0).add3(vec4);
            Position position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            Ellipsoid ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.rollGuideAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)CHANGE_ROLL_ACTION);
            ellipsoid.setVisible(false);
            this.controlPoints.add((RigidShape)ellipsoid);
            Path path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.rotationRodAttributes);
            path.setVisible(false);
            this.controlPointRods.add(path);
            vec42 = matrix.transformBy3(matrix, 0.0, 1.5, 0.0).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.headingGuideAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)CHANGE_HEADING_ACTION);
            ellipsoid.setVisible(false);
            this.controlPoints.add((RigidShape)ellipsoid);
            path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.rotationRodAttributes);
            path.setVisible(false);
            this.controlPointRods.add(path);
            vec42 = matrix.transformBy3(matrix, 0.0, 0.0, 1.5).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.tiltGuideAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)CHANGE_TILT_ACTION);
            ellipsoid.setVisible(false);
            this.controlPoints.add((RigidShape)ellipsoid);
            path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.rotationRodAttributes);
            path.setVisible(false);
            this.controlPointRods.add(path);
            Ellipsoid ellipsoid2 = new Ellipsoid(this.shape.getReferencePosition(), d / 2.0, this.shape.getVerticalRadius() * 1.5, this.shape.getEastWestRadius() * 1.5);
            ellipsoid2.setHeading(this.shape.getHeading());
            ellipsoid2.setTilt(this.shape.getTilt());
            ellipsoid2.setRoll(this.shape.getRoll());
            ellipsoid2.setAttributes(this.rollGuideAttributes);
            ellipsoid2.setAltitudeMode(this.getAltitudeMode());
            ellipsoid2.setValue("gov.nasa.worldwind.avkey.Action", (Object)CHANGE_ROLL_ACTION);
            ellipsoid2.setVisible(true);
            this.controlPoints.add((RigidShape)ellipsoid2);
            Ellipsoid ellipsoid3 = new Ellipsoid(this.shape.getReferencePosition(), this.shape.getNorthSouthRadius() * 1.5, d / 2.0, this.shape.getEastWestRadius() * 1.5);
            ellipsoid3.setHeading(this.shape.getHeading());
            ellipsoid3.setTilt(this.shape.getTilt());
            ellipsoid3.setRoll(this.shape.getRoll());
            ellipsoid3.setAttributes(this.headingGuideAttributes);
            ellipsoid3.setAltitudeMode(this.getAltitudeMode());
            ellipsoid3.setValue("gov.nasa.worldwind.avkey.Action", (Object)CHANGE_HEADING_ACTION);
            ellipsoid3.setVisible(true);
            this.controlPoints.add((RigidShape)ellipsoid3);
            Ellipsoid ellipsoid4 = new Ellipsoid(this.shape.getReferencePosition(), this.shape.getNorthSouthRadius() * 1.5, this.shape.getVerticalRadius() * 1.5, d / 2.0);
            ellipsoid4.setHeading(this.shape.getHeading());
            ellipsoid4.setTilt(this.shape.getTilt());
            ellipsoid4.setRoll(this.shape.getRoll());
            ellipsoid4.setAttributes(this.tiltGuideAttributes);
            ellipsoid4.setAltitudeMode(this.getAltitudeMode());
            ellipsoid4.setValue("gov.nasa.worldwind.avkey.Action", (Object)CHANGE_TILT_ACTION);
            ellipsoid4.setVisible(true);
            this.controlPoints.add((RigidShape)ellipsoid4);
        }
    }

    protected void assembleSkewControlPoints(DrawContext drawContext) {
        RigidShape rigidShape = this.getShape();
        Matrix matrix = rigidShape.computeRenderMatrix(drawContext);
        Vec4 vec4 = rigidShape.computeReferencePoint(drawContext);
        Position position = rigidShape.getReferencePosition();
        double d = ShapeUtils.getViewportScaleFactor(this.wwd) / 12.0;
        if (this.controlPoints.size() > 0) {
            for (RigidShape rigidShape2 : this.controlPoints) {
                rigidShape2.setEastWestRadius(d);
                rigidShape2.setNorthSouthRadius(d);
                rigidShape2.setVerticalRadius(d);
            }
        } else {
            Vec4 vec42 = matrix.transformBy3(matrix, 1.0, 0.0, 1.0).add3(vec4);
            Position position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            Ellipsoid ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.radiusControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)SKEW_EAST_WEST_ACTION);
            ellipsoid.setVisible(true);
            this.controlPoints.add((RigidShape)ellipsoid);
            Path path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.radiusRodAttributes);
            this.controlPointRods.add(path);
            vec42 = matrix.transformBy3(matrix, 0.0, 1.0, 1.0).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.radiusControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setValue("gov.nasa.worldwind.avkey.Action", (Object)SKEW_NORTH_SOUTH_ACTION);
            ellipsoid.setVisible(true);
            this.controlPoints.add((RigidShape)ellipsoid);
            path = new Path(position, position2);
            path.setAltitudeMode(this.getAltitudeMode());
            path.setAttributes(this.radiusRodAttributes);
            this.controlPointRods.add(path);
            vec42 = matrix.transformBy3(matrix, 1.0, 0.0, 0.0).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.rotationControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setVisible(false);
            this.controlPoints.add((RigidShape)ellipsoid);
            vec42 = matrix.transformBy3(matrix, 0.0, 1.0, 0.0).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.rotationControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setVisible(false);
            this.controlPoints.add((RigidShape)ellipsoid);
            vec42 = matrix.transformBy3(matrix, 0.0, 0.0, 1.0).add3(vec4);
            position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
            ellipsoid = new Ellipsoid(position2, d, d, d);
            ellipsoid.setAttributes(this.rotationControlAttributes);
            ellipsoid.setAltitudeMode(this.getAltitudeMode());
            ellipsoid.setVisible(false);
            this.controlPoints.add((RigidShape)ellipsoid);
        }
    }

    protected void assembleTextureControlPoints(DrawContext drawContext) {
    }

    protected void assembleVertexControlPoints(DrawContext drawContext) {
    }

    protected void doRender(DrawContext drawContext) {
        if (this.frameTimestamp != drawContext.getFrameTimeStamp()) {
            this.assembleControlPoints(drawContext);
            this.frameTimestamp = drawContext.getFrameTimeStamp();
        }
        for (RigidShape rigidShape : this.controlPoints) {
            rigidShape.render(drawContext);
        }
        for (Path path : this.controlPointRods) {
            path.render(drawContext);
        }
        if (this.annotation != null && this.isShowAnnotation()) {
            this.annotation.render(drawContext);
        }
        if (this.tempPath != null) {
            this.tempPath.render(drawContext);
        }
        if (this.tempPath2 != null) {
            this.tempPath2.render(drawContext);
        }
        if (this.tempPath3 != null) {
            this.tempPath3.render(drawContext);
        }
    }

    protected void doPick(DrawContext drawContext, Point point) {
        this.doRender(drawContext);
    }

    protected void assembleControlPointAttributes() {
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setInteriorMaterial(Material.GREEN);
        basicShapeAttributes.setInteriorOpacity(1.0);
        basicShapeAttributes.setEnableLighting(true);
        basicShapeAttributes.setDrawInterior(true);
        basicShapeAttributes.setDrawOutline(false);
        this.translationControlAttributes = basicShapeAttributes;
        BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes();
        basicShapeAttributes2.setInteriorMaterial(Material.RED);
        basicShapeAttributes2.setInteriorOpacity(1.0);
        basicShapeAttributes2.setEnableLighting(true);
        basicShapeAttributes2.setDrawInterior(true);
        basicShapeAttributes2.setDrawOutline(false);
        this.scaleControlAttributes = basicShapeAttributes2;
        BasicShapeAttributes basicShapeAttributes3 = new BasicShapeAttributes();
        basicShapeAttributes3.setInteriorMaterial(Material.YELLOW);
        basicShapeAttributes3.setInteriorOpacity(1.0);
        basicShapeAttributes3.setEnableLighting(true);
        basicShapeAttributes3.setDrawInterior(true);
        basicShapeAttributes3.setDrawOutline(false);
        this.rotationControlAttributes = basicShapeAttributes3;
        this.textureControlAttributes = basicShapeAttributes3;
        BasicShapeAttributes basicShapeAttributes4 = new BasicShapeAttributes();
        basicShapeAttributes4.setInteriorMaterial(Material.RED);
        basicShapeAttributes4.setInteriorOpacity(1.0);
        basicShapeAttributes4.setEnableLighting(true);
        basicShapeAttributes4.setDrawInterior(true);
        basicShapeAttributes4.setDrawOutline(false);
        this.heightControlAttributes = basicShapeAttributes4;
        BasicShapeAttributes basicShapeAttributes5 = new BasicShapeAttributes();
        basicShapeAttributes5.setInteriorMaterial(Material.BLUE);
        basicShapeAttributes5.setInteriorOpacity(1.0);
        basicShapeAttributes5.setEnableLighting(true);
        basicShapeAttributes5.setDrawInterior(true);
        basicShapeAttributes5.setDrawOutline(false);
        this.radiusControlAttributes = basicShapeAttributes5;
        BasicShapeAttributes basicShapeAttributes6 = new BasicShapeAttributes();
        basicShapeAttributes6.setInteriorMaterial(Material.RED);
        basicShapeAttributes6.setInteriorOpacity(0.4);
        basicShapeAttributes6.setEnableLighting(true);
        basicShapeAttributes6.setDrawInterior(true);
        basicShapeAttributes6.setDrawOutline(false);
        this.rollGuideAttributes = basicShapeAttributes6;
        BasicShapeAttributes basicShapeAttributes7 = new BasicShapeAttributes();
        basicShapeAttributes7.setInteriorMaterial(Material.YELLOW);
        basicShapeAttributes7.setInteriorOpacity(0.4);
        basicShapeAttributes7.setEnableLighting(true);
        basicShapeAttributes7.setDrawInterior(true);
        basicShapeAttributes7.setDrawOutline(false);
        this.headingGuideAttributes = basicShapeAttributes7;
        BasicShapeAttributes basicShapeAttributes8 = new BasicShapeAttributes();
        basicShapeAttributes8.setInteriorMaterial(Material.GREEN);
        basicShapeAttributes8.setInteriorOpacity(0.4);
        basicShapeAttributes8.setEnableLighting(true);
        basicShapeAttributes8.setDrawInterior(true);
        basicShapeAttributes8.setDrawOutline(false);
        this.tiltGuideAttributes = basicShapeAttributes8;
        BasicShapeAttributes basicShapeAttributes9 = new BasicShapeAttributes();
        basicShapeAttributes9.setDrawOutline(true);
        basicShapeAttributes9.setOutlineMaterial(Material.GREEN);
        basicShapeAttributes9.setOutlineOpacity(0.6);
        this.translationRodAttributes = basicShapeAttributes9;
        BasicShapeAttributes basicShapeAttributes10 = new BasicShapeAttributes();
        basicShapeAttributes10.setDrawOutline(true);
        basicShapeAttributes10.setOutlineMaterial(Material.RED);
        basicShapeAttributes10.setOutlineOpacity(0.6);
        this.scaleRodAttributes = basicShapeAttributes10;
        BasicShapeAttributes basicShapeAttributes11 = new BasicShapeAttributes();
        basicShapeAttributes11.setDrawOutline(true);
        basicShapeAttributes11.setOutlineMaterial(Material.YELLOW);
        basicShapeAttributes11.setOutlineOpacity(0.6);
        this.rotationRodAttributes = basicShapeAttributes11;
        BasicShapeAttributes basicShapeAttributes12 = new BasicShapeAttributes();
        basicShapeAttributes12.setDrawOutline(true);
        basicShapeAttributes12.setOutlineMaterial(Material.BLUE);
        basicShapeAttributes12.setOutlineOpacity(0.6);
        basicShapeAttributes12.setDrawInterior(false);
        this.radiusRodAttributes = basicShapeAttributes12;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        if (!this.isArmed()) {
            return;
        }
        if (this.isArmed() && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            Object object = null;
            PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
            if (pickedObjectList != null) {
                object = pickedObjectList.getTopObject();
            }
            if (object instanceof ControlPointMarker) {
                this.removeVertex((ControlPointMarker)((Object)object));
                mouseEvent.consume();
            } else {
                this.addVertex(mouseEvent.getPoint());
                mouseEvent.consume();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.mousePoint;
        this.mousePoint = mouseEvent.getPoint();
        if (point == null) {
            point = this.mousePoint;
        }
        if (this.isShowAnnotation()) {
            if (this.activeControlPointIndex < 0) {
                this.updateAnnotation(this.shape.getCenterPosition());
            } else if (this.controlPoints != null) {
                this.updateAnnotation(this.controlPoints.get(this.activeControlPointIndex).getReferencePosition());
            }
        }
        if (CHANGE_HEIGHT_ACTION.equals(this.activeAction)) {
            this.setShapeHeight(point, this.mousePoint);
            mouseEvent.consume();
        } else if (CHANGE_LATITUDE_ACTION.equals(this.activeAction)) {
            this.moveShapeLatitude(point, this.mousePoint);
            mouseEvent.consume();
        } else if (CHANGE_LONGITUDE_ACTION.equals(this.activeAction)) {
            this.moveShapeLongitude(point, this.mousePoint);
            mouseEvent.consume();
        } else if (MOVE_SHAPE_ACTION.equals(this.activeAction)) {
            this.moveShape(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_NORTH_SOUTH_ACTION.equals(this.activeAction)) {
            this.scaleShapeNorthSouth(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_NORTH_ACTION.equals(this.activeAction)) {
            this.scaleShapeNorth(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_SOUTH_ACTION.equals(this.activeAction)) {
            this.scaleShapeSouth(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_EAST_WEST_ACTION.equals(this.activeAction)) {
            this.scaleShapeEastWest(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_EAST_ACTION.equals(this.activeAction)) {
            this.scaleShapeEast(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_WEST_ACTION.equals(this.activeAction)) {
            this.scaleShapeWest(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_VERTICAL_ACTION.equals(this.activeAction)) {
            this.scaleShapeVertical(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_UP_ACTION.equals(this.activeAction)) {
            this.scaleShapeUp(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_DOWN_ACTION.equals(this.activeAction)) {
            this.scaleShapeDown(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_NORTHEAST_ACTION.equals(this.activeAction)) {
            this.scaleShapeNortheast(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_SOUTHWEST_ACTION.equals(this.activeAction)) {
            this.scaleShapeSouthwest(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_RADIUS_ACTION.equals(this.activeAction)) {
            this.scaleShapeRadius(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_ANGLE_ACTION.equals(this.activeAction)) {
            this.scaleShapeAngle(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SCALE_SHAPE_ACTION.equals(this.activeAction)) {
            this.scaleShape(point, this.mousePoint);
            mouseEvent.consume();
        } else if (CHANGE_HEADING_ACTION.equals(this.activeAction)) {
            this.changeShapeHeading(point, this.mousePoint);
            mouseEvent.consume();
        } else if (CHANGE_TILT_ACTION.equals(this.activeAction)) {
            this.changeShapeTilt(point, this.mousePoint);
            mouseEvent.consume();
        } else if (CHANGE_ROLL_ACTION.equals(this.activeAction)) {
            this.changeShapeRoll(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SKEW_NORTH_SOUTH_ACTION.equals(this.activeAction)) {
            this.skewShapeNorthSouth(point, this.mousePoint);
            mouseEvent.consume();
        } else if (SKEW_EAST_WEST_ACTION.equals(this.activeAction)) {
            this.skewShapeEastWest(point, this.mousePoint);
            mouseEvent.consume();
        } else if (CHANGE_SKEW_ACTION.equals(this.activeAction)) {
            this.skewShape(point, this.mousePoint);
            mouseEvent.consume();
        } else if (TEXTURE_UPPER_LEFT_ACTION.equals(this.activeAction)) {
            this.moveTextureCorner(point, this.mousePoint, UPPER_LEFT_UV);
            mouseEvent.consume();
        } else if (TEXTURE_UPPER_RIGHT_ACTION.equals(this.activeAction)) {
            this.moveTextureCorner(point, this.mousePoint, UPPER_RIGHT_UV);
            mouseEvent.consume();
        } else if (TEXTURE_LOWER_LEFT_ACTION.equals(this.activeAction)) {
            this.moveTextureCorner(point, this.mousePoint, LOWER_LEFT_UV);
            mouseEvent.consume();
        } else if (TEXTURE_LOWER_RIGHT_ACTION.equals(this.activeAction)) {
            this.moveTextureCorner(point, this.mousePoint, LOWER_RIGHT_UV);
            mouseEvent.consume();
        } else if (TEXTURE_MOVE_ACTION.equals(this.activeAction)) {
            this.moveTexture(point, this.mousePoint);
            mouseEvent.consume();
        } else if (TEXTURE_SCALE_RIGHT_ACTION.equals(this.activeAction)) {
            this.scaleTexture(point, this.mousePoint, Direction.RIGHT);
            mouseEvent.consume();
        } else if (TEXTURE_SCALE_LEFT_ACTION.equals(this.activeAction)) {
            this.scaleTexture(point, this.mousePoint, Direction.LEFT);
            mouseEvent.consume();
        } else if (TEXTURE_SCALE_UP_ACTION.equals(this.activeAction)) {
            this.scaleTexture(point, this.mousePoint, Direction.UP);
            mouseEvent.consume();
        } else if (TEXTURE_SCALE_DOWN_ACTION.equals(this.activeAction)) {
            this.scaleTexture(point, this.mousePoint, Direction.DOWN);
            mouseEvent.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        this.mousePoint = mouseEvent.getPoint();
        Object object = null;
        PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
        if (pickedObjectList != null) {
            object = pickedObjectList.getTopObject();
        }
        if (object == this.getShape()) {
            if (this.editMode.equalsIgnoreCase(TRANSLATION_MODE)) {
                this.activeAction = MOVE_SHAPE_ACTION;
            } else if (this.editMode.equalsIgnoreCase(SCALE_MODE)) {
                this.activeAction = SCALE_SHAPE_ACTION;
            } else if (this.editMode.equalsIgnoreCase(TEXTURE_MODE)) {
                this.activeAction = SET_TEXTURE_ACTION;
                this.textureShape(mouseEvent.getPoint(), mouseEvent.getPoint());
            }
            this.activeControlPoint = (RigidShape)object;
            this.activeControlPointIndex = -1;
            if (!this.editMode.equalsIgnoreCase(TEXTURE_MODE)) {
                this.setShowAnnotation(true);
                this.updateAnnotation(this.shape.getReferencePosition());
            }
            mouseEvent.consume();
        } else if (object instanceof RigidShape && ((RigidShape)object).getValue("gov.nasa.worldwind.avkey.Action") != null) {
            this.activeControlPoint = (RigidShape)object;
            this.activeAction = (String)this.activeControlPoint.getValue("gov.nasa.worldwind.avkey.Action");
            if (!this.editMode.equalsIgnoreCase(TEXTURE_MODE)) {
                this.setShowAnnotation(true);
                this.updateAnnotation(this.activeControlPoint.getReferencePosition());
            }
            int n = 0;
            for (RigidShape rigidShape : this.controlPoints) {
                if (rigidShape.equals(object)) break;
                ++n;
            }
            this.activeControlPointIndex = n;
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        this.activeControlPoint = null;
        this.activeAction = null;
        this.setShowAnnotation(false);
        this.updateAnnotation(null);
        this.getWorldWindow().redraw();
        mouseEvent.consume();
    }

    protected void moveShape(Point point, Point point2) {
        View view = this.wwd.getView();
        Globe globe = this.wwd.getModel().getGlobe();
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Line line = view.computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = view.computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec4 = AirspaceEditorUtil.intersectGlobeAt((WorldWindow)this.wwd, (double)position.getElevation(), (Line)line);
        Vec4 vec42 = AirspaceEditorUtil.intersectGlobeAt((WorldWindow)this.wwd, (double)position.getElevation(), (Line)line2);
        if (vec4 == null || vec42 == null) {
            return;
        }
        Position position2 = globe.computePositionFromPoint(vec4);
        Position position3 = globe.computePositionFromPoint(vec42);
        Position position4 = position2.subtract(position3);
        this.shape.move(new Position(position4.getLatitude(), position4.getLongitude(), 0.0));
    }

    protected void moveShapeLatitude(Point point, Point point2) {
        View view = this.wwd.getView();
        Globe globe = this.wwd.getModel().getGlobe();
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Line line = view.computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = view.computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec4 = AirspaceEditorUtil.intersectGlobeAt((WorldWindow)this.wwd, (double)position.getElevation(), (Line)line);
        Vec4 vec42 = AirspaceEditorUtil.intersectGlobeAt((WorldWindow)this.wwd, (double)position.getElevation(), (Line)line2);
        if (vec4 == null || vec42 == null) {
            return;
        }
        Position position2 = globe.computePositionFromPoint(vec4);
        Position position3 = globe.computePositionFromPoint(vec42);
        Position position4 = position2.subtract(position3);
        this.shape.move(new Position(position4.getLatitude(), Angle.ZERO, 0.0));
    }

    protected void moveShapeLongitude(Point point, Point point2) {
        View view = this.wwd.getView();
        Globe globe = this.wwd.getModel().getGlobe();
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Line line = view.computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = view.computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec4 = AirspaceEditorUtil.intersectGlobeAt((WorldWindow)this.wwd, (double)position.getElevation(), (Line)line);
        Vec4 vec42 = AirspaceEditorUtil.intersectGlobeAt((WorldWindow)this.wwd, (double)position.getElevation(), (Line)line2);
        if (vec4 == null || vec42 == null) {
            return;
        }
        Position position2 = globe.computePositionFromPoint(vec4);
        Position position3 = globe.computePositionFromPoint(vec42);
        Position position4 = position2.subtract(position3);
        this.shape.move(new Position(Angle.ZERO, position4.getLongitude(), 0.0));
    }

    protected void setShapeHeight(Point point, Point point2) {
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Vec4 vec42 = this.wwd.getModel().getGlobe().computeSurfaceNormalAtLocation(position.getLatitude(), position.getLongitude());
        Line line = new Line(vec4, vec42);
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line3 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec43 = AirspaceEditorUtil.nearestPointOnLine((Line)line, (Line)line2);
        Vec4 vec44 = AirspaceEditorUtil.nearestPointOnLine((Line)line, (Line)line3);
        Position position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec43);
        Position position3 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec44);
        double d = position2.getElevation() - position3.getElevation();
        RigidShape rigidShape = this.getShape();
        double d2 = rigidShape.getCenterPosition().getElevation();
        if (this.aboveGround) {
            Vec4 vec45 = this.wwd.getSceneController().getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude(), this.shape.getNorthSouthRadius());
            Position position4 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec45);
            if (this.shape.getReferencePosition().getAltitude() < position4.getAltitude()) {
                this.shape.setCenterPosition(new Position(position.getLatitude(), position.getLongitude(), position4.getAltitude()));
                return;
            }
            if (this.shape.getReferencePosition().getAltitude() == position4.getAltitude() && d <= 0.0) {
                this.shape.setCenterPosition(new Position(position.getLatitude(), position.getLongitude(), position4.getAltitude()));
                return;
            }
        }
        this.shape.setCenterPosition(new Position(position.getLatitude(), position.getLongitude(), d2 + d));
    }

    protected void scaleShapeEastWest(Point point, Point point2) {
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec42 = line.nearestPointTo(vec4);
        Vec4 vec43 = line2.nearestPointTo(vec4);
        double d = vec42.distanceTo3(vec4);
        double d2 = vec43.distanceTo3(vec4);
        double d3 = d - d2;
        RigidShape rigidShape = this.getShape();
        double d4 = rigidShape.getEastWestRadius();
        if (d4 + d3 > 0.0) {
            this.shape.setEastWestRadius(d4 + d3);
        }
    }

    protected void scaleShapeEast(Point point, Point point2) {
        this.scaleShapeEastWest(point, point2);
    }

    protected void scaleShapeWest(Point point, Point point2) {
        this.scaleShapeEastWest(point, point2);
    }

    protected void scaleShapeNorthSouth(Point point, Point point2) {
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec42 = line.nearestPointTo(vec4);
        Vec4 vec43 = line2.nearestPointTo(vec4);
        double d = vec42.distanceTo3(vec4);
        double d2 = vec43.distanceTo3(vec4);
        double d3 = d - d2;
        RigidShape rigidShape = this.getShape();
        double d4 = rigidShape.getNorthSouthRadius();
        if (d4 + d3 > 0.0) {
            this.shape.setNorthSouthRadius(d4 + d3);
        }
    }

    protected void scaleShapeNorth(Point point, Point point2) {
        this.scaleShapeNorthSouth(point, point2);
    }

    protected void scaleShapeSouth(Point point, Point point2) {
        this.scaleShapeNorthSouth(point, point2);
    }

    protected void scaleShapeVertical(Point point, Point point2) {
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec42 = line.nearestPointTo(vec4);
        Vec4 vec43 = line2.nearestPointTo(vec4);
        double d = vec42.distanceTo3(vec4);
        double d2 = vec43.distanceTo3(vec4);
        double d3 = d - d2;
        RigidShape rigidShape = this.getShape();
        double d4 = rigidShape.getVerticalRadius();
        if (d4 + d3 > 0.0) {
            this.shape.setVerticalRadius(d4 + d3);
        }
    }

    protected void scaleShapeUp(Point point, Point point2) {
        this.scaleShapeVertical(point, point2);
    }

    protected void scaleShapeDown(Point point, Point point2) {
        this.scaleShapeVertical(point, point2);
    }

    protected void scaleShapeNortheast(Point point, Point point2) {
    }

    protected void scaleShapeSouthwest(Point point, Point point2) {
    }

    protected void scaleShapeRadius(Point point, Point point2) {
    }

    protected void scaleShapeAngle(Point point, Point point2) {
    }

    protected void scaleShape(Point point, Point point2) {
        double d;
        double d2;
        RigidShape rigidShape;
        double d3;
        double d4;
        double d5;
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec42 = line.nearestPointTo(vec4);
        Vec4 vec43 = line2.nearestPointTo(vec4);
        double d6 = vec42.distanceTo3(vec4);
        double d7 = d6 - (d5 = vec43.distanceTo3(vec4));
        double d8 = (d7 + (d4 = ((d3 = (rigidShape = this.getShape()).getEastWestRadius()) + (d2 = rigidShape.getNorthSouthRadius()) + (d = rigidShape.getVerticalRadius())) / 3.0)) / d4;
        if (d8 > 0.0) {
            this.shape.setEastWestRadius(d3 * d8);
            this.shape.setNorthSouthRadius(d2 * d8);
            this.shape.setVerticalRadius(d * d8);
        }
    }

    protected void changeShapeHeading(Point point, Point point2) {
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Position position2 = this.controlPoints.get(1).getCenterPosition();
        Vec4 vec42 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Position position3 = this.controlPoints.get(0).getCenterPosition();
        Vec4 vec43 = this.wwd.getModel().getGlobe().computePointFromPosition(position3);
        Position position4 = this.controlPoints.get(2).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position4);
        Plane plane = Plane.fromPoints((Vec4)vec4, (Vec4)vec42, (Vec4)vec43);
        Vec4 vec45 = plane.intersect(line);
        Vec4 vec46 = plane.intersect(line2);
        Vec4 vec47 = vec45.subtract3(vec4);
        Vec4 vec48 = vec46.subtract3(vec4);
        Vec4 vec49 = vec44.subtract3(vec4);
        RigidShape rigidShape = this.getShape();
        Angle angle = vec47.angleBetween3(vec48);
        if (vec47.cross3(vec48).dot3(vec49) < 0.0) {
            angle = Angle.fromRadians((double)(angle.getRadians() * -1.0));
        }
        Angle angle2 = this.shape.getHeading().multiply(-1.0);
        Angle angle3 = this.shape.getTilt().multiply(-1.0);
        Angle angle4 = this.shape.getRoll().multiply(-1.0);
        Matrix matrix = Matrix.IDENTITY;
        if (angle4 != null) {
            matrix = matrix.multiply(Matrix.fromRotationY((Angle)angle4));
        }
        if (angle3 != null) {
            matrix = matrix.multiply(Matrix.fromRotationX((Angle)angle3));
        }
        if (angle2 != null) {
            matrix = matrix.multiply(Matrix.fromRotationZ((Angle)angle2));
        }
        Vec4 vec410 = new Vec4(0.0, 0.0, -1.0);
        Vec4 vec411 = vec410.transformBy4(matrix).normalize3();
        Matrix matrix2 = Matrix.fromAxisAngle((Angle)angle, (Vec4)vec411);
        Matrix matrix3 = matrix2.multiply(matrix);
        this.shape.setHeading(matrix3.getKMLRotationZ());
        this.shape.setRoll(matrix3.getKMLRotationY());
        this.shape.setTilt(matrix3.getKMLRotationX());
    }

    protected void changeShapeRoll(Point point, Point point2) {
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Position position2 = this.controlPoints.get(0).getCenterPosition();
        Vec4 vec42 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Position position3 = this.controlPoints.get(2).getCenterPosition();
        Vec4 vec43 = this.wwd.getModel().getGlobe().computePointFromPosition(position3);
        Position position4 = this.controlPoints.get(1).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position4);
        Plane plane = Plane.fromPoints((Vec4)vec4, (Vec4)vec42, (Vec4)vec43);
        Vec4 vec45 = plane.intersect(line);
        Vec4 vec46 = plane.intersect(line2);
        Vec4 vec47 = vec45.subtract3(vec4);
        Vec4 vec48 = vec46.subtract3(vec4);
        Vec4 vec49 = vec44.subtract3(vec4);
        RigidShape rigidShape = this.getShape();
        Angle angle = vec47.angleBetween3(vec48);
        if (vec47.cross3(vec48).dot3(vec49) < 0.0) {
            angle = Angle.fromRadians((double)(angle.getRadians() * -1.0));
        }
        Angle angle2 = this.shape.getHeading().multiply(-1.0);
        Angle angle3 = this.shape.getTilt().multiply(-1.0);
        Angle angle4 = this.shape.getRoll().multiply(-1.0);
        Matrix matrix = Matrix.IDENTITY;
        if (angle4 != null) {
            matrix = matrix.multiply(Matrix.fromRotationY((Angle)angle4));
        }
        if (angle3 != null) {
            matrix = matrix.multiply(Matrix.fromRotationX((Angle)angle3));
        }
        if (angle2 != null) {
            matrix = matrix.multiply(Matrix.fromRotationZ((Angle)angle2));
        }
        Vec4 vec410 = new Vec4(0.0, -1.0, 0.0);
        Vec4 vec411 = vec410.transformBy4(matrix).normalize3();
        Matrix matrix2 = Matrix.fromAxisAngle((Angle)angle, (Vec4)vec411);
        Matrix matrix3 = matrix2.multiply(matrix);
        this.shape.setHeading(matrix3.getKMLRotationZ());
        this.shape.setRoll(matrix3.getKMLRotationY());
        this.shape.setTilt(matrix3.getKMLRotationX());
    }

    protected void changeShapeTilt(Point point, Point point2) {
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Position position2 = this.controlPoints.get(2).getCenterPosition();
        Vec4 vec42 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Position position3 = this.controlPoints.get(1).getCenterPosition();
        Vec4 vec43 = this.wwd.getModel().getGlobe().computePointFromPosition(position3);
        Position position4 = this.controlPoints.get(0).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position4);
        Plane plane = Plane.fromPoints((Vec4)vec4, (Vec4)vec42, (Vec4)vec43);
        Vec4 vec45 = plane.intersect(line);
        Vec4 vec46 = plane.intersect(line2);
        Vec4 vec47 = vec45.subtract3(vec4);
        Vec4 vec48 = vec46.subtract3(vec4);
        Vec4 vec49 = vec44.subtract3(vec4);
        RigidShape rigidShape = this.getShape();
        Angle angle = vec47.angleBetween3(vec48);
        if (vec47.cross3(vec48).dot3(vec49) < 0.0) {
            angle = Angle.fromRadians((double)(angle.getRadians() * -1.0));
        }
        Angle angle2 = this.shape.getHeading().multiply(-1.0);
        Angle angle3 = this.shape.getTilt().multiply(-1.0);
        Angle angle4 = this.shape.getRoll().multiply(-1.0);
        Matrix matrix = Matrix.IDENTITY;
        if (angle4 != null) {
            matrix = matrix.multiply(Matrix.fromRotationY((Angle)angle4));
        }
        if (angle3 != null) {
            matrix = matrix.multiply(Matrix.fromRotationX((Angle)angle3));
        }
        if (angle2 != null) {
            matrix = matrix.multiply(Matrix.fromRotationZ((Angle)angle2));
        }
        Vec4 vec410 = new Vec4(-1.0, 0.0, 0.0);
        Vec4 vec411 = vec410.transformBy4(matrix).normalize3();
        Matrix matrix2 = Matrix.fromAxisAngle((Angle)angle, (Vec4)vec411);
        Matrix matrix3 = matrix2.multiply(matrix);
        this.shape.setHeading(matrix3.getKMLRotationZ());
        this.shape.setRoll(matrix3.getKMLRotationY());
        this.shape.setTilt(matrix3.getKMLRotationX());
    }

    protected void skewShapeEastWest(Point point, Point point2) {
        RigidShape rigidShape = this.getShape();
        double d = rigidShape.getSkewEastWest().getDegrees();
        double d2 = ShapeUtils.getViewportScaleFactor(this.wwd);
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Position position2 = this.controlPoints.get(2).getCenterPosition();
        Vec4 vec42 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Vec4 vec43 = vec42.subtract3(vec4).normalize3();
        Position position3 = this.controlPoints.get(3).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position3);
        Vec4 vec45 = vec44.subtract3(vec4).normalize3();
        Position position4 = this.controlPoints.get(4).getCenterPosition();
        Vec4 vec46 = this.wwd.getModel().getGlobe().computePointFromPosition(position4);
        Vec4 vec47 = vec46.subtract3(vec4).normalize3();
        Vec4 vec48 = vec4.add3(vec43.multiply3(this.shape.getEastWestRadius()));
        Vec4 vec49 = vec48.add3(vec45);
        Vec4 vec410 = vec48.add3(vec47);
        Plane plane = Plane.fromPoints((Vec4)vec48, (Vec4)vec49, (Vec4)vec410);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec411 = line.nearestPointTo(vec48);
        Vec4 vec412 = line2.nearestPointTo(vec48);
        double d3 = vec411.distanceTo3(vec48);
        double d4 = vec412.distanceTo3(vec48);
        double d5 = (d3 - d4) / d2;
        d5 *= 1.0 - Math.abs(d - 90.0) / 90.0;
        d5 *= 50.0;
        int n = plane.onSameSide(vec4, vec411);
        if (n != 0) {
            d5 *= -1.0;
        }
        if (d + d5 >= 0.0 && d + d5 < 180.0) {
            this.shape.setSkewEastWest(Angle.fromDegrees((double)(d + d5)));
        }
    }

    protected void skewShapeNorthSouth(Point point, Point point2) {
        RigidShape rigidShape = this.getShape();
        double d = rigidShape.getSkewNorthSouth().getDegrees();
        double d2 = ShapeUtils.getViewportScaleFactor(this.wwd);
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Position position2 = this.controlPoints.get(3).getCenterPosition();
        Vec4 vec42 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Vec4 vec43 = vec42.subtract3(vec4).normalize3();
        Position position3 = this.controlPoints.get(2).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position3);
        Vec4 vec45 = vec44.subtract3(vec4).normalize3();
        Position position4 = this.controlPoints.get(4).getCenterPosition();
        Vec4 vec46 = this.wwd.getModel().getGlobe().computePointFromPosition(position4);
        Vec4 vec47 = vec46.subtract3(vec4).normalize3();
        Vec4 vec48 = vec4.add3(vec43.multiply3(this.shape.getNorthSouthRadius()));
        Vec4 vec49 = vec48.add3(vec45);
        Vec4 vec410 = vec48.add3(vec47);
        Plane plane = Plane.fromPoints((Vec4)vec48, (Vec4)vec49, (Vec4)vec410);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec411 = line.nearestPointTo(vec48);
        Vec4 vec412 = line2.nearestPointTo(vec48);
        double d3 = vec411.distanceTo3(vec48);
        double d4 = vec412.distanceTo3(vec48);
        double d5 = (d3 - d4) / d2;
        d5 *= 1.0 - Math.abs(d - 90.0) / 90.0;
        d5 *= 50.0;
        int n = plane.onSameSide(vec4, vec411);
        if (n != 0) {
            d5 *= -1.0;
        }
        if (d + d5 >= 0.0 && d + d5 < 180.0) {
            this.shape.setSkewNorthSouth(Angle.fromDegrees((double)(d + d5)));
        }
    }

    protected void skewShape(Point point, Point point2) {
        RigidShape rigidShape = this.getShape();
        double d = rigidShape.getSkewEastWest().getDegrees();
        double d2 = rigidShape.getSkewNorthSouth().getDegrees();
        double d3 = ShapeUtils.getViewportScaleFactor(this.wwd);
        Position position = this.shape.getReferencePosition();
        if (position == null) {
            return;
        }
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(position);
        Position position2 = this.controlPoints.get(0).getCenterPosition();
        Vec4 vec42 = this.wwd.getModel().getGlobe().computePointFromPosition(position2);
        Vec4 vec43 = vec42.subtract3(vec4).normalize3();
        Position position3 = this.controlPoints.get(1).getCenterPosition();
        Vec4 vec44 = this.wwd.getModel().getGlobe().computePointFromPosition(position3);
        Vec4 vec45 = vec44.subtract3(vec4).normalize3();
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = this.wwd.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Position position4 = this.controlPoints.get(2).getCenterPosition();
        Vec4 vec46 = this.wwd.getModel().getGlobe().computePointFromPosition(position4);
        Position position5 = this.controlPoints.get(1).getCenterPosition();
        Vec4 vec47 = this.wwd.getModel().getGlobe().computePointFromPosition(position5);
        Position position6 = this.controlPoints.get(0).getCenterPosition();
        Vec4 vec48 = this.wwd.getModel().getGlobe().computePointFromPosition(position6);
        Plane plane = Plane.fromPoints((Vec4)vec4, (Vec4)vec46, (Vec4)vec47);
        Vec4 vec49 = plane.intersect(line);
        Vec4 vec410 = plane.intersect(line2);
        Vec4 vec411 = vec49.subtract3(vec410);
        Vec4 vec412 = vec48.subtract3(vec4);
        double d4 = vec411.dot3(vec43);
        double d5 = d4 / d3;
        d5 *= 1.0 - Math.abs(d - 90.0) / 90.0;
        d5 *= 50.0;
        double d6 = vec411.dot3(vec45);
        double d7 = d6 / d3;
        d7 *= 1.0 - Math.abs(d2 - 90.0) / 90.0;
        d7 *= 50.0;
        if (d + d5 >= 0.0 && d + d5 < 180.0) {
            this.shape.setSkewEastWest(Angle.fromDegrees((double)(d + d5)));
        }
        if (d2 + d7 >= 0.0 && d2 + d7 < 180.0) {
            this.shape.setSkewNorthSouth(Angle.fromDegrees((double)(d2 + d7)));
        }
    }

    protected void moveTexture(Point point, Point point2) {
    }

    protected void moveTextureCorner(Point point, Point point2, Integer n) {
    }

    protected void scaleTexture(Point point, Point point2, Direction direction) {
    }

    protected void textureShape(Point point, Point point2) {
        RigidShape rigidShape = this.getShape();
        int n = rigidShape.getFaceCount();
        Matrix matrix = rigidShape.computeRenderMatrix(this.getWorldWindow().getModel().getGlobe(), 0.0);
        Line line = this.wwd.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        try {
            double d = 1.0E10;
            Integer n2 = null;
            for (int i = 0; i < n; ++i) {
                List list = rigidShape.intersectFace(line, i, matrix);
                if (list == null || list.size() <= 0) continue;
                for (Intersection intersection : list) {
                    double d2 = this.wwd.getView().getEyePoint().distanceTo3(intersection.getIntersectionPoint());
                    if (!(d2 < d)) continue;
                    d = d2;
                    n2 = i;
                }
            }
            if (n2 != null && n2.equals(this.getSelectedFace())) {
                this.moveTexture(point, point2);
            } else if (n2 != null && n2 >= 0) {
                this.setSelectedFace(n2);
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Operation was interrupted");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void moveControlPoint(ControlPointMarker controlPointMarker, Point point) {
    }

    protected void addVertex(Point point) {
    }

    protected void removeVertex(ControlPointMarker controlPointMarker) {
    }

    protected Vec4 intersectPolygonAltitudeAt(Line line) {
        double d = 0.0;
        if (this.controlPoints.size() > 0) {
            d = this.controlPoints.get(0).getCenterPosition().getElevation();
        }
        return AirspaceEditorUtil.intersectGlobeAt((WorldWindow)this.wwd, (double)d, (Line)line);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void updateAnnotation(Position position) {
        if (position == null) {
            this.annotation.getAttributes().setVisible(false);
            return;
        }
        String string = this.getDisplayString(position);
        if (string == null) {
            this.annotation.getAttributes().setVisible(false);
            return;
        }
        this.annotation.setText(string);
        Vec4 vec4 = this.computeAnnotationPosition(position);
        if (vec4 != null) {
            this.annotation.setScreenPoint(new Point((int)vec4.x, (int)vec4.y));
        }
        this.annotation.getAttributes().setVisible(true);
    }

    protected Vec4 computeAnnotationPosition(Position position) {
        Vec4 vec4 = this.wwd.getSceneController().getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude());
        if (vec4 == null) {
            Globe globe = this.wwd.getModel().getGlobe();
            vec4 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), globe.getElevation(position.getLatitude(), position.getLongitude()));
        }
        return this.wwd.getView().project(vec4);
    }

    protected String getDisplayString(Position position) {
        String string = null;
        if (position != null) {
            string = this.formatMeasurements(position);
        }
        return string;
    }

    protected String formatMeasurements(Position position) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel("MeasureTool.WidthLabel"), this.shape.getEastWestRadius() * 2.0));
        stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel("MeasureTool.LengthLabel"), this.shape.getNorthSouthRadius() * 2.0));
        stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel("MeasureTool.HeightLabel"), this.shape.getVerticalRadius() * 2.0));
        stringBuilder.append(this.unitsFormat.angleNL(this.getLabel("MeasureTool.HeadingLabel"), this.shape.getHeading()));
        stringBuilder.append(this.unitsFormat.angleNL(this.getLabel("MeasureTool.TiltLabel"), this.shape.getTilt()));
        stringBuilder.append(this.unitsFormat.angleNL(this.getLabel("MeasureTool.RollLabel"), this.shape.getRoll()));
        stringBuilder.append(this.unitsFormat.angleNL(this.getLabel("MeasureTool.EastSkewLabel"), this.shape.getSkewEastWest()));
        stringBuilder.append(this.unitsFormat.angleNL(this.getLabel("MeasureTool.NorthSkewLabel"), this.shape.getSkewNorthSouth()));
        if (!this.arePositionsRedundant(position, this.shape.getCenterPosition())) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel("MeasureTool.LatitudeLabel"), position.getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel("MeasureTool.LongitudeLabel"), position.getLongitude()));
            stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel("MeasureTool.AltitudeLabel"), position.getAltitude()));
        }
        if (this.shape.getCenterPosition() != null) {
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel("MeasureTool.CenterLatitudeLabel"), this.shape.getCenterPosition().getLatitude()));
            stringBuilder.append(this.unitsFormat.angleNL(this.getLabel("MeasureTool.CenterLongitudeLabel"), this.shape.getCenterPosition().getLongitude()));
            stringBuilder.append(this.unitsFormat.lengthNL(this.getLabel("MeasureTool.CenterAltitudeLabel"), this.shape.getCenterPosition().getAltitude()));
        }
        return stringBuilder.toString();
    }

    protected static class ControlPointMarker
    extends BasicMarker {
        protected int index;
        protected String type;
        protected Vec4 point;

        public ControlPointMarker(String string, Position position, Vec4 vec4, MarkerAttributes markerAttributes, int n) {
            super(position, markerAttributes);
            this.point = vec4;
            this.index = n;
            this.type = string;
        }

        public int getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }

        public Vec4 getPoint() {
            return this.point;
        }
    }

    public static enum Direction {
        RIGHT,
        LEFT,
        UP,
        DOWN;

    }
}

