/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.symbology;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.symbology.IconRetriever;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525IconRetriever;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class IconRetrieverUsage {
    public static void main(String[] stringArray) {
        if (Configuration.isMacOS()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Icon Retriever");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppFrame appFrame = new AppFrame();
                appFrame.setTitle("World Wind Icon Retriever");
                appFrame.setVisible(true);
                appFrame.setDefaultCloseOperation(3);
            }
        });
    }

    private static class AppFrame
    extends JFrame {
        protected IconRetriever iconRetriever;

        public AppFrame() {
            this.getContentPane().setLayout(new FlowLayout());
            String string = Configuration.getStringValue((String)"gov.nasa.worldwind.avkey.MilStd2525IconRetrieverPath", (String)"http://worldwind.arc.nasa.gov/milstd2525c/rev1/");
            this.iconRetriever = new MilStd2525IconRetriever(string);
            WorldWind.getTaskService().addTask(new Runnable(){

                @Override
                public void run() {
                    AVListImpl aVListImpl = new AVListImpl();
                    BufferedImage bufferedImage = AppFrame.this.iconRetriever.createIcon("SFAPMFQM--GIUSA", (AVList)aVListImpl);
                    AppFrame.this.addLater(bufferedImage, "Full symbol");
                    aVListImpl.setValue("gov.nasa.worldwind.symbology.ShowFrame", (Object)false);
                    bufferedImage = AppFrame.this.iconRetriever.createIcon("SFAPMFQM--GIUSA", (AVList)aVListImpl);
                    AppFrame.this.addLater(bufferedImage, "No frame");
                    aVListImpl.setValue("gov.nasa.worldwind.symbology.ShowFrame", (Object)true);
                    aVListImpl.setValue("gov.nasa.worldwind.symbology.ShowFill", (Object)false);
                    bufferedImage = AppFrame.this.iconRetriever.createIcon("SFAPMFQM--GIUSA", (AVList)aVListImpl);
                    AppFrame.this.addLater(bufferedImage, "No fill");
                    aVListImpl.setValue("gov.nasa.worldwind.avkey.Color", (Object)Color.GREEN);
                    aVListImpl.setValue("gov.nasa.worldwind.symbology.ShowFrame", (Object)true);
                    aVListImpl.setValue("gov.nasa.worldwind.symbology.ShowFill", (Object)true);
                    bufferedImage = AppFrame.this.iconRetriever.createIcon("SFAPMFQM--GIUSA", (AVList)aVListImpl);
                    AppFrame.this.addLater(bufferedImage, "Custom color");
                }
            });
        }

        protected void addLater(final BufferedImage bufferedImage, final String string) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JLabel jLabel = new JLabel(new ImageIcon(bufferedImage));
                    jLabel.setText(string);
                    AppFrame.this.getContentPane().add(jLabel);
                    AppFrame.this.pack();
                }
            });
        }
    }
}

