/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.symbology;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.symbology.TacticalGraphic;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525GraphicFactory;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525TacticalSymbol;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;

public class Symbology
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)34.478);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)-117.525);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)40000);
        ApplicationTemplate.start("World Wind Symbology", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            this.addTacticalSymbols();
            this.addTacticalGraphics();
            Dimension dimension = new Dimension(1800, 1000);
            this.setPreferredSize(dimension);
            this.pack();
            WWUtil.alignComponent(null, (Component)this, (String)"gov.nasa.worldwind.avkey.Center");
        }

        protected void addTacticalSymbols() {
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Tactical Symbols");
            MilStd2525TacticalSymbol milStd2525TacticalSymbol = new MilStd2525TacticalSymbol("SFAPMFQM------A", Position.fromDegrees((double)34.4934, (double)-117.6003, (double)3000.0));
            milStd2525TacticalSymbol.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"MIL-STD-2525 Tactical Symbol");
            milStd2525TacticalSymbol.setShowLocation(false);
            renderableLayer.addRenderable((Renderable)milStd2525TacticalSymbol);
            this.getWwd().getModel().getLayers().add((Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }

        protected void addTacticalGraphics() {
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Tactical Graphics");
            List<Position> list = Arrays.asList(Position.fromDegrees((double)34.498, (double)-117.5541, (double)0.0), Position.fromDegrees((double)34.4951, (double)-117.4667, (double)0.0), Position.fromDegrees((double)34.4733, (double)-117.4303, (double)0.0), Position.fromDegrees((double)34.4217, (double)-117.4056, (double)0.0), Position.fromDegrees((double)34.478, (double)-117.53, (double)0.0));
            MilStd2525GraphicFactory milStd2525GraphicFactory = new MilStd2525GraphicFactory();
            TacticalGraphic tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLAGS-----X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"MIL-STD-2525 Tactical Graphic");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            this.addControlPoints(list, renderableLayer);
            this.getWwd().getModel().getLayers().add((Layer)renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }

        protected void addControlPoints(Iterable<Position> iterable, RenderableLayer renderableLayer) {
            PointPlacemarkAttributes pointPlacemarkAttributes = new PointPlacemarkAttributes();
            pointPlacemarkAttributes.setUsePointAsDefaultImage(true);
            int n = 1;
            for (Position position : iterable) {
                PointPlacemark pointPlacemark = new PointPlacemark(position);
                pointPlacemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)("Tactical Graphic Position " + n));
                pointPlacemark.setAttributes(pointPlacemarkAttributes);
                pointPlacemark.setHighlightAttributes(pointPlacemarkAttributes);
                renderableLayer.addRenderable((Renderable)pointPlacemark);
                ++n;
            }
        }
    }
}

