/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.symbology;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.symbology.BasicTacticalGraphicAttributes;
import gov.nasa.worldwind.symbology.TacticalCircle;
import gov.nasa.worldwind.symbology.TacticalGraphic;
import gov.nasa.worldwind.symbology.TacticalGraphicAttributes;
import gov.nasa.worldwind.symbology.TacticalPoint;
import gov.nasa.worldwind.symbology.TacticalQuad;
import gov.nasa.worldwind.symbology.TacticalRoute;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525GraphicFactory;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TacticalGraphics
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)34.9);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)-117.44);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)155000);
        ApplicationTemplate.start("World Wind Tactical Graphics", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected RenderableLayer pointLayer = new RenderableLayer();
        protected RenderableLayer lineLayer;
        protected RenderableLayer areaLayer;
        protected TacticalGraphicAttributes sharedAttrs;
        protected TacticalGraphicAttributes sharedPointAttrs;

        public AppFrame() {
            super(true, true, false);
            this.pointLayer.setName("Tactical Graphics (Points)");
            this.lineLayer = new RenderableLayer();
            this.lineLayer.setName("Tactical Graphics (Lines)");
            this.areaLayer = new RenderableLayer();
            this.areaLayer.setName("Tactical Graphics (Areas)");
            this.sharedAttrs = new BasicTacticalGraphicAttributes();
            this.sharedAttrs.setScale(Double.valueOf(0.25));
            this.sharedPointAttrs = new BasicTacticalGraphicAttributes();
            this.createPointGraphics(this.pointLayer);
            this.createLineGraphics(this.lineLayer);
            this.createAreaGraphics(this.areaLayer);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), (Layer)this.pointLayer);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), (Layer)this.lineLayer);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), (Layer)this.areaLayer);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().addSelectListener((SelectListener)new BasicDragger(this.getWwd()));
            this.addGraphicControls();
            Dimension dimension = new Dimension(1800, 1000);
            this.setPreferredSize(dimension);
            this.pack();
            WWUtil.alignComponent(null, (Component)this, (String)"gov.nasa.worldwind.avkey.Center");
        }

        protected void createPointGraphics(RenderableLayer renderableLayer) {
            MilStd2525GraphicFactory milStd2525GraphicFactory = new MilStd2525GraphicFactory();
            TacticalPoint tacticalPoint = milStd2525GraphicFactory.createPoint("GHMPNZ--------X", Position.fromDegrees((double)35.2144, (double)-117.8824), null);
            tacticalPoint.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Nuclear Event (2.X.3.4.2)");
            tacticalPoint.setText("X691");
            tacticalPoint.setModifier("W", (Object)"10095900ZJAN92");
            tacticalPoint.setModifier("C", (Object)"15");
            tacticalPoint.setModifier("V", (Object)"B83");
            renderableLayer.addRenderable((Renderable)tacticalPoint);
            tacticalPoint = milStd2525GraphicFactory.createPoint("GHMPOHTH------X", Position.fromDegrees((double)35.2544, (double)-117.724), null);
            tacticalPoint.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"High Tower");
            tacticalPoint.setModifier("X", (Object)"2562");
            renderableLayer.addRenderable((Renderable)tacticalPoint);
            this.setAttributes(renderableLayer, this.sharedAttrs, this.sharedPointAttrs);
        }

        protected void createLineGraphics(RenderableLayer renderableLayer) {
            MilStd2525GraphicFactory milStd2525GraphicFactory = new MilStd2525GraphicFactory();
            List<Position> list = Arrays.asList(Position.fromDegrees((double)34.9349, (double)-117.6303), Position.fromDegrees((double)34.9843, (double)-117.5885), Position.fromDegrees((double)34.9961, (double)-117.4891));
            TacticalGraphic tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGLP----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Phase line: friendly (2.X.2.2.2.2)");
            tacticalGraphic.setText("A");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.919, (double)-117.5919), Position.fromDegrees((double)34.9589, (double)-117.5618), Position.fromDegrees((double)34.9701, (double)-117.4798));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPGLP----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Phase line: hostile (2.X.2.2.2.2)");
            tacticalGraphic.setText("B");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.891, (double)-117.5726), Position.fromDegrees((double)34.9367, (double)-117.5354), Position.fromDegrees((double)34.948, (double)-117.4741));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGAGLP----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Phase line: hostile, anticipated (2.X.2.2.2.2)");
            tacticalGraphic.setText("C");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.8703, (double)-117.5525), Position.fromDegrees((double)34.9158, (double)-117.5153), Position.fromDegrees((double)34.9238, (double)-117.46));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGLP----AUSX", list, null);
            tacticalGraphic.setText("D");
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Phase line: custom color and font (2.X.2.2.2.2)");
            BasicTacticalGraphicAttributes basicTacticalGraphicAttributes = new BasicTacticalGraphicAttributes();
            basicTacticalGraphicAttributes.setOutlineMaterial(Material.GRAY);
            basicTacticalGraphicAttributes.setTextModifierFont(Font.decode("Arial-12"));
            tacticalGraphic.setAttributes((TacticalGraphicAttributes)basicTacticalGraphicAttributes);
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.5479, (double)-117.8777), Position.fromDegrees((double)34.5137, (double)-118.0092), Position.fromDegrees((double)34.5898, (double)-118.0775), Position.fromDegrees((double)34.536, (double)-118.1833));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPGLB----JUSX", list, null);
            tacticalGraphic.setModifier("T", Arrays.asList("40ID", "18ID"));
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Boundary (2.X.2.1.2.1)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.6643, (double)-117.7323), Position.fromDegrees((double)34.6962, (double)-117.7808), Position.fromDegrees((double)34.6934, (double)-117.8444), Position.fromDegrees((double)34.6602, (double)-117.857), Position.fromDegrees((double)34.6844, (double)-117.7303));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLAGM-----X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Main Attack (2.X.2.5.2.1.4.1)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.761, (double)-117.4541), Position.fromDegrees((double)34.7614, (double)-117.5852), Position.fromDegrees((double)34.7287, (double)-117.6363), Position.fromDegrees((double)34.6726, (double)-117.6363), Position.fromDegrees((double)34.782, (double)-117.47));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLAR------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Attack, Rotary Wing (2.X.2.5.2.1.3)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.7437, (double)-117.8007), Position.fromDegrees((double)34.7535, (double)-117.9256), Position.fromDegrees((double)34.8051, (double)-117.9707), Position.fromDegrees((double)34.7643, (double)-117.8219));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLAV------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Aviation (2.X.2.5.2.1.1)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.698, (double)-117.5541), Position.fromDegrees((double)34.6951, (double)-117.4667), Position.fromDegrees((double)34.6733, (double)-117.4303), Position.fromDegrees((double)34.6217, (double)-117.4056), Position.fromDegrees((double)34.678, (double)-117.53));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLAGS-----X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Supporting Attack (2.X.2.5.2.1.4.2)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.7099, (double)-117.9047), Position.fromDegrees((double)34.6725, (double)-117.959), Position.fromDegrees((double)34.6814, (double)-118.0522), Position.fromDegrees((double)34.7124, (double)-117.9284));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLAA------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Airborne (2.X.2.5.2.1.2)");
            tacticalGraphic.setModifier("A", (Object)"SFGPUCI--------");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            ArrayList<TacticalPoint> arrayList = new ArrayList<TacticalPoint>();
            TacticalPoint tacticalPoint = milStd2525GraphicFactory.createPoint("GFGPAPP-------X", Position.fromDegrees((double)34.8802, (double)-117.9773), null);
            tacticalPoint.setText("1");
            arrayList.add(tacticalPoint);
            tacticalPoint = milStd2525GraphicFactory.createPoint("GFGPAPP-------X", Position.fromDegrees((double)35.0947, (double)-117.9578), null);
            tacticalPoint.setText("2");
            arrayList.add(tacticalPoint);
            tacticalPoint = milStd2525GraphicFactory.createPoint("GFGPAPC-------X", Position.fromDegrees((double)35.1739, (double)-117.6957), null);
            tacticalPoint.setText("3");
            arrayList.add(tacticalPoint);
            TacticalRoute tacticalRoute = milStd2525GraphicFactory.createRoute("GFGPALM-------X", arrayList, null);
            tacticalRoute.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Minimum Risk Route (2.X.2.2.2.2)");
            tacticalRoute.setText("KNIGHT");
            tacticalRoute.setModifier("AM", (Object)4000.0);
            tacticalRoute.setModifier("W", Arrays.asList("270600Z", "271845Z"));
            tacticalRoute.setModifier("X", Arrays.asList("50 FT AGL", "200 FT AGL"));
            renderableLayer.addRenderable((Renderable)tacticalRoute);
            list = Arrays.asList(Position.fromDegrees((double)35.0459, (double)-117.3795), Position.fromDegrees((double)35.0459, (double)-117.5633));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLKGM-----X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Direction of Main Attack (2.X.2.5.2.2.2.1)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.8917, (double)-117.8344), Position.fromDegrees((double)34.8283, (double)-117.6794));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPLTF-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Final Protective Fire (2.X.4.2.1.2)");
            tacticalGraphic.setModifier("T", Arrays.asList("AG1201", "2-22 INF MORT"));
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.5556, (double)-117.4123), Position.fromDegrees((double)34.521, (double)-117.4786), Position.fromDegrees((double)34.5942, (double)-117.4766));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPSLA-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Ambush (2.X.2.6.1.1)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.2805, (double)-117.5978), Position.fromDegrees((double)35.2978, (double)-117.3702));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPDLF-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Forward Edge of Battle Area (2.X.2.4.2.1)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.2829, (double)-117.59), Position.fromDegrees((double)35.299, (double)-117.3727));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGLC-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Line of Contact (2.X.2.1.2.3)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.4179, (double)-117.4399), Position.fromDegrees((double)34.4486, (double)-117.6857));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPLCF-------X", list, null);
            tacticalGraphic.setModifier("T", Arrays.asList("X CORPS", "ALPHA"));
            tacticalGraphic.setModifier("W", Arrays.asList("202100Z", "270800Z SEP"));
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Fire Support Coordination Line (2.X.4.2.2.1)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.7502, (double)-118.198), Position.fromDegrees((double)34.8542, (double)-118.2565), Position.fromDegrees((double)34.8515, (double)-118.1129));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPDLP-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Principle Direction of Fire (2.X.2.4.2.2)");
            tacticalGraphic.setModifier("A", (Object)"SFGPEWRH--MTUSG");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.9738, (double)-118.2632), Position.fromDegrees((double)34.9306, (double)-118.1597), Position.fromDegrees((double)35.0092, (double)-118.1717));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGAS-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Search Area/Reconnaissance Area (2.X.2.1.3.9)");
            tacticalGraphic.setModifier("A", (Object)"SFGPEWRH--MTUSG");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.3401, (double)-117.6356), Position.fromDegrees((double)35.3723, (double)-117.529), Position.fromDegrees((double)35.3776, (double)-117.4182));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGLF-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Forward Line of Own Troops (2.X.2.1.2.2)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.1143, (double)-118.0609), Position.fromDegrees((double)35.0765, (double)-118.2397));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPOLKA------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Direction of Attack, Aviation (2.X.2.5.2.2.1)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.2678, (double)-118.0194), Position.fromDegrees((double)35.1504, (double)-118.1822), Position.fromDegrees((double)35.2402, (double)-118.0716));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOLI-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Infiltration Lane (2.X.2.5.2.4)");
            tacticalGraphic.setText("CHARLIE");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.6377, (double)-118.077), Position.fromDegrees((double)34.6413, (double)-118.1572), Position.fromDegrees((double)34.6808, (double)-118.21), Position.fromDegrees((double)34.6547, (double)-118.0988));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPPA--------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Axis of Advance for Feint (2.X.2.3.2)");
            tacticalGraphic.setText("GREEN");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.1184, (double)-118.4377), Position.fromDegrees((double)35.0339, (double)-118.4318), Position.fromDegrees((double)35.0843, (double)-118.3376));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPSLH-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Holding Line (2.X.2.6.1.2)");
            tacticalGraphic.setText("ALPHA");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.0656, (double)-118.0508), Position.fromDegrees((double)35.0383, (double)-118.2275));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPPF--------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Direction of Attack for Feint (2.X.2.3.3)");
            tacticalGraphic.setText("DAVID");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            this.setAttributes(renderableLayer, this.sharedAttrs, this.sharedPointAttrs);
        }

        protected void createAreaGraphics(RenderableLayer renderableLayer) {
            MilStd2525GraphicFactory milStd2525GraphicFactory = new MilStd2525GraphicFactory();
            List<Position> list = Arrays.asList(Position.fromDegrees((double)34.913, (double)-117.1897), Position.fromDegrees((double)34.9789, (double)-117.1368), Position.fromDegrees((double)34.9706, (double)-116.99), Position.fromDegrees((double)34.9188, (double)-116.9906));
            TacticalGraphic tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPGAA----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Assembly Area (2.X.2.1.3.2)");
            tacticalGraphic.setText("Atlanta");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.7985, (double)-117.1938), Position.fromDegrees((double)34.8358, (double)-117.1282), Position.fromDegrees((double)34.8456, (double)-117.0773), Position.fromDegrees((double)34.8159, (double)-116.9723), Position.fromDegrees((double)34.7836, (double)-117.101), Position.fromDegrees((double)34.7985, (double)-117.1938));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPGAF----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Fortified Area (2.X.2.1.3.4)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.9001, (double)-117.4044), Position.fromDegrees((double)34.991, (double)-117.3297), Position.fromDegrees((double)34.9851, (double)-117.2224), Position.fromDegrees((double)34.9134, (double)-117.267));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGAZ----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Airfield Zone (2.X.2.1.3.11)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.2331, (double)-117.6217), Position.fromDegrees((double)35.2331, (double)-117.3552), Position.fromDegrees((double)35.1998, (double)-117.256), Position.fromDegrees((double)35.0851, (double)-117.3604), Position.fromDegrees((double)35.0857, (double)-117.6261));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPAAR----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Restricted Operations Zone (2.X.2.2.3.1)");
            tacticalGraphic.setText("(Unit ID)");
            tacticalGraphic.setModifier("W", Arrays.asList("180500Z", "180615Z"));
            tacticalGraphic.setModifier("X", Arrays.asList("2000 FT AGL", "3000 FT AGL"));
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.7849, (double)-117.3661), Position.fromDegrees((double)34.6715, (double)-117.3738), Position.fromDegrees((double)34.6374, (double)-117.3208), Position.fromDegrees((double)34.6549, (double)-117.1448), Position.fromDegrees((double)34.7506, (double)-117.1436));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPAAW----AUSX", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Weapons Free Zone (2.X.2.2.3.5)");
            tacticalGraphic.setText("(Unit ID)");
            tacticalGraphic.setModifier("W", Arrays.asList("1000Z", "1300Z"));
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            Position position = Position.fromDegrees((double)35.1108, (double)-117.087);
            TacticalCircle tacticalCircle = milStd2525GraphicFactory.createCircle("GHFPATC-------X", position, 5000.0, null);
            tacticalCircle.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Circular Target (2.X.4.3.1.2)");
            tacticalCircle.setText("AG9999");
            renderableLayer.addRenderable((Renderable)tacticalCircle);
            position = Position.fromDegrees((double)35.0295, (double)-116.929);
            TacticalQuad tacticalQuad = milStd2525GraphicFactory.createQuad("GHFPATR-------X", Arrays.asList(position), null);
            tacticalQuad.setLength(8000.0);
            tacticalQuad.setWidth(4000.0);
            tacticalQuad.setText("AB0176");
            tacticalQuad.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Rectangular Target (2.X.4.3.1.1)");
            renderableLayer.addRenderable((Renderable)tacticalQuad);
            position = Position.fromDegrees((double)35.2106, (double)-117.0092);
            tacticalCircle = milStd2525GraphicFactory.createCircle("GFFPACPC------X", position, 5000.0, null);
            tacticalCircle.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Position Area for Artillery (2.X.4.3.2.6.2)");
            renderableLayer.addRenderable((Renderable)tacticalCircle);
            list = Arrays.asList(Position.fromDegrees((double)35.252, (double)-116.8968), Position.fromDegrees((double)35.2364, (double)-116.8063));
            tacticalQuad = milStd2525GraphicFactory.createQuad("GFFPACPR------X", list, null);
            tacticalQuad.setWidth(5000.0);
            tacticalQuad.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Position Area for Artillery (2.X.4.3.2.6.1)");
            renderableLayer.addRenderable((Renderable)tacticalQuad);
            position = Position.fromDegrees((double)34.6813, (double)-116.9724);
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPAXC-------X", Arrays.asList(position), null);
            tacticalGraphic.setModifier("AM", Arrays.asList(1000.0, 6000.0, 11000.0));
            tacticalGraphic.setModifier("X", Arrays.asList("GL", "GL", "GL"));
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Weapon/Sensor Range Fan (2.X.4.3.4.1)");
            tacticalGraphic.setModifier("A", (Object)"SFGPUCFH-------");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            List<Angle> list2 = Arrays.asList(Angle.fromDegrees((double)290.0), Angle.fromDegrees((double)30.0), Angle.fromDegrees((double)290.0), Angle.fromDegrees((double)30.0), Angle.fromDegrees((double)315.0), Angle.fromDegrees((double)30.0), Angle.fromDegrees((double)315.0), Angle.fromDegrees((double)35.0));
            position = Position.fromDegrees((double)34.5798, (double)-116.6591);
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPAXS-------X", Arrays.asList(position), null);
            tacticalGraphic.setModifier("AM", Arrays.asList(4000.0, 6000.0, 11000.0, 15000.0));
            tacticalGraphic.setModifier("AN", list2);
            tacticalGraphic.setModifier("X", Arrays.asList("GL", "GL", "GL", "GL"));
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Weapon/Sensor Range Fan (2.X.4.3.4.2)");
            tacticalGraphic.setModifier("A", (Object)"SFGPUCFTR------");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.9672, (double)-116.8974), Position.fromDegrees((double)34.9188, (double)-116.8205));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPACRR------X", list, null);
            tacticalGraphic.setModifier("AM", (Object)5000.0);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Restrictive Fire Area (2.X.4.3.2.5.2)");
            tacticalGraphic.setText("X CORPS");
            tacticalGraphic.setModifier("W", Arrays.asList("051030", "051600Z"));
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            position = Position.fromDegrees((double)34.8208, (double)-116.8284);
            tacticalGraphic = milStd2525GraphicFactory.createCircle("GFFPACSC------X", position, 5000.0, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Fire Support Area (2.X.4.3.2.1.3)");
            tacticalGraphic.setText("GREEN");
            tacticalGraphic.setModifier("W", Arrays.asList("051030", "051600Z"));
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.0592, (double)-117.2903), Position.fromDegrees((double)35.062, (double)-117.1606));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPACER------X", list, null);
            tacticalGraphic.setModifier("AM", (Object)5000.0);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Sensor Zone");
            tacticalGraphic.setText("Q37");
            tacticalGraphic.setModifier("W", Arrays.asList("051030", "051600Z"));
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.1386, (double)-116.9302), Position.fromDegrees((double)35.103, (double)-116.9302), Position.fromDegrees((double)35.0731, (double)-116.9561), Position.fromDegrees((double)35.062, (double)-116.8345), Position.fromDegrees((double)35.1422, (double)-116.8193));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPAZXI------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Call for Fire Zone (2.X.4.3.3.2.1)");
            tacticalGraphic.setText("3BDE 4ID");
            tacticalGraphic.setModifier("W", Arrays.asList("051030", "051600Z"));
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.016, (double)-116.6625), Position.fromDegrees((double)35.0601, (double)-116.6773), Position.fromDegrees((double)35.0542, (double)-116.7611), Position.fromDegrees((double)35.0092, (double)-116.779));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFFPATG-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Series or Group of Targets (2.X.4.3.1.3)");
            tacticalGraphic.setText("JEFF");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.126, (double)-116.6625), Position.fromDegrees((double)35.1701, (double)-116.6773), Position.fromDegrees((double)35.1642, (double)-116.7611), Position.fromDegrees((double)35.1192, (double)-116.779));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPSAA-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Airhead (2.X.2.6.2.2)");
            tacticalGraphic.setText("DELTA");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.9073, (double)-116.7041), Position.fromDegrees((double)34.923, (double)-116.6842), Position.fromDegrees((double)34.8723, (double)-116.6841), Position.fromDegrees((double)34.887, (double)-116.7783));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFMPNM--------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Minimum Safe Distance Zones (2.X.3.4.1)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            position = Position.fromDegrees((double)35.2132, (double)-117.8042);
            tacticalCircle = milStd2525GraphicFactory.createCircle("GFGPAPU-------X", position, 2000.0, null);
            tacticalCircle.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Pull-Up Point (2.X.2.2.1.3)");
            renderableLayer.addRenderable((Renderable)tacticalCircle);
            list = Arrays.asList(Position.fromDegrees((double)34.6297, (double)-117.6718), Position.fromDegrees((double)34.5807, (double)-117.5902), Position.fromDegrees((double)34.5344, (double)-117.6686));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOAF-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Attack by Fire Position (2.X.2.5.3.3)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.6159, (double)-117.8571), Position.fromDegrees((double)34.5775, (double)-117.7887), Position.fromDegrees((double)34.6308, (double)-117.8477), Position.fromDegrees((double)34.5837, (double)-117.7725));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPOAS-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Support by Fire Position (2.X.2.5.3.4)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.4916, (double)-117.3427), Position.fromDegrees((double)34.577, (double)-117.2273), Position.fromDegrees((double)34.5666, (double)-117.092), Position.fromDegrees((double)34.4943, (double)-117.0629), Position.fromDegrees((double)34.457, (double)-117.1613), Position.fromDegrees((double)34.4508, (double)-117.3106));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFMPNB--------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Biologically Contaminated Area (2.X.3.4.5)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            tacticalGraphic = milStd2525GraphicFactory.createPoint("GFMPNEB-------X", Position.fromDegrees((double)34.5059, (double)-117.202), null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Biological Release Event (2.X.3.4.7.1)");
            tacticalGraphic.setShowLocation(false);
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            this.setAttributes(renderableLayer, this.sharedAttrs, this.sharedPointAttrs);
            list = Arrays.asList(Position.fromDegrees((double)34.9684, (double)-116.4864), Position.fromDegrees((double)34.9776, (double)-116.6114), Position.fromDegrees((double)35.0271, (double)-116.5614), Position.fromDegrees((double)35.0309, (double)-116.4132));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPDAB----J--X", list, null);
            tacticalGraphic.setText("Blue");
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Battle Position, Prepared but not Occupied (2.X.2.4.3.1.1)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.8166, (double)-116.5491), Position.fromDegrees((double)34.8121, (double)-116.5027), Position.fromDegrees((double)34.8182, (double)-116.4528), Position.fromDegrees((double)34.8489, (double)-116.4137), Position.fromDegrees((double)34.8848, (double)-116.4246), Position.fromDegrees((double)34.905, (double)-116.4664), Position.fromDegrees((double)34.908, (double)-116.5246), Position.fromDegrees((double)34.8893, (double)-116.5828), Position.fromDegrees((double)34.8495, (double)-116.6091), Position.fromDegrees((double)34.8211, (double)-116.5782));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GHGPSAE-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Encirclement (2.X.2.6.2.3)");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.771, (double)-116.4909), Position.fromDegrees((double)34.7764, (double)-116.472), Position.fromDegrees((double)34.779, (double)-116.421), Position.fromDegrees((double)34.7509, (double)-116.3918), Position.fromDegrees((double)34.7285, (double)-116.381), Position.fromDegrees((double)34.7066, (double)-116.3831), Position.fromDegrees((double)34.6787, (double)-116.4378), Position.fromDegrees((double)34.685, (double)-116.49), Position.fromDegrees((double)34.7063, (double)-116.5192), Position.fromDegrees((double)34.733, (double)-116.517));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFMPNL--------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Dose Rate Contour Line (2.X.3.4.9)");
            tacticalGraphic.setText("100 cGY");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)34.7504, (double)-116.48), Position.fromDegrees((double)34.7552, (double)-116.4637), Position.fromDegrees((double)34.7556, (double)-116.4283), Position.fromDegrees((double)34.7469, (double)-116.4137), Position.fromDegrees((double)34.7259, (double)-116.4129), Position.fromDegrees((double)34.7091, (double)-116.4138), Position.fromDegrees((double)34.7053, (double)-116.428), Position.fromDegrees((double)34.7073, (double)-116.4634), Position.fromDegrees((double)34.7149, (double)-116.4891), Position.fromDegrees((double)34.7314, (double)-116.4908));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFMPNL--------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Dose Rate Contour Line (2.X.3.4.9)");
            tacticalGraphic.setText("300 cGY");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.1421, (double)-116.5798), Position.fromDegrees((double)35.0979, (double)-116.5971), Position.fromDegrees((double)35.0934, (double)-116.4595), Position.fromDegrees((double)35.157, (double)-116.4832));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGAG-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"General Area (2.X.2.1.3.1)");
            tacticalGraphic.setText("CHEM");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            list = Arrays.asList(Position.fromDegrees((double)35.1612, (double)-116.4304), Position.fromDegrees((double)35.1358, (double)-116.4955));
            tacticalGraphic = milStd2525GraphicFactory.createGraphic("GFGPGAY-------X", list, null);
            tacticalGraphic.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"Limited Access Area (2.X.2.1.3.10)");
            tacticalGraphic.setModifier("A", (Object)"SFGPUCI--------");
            renderableLayer.addRenderable((Renderable)tacticalGraphic);
            this.setAttributes(renderableLayer, this.sharedAttrs, this.sharedPointAttrs);
        }

        protected void setAttributes(RenderableLayer renderableLayer, TacticalGraphicAttributes tacticalGraphicAttributes, TacticalGraphicAttributes tacticalGraphicAttributes2) {
            for (Renderable renderable : renderableLayer.getRenderables()) {
                TacticalGraphic tacticalGraphic;
                if (renderable instanceof TacticalPoint) {
                    tacticalGraphic = (TacticalGraphic)renderable;
                    if (tacticalGraphic.getAttributes() != null) continue;
                    tacticalGraphic.setAttributes(tacticalGraphicAttributes2);
                    continue;
                }
                if (!(renderable instanceof TacticalGraphic) || (tacticalGraphic = (TacticalGraphic)renderable).getAttributes() != null) continue;
                tacticalGraphic.setAttributes(tacticalGraphicAttributes);
            }
        }

        protected void addGraphicControls() {
            Box box = Box.createVerticalBox();
            box.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            JLabel jLabel = new JLabel("Opacity");
            JSlider jSlider = new JSlider(0, 100, 100);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    double d = (double)jSlider.getValue() / 100.0;
                    AppFrame.this.sharedAttrs.setInteriorOpacity(Double.valueOf(d));
                    AppFrame.this.sharedAttrs.setOutlineOpacity(Double.valueOf(d));
                    AppFrame.this.sharedPointAttrs.setInteriorOpacity(Double.valueOf(d));
                    AppFrame.this.sharedPointAttrs.setOutlineOpacity(Double.valueOf(d));
                    AppFrame.this.getWwd().redraw();
                }
            });
            box.add(Box.createVerticalStrut(10));
            jLabel.setAlignmentX(0.0f);
            jSlider.setAlignmentX(0.0f);
            box.add(jLabel);
            box.add(jSlider);
            JCheckBox jCheckBox = new JCheckBox("Text Modifiers", true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    this.setShowModifiers(AppFrame.this.pointLayer, bl);
                    this.setShowModifiers(AppFrame.this.lineLayer, bl);
                    this.setShowModifiers(AppFrame.this.areaLayer, bl);
                    AppFrame.this.getWwd().redraw();
                }

                protected void setShowModifiers(RenderableLayer renderableLayer, boolean bl) {
                    for (Renderable renderable : renderableLayer.getRenderables()) {
                        if (!(renderable instanceof TacticalGraphic)) continue;
                        ((TacticalGraphic)renderable).setShowTextModifiers(bl);
                    }
                }
            });
            jCheckBox.setAlignmentX(0.0f);
            box.add(Box.createVerticalStrut(10));
            box.add(jCheckBox);
            jCheckBox = new JCheckBox("Graphic Modifiers", true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    this.setShowModifiers(AppFrame.this.pointLayer, bl);
                    this.setShowModifiers(AppFrame.this.lineLayer, bl);
                    this.setShowModifiers(AppFrame.this.areaLayer, bl);
                    AppFrame.this.getWwd().redraw();
                }

                protected void setShowModifiers(RenderableLayer renderableLayer, boolean bl) {
                    for (Renderable renderable : renderableLayer.getRenderables()) {
                        if (!(renderable instanceof TacticalGraphic)) continue;
                        ((TacticalGraphic)renderable).setShowGraphicModifiers(bl);
                    }
                }
            });
            jCheckBox.setAlignmentX(0.0f);
            box.add(Box.createVerticalStrut(10));
            box.add(jCheckBox);
            jCheckBox = new JCheckBox("Hostile indicator", true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    this.setShowHostile(AppFrame.this.pointLayer, bl);
                    this.setShowHostile(AppFrame.this.lineLayer, bl);
                    this.setShowHostile(AppFrame.this.areaLayer, bl);
                    AppFrame.this.getWwd().redraw();
                }

                protected void setShowHostile(RenderableLayer renderableLayer, boolean bl) {
                    for (Renderable renderable : renderableLayer.getRenderables()) {
                        if (!(renderable instanceof TacticalGraphic)) continue;
                        ((TacticalGraphic)renderable).setShowHostileIndicator(bl);
                    }
                }
            });
            jCheckBox.setAlignmentX(0.0f);
            box.add(Box.createVerticalStrut(10));
            box.add(jCheckBox);
            this.getLayerPanel().add((Component)box, "South");
        }
    }
}

