/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.symbology;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.symbology.BasicTacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.TacticalSymbol;
import gov.nasa.worldwind.symbology.TacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525TacticalSymbol;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TacticalSymbols
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)32.49);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)63.455);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialHeading", (Object)22);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialPitch", (Object)82);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)20000);
        TacticalSymbols.start("World Wind Tactical Symbols", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected RenderableLayer symbolLayer = new RenderableLayer();
        protected TacticalSymbolAttributes sharedAttrs;
        protected TacticalSymbolAttributes sharedHighlightAttrs;
        protected BasicDragger dragger;

        public AppFrame() {
            this.symbolLayer.setName("Tactical Symbols");
            this.sharedAttrs = new BasicTacticalSymbolAttributes();
            this.sharedHighlightAttrs = new BasicTacticalSymbolAttributes();
            this.sharedHighlightAttrs.setInteriorMaterial(Material.WHITE);
            this.sharedHighlightAttrs.setOpacity(Double.valueOf(1.0));
            MilStd2525TacticalSymbol milStd2525TacticalSymbol = new MilStd2525TacticalSymbol("SFAPMFQM--GIUSA", Position.fromDegrees((double)32.452, (double)63.44553, (double)3000.0));
            milStd2525TacticalSymbol.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"MIL-STD-2525 Friendly SOF Drone Aircraft");
            milStd2525TacticalSymbol.setAttributes(this.sharedAttrs);
            milStd2525TacticalSymbol.setHighlightAttributes(this.sharedHighlightAttrs);
            milStd2525TacticalSymbol.setModifier("Q", (Object)Angle.fromDegrees((double)235.0));
            milStd2525TacticalSymbol.setShowLocation(false);
            this.symbolLayer.addRenderable((Renderable)milStd2525TacticalSymbol);
            MilStd2525TacticalSymbol milStd2525TacticalSymbol2 = new MilStd2525TacticalSymbol("SHGXUCFRMS----G", Position.fromDegrees((double)32.4014, (double)63.3894, (double)0.0));
            milStd2525TacticalSymbol2.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"MIL-STD-2525 Hostile Self-Propelled Rocket Launchers");
            milStd2525TacticalSymbol2.setAttributes(this.sharedAttrs);
            milStd2525TacticalSymbol2.setHighlightAttributes(this.sharedHighlightAttrs);
            milStd2525TacticalSymbol2.setModifier("Q", (Object)Angle.fromDegrees((double)90.0));
            milStd2525TacticalSymbol2.setModifier("AJ", (Object)0.5);
            milStd2525TacticalSymbol2.setShowLocation(false);
            this.symbolLayer.addRenderable((Renderable)milStd2525TacticalSymbol2);
            MilStd2525TacticalSymbol milStd2525TacticalSymbol3 = new MilStd2525TacticalSymbol("SFGPEWRH--MTUSG", Position.fromDegrees((double)32.3902, (double)63.4161, (double)0.0));
            milStd2525TacticalSymbol3.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)"MIL-STD-2525 Friendly Heavy Machine Gun");
            milStd2525TacticalSymbol3.setAttributes(this.sharedAttrs);
            milStd2525TacticalSymbol3.setHighlightAttributes(this.sharedHighlightAttrs);
            milStd2525TacticalSymbol3.setModifier("C", (Object)200);
            milStd2525TacticalSymbol3.setModifier("G", (Object)"FOR REINFORCEMENTS");
            milStd2525TacticalSymbol3.setModifier("H", (Object)"ADDED SUPPORT FOR JJ");
            milStd2525TacticalSymbol3.setModifier("V", (Object)"MACHINE GUN");
            milStd2525TacticalSymbol3.setModifier("W", (Object)"30140000ZSEP97");
            this.symbolLayer.addRenderable((Renderable)milStd2525TacticalSymbol3);
            this.getWwd().getModel().getLayers().add((Layer)this.symbolLayer);
            this.getLayerPanel().update(this.getWwd());
            this.dragger = new BasicDragger(this.getWwd());
            this.getWwd().addSelectListener((SelectListener)this.dragger);
            this.addSymbolControls();
            Dimension dimension = new Dimension(1800, 1000);
            this.setPreferredSize(dimension);
            this.pack();
            WWUtil.alignComponent(null, (Component)this, (String)"gov.nasa.worldwind.avkey.Center");
        }

        protected void addSymbolControls() {
            Box box = Box.createVerticalBox();
            box.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            JLabel jLabel = new JLabel("Scale");
            JSlider jSlider = new JSlider(0, 100, 100);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    double d = (double)jSlider.getValue() / 100.0;
                    AppFrame.this.sharedAttrs.setScale(Double.valueOf(d));
                    AppFrame.this.sharedHighlightAttrs.setScale(Double.valueOf(d));
                    AppFrame.this.getWwd().redraw();
                }
            });
            jLabel.setAlignmentX(0.0f);
            jSlider.setAlignmentX(0.0f);
            box.add(jLabel);
            box.add(jSlider);
            jLabel = new JLabel("Opacity");
            jSlider = new JSlider(0, 100, 100);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    double d = (double)jSlider.getValue() / 100.0;
                    AppFrame.this.sharedAttrs.setOpacity(Double.valueOf(d));
                    AppFrame.this.getWwd().redraw();
                }
            });
            box.add(Box.createVerticalStrut(10));
            jLabel.setAlignmentX(0.0f);
            jSlider.setAlignmentX(0.0f);
            box.add(jLabel);
            box.add(jSlider);
            JCheckBox jCheckBox = new JCheckBox("Graphic Modifiers", true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    for (Renderable renderable : AppFrame.this.symbolLayer.getRenderables()) {
                        if (renderable instanceof TacticalSymbol) {
                            ((TacticalSymbol)renderable).setShowGraphicModifiers(bl);
                        }
                        AppFrame.this.getWwd().redraw();
                    }
                }
            });
            jCheckBox.setAlignmentX(0.0f);
            box.add(Box.createVerticalStrut(10));
            box.add(jCheckBox);
            jCheckBox = new JCheckBox("Text Modifiers", true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    for (Renderable renderable : AppFrame.this.symbolLayer.getRenderables()) {
                        if (renderable instanceof TacticalSymbol) {
                            ((TacticalSymbol)renderable).setShowTextModifiers(bl);
                        }
                        AppFrame.this.getWwd().redraw();
                    }
                }
            });
            jCheckBox.setAlignmentX(0.0f);
            box.add(Box.createVerticalStrut(10));
            box.add(jCheckBox);
            jCheckBox = new JCheckBox("Show Frame", true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    for (Renderable renderable : AppFrame.this.symbolLayer.getRenderables()) {
                        if (renderable instanceof TacticalSymbol) {
                            ((MilStd2525TacticalSymbol)renderable).setShowFrame(bl);
                        }
                        AppFrame.this.getWwd().redraw();
                    }
                }
            });
            jCheckBox.setAlignmentX(0.0f);
            box.add(Box.createVerticalStrut(10));
            box.add(jCheckBox);
            jCheckBox = new JCheckBox("Show Fill", true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    for (Renderable renderable : AppFrame.this.symbolLayer.getRenderables()) {
                        if (renderable instanceof TacticalSymbol) {
                            ((MilStd2525TacticalSymbol)renderable).setShowFill(bl);
                        }
                        AppFrame.this.getWwd().redraw();
                    }
                }
            });
            jCheckBox.setAlignmentX(0.0f);
            box.add(Box.createVerticalStrut(10));
            box.add(jCheckBox);
            jCheckBox = new JCheckBox("Show Icon", true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    for (Renderable renderable : AppFrame.this.symbolLayer.getRenderables()) {
                        if (renderable instanceof TacticalSymbol) {
                            ((MilStd2525TacticalSymbol)renderable).setShowIcon(bl);
                        }
                        AppFrame.this.getWwd().redraw();
                    }
                }
            });
            jCheckBox.setAlignmentX(0.0f);
            box.add(Box.createVerticalStrut(10));
            box.add(jCheckBox);
            this.getLayerPanel().add((Component)box, "South");
        }
    }
}

